/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModelImpl;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.dto.wage.TrackWatchDataFullDto;
import de.datomino.peppergis.dto.wage.TrackWatchDataProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class TrackWatchDataModelImpl
extends AbstractModel<TrackWatchDataFullDto, TrackWatchDataProxyDto>
implements TrackWatchDataModel {
    private ImmutablePoint geoTrack;
    private Date trackTime;
    private Integer eventPeriod;
    private HistoryAreaTourModel historyAreaTour;

    public TrackWatchDataModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TrackWatchDataModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getGeoTrack() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geoTrack;
    }

    @Override
    public void setGeoTrack(ImmutablePoint geoTrack) {
        this.setGeoTrack(geoTrack, true);
    }

    private void setGeoTrack(ImmutablePoint geoTrack, boolean setDirty) {
        ImmutablePoint oldGeoTrack = this.getGeoTrack();
        if (new EqualsBuilder().append(oldGeoTrack, geoTrack).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TrackWatchDataModelEnum.GEO_TRACK.getPropertyName());
        }
        this.geoTrack = geoTrack;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TrackWatchDataModelEnum.GEO_TRACK, geoTrack, oldGeoTrack);
    }

    @Override
    public Date getTrackTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.trackTime;
    }

    @Override
    public void setTrackTime(Date trackTime) {
        this.setTrackTime(trackTime, true);
    }

    private void setTrackTime(Date trackTime, boolean setDirty) {
        Date oldTrackTime = this.getTrackTime();
        if (new EqualsBuilder().append(oldTrackTime, trackTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TrackWatchDataModelEnum.TRACK_TIME.getPropertyName());
        }
        this.trackTime = trackTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TrackWatchDataModelEnum.TRACK_TIME, trackTime, oldTrackTime);
    }

    @Override
    public Integer getEventPeriod() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.eventPeriod;
    }

    @Override
    public void setEventPeriod(Integer eventPeriod) {
        this.setEventPeriod(eventPeriod, true);
    }

    private void setEventPeriod(Integer eventPeriod, boolean setDirty) {
        Integer oldEventPeriod = this.getEventPeriod();
        if (new EqualsBuilder().append(oldEventPeriod, eventPeriod).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TrackWatchDataModelEnum.EVENT_PERIOD.getPropertyName());
        }
        this.eventPeriod = eventPeriod;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TrackWatchDataModelEnum.EVENT_PERIOD, eventPeriod, oldEventPeriod);
    }

    @Override
    public HistoryAreaTourModel getHistoryAreaTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.historyAreaTour;
    }

    @Override
    public void setHistoryAreaTour(HistoryAreaTourModel historyAreaTour) {
        this.setHistoryAreaTour(historyAreaTour, true);
    }

    private void setHistoryAreaTour(HistoryAreaTourModel historyAreaTour, boolean setDirty) {
        HistoryAreaTourModel oldHistoryAreaTour = this.getHistoryAreaTour();
        if (oldHistoryAreaTour == historyAreaTour) {
            return;
        }
        if (oldHistoryAreaTour != null) {
            oldHistoryAreaTour.removeATrackWatchData(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TrackWatchDataModelEnum.HISTORY_AREA_TOUR.getPropertyName());
        }
        this.historyAreaTour = historyAreaTour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TrackWatchDataModelEnum.HISTORY_AREA_TOUR, historyAreaTour, oldHistoryAreaTour);
        if (this.historyAreaTour != null) {
            this.historyAreaTour.addATrackWatchData(this);
        }
    }

    @Override
    protected void updateByDto(TrackWatchDataFullDto trackWatchDataDto) {
        ImmutablePointDto geoTrack = trackWatchDataDto.getGeoTrack();
        this.geoTrack = geoTrack == null ? null : (ImmutablePoint)geoTrack.getGeoObject();
        this.trackTime = trackWatchDataDto.getTrackTime();
        this.eventPeriod = trackWatchDataDto.getEventPeriod();
        this.historyAreaTour = (HistoryAreaTourModel)this.getModelCache().getModel(trackWatchDataDto.getHistoryAreaTour());
    }

    @Override
    protected void updateMasterRelationsByDto(TrackWatchDataFullDto trackWatchDataDto) {
    }

    @Override
    protected void checkStaleByDto(TrackWatchDataFullDto trackWatchDataDto) throws StaleStateException {
        HistoryAreaTourModelImpl historyAreaTourModel;
        HistoryAreaTourDto historyAreaTourDto = trackWatchDataDto.getHistoryAreaTour();
        if (historyAreaTourDto != null && historyAreaTourDto.getId() != null && (historyAreaTourModel = (HistoryAreaTourModelImpl)this.getModelCache().getModel(HistoryAreaTourModel.class, historyAreaTourDto.getId())) != null) {
            historyAreaTourModel.checkStaleState(historyAreaTourDto);
        }
    }

    @Override
    public TrackWatchDataFullDto createDto() {
        Long id = this.getId();
        TrackWatchDataFullDto trackWatchDataDto = id == null ? new TrackWatchDataFullDto(this.getTempUUID()) : new TrackWatchDataFullDto(id, this.getVersion());
        ImmutablePoint geoTrack = this.getGeoTrack();
        trackWatchDataDto.setGeoTrack(ImmutablePointDto.create(geoTrack));
        trackWatchDataDto.setTrackTime(this.getTrackTime());
        trackWatchDataDto.setEventPeriod(this.getEventPeriod());
        HistoryAreaTourModelImpl historyAreaTour = (HistoryAreaTourModelImpl)this.getHistoryAreaTour();
        if (historyAreaTour != null) {
            trackWatchDataDto.setHistoryAreaTour(historyAreaTour.createProxy());
        }
        return trackWatchDataDto;
    }

    @Override
    public TrackWatchDataProxyDto createProxy() {
        Long id = this.getId();
        TrackWatchDataProxyDto trackWatchDataDto = id == null ? new TrackWatchDataProxyDto(this.getTempUUID()) : new TrackWatchDataProxyDto(id, this.getVersion());
        return trackWatchDataDto;
    }

    public static enum TrackWatchDataModelEnum {
        GEO_TRACK("geoTrack"),
        TRACK_TIME("trackTime"),
        EVENT_PERIOD("eventPeriod"),
        HISTORY_AREA_TOUR("historyAreaTour");

        private String propertyName;

        private TrackWatchDataModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

