/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModelImpl;
import de.datomino.peppergis.dto.wage.SpecialWageHolidayFullDto;
import de.datomino.peppergis.dto.wage.SpecialWageHolidayProxyDto;
import de.datomino.peppergis.dto.wage.WageHolidaySetDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SpecialWageHolidayModelImpl
extends AbstractModel<SpecialWageHolidayFullDto, SpecialWageHolidayProxyDto>
implements SpecialWageHolidayModel {
    private String name;
    private Integer day;
    private Integer month;
    private WageHolidaySetModel wageHolidaySet;

    public SpecialWageHolidayModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SpecialWageHolidayModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SpecialWageHolidayModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SpecialWageHolidayModelEnum.NAME, name, oldName);
    }

    @Override
    public Integer getDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.day;
    }

    @Override
    public void setDay(Integer day) {
        this.setDay(day, true);
    }

    private void setDay(Integer day, boolean setDirty) {
        Integer oldDay = this.getDay();
        if (new EqualsBuilder().append(oldDay, day).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SpecialWageHolidayModelEnum.DAY.getPropertyName());
        }
        this.day = day;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SpecialWageHolidayModelEnum.DAY, day, oldDay);
    }

    @Override
    public Integer getMonth() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.month;
    }

    @Override
    public void setMonth(Integer month) {
        this.setMonth(month, true);
    }

    private void setMonth(Integer month, boolean setDirty) {
        Integer oldMonth = this.getMonth();
        if (new EqualsBuilder().append(oldMonth, month).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SpecialWageHolidayModelEnum.MONTH.getPropertyName());
        }
        this.month = month;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SpecialWageHolidayModelEnum.MONTH, month, oldMonth);
    }

    @Override
    public WageHolidaySetModel getWageHolidaySet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wageHolidaySet;
    }

    @Override
    public void setWageHolidaySet(WageHolidaySetModel wageHolidaySet) {
        this.setWageHolidaySet(wageHolidaySet, true);
    }

    private void setWageHolidaySet(WageHolidaySetModel wageHolidaySet, boolean setDirty) {
        WageHolidaySetModel oldWageHolidaySet = this.getWageHolidaySet();
        if (oldWageHolidaySet == wageHolidaySet) {
            return;
        }
        if (oldWageHolidaySet != null) {
            oldWageHolidaySet.removeSpecialWageHoliday(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SpecialWageHolidayModelEnum.WAGE_HOLIDAY_SET.getPropertyName());
        }
        this.wageHolidaySet = wageHolidaySet;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SpecialWageHolidayModelEnum.WAGE_HOLIDAY_SET, wageHolidaySet, oldWageHolidaySet);
        if (this.wageHolidaySet != null) {
            this.wageHolidaySet.addSpecialWageHoliday(this);
        }
    }

    @Override
    protected void updateByDto(SpecialWageHolidayFullDto specialWageHolidayDto) {
        this.name = specialWageHolidayDto.getName();
        this.day = specialWageHolidayDto.getDay();
        this.month = specialWageHolidayDto.getMonth();
        this.wageHolidaySet = (WageHolidaySetModel)this.getModelCache().getModel(specialWageHolidayDto.getWageHolidaySet());
    }

    @Override
    protected void updateMasterRelationsByDto(SpecialWageHolidayFullDto specialWageHolidayDto) {
    }

    @Override
    protected void checkStaleByDto(SpecialWageHolidayFullDto specialWageHolidayDto) throws StaleStateException {
        WageHolidaySetModelImpl wageHolidaySetModel;
        WageHolidaySetDto wageHolidaySetDto = specialWageHolidayDto.getWageHolidaySet();
        if (wageHolidaySetDto != null && wageHolidaySetDto.getId() != null && (wageHolidaySetModel = (WageHolidaySetModelImpl)this.getModelCache().getModel(WageHolidaySetModel.class, wageHolidaySetDto.getId())) != null) {
            wageHolidaySetModel.checkStaleState(wageHolidaySetDto);
        }
    }

    @Override
    public SpecialWageHolidayFullDto createDto() {
        Long id = this.getId();
        SpecialWageHolidayFullDto specialWageHolidayDto = id == null ? new SpecialWageHolidayFullDto(this.getTempUUID()) : new SpecialWageHolidayFullDto(id, this.getVersion());
        specialWageHolidayDto.setName(this.getName());
        specialWageHolidayDto.setDay(this.getDay());
        specialWageHolidayDto.setMonth(this.getMonth());
        WageHolidaySetModelImpl wageHolidaySet = (WageHolidaySetModelImpl)this.getWageHolidaySet();
        if (wageHolidaySet != null) {
            specialWageHolidayDto.setWageHolidaySet(wageHolidaySet.createProxy());
        }
        return specialWageHolidayDto;
    }

    @Override
    public SpecialWageHolidayProxyDto createProxy() {
        Long id = this.getId();
        SpecialWageHolidayProxyDto specialWageHolidayDto = id == null ? new SpecialWageHolidayProxyDto(this.getTempUUID()) : new SpecialWageHolidayProxyDto(id, this.getVersion());
        return specialWageHolidayDto;
    }

    public static enum SpecialWageHolidayModelEnum {
        NAME("name"),
        DAY("day"),
        MONTH("month"),
        WAGE_HOLIDAY_SET("wageHolidaySet");

        private String propertyName;

        private SpecialWageHolidayModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

