/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModelImpl;
import de.datomino.peppergis.dto.wage.HistoryAreaStopFullDto;
import de.datomino.peppergis.dto.wage.HistoryAreaStopProxyDto;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class HistoryAreaStopModelImpl
extends AbstractModel<HistoryAreaStopFullDto, HistoryAreaStopProxyDto>
implements HistoryAreaStopModel {
    private ImmutablePoint location;
    private ImmutablePoint accessLocation;
    private Integer estimatedDurationSeconds;
    private Integer metersFromStart;
    private Integer secondsFromStart;
    private Integer part;
    private Integer sortOrder;
    private HistoryAreaTourModel historyAreaTour;

    public HistoryAreaStopModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public HistoryAreaStopModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(ImmutablePoint location) {
        this.setLocation(location, true);
    }

    private void setLocation(ImmutablePoint location, boolean setDirty) {
        ImmutablePoint oldLocation = this.getLocation();
        if (new EqualsBuilder().append(oldLocation, location).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public ImmutablePoint getAccessLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.accessLocation;
    }

    @Override
    public void setAccessLocation(ImmutablePoint accessLocation) {
        this.setAccessLocation(accessLocation, true);
    }

    private void setAccessLocation(ImmutablePoint accessLocation, boolean setDirty) {
        ImmutablePoint oldAccessLocation = this.getAccessLocation();
        if (new EqualsBuilder().append(oldAccessLocation, accessLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.ACCESS_LOCATION.getPropertyName());
        }
        this.accessLocation = accessLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.ACCESS_LOCATION, accessLocation, oldAccessLocation);
    }

    @Override
    public Integer getEstimatedDurationSeconds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.estimatedDurationSeconds;
    }

    @Override
    public void setEstimatedDurationSeconds(Integer estimatedDurationSeconds) {
        this.setEstimatedDurationSeconds(estimatedDurationSeconds, true);
    }

    private void setEstimatedDurationSeconds(Integer estimatedDurationSeconds, boolean setDirty) {
        Integer oldEstimatedDurationSeconds = this.getEstimatedDurationSeconds();
        if (new EqualsBuilder().append(oldEstimatedDurationSeconds, estimatedDurationSeconds).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.ESTIMATED_DURATION_SECONDS.getPropertyName());
        }
        this.estimatedDurationSeconds = estimatedDurationSeconds;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.ESTIMATED_DURATION_SECONDS, estimatedDurationSeconds, oldEstimatedDurationSeconds);
    }

    @Override
    public Integer getMetersFromStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.metersFromStart;
    }

    @Override
    public void setMetersFromStart(Integer metersFromStart) {
        this.setMetersFromStart(metersFromStart, true);
    }

    private void setMetersFromStart(Integer metersFromStart, boolean setDirty) {
        Integer oldMetersFromStart = this.getMetersFromStart();
        if (new EqualsBuilder().append(oldMetersFromStart, metersFromStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.METERS_FROM_START.getPropertyName());
        }
        this.metersFromStart = metersFromStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.METERS_FROM_START, metersFromStart, oldMetersFromStart);
    }

    @Override
    public Integer getSecondsFromStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.secondsFromStart;
    }

    @Override
    public void setSecondsFromStart(Integer secondsFromStart) {
        this.setSecondsFromStart(secondsFromStart, true);
    }

    private void setSecondsFromStart(Integer secondsFromStart, boolean setDirty) {
        Integer oldSecondsFromStart = this.getSecondsFromStart();
        if (new EqualsBuilder().append(oldSecondsFromStart, secondsFromStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.SECONDS_FROM_START.getPropertyName());
        }
        this.secondsFromStart = secondsFromStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.SECONDS_FROM_START, secondsFromStart, oldSecondsFromStart);
    }

    @Override
    public Integer getPart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.part;
    }

    @Override
    public void setPart(Integer part) {
        this.setPart(part, true);
    }

    private void setPart(Integer part, boolean setDirty) {
        Integer oldPart = this.getPart();
        if (new EqualsBuilder().append(oldPart, part).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.PART.getPropertyName());
        }
        this.part = part;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.PART, part, oldPart);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public HistoryAreaTourModel getHistoryAreaTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.historyAreaTour;
    }

    @Override
    public void setHistoryAreaTour(HistoryAreaTourModel historyAreaTour) {
        this.setHistoryAreaTour(historyAreaTour, true);
    }

    private void setHistoryAreaTour(HistoryAreaTourModel historyAreaTour, boolean setDirty) {
        HistoryAreaTourModel oldHistoryAreaTour = this.getHistoryAreaTour();
        if (oldHistoryAreaTour == historyAreaTour) {
            return;
        }
        if (oldHistoryAreaTour != null) {
            oldHistoryAreaTour.removeAHistoryAreaTourStop(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, HistoryAreaStopModelEnum.HISTORY_AREA_TOUR.getPropertyName());
        }
        this.historyAreaTour = historyAreaTour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(HistoryAreaStopModelEnum.HISTORY_AREA_TOUR, historyAreaTour, oldHistoryAreaTour);
        if (this.historyAreaTour != null) {
            this.historyAreaTour.addAHistoryAreaTourStop(this);
        }
    }

    @Override
    protected void updateByDto(HistoryAreaStopFullDto historyAreaStopDto) {
        ImmutablePointDto location = historyAreaStopDto.getLocation();
        this.location = location == null ? null : (ImmutablePoint)location.getGeoObject();
        ImmutablePointDto accessLocation = historyAreaStopDto.getAccessLocation();
        this.accessLocation = accessLocation == null ? null : (ImmutablePoint)accessLocation.getGeoObject();
        this.estimatedDurationSeconds = historyAreaStopDto.getEstimatedDurationSeconds();
        this.metersFromStart = historyAreaStopDto.getMetersFromStart();
        this.secondsFromStart = historyAreaStopDto.getSecondsFromStart();
        this.part = historyAreaStopDto.getPart();
        this.sortOrder = historyAreaStopDto.getSortOrder();
        this.historyAreaTour = (HistoryAreaTourModel)this.getModelCache().getModel(historyAreaStopDto.getHistoryAreaTour());
    }

    @Override
    protected void updateMasterRelationsByDto(HistoryAreaStopFullDto historyAreaStopDto) {
    }

    @Override
    protected void checkStaleByDto(HistoryAreaStopFullDto historyAreaStopDto) throws StaleStateException {
        HistoryAreaTourModelImpl historyAreaTourModel;
        HistoryAreaTourDto historyAreaTourDto = historyAreaStopDto.getHistoryAreaTour();
        if (historyAreaTourDto != null && historyAreaTourDto.getId() != null && (historyAreaTourModel = (HistoryAreaTourModelImpl)this.getModelCache().getModel(HistoryAreaTourModel.class, historyAreaTourDto.getId())) != null) {
            historyAreaTourModel.checkStaleState(historyAreaTourDto);
        }
    }

    @Override
    public HistoryAreaStopFullDto createDto() {
        Long id = this.getId();
        HistoryAreaStopFullDto historyAreaStopDto = id == null ? new HistoryAreaStopFullDto(this.getTempUUID()) : new HistoryAreaStopFullDto(id, this.getVersion());
        ImmutablePoint location = this.getLocation();
        historyAreaStopDto.setLocation(ImmutablePointDto.create(location));
        ImmutablePoint accessLocation = this.getAccessLocation();
        historyAreaStopDto.setAccessLocation(ImmutablePointDto.create(accessLocation));
        historyAreaStopDto.setEstimatedDurationSeconds(this.getEstimatedDurationSeconds());
        historyAreaStopDto.setMetersFromStart(this.getMetersFromStart());
        historyAreaStopDto.setSecondsFromStart(this.getSecondsFromStart());
        historyAreaStopDto.setPart(this.getPart());
        historyAreaStopDto.setSortOrder(this.getSortOrder());
        HistoryAreaTourModelImpl historyAreaTour = (HistoryAreaTourModelImpl)this.getHistoryAreaTour();
        if (historyAreaTour != null) {
            historyAreaStopDto.setHistoryAreaTour(historyAreaTour.createProxy());
        }
        return historyAreaStopDto;
    }

    @Override
    public HistoryAreaStopProxyDto createProxy() {
        Long id = this.getId();
        HistoryAreaStopProxyDto historyAreaStopDto = id == null ? new HistoryAreaStopProxyDto(this.getTempUUID()) : new HistoryAreaStopProxyDto(id, this.getVersion());
        return historyAreaStopDto;
    }

    public static enum HistoryAreaStopModelEnum {
        LOCATION("location"),
        ACCESS_LOCATION("accessLocation"),
        ESTIMATED_DURATION_SECONDS("estimatedDurationSeconds"),
        METERS_FROM_START("metersFromStart"),
        SECONDS_FROM_START("secondsFromStart"),
        PART("part"),
        SORT_ORDER("sortOrder"),
        HISTORY_AREA_TOUR("historyAreaTour");

        private String propertyName;

        private HistoryAreaStopModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

