/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.BranchModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.client.model.tour.VehicleModel;
import de.datomino.peppergis.client.model.tour.VehicleModelImpl;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.TourFullDto;
import de.datomino.peppergis.dto.tour.TourPartDto;
import de.datomino.peppergis.dto.tour.TourProxyDto;
import de.datomino.peppergis.dto.tour.VehicleDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class TourModelImpl
extends AbstractModel<TourFullDto, TourProxyDto>
implements TourModel {
    private String name;
    private String information;
    private Date plannedStartTime;
    private Date actualStartTime;
    private DelivererModel deliverer;
    private VehicleModel vehicle;
    private BranchModel branch;
    private List<TourPartModel> tourParts = null;
    private Boolean mobileActive;
    private Boolean mobileAlreadySynced;
    private Integer kilometerStart;
    private Integer kilometerEnd;
    private Date actualEndTime;
    private Double startWeight;

    public TourModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TourModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public Date getPlannedStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.plannedStartTime;
    }

    @Override
    public void setPlannedStartTime(Date plannedStartTime) {
        this.setPlannedStartTime(plannedStartTime, true);
    }

    private void setPlannedStartTime(Date plannedStartTime, boolean setDirty) {
        Date oldPlannedStartTime = this.getPlannedStartTime();
        if (new EqualsBuilder().append(oldPlannedStartTime, plannedStartTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.PLANNED_START_TIME.getPropertyName());
        }
        this.plannedStartTime = plannedStartTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.PLANNED_START_TIME, plannedStartTime, oldPlannedStartTime);
    }

    @Override
    public Date getActualStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.actualStartTime;
    }

    @Override
    public void setActualStartTime(Date actualStartTime) {
        this.setActualStartTime(actualStartTime, true);
    }

    private void setActualStartTime(Date actualStartTime, boolean setDirty) {
        Date oldActualStartTime = this.getActualStartTime();
        if (new EqualsBuilder().append(oldActualStartTime, actualStartTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.ACTUAL_START_TIME.getPropertyName());
        }
        this.actualStartTime = actualStartTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.ACTUAL_START_TIME, actualStartTime, oldActualStartTime);
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.DELIVERER, deliverer, oldDeliverer);
    }

    @Override
    public VehicleModel getVehicle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicle;
    }

    @Override
    public void setVehicle(VehicleModel vehicle) {
        this.setVehicle(vehicle, true);
    }

    private void setVehicle(VehicleModel vehicle, boolean setDirty) {
        VehicleModel oldVehicle = this.getVehicle();
        if (oldVehicle == vehicle) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.VEHICLE.getPropertyName());
        }
        this.vehicle = vehicle;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.VEHICLE, vehicle, oldVehicle);
    }

    @Override
    public BranchModel getBranch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.branch;
    }

    @Override
    public void setBranch(BranchModel branch) {
        this.setBranch(branch, true);
    }

    private void setBranch(BranchModel branch, boolean setDirty) {
        BranchModel oldBranch = this.getBranch();
        if (oldBranch == branch) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.BRANCH.getPropertyName());
        }
        this.branch = branch;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.BRANCH, branch, oldBranch);
    }

    @Override
    public int countTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return this.tourParts.size();
    }

    @Override
    public Iterator<TourPartModel> iterateTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return new ImmutableIterator<TourPartModel>(this.tourParts);
    }

    @Override
    public Iterable<TourPartModel> iterableTourParts() {
        return new IteratorIterable<TourPartModel>(this.iterateTourParts());
    }

    @Override
    public void addTourPart(TourPartModel tourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        if (this.tourParts.contains(tourPart)) {
            return;
        }
        this.tourParts.add(tourPart);
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, tourPart, null);
        if (tourPart != null) {
            tourPart.setTour(this);
            tourPart.setSortOrder(this.tourParts.size() - 1);
        }
    }

    @Override
    public void removeTourPart(TourPartModel tourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        if (!this.tourParts.contains(tourPart)) {
            return;
        }
        this.tourParts.remove(tourPart);
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, tourPart, null);
        if (tourPart != null) {
            tourPart.setTour(null);
            tourPart.setSortOrder(null);
        }
        this.reorderTourParts(0);
    }

    @Override
    public TourPartModel getTourPartAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return this.tourParts.get(index);
    }

    @Override
    public void insertTourPart(TourPartModel tourPart, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        if (this.tourParts.contains(tourPart)) {
            this.removeTourPart(tourPart);
        }
        this.tourParts.add(index, tourPart);
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, tourPart, null);
        if (tourPart != null) {
            tourPart.setTour(this);
        }
        this.reorderTourParts(index);
    }

    @Override
    public void removeTourPartAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        TourPartModel oldTourPart = this.tourParts.get(index);
        this.tourParts.remove(index);
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, oldTourPart, null);
        if (oldTourPart != null) {
            oldTourPart.setTour(null);
            oldTourPart.setSortOrder(null);
        }
        this.reorderTourParts(index);
    }

    @Override
    public void setTourPartAt(TourPartModel tourPart, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        TourPartModel oldTourPart = this.tourParts.get(index);
        this.tourParts.set(index, tourPart);
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, tourPart, oldTourPart);
        if (oldTourPart != null) {
            oldTourPart.setTour(null);
            oldTourPart.setSortOrder(null);
        }
        if (tourPart != null) {
            tourPart.setTour(this);
            tourPart.setSortOrder(index);
        }
    }

    @Override
    public void clearTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        ArrayList<TourPartModel> oldTourParts = new ArrayList<TourPartModel>(this.tourParts);
        this.tourParts.clear();
        this.fireValueChanged(TourModelEnum.TOUR_PARTS, null, null);
        for (TourPartModel oldTourPart : oldTourParts) {
            if (oldTourPart == null) continue;
            oldTourPart.setTour(null);
            oldTourPart.setSortOrder(null);
        }
    }

    @Override
    public boolean isTourPartsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return this.tourParts.isEmpty();
    }

    @Override
    public boolean containsTourPart(TourPartModel tourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return this.tourParts.contains(tourPart);
    }

    @Override
    public int indexOfTourPart(TourPartModel tourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        return this.tourParts.indexOf(tourPart);
    }

    @Override
    public boolean isTourPartsInitialized() {
        return this.tourParts != null;
    }

    private void reorderTourParts(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<TourPartModel>();
            if (this.getId() != null) {
                Collection tourPartsCollection = this.commonCaller.fetchChildren(this, TourModelEnum.TOUR_PARTS.getPropertyName());
                this.tourParts.addAll(tourPartsCollection);
            }
        }
        ListIterator<TourPartModel> listIterator = this.tourParts.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            TourPartModel tourPart = listIterator.next();
            tourPart.setSortOrder(index++);
        }
    }

    @Override
    public Boolean getMobileActive() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileActive;
    }

    @Override
    public void setMobileActive(Boolean mobileActive) {
        this.setMobileActive(mobileActive, true);
    }

    private void setMobileActive(Boolean mobileActive, boolean setDirty) {
        Boolean oldMobileActive = this.getMobileActive();
        if (new EqualsBuilder().append(oldMobileActive, mobileActive).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.MOBILE_ACTIVE.getPropertyName());
        }
        this.mobileActive = mobileActive;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.MOBILE_ACTIVE, mobileActive, oldMobileActive);
    }

    @Override
    public Boolean getMobileAlreadySynced() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileAlreadySynced;
    }

    @Override
    public void setMobileAlreadySynced(Boolean mobileAlreadySynced) {
        this.setMobileAlreadySynced(mobileAlreadySynced, true);
    }

    private void setMobileAlreadySynced(Boolean mobileAlreadySynced, boolean setDirty) {
        Boolean oldMobileAlreadySynced = this.getMobileAlreadySynced();
        if (new EqualsBuilder().append(oldMobileAlreadySynced, mobileAlreadySynced).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.MOBILE_ALREADY_SYNCED.getPropertyName());
        }
        this.mobileAlreadySynced = mobileAlreadySynced;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.MOBILE_ALREADY_SYNCED, mobileAlreadySynced, oldMobileAlreadySynced);
    }

    @Override
    public Integer getKilometerStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.kilometerStart;
    }

    @Override
    public void setKilometerStart(Integer kilometerStart) {
        this.setKilometerStart(kilometerStart, true);
    }

    private void setKilometerStart(Integer kilometerStart, boolean setDirty) {
        Integer oldKilometerStart = this.getKilometerStart();
        if (new EqualsBuilder().append(oldKilometerStart, kilometerStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.KILOMETER_START.getPropertyName());
        }
        this.kilometerStart = kilometerStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.KILOMETER_START, kilometerStart, oldKilometerStart);
    }

    @Override
    public Integer getKilometerEnd() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.kilometerEnd;
    }

    @Override
    public void setKilometerEnd(Integer kilometerEnd) {
        this.setKilometerEnd(kilometerEnd, true);
    }

    private void setKilometerEnd(Integer kilometerEnd, boolean setDirty) {
        Integer oldKilometerEnd = this.getKilometerEnd();
        if (new EqualsBuilder().append(oldKilometerEnd, kilometerEnd).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.KILOMETER_END.getPropertyName());
        }
        this.kilometerEnd = kilometerEnd;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.KILOMETER_END, kilometerEnd, oldKilometerEnd);
    }

    @Override
    public Date getActualEndTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.actualEndTime;
    }

    @Override
    public void setActualEndTime(Date actualEndTime) {
        this.setActualEndTime(actualEndTime, true);
    }

    private void setActualEndTime(Date actualEndTime, boolean setDirty) {
        Date oldActualEndTime = this.getActualEndTime();
        if (new EqualsBuilder().append(oldActualEndTime, actualEndTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.ACTUAL_END_TIME.getPropertyName());
        }
        this.actualEndTime = actualEndTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.ACTUAL_END_TIME, actualEndTime, oldActualEndTime);
    }

    @Override
    public Double getStartWeight() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startWeight;
    }

    @Override
    public void setStartWeight(Double startWeight) {
        this.setStartWeight(startWeight, true);
    }

    private void setStartWeight(Double startWeight, boolean setDirty) {
        Double oldStartWeight = this.getStartWeight();
        if (new EqualsBuilder().append(oldStartWeight, startWeight).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourModelEnum.START_WEIGHT.getPropertyName());
        }
        this.startWeight = startWeight;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourModelEnum.START_WEIGHT, startWeight, oldStartWeight);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.tourParts = null;
        }
    }

    @Override
    protected void updateByDto(TourFullDto tourDto) {
        this.name = tourDto.getName();
        this.information = tourDto.getInformation();
        this.plannedStartTime = tourDto.getPlannedStartTime();
        this.actualStartTime = tourDto.getActualStartTime();
        this.deliverer = (DelivererModel)this.getModelCache().getModel(tourDto.getDeliverer());
        this.vehicle = (VehicleModel)this.getModelCache().getModel(tourDto.getVehicle());
        this.branch = (BranchModel)this.getModelCache().getModel(tourDto.getBranch());
        TourPartDto[] tourParts = tourDto.getTourParts();
        if (tourParts != null) {
            if (this.tourParts == null) {
                this.tourParts = new ArrayList<TourPartModel>();
            } else {
                this.tourParts.clear();
            }
        }
        this.mobileActive = tourDto.getMobileActive();
        this.mobileAlreadySynced = tourDto.getMobileAlreadySynced();
        this.kilometerStart = tourDto.getKilometerStart();
        this.kilometerEnd = tourDto.getKilometerEnd();
        this.actualEndTime = tourDto.getActualEndTime();
        this.startWeight = tourDto.getStartWeight();
    }

    @Override
    protected void updateMasterRelationsByDto(TourFullDto tourDto) {
        TourPartDto[] tourParts = tourDto.getTourParts();
        if (tourParts != null) {
            if (this.tourParts == null) {
                this.tourParts = new ArrayList<TourPartModel>();
            } else {
                this.tourParts.clear();
            }
            for (TourPartDto tourPartDto : tourParts) {
                TourPartModel tourPartModel = (TourPartModel)this.getModelCache().getModel(tourPartDto);
                this.tourParts.add(tourPartModel);
            }
        } else {
            this.tourParts = null;
        }
    }

    @Override
    protected void checkStaleByDto(TourFullDto tourDto) throws StaleStateException {
        TourPartDto[] tourPartDtos;
        BranchModelImpl branchModel;
        BranchDto branchDto;
        VehicleModelImpl vehicleModel;
        VehicleDto vehicleDto;
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto = tourDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
        if ((vehicleDto = tourDto.getVehicle()) != null && vehicleDto.getId() != null && (vehicleModel = (VehicleModelImpl)this.getModelCache().getModel(VehicleModel.class, vehicleDto.getId())) != null) {
            vehicleModel.checkStaleState(vehicleDto);
        }
        if ((branchDto = tourDto.getBranch()) != null && branchDto.getId() != null && (branchModel = (BranchModelImpl)this.getModelCache().getModel(BranchModel.class, branchDto.getId())) != null) {
            branchModel.checkStaleState(branchDto);
        }
        if ((tourPartDtos = tourDto.getTourParts()) != null) {
            for (TourPartDto tourPartDto : tourPartDtos) {
                TourPartModelImpl tourPartModel = (TourPartModelImpl)this.getModelCache().getModel(TourPartModel.class, tourPartDto.getId());
                if (tourPartModel == null) continue;
                tourPartModel.checkStaleState(tourPartDto);
            }
        }
    }

    @Override
    public TourFullDto createDto() {
        BranchModelImpl branch;
        VehicleModelImpl vehicle;
        Long id = this.getId();
        TourFullDto tourDto = id == null ? new TourFullDto(this.getTempUUID()) : new TourFullDto(id, this.getVersion());
        tourDto.setName(this.getName());
        tourDto.setInformation(this.getInformation());
        tourDto.setPlannedStartTime(this.getPlannedStartTime());
        tourDto.setActualStartTime(this.getActualStartTime());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            tourDto.setDeliverer(deliverer.createProxy());
        }
        if ((vehicle = (VehicleModelImpl)this.getVehicle()) != null) {
            tourDto.setVehicle(vehicle.createProxy());
        }
        if ((branch = (BranchModelImpl)this.getBranch()) != null) {
            tourDto.setBranch(branch.createProxy());
        }
        tourDto.setMobileActive(this.getMobileActive());
        tourDto.setMobileAlreadySynced(this.getMobileAlreadySynced());
        tourDto.setKilometerStart(this.getKilometerStart());
        tourDto.setKilometerEnd(this.getKilometerEnd());
        tourDto.setActualEndTime(this.getActualEndTime());
        tourDto.setStartWeight(this.getStartWeight());
        return tourDto;
    }

    @Override
    public TourProxyDto createProxy() {
        Long id = this.getId();
        TourProxyDto tourDto = id == null ? new TourProxyDto(this.getTempUUID()) : new TourProxyDto(id, this.getVersion());
        return tourDto;
    }

    public static enum TourModelEnum {
        NAME("name"),
        INFORMATION("information"),
        PLANNED_START_TIME("plannedStartTime"),
        ACTUAL_START_TIME("actualStartTime"),
        DELIVERER("deliverer"),
        VEHICLE("vehicle"),
        BRANCH("branch"),
        TOUR_PARTS("tourParts"),
        MOBILE_ACTIVE("mobileActive"),
        MOBILE_ALREADY_SYNCED("mobileAlreadySynced"),
        KILOMETER_START("kilometerStart"),
        KILOMETER_END("kilometerEnd"),
        ACTUAL_END_TIME("actualEndTime"),
        START_WEIGHT("startWeight");

        private String propertyName;

        private TourModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

