/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.dto.tour.TimeWindowFullDto;
import de.datomino.peppergis.dto.tour.TimeWindowProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class TimeWindowModelImpl
extends AbstractModel<TimeWindowFullDto, TimeWindowProxyDto>
implements TimeWindowModel {
    private Date startTime;
    private Date endTime;
    private StopModel stop;

    public TimeWindowModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TimeWindowModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Date getStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.setStartTime(startTime, true);
    }

    private void setStartTime(Date startTime, boolean setDirty) {
        Date oldStartTime = this.getStartTime();
        if (new EqualsBuilder().append(oldStartTime, startTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TimeWindowModelEnum.START_TIME.getPropertyName());
        }
        this.startTime = startTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TimeWindowModelEnum.START_TIME, startTime, oldStartTime);
    }

    @Override
    public Date getEndTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.setEndTime(endTime, true);
    }

    private void setEndTime(Date endTime, boolean setDirty) {
        Date oldEndTime = this.getEndTime();
        if (new EqualsBuilder().append(oldEndTime, endTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TimeWindowModelEnum.END_TIME.getPropertyName());
        }
        this.endTime = endTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TimeWindowModelEnum.END_TIME, endTime, oldEndTime);
    }

    @Override
    public StopModel getStop() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stop;
    }

    @Override
    public void setStop(StopModel stop) {
        this.setStop(stop, true);
    }

    private void setStop(StopModel stop, boolean setDirty) {
        StopModel oldStop = this.getStop();
        if (oldStop == stop) {
            return;
        }
        if (oldStop != null) {
            oldStop.removeTimeWindow(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TimeWindowModelEnum.STOP.getPropertyName());
        }
        this.stop = stop;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TimeWindowModelEnum.STOP, stop, oldStop);
        if (this.stop != null) {
            this.stop.addTimeWindow(this);
        }
    }

    @Override
    protected void updateByDto(TimeWindowFullDto timeWindowDto) {
        this.startTime = timeWindowDto.getStartTime();
        this.endTime = timeWindowDto.getEndTime();
        this.stop = (StopModel)this.getModelCache().getModel(timeWindowDto.getStop());
    }

    @Override
    protected void updateMasterRelationsByDto(TimeWindowFullDto timeWindowDto) {
    }

    @Override
    protected void checkStaleByDto(TimeWindowFullDto timeWindowDto) throws StaleStateException {
        StopModelImpl stopModel;
        StopDto stopDto = timeWindowDto.getStop();
        if (stopDto != null && stopDto.getId() != null && (stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId())) != null) {
            stopModel.checkStaleState(stopDto);
        }
    }

    @Override
    public TimeWindowFullDto createDto() {
        Long id = this.getId();
        TimeWindowFullDto timeWindowDto = id == null ? new TimeWindowFullDto(this.getTempUUID()) : new TimeWindowFullDto(id, this.getVersion());
        timeWindowDto.setStartTime(this.getStartTime());
        timeWindowDto.setEndTime(this.getEndTime());
        StopModelImpl stop = (StopModelImpl)this.getStop();
        if (stop != null) {
            timeWindowDto.setStop(stop.createProxy());
        }
        return timeWindowDto;
    }

    @Override
    public TimeWindowProxyDto createProxy() {
        Long id = this.getId();
        TimeWindowProxyDto timeWindowDto = id == null ? new TimeWindowProxyDto(this.getTempUUID()) : new TimeWindowProxyDto(id, this.getVersion());
        return timeWindowDto;
    }

    public static enum TimeWindowModelEnum {
        START_TIME("startTime"),
        END_TIME("endTime"),
        STOP("stop");

        private String propertyName;

        private TimeWindowModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

