/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.BranchModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModelImpl;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.mobile.LocationCapturingDto;
import de.datomino.peppergis.dto.tour.ServiceTicketStopRelationDto;
import de.datomino.peppergis.dto.tour.StopFullDto;
import de.datomino.peppergis.dto.tour.StopProxyDto;
import de.datomino.peppergis.dto.tour.TimeWindowDto;
import de.datomino.peppergis.dto.tour.TourPartDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.StopStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class StopModelImpl
extends AbstractModel<StopFullDto, StopProxyDto>
implements StopModel {
    private String name;
    private String information;
    private String parkingInformation;
    private String delivererInformation;
    private LocationModel location;
    private Date estimatedTimeOfArrival;
    private Integer estimatedDurationSeconds;
    private Integer streetMileageMetersFromTourStart;
    private Date actualTimeOfArrival;
    private Integer actualDurationSeconds;
    private Set<TimeWindowModel> timeWindows = null;
    private TourPartModel tourPart;
    private Set<ServiceTicketStopRelationModel> serviceStopRelations = null;
    private Integer sortOrder;
    private PoiModel poi;
    private BranchModel branch;
    private Integer importOrder;
    private Boolean exportedByJob;
    private Set<LocationCapturingModel> locationCapturings = null;
    private StopStatus stopStatus;
    private Integer gpsDurationSeconds;

    public StopModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public StopModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public String getParkingInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parkingInformation;
    }

    @Override
    public void setParkingInformation(String parkingInformation) {
        this.setParkingInformation(parkingInformation, true);
    }

    private void setParkingInformation(String parkingInformation, boolean setDirty) {
        String oldParkingInformation = this.getParkingInformation();
        if (new EqualsBuilder().append(oldParkingInformation, parkingInformation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.PARKING_INFORMATION.getPropertyName());
        }
        this.parkingInformation = parkingInformation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.PARKING_INFORMATION, parkingInformation, oldParkingInformation);
    }

    @Override
    public String getDelivererInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.delivererInformation;
    }

    @Override
    public void setDelivererInformation(String delivererInformation) {
        this.setDelivererInformation(delivererInformation, true);
    }

    private void setDelivererInformation(String delivererInformation, boolean setDirty) {
        String oldDelivererInformation = this.getDelivererInformation();
        if (new EqualsBuilder().append(oldDelivererInformation, delivererInformation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.DELIVERER_INFORMATION.getPropertyName());
        }
        this.delivererInformation = delivererInformation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.DELIVERER_INFORMATION, delivererInformation, oldDelivererInformation);
    }

    @Override
    public LocationModel getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(LocationModel location) {
        this.setLocation(location, true);
    }

    private void setLocation(LocationModel location, boolean setDirty) {
        LocationModel oldLocation = this.getLocation();
        if (oldLocation == location) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public Date getEstimatedTimeOfArrival() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.estimatedTimeOfArrival;
    }

    @Override
    public void setEstimatedTimeOfArrival(Date estimatedTimeOfArrival) {
        this.setEstimatedTimeOfArrival(estimatedTimeOfArrival, true);
    }

    private void setEstimatedTimeOfArrival(Date estimatedTimeOfArrival, boolean setDirty) {
        Date oldEstimatedTimeOfArrival = this.getEstimatedTimeOfArrival();
        if (new EqualsBuilder().append(oldEstimatedTimeOfArrival, estimatedTimeOfArrival).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.ESTIMATED_TIME_OF_ARRIVAL.getPropertyName());
        }
        this.estimatedTimeOfArrival = estimatedTimeOfArrival;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.ESTIMATED_TIME_OF_ARRIVAL, estimatedTimeOfArrival, oldEstimatedTimeOfArrival);
    }

    @Override
    public Integer getEstimatedDurationSeconds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.estimatedDurationSeconds;
    }

    @Override
    public void setEstimatedDurationSeconds(Integer estimatedDurationSeconds) {
        this.setEstimatedDurationSeconds(estimatedDurationSeconds, true);
    }

    private void setEstimatedDurationSeconds(Integer estimatedDurationSeconds, boolean setDirty) {
        Integer oldEstimatedDurationSeconds = this.getEstimatedDurationSeconds();
        if (new EqualsBuilder().append(oldEstimatedDurationSeconds, estimatedDurationSeconds).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.ESTIMATED_DURATION_SECONDS.getPropertyName());
        }
        this.estimatedDurationSeconds = estimatedDurationSeconds;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.ESTIMATED_DURATION_SECONDS, estimatedDurationSeconds, oldEstimatedDurationSeconds);
    }

    @Override
    public Integer getStreetMileageMetersFromTourStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.streetMileageMetersFromTourStart;
    }

    @Override
    public void setStreetMileageMetersFromTourStart(Integer streetMileageMetersFromTourStart) {
        this.setStreetMileageMetersFromTourStart(streetMileageMetersFromTourStart, true);
    }

    private void setStreetMileageMetersFromTourStart(Integer streetMileageMetersFromTourStart, boolean setDirty) {
        Integer oldStreetMileageMetersFromTourStart = this.getStreetMileageMetersFromTourStart();
        if (new EqualsBuilder().append(oldStreetMileageMetersFromTourStart, streetMileageMetersFromTourStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.STREET_MILEAGE_METERS_FROM_TOUR_START.getPropertyName());
        }
        this.streetMileageMetersFromTourStart = streetMileageMetersFromTourStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.STREET_MILEAGE_METERS_FROM_TOUR_START, streetMileageMetersFromTourStart, oldStreetMileageMetersFromTourStart);
    }

    @Override
    public Date getActualTimeOfArrival() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.actualTimeOfArrival;
    }

    @Override
    public void setActualTimeOfArrival(Date actualTimeOfArrival) {
        this.setActualTimeOfArrival(actualTimeOfArrival, true);
    }

    private void setActualTimeOfArrival(Date actualTimeOfArrival, boolean setDirty) {
        Date oldActualTimeOfArrival = this.getActualTimeOfArrival();
        if (new EqualsBuilder().append(oldActualTimeOfArrival, actualTimeOfArrival).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.ACTUAL_TIME_OF_ARRIVAL.getPropertyName());
        }
        this.actualTimeOfArrival = actualTimeOfArrival;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.ACTUAL_TIME_OF_ARRIVAL, actualTimeOfArrival, oldActualTimeOfArrival);
    }

    @Override
    public Integer getActualDurationSeconds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.actualDurationSeconds;
    }

    @Override
    public void setActualDurationSeconds(Integer actualDurationSeconds) {
        this.setActualDurationSeconds(actualDurationSeconds, true);
    }

    private void setActualDurationSeconds(Integer actualDurationSeconds, boolean setDirty) {
        Integer oldActualDurationSeconds = this.getActualDurationSeconds();
        if (new EqualsBuilder().append(oldActualDurationSeconds, actualDurationSeconds).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.ACTUAL_DURATION_SECONDS.getPropertyName());
        }
        this.actualDurationSeconds = actualDurationSeconds;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.ACTUAL_DURATION_SECONDS, actualDurationSeconds, oldActualDurationSeconds);
    }

    @Override
    public int countTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        return this.timeWindows.size();
    }

    @Override
    public Iterator<TimeWindowModel> iterateTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        return new ImmutableIterator<TimeWindowModel>(this.timeWindows);
    }

    @Override
    public Iterable<TimeWindowModel> iterableTimeWindows() {
        return new IteratorIterable<TimeWindowModel>(this.iterateTimeWindows());
    }

    @Override
    public void addTimeWindow(TimeWindowModel timeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        if (this.timeWindows.contains(timeWindow)) {
            return;
        }
        this.timeWindows.add(timeWindow);
        this.fireValueChanged(StopModelEnum.TIME_WINDOWS, timeWindow, null);
        if (timeWindow != null) {
            timeWindow.setStop(this);
        }
    }

    @Override
    public void removeTimeWindow(TimeWindowModel timeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        if (!this.timeWindows.contains(timeWindow)) {
            return;
        }
        this.timeWindows.remove(timeWindow);
        this.fireValueChanged(StopModelEnum.TIME_WINDOWS, timeWindow, null);
        if (timeWindow != null) {
            timeWindow.setStop(null);
        }
    }

    @Override
    public void clearTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        ArrayList<TimeWindowModel> oldTimeWindows = new ArrayList<TimeWindowModel>(this.timeWindows);
        this.timeWindows.clear();
        this.fireValueChanged(StopModelEnum.TIME_WINDOWS, null, null);
        for (TimeWindowModel oldTimeWindow : oldTimeWindows) {
            if (oldTimeWindow == null) continue;
            oldTimeWindow.setStop(null);
        }
    }

    @Override
    public boolean isTimeWindowsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        return this.timeWindows.isEmpty();
    }

    @Override
    public boolean containsTimeWindow(TimeWindowModel timeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.timeWindows == null) {
            this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            if (this.getId() != null) {
                Collection timeWindowsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.TIME_WINDOWS.getPropertyName());
                this.timeWindows.addAll(timeWindowsCollection);
            }
        }
        return this.timeWindows.contains(timeWindow);
    }

    @Override
    public boolean isTimeWindowsInitialized() {
        return this.timeWindows != null;
    }

    @Override
    public TourPartModel getTourPart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tourPart;
    }

    @Override
    public void setTourPart(TourPartModel tourPart) {
        this.setTourPart(tourPart, true);
    }

    private void setTourPart(TourPartModel tourPart, boolean setDirty) {
        TourPartModel oldTourPart = this.getTourPart();
        if (oldTourPart == tourPart) {
            return;
        }
        if (oldTourPart != null) {
            oldTourPart.removeStop(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.TOUR_PART.getPropertyName());
        }
        this.tourPart = tourPart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.TOUR_PART, tourPart, oldTourPart);
        if (this.tourPart != null) {
            this.tourPart.addStop(this);
        }
    }

    @Override
    public int countServiceStopRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        return this.serviceStopRelations.size();
    }

    @Override
    public Iterator<ServiceTicketStopRelationModel> iterateServiceStopRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        return new ImmutableIterator<ServiceTicketStopRelationModel>(this.serviceStopRelations);
    }

    @Override
    public Iterable<ServiceTicketStopRelationModel> iterableServiceStopRelations() {
        return new IteratorIterable<ServiceTicketStopRelationModel>(this.iterateServiceStopRelations());
    }

    @Override
    public void addServiceStopRelation(ServiceTicketStopRelationModel serviceStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        if (this.serviceStopRelations.contains(serviceStopRelation)) {
            return;
        }
        this.serviceStopRelations.add(serviceStopRelation);
        this.fireValueChanged(StopModelEnum.SERVICE_STOP_RELATIONS, serviceStopRelation, null);
        if (serviceStopRelation != null) {
            serviceStopRelation.setStop(this);
        }
    }

    @Override
    public void removeServiceStopRelation(ServiceTicketStopRelationModel serviceStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        if (!this.serviceStopRelations.contains(serviceStopRelation)) {
            return;
        }
        this.serviceStopRelations.remove(serviceStopRelation);
        this.fireValueChanged(StopModelEnum.SERVICE_STOP_RELATIONS, serviceStopRelation, null);
        if (serviceStopRelation != null) {
            serviceStopRelation.setStop(null);
        }
    }

    @Override
    public void clearServiceStopRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        ArrayList<ServiceTicketStopRelationModel> oldServiceStopRelations = new ArrayList<ServiceTicketStopRelationModel>(this.serviceStopRelations);
        this.serviceStopRelations.clear();
        this.fireValueChanged(StopModelEnum.SERVICE_STOP_RELATIONS, null, null);
        for (ServiceTicketStopRelationModel oldServiceStopRelation : oldServiceStopRelations) {
            if (oldServiceStopRelation == null) continue;
            oldServiceStopRelation.setStop(null);
        }
    }

    @Override
    public boolean isServiceStopRelationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        return this.serviceStopRelations.isEmpty();
    }

    @Override
    public boolean containsServiceStopRelation(ServiceTicketStopRelationModel serviceStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStopRelations == null) {
            this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceStopRelationsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.SERVICE_STOP_RELATIONS.getPropertyName());
                this.serviceStopRelations.addAll(serviceStopRelationsCollection);
            }
        }
        return this.serviceStopRelations.contains(serviceStopRelation);
    }

    @Override
    public boolean isServiceStopRelationsInitialized() {
        return this.serviceStopRelations != null;
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (oldPoi != null) {
            oldPoi.removeStop(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.POI, poi, oldPoi);
        if (this.poi != null) {
            this.poi.addStop(this);
        }
    }

    @Override
    public BranchModel getBranch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.branch;
    }

    @Override
    public void setBranch(BranchModel branch) {
        this.setBranch(branch, true);
    }

    private void setBranch(BranchModel branch, boolean setDirty) {
        BranchModel oldBranch = this.getBranch();
        if (oldBranch == branch) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.BRANCH.getPropertyName());
        }
        this.branch = branch;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.BRANCH, branch, oldBranch);
    }

    @Override
    public Integer getImportOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importOrder;
    }

    @Override
    public void setImportOrder(Integer importOrder) {
        this.setImportOrder(importOrder, true);
    }

    private void setImportOrder(Integer importOrder, boolean setDirty) {
        Integer oldImportOrder = this.getImportOrder();
        if (new EqualsBuilder().append(oldImportOrder, importOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.IMPORT_ORDER.getPropertyName());
        }
        this.importOrder = importOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.IMPORT_ORDER, importOrder, oldImportOrder);
    }

    @Override
    public Boolean getExportedByJob() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.exportedByJob;
    }

    @Override
    public void setExportedByJob(Boolean exportedByJob) {
        this.setExportedByJob(exportedByJob, true);
    }

    private void setExportedByJob(Boolean exportedByJob, boolean setDirty) {
        Boolean oldExportedByJob = this.getExportedByJob();
        if (new EqualsBuilder().append(oldExportedByJob, exportedByJob).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.EXPORTED_BY_JOB.getPropertyName());
        }
        this.exportedByJob = exportedByJob;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.EXPORTED_BY_JOB, exportedByJob, oldExportedByJob);
    }

    @Override
    public int countLocationCapturings() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        return this.locationCapturings.size();
    }

    @Override
    public Iterator<LocationCapturingModel> iterateLocationCapturings() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        return new ImmutableIterator<LocationCapturingModel>(this.locationCapturings);
    }

    @Override
    public Iterable<LocationCapturingModel> iterableLocationCapturings() {
        return new IteratorIterable<LocationCapturingModel>(this.iterateLocationCapturings());
    }

    @Override
    public void addLocationCapturing(LocationCapturingModel locationCapturing) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        if (this.locationCapturings.contains(locationCapturing)) {
            return;
        }
        this.locationCapturings.add(locationCapturing);
        this.fireValueChanged(StopModelEnum.LOCATION_CAPTURINGS, locationCapturing, null);
        if (locationCapturing != null) {
            locationCapturing.setStop(this);
        }
    }

    @Override
    public void removeLocationCapturing(LocationCapturingModel locationCapturing) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        if (!this.locationCapturings.contains(locationCapturing)) {
            return;
        }
        this.locationCapturings.remove(locationCapturing);
        this.fireValueChanged(StopModelEnum.LOCATION_CAPTURINGS, locationCapturing, null);
        if (locationCapturing != null) {
            locationCapturing.setStop(null);
        }
    }

    @Override
    public void clearLocationCapturings() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        ArrayList<LocationCapturingModel> oldLocationCapturings = new ArrayList<LocationCapturingModel>(this.locationCapturings);
        this.locationCapturings.clear();
        this.fireValueChanged(StopModelEnum.LOCATION_CAPTURINGS, null, null);
        for (LocationCapturingModel oldLocationCapturing : oldLocationCapturings) {
            if (oldLocationCapturing == null) continue;
            oldLocationCapturing.setStop(null);
        }
    }

    @Override
    public boolean isLocationCapturingsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        return this.locationCapturings.isEmpty();
    }

    @Override
    public boolean containsLocationCapturing(LocationCapturingModel locationCapturing) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locationCapturings == null) {
            this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            if (this.getId() != null) {
                Collection locationCapturingsCollection = this.commonCaller.fetchChildren(this, StopModelEnum.LOCATION_CAPTURINGS.getPropertyName());
                this.locationCapturings.addAll(locationCapturingsCollection);
            }
        }
        return this.locationCapturings.contains(locationCapturing);
    }

    @Override
    public boolean isLocationCapturingsInitialized() {
        return this.locationCapturings != null;
    }

    @Override
    public StopStatus getStopStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stopStatus;
    }

    @Override
    public void setStopStatus(StopStatus stopStatus) {
        this.setStopStatus(stopStatus, true);
    }

    private void setStopStatus(StopStatus stopStatus, boolean setDirty) {
        StopStatus oldStopStatus = this.getStopStatus();
        if (new EqualsBuilder().append((Object)oldStopStatus, (Object)stopStatus).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.STOP_STATUS.getPropertyName());
        }
        this.stopStatus = stopStatus;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.STOP_STATUS, (Object)stopStatus, (Object)oldStopStatus);
    }

    @Override
    public Integer getGpsDurationSeconds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.gpsDurationSeconds;
    }

    @Override
    public void setGpsDurationSeconds(Integer gpsDurationSeconds) {
        this.setGpsDurationSeconds(gpsDurationSeconds, true);
    }

    private void setGpsDurationSeconds(Integer gpsDurationSeconds, boolean setDirty) {
        Integer oldGpsDurationSeconds = this.getGpsDurationSeconds();
        if (new EqualsBuilder().append(oldGpsDurationSeconds, gpsDurationSeconds).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopModelEnum.GPS_DURATION_SECONDS.getPropertyName());
        }
        this.gpsDurationSeconds = gpsDurationSeconds;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopModelEnum.GPS_DURATION_SECONDS, gpsDurationSeconds, oldGpsDurationSeconds);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.timeWindows = null;
            this.serviceStopRelations = null;
            this.locationCapturings = null;
        }
    }

    @Override
    protected void updateByDto(StopFullDto stopDto) {
        this.name = stopDto.getName();
        this.information = stopDto.getInformation();
        this.parkingInformation = stopDto.getParkingInformation();
        this.delivererInformation = stopDto.getDelivererInformation();
        this.location = (LocationModel)this.getModelCache().getModel(stopDto.getLocation());
        this.estimatedTimeOfArrival = stopDto.getEstimatedTimeOfArrival();
        this.estimatedDurationSeconds = stopDto.getEstimatedDurationSeconds();
        this.streetMileageMetersFromTourStart = stopDto.getStreetMileageMetersFromTourStart();
        this.actualTimeOfArrival = stopDto.getActualTimeOfArrival();
        this.actualDurationSeconds = stopDto.getActualDurationSeconds();
        TimeWindowDto[] timeWindows = stopDto.getTimeWindows();
        if (timeWindows != null) {
            if (this.timeWindows == null) {
                this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            } else {
                this.timeWindows.clear();
            }
        }
        this.tourPart = (TourPartModel)this.getModelCache().getModel(stopDto.getTourPart());
        ServiceTicketStopRelationDto[] serviceStopRelations = stopDto.getServiceStopRelations();
        if (serviceStopRelations != null) {
            if (this.serviceStopRelations == null) {
                this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            } else {
                this.serviceStopRelations.clear();
            }
        }
        this.sortOrder = stopDto.getSortOrder();
        this.poi = (PoiModel)this.getModelCache().getModel(stopDto.getPoi());
        this.branch = (BranchModel)this.getModelCache().getModel(stopDto.getBranch());
        this.importOrder = stopDto.getImportOrder();
        this.exportedByJob = stopDto.getExportedByJob();
        LocationCapturingDto[] locationCapturings = stopDto.getLocationCapturings();
        if (locationCapturings != null) {
            if (this.locationCapturings == null) {
                this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            } else {
                this.locationCapturings.clear();
            }
        }
        this.stopStatus = stopDto.getStopStatus();
        this.gpsDurationSeconds = stopDto.getGpsDurationSeconds();
    }

    @Override
    protected void updateMasterRelationsByDto(StopFullDto stopDto) {
        LocationCapturingDto[] locationCapturings;
        ServiceTicketStopRelationDto[] serviceStopRelations;
        TimeWindowDto[] timeWindows = stopDto.getTimeWindows();
        if (timeWindows != null) {
            if (this.timeWindows == null) {
                this.timeWindows = new LinkedHashSet<TimeWindowModel>();
            } else {
                this.timeWindows.clear();
            }
            for (TimeWindowDto timeWindowDto : timeWindows) {
                TimeWindowModel timeWindowModel = (TimeWindowModel)this.getModelCache().getModel(timeWindowDto);
                this.timeWindows.add(timeWindowModel);
            }
        } else {
            this.timeWindows = null;
        }
        if ((serviceStopRelations = stopDto.getServiceStopRelations()) != null) {
            if (this.serviceStopRelations == null) {
                this.serviceStopRelations = new LinkedHashSet<ServiceTicketStopRelationModel>();
            } else {
                this.serviceStopRelations.clear();
            }
            for (ServiceTicketStopRelationDto serviceStopRelationDto : serviceStopRelations) {
                ServiceTicketStopRelationModel serviceStopRelationModel = (ServiceTicketStopRelationModel)this.getModelCache().getModel(serviceStopRelationDto);
                this.serviceStopRelations.add(serviceStopRelationModel);
            }
        } else {
            this.serviceStopRelations = null;
        }
        if ((locationCapturings = stopDto.getLocationCapturings()) != null) {
            if (this.locationCapturings == null) {
                this.locationCapturings = new LinkedHashSet<LocationCapturingModel>();
            } else {
                this.locationCapturings.clear();
            }
            for (LocationCapturingDto locationCapturingDto : locationCapturings) {
                LocationCapturingModel locationCapturingModel = (LocationCapturingModel)this.getModelCache().getModel(locationCapturingDto);
                this.locationCapturings.add(locationCapturingModel);
            }
        } else {
            this.locationCapturings = null;
        }
    }

    @Override
    protected void checkStaleByDto(StopFullDto stopDto) throws StaleStateException {
        LocationCapturingDto[] locationCapturingDtos;
        BranchModelImpl branchModel;
        BranchDto branchDto;
        PoiModelImpl poiModel;
        PoiDto poiDto;
        ServiceTicketStopRelationDto[] serviceStopRelationDtos;
        TourPartModelImpl tourPartModel;
        TourPartDto tourPartDto;
        TimeWindowDto[] timeWindowDtos;
        LocationModelImpl locationModel;
        LocationDto locationDto = stopDto.getLocation();
        if (locationDto != null && locationDto.getId() != null && (locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId())) != null) {
            locationModel.checkStaleState(locationDto);
        }
        if ((timeWindowDtos = stopDto.getTimeWindows()) != null) {
            for (TimeWindowDto timeWindowDto : timeWindowDtos) {
                TimeWindowModelImpl timeWindowModel = (TimeWindowModelImpl)this.getModelCache().getModel(TimeWindowModel.class, timeWindowDto.getId());
                if (timeWindowModel == null) continue;
                timeWindowModel.checkStaleState(timeWindowDto);
            }
        }
        if ((tourPartDto = stopDto.getTourPart()) != null && tourPartDto.getId() != null && (tourPartModel = (TourPartModelImpl)this.getModelCache().getModel(TourPartModel.class, tourPartDto.getId())) != null) {
            tourPartModel.checkStaleState(tourPartDto);
        }
        if ((serviceStopRelationDtos = stopDto.getServiceStopRelations()) != null) {
            for (ServiceTicketStopRelationDto serviceStopRelationDto : serviceStopRelationDtos) {
                ServiceTicketStopRelationModelImpl serviceStopRelationModel = (ServiceTicketStopRelationModelImpl)this.getModelCache().getModel(ServiceTicketStopRelationModel.class, serviceStopRelationDto.getId());
                if (serviceStopRelationModel == null) continue;
                serviceStopRelationModel.checkStaleState(serviceStopRelationDto);
            }
        }
        if ((poiDto = stopDto.getPoi()) != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
        if ((branchDto = stopDto.getBranch()) != null && branchDto.getId() != null && (branchModel = (BranchModelImpl)this.getModelCache().getModel(BranchModel.class, branchDto.getId())) != null) {
            branchModel.checkStaleState(branchDto);
        }
        if ((locationCapturingDtos = stopDto.getLocationCapturings()) != null) {
            for (LocationCapturingDto locationCapturingDto : locationCapturingDtos) {
                LocationCapturingModelImpl locationCapturingModel = (LocationCapturingModelImpl)this.getModelCache().getModel(LocationCapturingModel.class, locationCapturingDto.getId());
                if (locationCapturingModel == null) continue;
                locationCapturingModel.checkStaleState(locationCapturingDto);
            }
        }
    }

    @Override
    public StopFullDto createDto() {
        BranchModelImpl branch;
        Long id = this.getId();
        StopFullDto stopDto = id == null ? new StopFullDto(this.getTempUUID()) : new StopFullDto(id, this.getVersion());
        stopDto.setName(this.getName());
        stopDto.setInformation(this.getInformation());
        stopDto.setParkingInformation(this.getParkingInformation());
        stopDto.setDelivererInformation(this.getDelivererInformation());
        LocationModelImpl location = (LocationModelImpl)this.getLocation();
        if (location != null) {
            stopDto.setLocation(location.createProxy());
        }
        stopDto.setEstimatedTimeOfArrival(this.getEstimatedTimeOfArrival());
        stopDto.setEstimatedDurationSeconds(this.getEstimatedDurationSeconds());
        stopDto.setStreetMileageMetersFromTourStart(this.getStreetMileageMetersFromTourStart());
        stopDto.setActualTimeOfArrival(this.getActualTimeOfArrival());
        stopDto.setActualDurationSeconds(this.getActualDurationSeconds());
        TourPartModelImpl tourPart = (TourPartModelImpl)this.getTourPart();
        if (tourPart != null) {
            stopDto.setTourPart(tourPart.createProxy());
        }
        stopDto.setSortOrder(this.getSortOrder());
        PoiModelImpl poi = (PoiModelImpl)this.getPoi();
        if (poi != null) {
            stopDto.setPoi(poi.createProxy());
        }
        if ((branch = (BranchModelImpl)this.getBranch()) != null) {
            stopDto.setBranch(branch.createProxy());
        }
        stopDto.setImportOrder(this.getImportOrder());
        stopDto.setExportedByJob(this.getExportedByJob());
        stopDto.setStopStatus(this.getStopStatus());
        stopDto.setGpsDurationSeconds(this.getGpsDurationSeconds());
        return stopDto;
    }

    @Override
    public StopProxyDto createProxy() {
        Long id = this.getId();
        StopProxyDto stopDto = id == null ? new StopProxyDto(this.getTempUUID()) : new StopProxyDto(id, this.getVersion());
        return stopDto;
    }

    public static enum StopModelEnum {
        NAME("name"),
        INFORMATION("information"),
        PARKING_INFORMATION("parkingInformation"),
        DELIVERER_INFORMATION("delivererInformation"),
        LOCATION("location"),
        ESTIMATED_TIME_OF_ARRIVAL("estimatedTimeOfArrival"),
        ESTIMATED_DURATION_SECONDS("estimatedDurationSeconds"),
        STREET_MILEAGE_METERS_FROM_TOUR_START("streetMileageMetersFromTourStart"),
        ACTUAL_TIME_OF_ARRIVAL("actualTimeOfArrival"),
        ACTUAL_DURATION_SECONDS("actualDurationSeconds"),
        TIME_WINDOWS("timeWindows"),
        TOUR_PART("tourPart"),
        SERVICE_STOP_RELATIONS("serviceStopRelations"),
        SORT_ORDER("sortOrder"),
        POI("poi"),
        BRANCH("branch"),
        IMPORT_ORDER("importOrder"),
        EXPORTED_BY_JOB("exportedByJob"),
        LOCATION_CAPTURINGS("locationCapturings"),
        STOP_STATUS("stopStatus"),
        GPS_DURATION_SECONDS("gpsDurationSeconds");

        private String propertyName;

        private StopModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

