/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModelImpl;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModelImpl;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.dto.base.ServiceTicketDto;
import de.datomino.peppergis.dto.tour.ServiceTicketStopRelationFullDto;
import de.datomino.peppergis.dto.tour.ServiceTicketStopRelationProxyDto;
import de.datomino.peppergis.dto.tour.ServiceValueDto;
import de.datomino.peppergis.dto.tour.ServiceValueHistoryDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.MobileGpsStatus;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ServiceTicketStopRelationModelImpl
extends AbstractModel<ServiceTicketStopRelationFullDto, ServiceTicketStopRelationProxyDto>
implements ServiceTicketStopRelationModel {
    private Set<ServiceValueModel> serviceValues = null;
    private ServiceTicketModel serviceTicket;
    private StopModel stop;
    private Date mobileLastUpdateTime;
    private ImmutablePoint mobileLastPosition;
    private Set<ServiceValueHistoryModel> serviceValueHistoryEntries = null;
    private MobileGpsStatus gpsStatus;
    private Integer autoGpsPerimeter;
    private Date gpsEnterTime;
    private Date gpsExitTime;
    private Integer minAutoGpsDuration;

    public ServiceTicketStopRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ServiceTicketStopRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public int countServiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        return this.serviceValues.size();
    }

    @Override
    public Iterator<ServiceValueModel> iterateServiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        return new ImmutableIterator<ServiceValueModel>(this.serviceValues);
    }

    @Override
    public Iterable<ServiceValueModel> iterableServiceValues() {
        return new IteratorIterable<ServiceValueModel>(this.iterateServiceValues());
    }

    @Override
    public void addServiceValue(ServiceValueModel serviceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        if (this.serviceValues.contains(serviceValue)) {
            return;
        }
        this.serviceValues.add(serviceValue);
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUES, serviceValue, null);
        if (serviceValue != null) {
            serviceValue.setServiceStopRelation(this);
        }
    }

    @Override
    public void removeServiceValue(ServiceValueModel serviceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        if (!this.serviceValues.contains(serviceValue)) {
            return;
        }
        this.serviceValues.remove(serviceValue);
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUES, serviceValue, null);
        if (serviceValue != null) {
            serviceValue.setServiceStopRelation(null);
        }
    }

    @Override
    public void clearServiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        ArrayList<ServiceValueModel> oldServiceValues = new ArrayList<ServiceValueModel>(this.serviceValues);
        this.serviceValues.clear();
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUES, null, null);
        for (ServiceValueModel oldServiceValue : oldServiceValues) {
            if (oldServiceValue == null) continue;
            oldServiceValue.setServiceStopRelation(null);
        }
    }

    @Override
    public boolean isServiceValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        return this.serviceValues.isEmpty();
    }

    @Override
    public boolean containsServiceValue(ServiceValueModel serviceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValues == null) {
            this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            if (this.getId() != null) {
                Collection serviceValuesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUES.getPropertyName());
                this.serviceValues.addAll(serviceValuesCollection);
            }
        }
        return this.serviceValues.contains(serviceValue);
    }

    @Override
    public boolean isServiceValuesInitialized() {
        return this.serviceValues != null;
    }

    @Override
    public ServiceTicketModel getServiceTicket() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.serviceTicket;
    }

    @Override
    public void setServiceTicket(ServiceTicketModel serviceTicket) {
        this.setServiceTicket(serviceTicket, true);
    }

    private void setServiceTicket(ServiceTicketModel serviceTicket, boolean setDirty) {
        ServiceTicketModel oldServiceTicket = this.getServiceTicket();
        if (oldServiceTicket == serviceTicket) {
            return;
        }
        if (oldServiceTicket != null) {
            oldServiceTicket.removeAServiceTicketStopRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.SERVICE_TICKET.getPropertyName());
        }
        this.serviceTicket = serviceTicket;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_TICKET, serviceTicket, oldServiceTicket);
        if (this.serviceTicket != null) {
            this.serviceTicket.addAServiceTicketStopRelation(this);
        }
    }

    @Override
    public StopModel getStop() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stop;
    }

    @Override
    public void setStop(StopModel stop) {
        this.setStop(stop, true);
    }

    private void setStop(StopModel stop, boolean setDirty) {
        StopModel oldStop = this.getStop();
        if (oldStop == stop) {
            return;
        }
        if (oldStop != null) {
            oldStop.removeServiceStopRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.STOP.getPropertyName());
        }
        this.stop = stop;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.STOP, stop, oldStop);
        if (this.stop != null) {
            this.stop.addServiceStopRelation(this);
        }
    }

    @Override
    public Date getMobileLastUpdateTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileLastUpdateTime;
    }

    @Override
    public void setMobileLastUpdateTime(Date mobileLastUpdateTime) {
        this.setMobileLastUpdateTime(mobileLastUpdateTime, true);
    }

    private void setMobileLastUpdateTime(Date mobileLastUpdateTime, boolean setDirty) {
        Date oldMobileLastUpdateTime = this.getMobileLastUpdateTime();
        if (new EqualsBuilder().append(oldMobileLastUpdateTime, mobileLastUpdateTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.MOBILE_LAST_UPDATE_TIME.getPropertyName());
        }
        this.mobileLastUpdateTime = mobileLastUpdateTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.MOBILE_LAST_UPDATE_TIME, mobileLastUpdateTime, oldMobileLastUpdateTime);
    }

    @Override
    public ImmutablePoint getMobileLastPosition() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileLastPosition;
    }

    @Override
    public void setMobileLastPosition(ImmutablePoint mobileLastPosition) {
        this.setMobileLastPosition(mobileLastPosition, true);
    }

    private void setMobileLastPosition(ImmutablePoint mobileLastPosition, boolean setDirty) {
        ImmutablePoint oldMobileLastPosition = this.getMobileLastPosition();
        if (new EqualsBuilder().append(oldMobileLastPosition, mobileLastPosition).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.MOBILE_LAST_POSITION.getPropertyName());
        }
        this.mobileLastPosition = mobileLastPosition;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.MOBILE_LAST_POSITION, mobileLastPosition, oldMobileLastPosition);
    }

    @Override
    public int countServiceValueHistoryEntries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        return this.serviceValueHistoryEntries.size();
    }

    @Override
    public Iterator<ServiceValueHistoryModel> iterateServiceValueHistoryEntries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        return new ImmutableIterator<ServiceValueHistoryModel>(this.serviceValueHistoryEntries);
    }

    @Override
    public Iterable<ServiceValueHistoryModel> iterableServiceValueHistoryEntries() {
        return new IteratorIterable<ServiceValueHistoryModel>(this.iterateServiceValueHistoryEntries());
    }

    @Override
    public void addServiceValueHistoryEntrie(ServiceValueHistoryModel serviceValueHistoryEntrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        if (this.serviceValueHistoryEntries.contains(serviceValueHistoryEntrie)) {
            return;
        }
        this.serviceValueHistoryEntries.add(serviceValueHistoryEntrie);
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES, serviceValueHistoryEntrie, null);
        if (serviceValueHistoryEntrie != null) {
            serviceValueHistoryEntrie.setServiceStopRelation(this);
        }
    }

    @Override
    public void removeServiceValueHistoryEntrie(ServiceValueHistoryModel serviceValueHistoryEntrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        if (!this.serviceValueHistoryEntries.contains(serviceValueHistoryEntrie)) {
            return;
        }
        this.serviceValueHistoryEntries.remove(serviceValueHistoryEntrie);
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES, serviceValueHistoryEntrie, null);
        if (serviceValueHistoryEntrie != null) {
            serviceValueHistoryEntrie.setServiceStopRelation(null);
        }
    }

    @Override
    public void clearServiceValueHistoryEntries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        ArrayList<ServiceValueHistoryModel> oldServiceValueHistoryEntries = new ArrayList<ServiceValueHistoryModel>(this.serviceValueHistoryEntries);
        this.serviceValueHistoryEntries.clear();
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES, null, null);
        for (ServiceValueHistoryModel oldServiceValueHistoryEntrie : oldServiceValueHistoryEntries) {
            if (oldServiceValueHistoryEntrie == null) continue;
            oldServiceValueHistoryEntrie.setServiceStopRelation(null);
        }
    }

    @Override
    public boolean isServiceValueHistoryEntriesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        return this.serviceValueHistoryEntries.isEmpty();
    }

    @Override
    public boolean containsServiceValueHistoryEntrie(ServiceValueHistoryModel serviceValueHistoryEntrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueHistoryEntries == null) {
            this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            if (this.getId() != null) {
                Collection serviceValueHistoryEntriesCollection = this.commonCaller.fetchChildren(this, ServiceTicketStopRelationModelEnum.SERVICE_VALUE_HISTORY_ENTRIES.getPropertyName());
                this.serviceValueHistoryEntries.addAll(serviceValueHistoryEntriesCollection);
            }
        }
        return this.serviceValueHistoryEntries.contains(serviceValueHistoryEntrie);
    }

    @Override
    public boolean isServiceValueHistoryEntriesInitialized() {
        return this.serviceValueHistoryEntries != null;
    }

    @Override
    public MobileGpsStatus getGpsStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.gpsStatus;
    }

    @Override
    public void setGpsStatus(MobileGpsStatus gpsStatus) {
        this.setGpsStatus(gpsStatus, true);
    }

    private void setGpsStatus(MobileGpsStatus gpsStatus, boolean setDirty) {
        MobileGpsStatus oldGpsStatus = this.getGpsStatus();
        if (new EqualsBuilder().append((Object)oldGpsStatus, (Object)gpsStatus).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.GPS_STATUS.getPropertyName());
        }
        this.gpsStatus = gpsStatus;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.GPS_STATUS, (Object)gpsStatus, (Object)oldGpsStatus);
    }

    @Override
    public Integer getAutoGpsPerimeter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.autoGpsPerimeter;
    }

    @Override
    public void setAutoGpsPerimeter(Integer autoGpsPerimeter) {
        this.setAutoGpsPerimeter(autoGpsPerimeter, true);
    }

    private void setAutoGpsPerimeter(Integer autoGpsPerimeter, boolean setDirty) {
        Integer oldAutoGpsPerimeter = this.getAutoGpsPerimeter();
        if (new EqualsBuilder().append(oldAutoGpsPerimeter, autoGpsPerimeter).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.AUTO_GPS_PERIMETER.getPropertyName());
        }
        this.autoGpsPerimeter = autoGpsPerimeter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.AUTO_GPS_PERIMETER, autoGpsPerimeter, oldAutoGpsPerimeter);
    }

    @Override
    public Date getGpsEnterTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.gpsEnterTime;
    }

    @Override
    public void setGpsEnterTime(Date gpsEnterTime) {
        this.setGpsEnterTime(gpsEnterTime, true);
    }

    private void setGpsEnterTime(Date gpsEnterTime, boolean setDirty) {
        Date oldGpsEnterTime = this.getGpsEnterTime();
        if (new EqualsBuilder().append(oldGpsEnterTime, gpsEnterTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.GPS_ENTER_TIME.getPropertyName());
        }
        this.gpsEnterTime = gpsEnterTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.GPS_ENTER_TIME, gpsEnterTime, oldGpsEnterTime);
    }

    @Override
    public Date getGpsExitTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.gpsExitTime;
    }

    @Override
    public void setGpsExitTime(Date gpsExitTime) {
        this.setGpsExitTime(gpsExitTime, true);
    }

    private void setGpsExitTime(Date gpsExitTime, boolean setDirty) {
        Date oldGpsExitTime = this.getGpsExitTime();
        if (new EqualsBuilder().append(oldGpsExitTime, gpsExitTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.GPS_EXIT_TIME.getPropertyName());
        }
        this.gpsExitTime = gpsExitTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.GPS_EXIT_TIME, gpsExitTime, oldGpsExitTime);
    }

    @Override
    public Integer getMinAutoGpsDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.minAutoGpsDuration;
    }

    @Override
    public void setMinAutoGpsDuration(Integer minAutoGpsDuration) {
        this.setMinAutoGpsDuration(minAutoGpsDuration, true);
    }

    private void setMinAutoGpsDuration(Integer minAutoGpsDuration, boolean setDirty) {
        Integer oldMinAutoGpsDuration = this.getMinAutoGpsDuration();
        if (new EqualsBuilder().append(oldMinAutoGpsDuration, minAutoGpsDuration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketStopRelationModelEnum.MIN_AUTO_GPS_DURATION.getPropertyName());
        }
        this.minAutoGpsDuration = minAutoGpsDuration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketStopRelationModelEnum.MIN_AUTO_GPS_DURATION, minAutoGpsDuration, oldMinAutoGpsDuration);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.serviceValues = null;
            this.serviceValueHistoryEntries = null;
        }
    }

    @Override
    protected void updateByDto(ServiceTicketStopRelationFullDto serviceTicketStopRelationDto) {
        ServiceValueDto[] serviceValues = serviceTicketStopRelationDto.getServiceValues();
        if (serviceValues != null) {
            if (this.serviceValues == null) {
                this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            } else {
                this.serviceValues.clear();
            }
        }
        this.serviceTicket = (ServiceTicketModel)this.getModelCache().getModel(serviceTicketStopRelationDto.getServiceTicket());
        this.stop = (StopModel)this.getModelCache().getModel(serviceTicketStopRelationDto.getStop());
        this.mobileLastUpdateTime = serviceTicketStopRelationDto.getMobileLastUpdateTime();
        ImmutablePointDto mobileLastPosition = serviceTicketStopRelationDto.getMobileLastPosition();
        this.mobileLastPosition = mobileLastPosition == null ? null : (ImmutablePoint)mobileLastPosition.getGeoObject();
        ServiceValueHistoryDto[] serviceValueHistoryEntries = serviceTicketStopRelationDto.getServiceValueHistoryEntries();
        if (serviceValueHistoryEntries != null) {
            if (this.serviceValueHistoryEntries == null) {
                this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            } else {
                this.serviceValueHistoryEntries.clear();
            }
        }
        this.gpsStatus = serviceTicketStopRelationDto.getGpsStatus();
        this.autoGpsPerimeter = serviceTicketStopRelationDto.getAutoGpsPerimeter();
        this.gpsEnterTime = serviceTicketStopRelationDto.getGpsEnterTime();
        this.gpsExitTime = serviceTicketStopRelationDto.getGpsExitTime();
        this.minAutoGpsDuration = serviceTicketStopRelationDto.getMinAutoGpsDuration();
    }

    @Override
    protected void updateMasterRelationsByDto(ServiceTicketStopRelationFullDto serviceTicketStopRelationDto) {
        ServiceValueHistoryDto[] serviceValueHistoryEntries;
        ServiceValueDto[] serviceValues = serviceTicketStopRelationDto.getServiceValues();
        if (serviceValues != null) {
            if (this.serviceValues == null) {
                this.serviceValues = new LinkedHashSet<ServiceValueModel>();
            } else {
                this.serviceValues.clear();
            }
            for (ServiceValueDto serviceValueDto : serviceValues) {
                ServiceValueModel serviceValueModel = (ServiceValueModel)this.getModelCache().getModel(serviceValueDto);
                this.serviceValues.add(serviceValueModel);
            }
        } else {
            this.serviceValues = null;
        }
        if ((serviceValueHistoryEntries = serviceTicketStopRelationDto.getServiceValueHistoryEntries()) != null) {
            if (this.serviceValueHistoryEntries == null) {
                this.serviceValueHistoryEntries = new LinkedHashSet<ServiceValueHistoryModel>();
            } else {
                this.serviceValueHistoryEntries.clear();
            }
            for (ServiceValueHistoryDto serviceValueHistoryEntrieDto : serviceValueHistoryEntries) {
                ServiceValueHistoryModel serviceValueHistoryEntrieModel = (ServiceValueHistoryModel)this.getModelCache().getModel(serviceValueHistoryEntrieDto);
                this.serviceValueHistoryEntries.add(serviceValueHistoryEntrieModel);
            }
        } else {
            this.serviceValueHistoryEntries = null;
        }
    }

    @Override
    protected void checkStaleByDto(ServiceTicketStopRelationFullDto serviceTicketStopRelationDto) throws StaleStateException {
        ServiceValueHistoryDto[] serviceValueHistoryEntrieDtos;
        StopModelImpl stopModel;
        StopDto stopDto;
        ServiceTicketModelImpl serviceTicketModel;
        ServiceTicketDto serviceTicketDto;
        ServiceValueDto[] serviceValueDtos = serviceTicketStopRelationDto.getServiceValues();
        if (serviceValueDtos != null) {
            for (ServiceValueDto serviceValueDto : serviceValueDtos) {
                ServiceValueModelImpl serviceValueModel = (ServiceValueModelImpl)this.getModelCache().getModel(ServiceValueModel.class, serviceValueDto.getId());
                if (serviceValueModel == null) continue;
                serviceValueModel.checkStaleState(serviceValueDto);
            }
        }
        if ((serviceTicketDto = serviceTicketStopRelationDto.getServiceTicket()) != null && serviceTicketDto.getId() != null && (serviceTicketModel = (ServiceTicketModelImpl)this.getModelCache().getModel(ServiceTicketModel.class, serviceTicketDto.getId())) != null) {
            serviceTicketModel.checkStaleState(serviceTicketDto);
        }
        if ((stopDto = serviceTicketStopRelationDto.getStop()) != null && stopDto.getId() != null && (stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId())) != null) {
            stopModel.checkStaleState(stopDto);
        }
        if ((serviceValueHistoryEntrieDtos = serviceTicketStopRelationDto.getServiceValueHistoryEntries()) != null) {
            for (ServiceValueHistoryDto serviceValueHistoryEntrieDto : serviceValueHistoryEntrieDtos) {
                ServiceValueHistoryModelImpl serviceValueHistoryEntrieModel = (ServiceValueHistoryModelImpl)this.getModelCache().getModel(ServiceValueHistoryModel.class, serviceValueHistoryEntrieDto.getId());
                if (serviceValueHistoryEntrieModel == null) continue;
                serviceValueHistoryEntrieModel.checkStaleState(serviceValueHistoryEntrieDto);
            }
        }
    }

    @Override
    public ServiceTicketStopRelationFullDto createDto() {
        StopModelImpl stop;
        Long id = this.getId();
        ServiceTicketStopRelationFullDto serviceTicketStopRelationDto = id == null ? new ServiceTicketStopRelationFullDto(this.getTempUUID()) : new ServiceTicketStopRelationFullDto(id, this.getVersion());
        ServiceTicketModelImpl serviceTicket = (ServiceTicketModelImpl)this.getServiceTicket();
        if (serviceTicket != null) {
            serviceTicketStopRelationDto.setServiceTicket(serviceTicket.createProxy());
        }
        if ((stop = (StopModelImpl)this.getStop()) != null) {
            serviceTicketStopRelationDto.setStop(stop.createProxy());
        }
        serviceTicketStopRelationDto.setMobileLastUpdateTime(this.getMobileLastUpdateTime());
        ImmutablePoint mobileLastPosition = this.getMobileLastPosition();
        serviceTicketStopRelationDto.setMobileLastPosition(ImmutablePointDto.create(mobileLastPosition));
        serviceTicketStopRelationDto.setGpsStatus(this.getGpsStatus());
        serviceTicketStopRelationDto.setAutoGpsPerimeter(this.getAutoGpsPerimeter());
        serviceTicketStopRelationDto.setGpsEnterTime(this.getGpsEnterTime());
        serviceTicketStopRelationDto.setGpsExitTime(this.getGpsExitTime());
        serviceTicketStopRelationDto.setMinAutoGpsDuration(this.getMinAutoGpsDuration());
        return serviceTicketStopRelationDto;
    }

    @Override
    public ServiceTicketStopRelationProxyDto createProxy() {
        Long id = this.getId();
        ServiceTicketStopRelationProxyDto serviceTicketStopRelationDto = id == null ? new ServiceTicketStopRelationProxyDto(this.getTempUUID()) : new ServiceTicketStopRelationProxyDto(id, this.getVersion());
        return serviceTicketStopRelationDto;
    }

    public static enum ServiceTicketStopRelationModelEnum {
        SERVICE_VALUES("serviceValues"),
        SERVICE_TICKET("serviceTicket"),
        STOP("stop"),
        MOBILE_LAST_UPDATE_TIME("mobileLastUpdateTime"),
        MOBILE_LAST_POSITION("mobileLastPosition"),
        SERVICE_VALUE_HISTORY_ENTRIES("serviceValueHistoryEntries"),
        GPS_STATUS("gpsStatus"),
        AUTO_GPS_PERIMETER("autoGpsPerimeter"),
        GPS_ENTER_TIME("gpsEnterTime"),
        GPS_EXIT_TIME("gpsExitTime"),
        MIN_AUTO_GPS_DURATION("minAutoGpsDuration");

        private String propertyName;

        private ServiceTicketStopRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

