/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModelImpl;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.dto.tour.DeliveryProductDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundFullDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class DeliveryRoundModelImpl
extends AbstractModel<DeliveryRoundFullDto, DeliveryRoundProxyDto>
implements DeliveryRoundModel {
    private String name;
    private String information;
    private Set<DeliveryProductModel> deliveryProducts = null;

    public DeliveryRoundModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DeliveryRoundModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryRoundModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryRoundModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryRoundModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryRoundModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public int countDeliveryProducts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        return this.deliveryProducts.size();
    }

    @Override
    public Iterator<DeliveryProductModel> iterateDeliveryProducts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        return new ImmutableIterator<DeliveryProductModel>(this.deliveryProducts);
    }

    @Override
    public Iterable<DeliveryProductModel> iterableDeliveryProducts() {
        return new IteratorIterable<DeliveryProductModel>(this.iterateDeliveryProducts());
    }

    @Override
    public void addDeliveryProduct(DeliveryProductModel deliveryProduct) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        if (this.deliveryProducts.contains(deliveryProduct)) {
            return;
        }
        this.deliveryProducts.add(deliveryProduct);
        this.fireValueChanged(DeliveryRoundModelEnum.DELIVERY_PRODUCTS, deliveryProduct, null);
        if (deliveryProduct != null) {
            deliveryProduct.setDeliveryRound(this);
        }
    }

    @Override
    public void removeDeliveryProduct(DeliveryProductModel deliveryProduct) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        if (!this.deliveryProducts.contains(deliveryProduct)) {
            return;
        }
        this.deliveryProducts.remove(deliveryProduct);
        this.fireValueChanged(DeliveryRoundModelEnum.DELIVERY_PRODUCTS, deliveryProduct, null);
        if (deliveryProduct != null) {
            deliveryProduct.setDeliveryRound(null);
        }
    }

    @Override
    public void clearDeliveryProducts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        ArrayList<DeliveryProductModel> oldDeliveryProducts = new ArrayList<DeliveryProductModel>(this.deliveryProducts);
        this.deliveryProducts.clear();
        this.fireValueChanged(DeliveryRoundModelEnum.DELIVERY_PRODUCTS, null, null);
        for (DeliveryProductModel oldDeliveryProduct : oldDeliveryProducts) {
            if (oldDeliveryProduct == null) continue;
            oldDeliveryProduct.setDeliveryRound(null);
        }
    }

    @Override
    public boolean isDeliveryProductsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        return this.deliveryProducts.isEmpty();
    }

    @Override
    public boolean containsDeliveryProduct(DeliveryProductModel deliveryProduct) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliveryProducts == null) {
            this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            if (this.getId() != null) {
                Collection deliveryProductsCollection = this.commonCaller.fetchChildren(this, DeliveryRoundModelEnum.DELIVERY_PRODUCTS.getPropertyName());
                this.deliveryProducts.addAll(deliveryProductsCollection);
            }
        }
        return this.deliveryProducts.contains(deliveryProduct);
    }

    @Override
    public boolean isDeliveryProductsInitialized() {
        return this.deliveryProducts != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.deliveryProducts = null;
        }
    }

    @Override
    protected void updateByDto(DeliveryRoundFullDto deliveryRoundDto) {
        this.name = deliveryRoundDto.getName();
        this.information = deliveryRoundDto.getInformation();
        DeliveryProductDto[] deliveryProducts = deliveryRoundDto.getDeliveryProducts();
        if (deliveryProducts != null) {
            if (this.deliveryProducts == null) {
                this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            } else {
                this.deliveryProducts.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(DeliveryRoundFullDto deliveryRoundDto) {
        DeliveryProductDto[] deliveryProducts = deliveryRoundDto.getDeliveryProducts();
        if (deliveryProducts != null) {
            if (this.deliveryProducts == null) {
                this.deliveryProducts = new LinkedHashSet<DeliveryProductModel>();
            } else {
                this.deliveryProducts.clear();
            }
            for (DeliveryProductDto deliveryProductDto : deliveryProducts) {
                DeliveryProductModel deliveryProductModel = (DeliveryProductModel)this.getModelCache().getModel(deliveryProductDto);
                this.deliveryProducts.add(deliveryProductModel);
            }
        } else {
            this.deliveryProducts = null;
        }
    }

    @Override
    protected void checkStaleByDto(DeliveryRoundFullDto deliveryRoundDto) throws StaleStateException {
        DeliveryProductDto[] deliveryProductDtos = deliveryRoundDto.getDeliveryProducts();
        if (deliveryProductDtos != null) {
            for (DeliveryProductDto deliveryProductDto : deliveryProductDtos) {
                DeliveryProductModelImpl deliveryProductModel = (DeliveryProductModelImpl)this.getModelCache().getModel(DeliveryProductModel.class, deliveryProductDto.getId());
                if (deliveryProductModel == null) continue;
                deliveryProductModel.checkStaleState(deliveryProductDto);
            }
        }
    }

    @Override
    public DeliveryRoundFullDto createDto() {
        Long id = this.getId();
        DeliveryRoundFullDto deliveryRoundDto = id == null ? new DeliveryRoundFullDto(this.getTempUUID()) : new DeliveryRoundFullDto(id, this.getVersion());
        deliveryRoundDto.setName(this.getName());
        deliveryRoundDto.setInformation(this.getInformation());
        return deliveryRoundDto;
    }

    @Override
    public DeliveryRoundProxyDto createProxy() {
        Long id = this.getId();
        DeliveryRoundProxyDto deliveryRoundDto = id == null ? new DeliveryRoundProxyDto(this.getTempUUID()) : new DeliveryRoundProxyDto(id, this.getVersion());
        return deliveryRoundDto;
    }

    public static enum DeliveryRoundModelEnum {
        NAME("name"),
        INFORMATION("information"),
        DELIVERY_PRODUCTS("deliveryProducts");

        private String propertyName;

        private DeliveryRoundModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

