/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModel;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.DelivererStatusTimeWindowFullDto;
import de.datomino.peppergis.dto.tour.DelivererStatusTimeWindowProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.DelivererStatus;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DelivererStatusTimeWindowModelImpl
extends AbstractModel<DelivererStatusTimeWindowFullDto, DelivererStatusTimeWindowProxyDto>
implements DelivererStatusTimeWindowModel {
    private Date startTime;
    private Date endTime;
    private DelivererStatus status;
    private DelivererModel deliverer;

    public DelivererStatusTimeWindowModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DelivererStatusTimeWindowModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Date getStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.setStartTime(startTime, true);
    }

    private void setStartTime(Date startTime, boolean setDirty) {
        Date oldStartTime = this.getStartTime();
        if (new EqualsBuilder().append(oldStartTime, startTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererStatusTimeWindowModelEnum.START_TIME.getPropertyName());
        }
        this.startTime = startTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererStatusTimeWindowModelEnum.START_TIME, startTime, oldStartTime);
    }

    @Override
    public Date getEndTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.setEndTime(endTime, true);
    }

    private void setEndTime(Date endTime, boolean setDirty) {
        Date oldEndTime = this.getEndTime();
        if (new EqualsBuilder().append(oldEndTime, endTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererStatusTimeWindowModelEnum.END_TIME.getPropertyName());
        }
        this.endTime = endTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererStatusTimeWindowModelEnum.END_TIME, endTime, oldEndTime);
    }

    @Override
    public DelivererStatus getStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.status;
    }

    @Override
    public void setStatus(DelivererStatus status) {
        this.setStatus(status, true);
    }

    private void setStatus(DelivererStatus status, boolean setDirty) {
        DelivererStatus oldStatus = this.getStatus();
        if (new EqualsBuilder().append((Object)oldStatus, (Object)status).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererStatusTimeWindowModelEnum.STATUS.getPropertyName());
        }
        this.status = status;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererStatusTimeWindowModelEnum.STATUS, (Object)status, (Object)oldStatus);
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.removeStatusTimeWindow(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererStatusTimeWindowModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererStatusTimeWindowModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.addStatusTimeWindow(this);
        }
    }

    @Override
    protected void updateByDto(DelivererStatusTimeWindowFullDto delivererStatusTimeWindowDto) {
        this.startTime = delivererStatusTimeWindowDto.getStartTime();
        this.endTime = delivererStatusTimeWindowDto.getEndTime();
        this.status = delivererStatusTimeWindowDto.getStatus();
        this.deliverer = (DelivererModel)this.getModelCache().getModel(delivererStatusTimeWindowDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(DelivererStatusTimeWindowFullDto delivererStatusTimeWindowDto) {
    }

    @Override
    protected void checkStaleByDto(DelivererStatusTimeWindowFullDto delivererStatusTimeWindowDto) throws StaleStateException {
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto = delivererStatusTimeWindowDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public DelivererStatusTimeWindowFullDto createDto() {
        Long id = this.getId();
        DelivererStatusTimeWindowFullDto delivererStatusTimeWindowDto = id == null ? new DelivererStatusTimeWindowFullDto(this.getTempUUID()) : new DelivererStatusTimeWindowFullDto(id, this.getVersion());
        delivererStatusTimeWindowDto.setStartTime(this.getStartTime());
        delivererStatusTimeWindowDto.setEndTime(this.getEndTime());
        delivererStatusTimeWindowDto.setStatus(this.getStatus());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            delivererStatusTimeWindowDto.setDeliverer(deliverer.createProxy());
        }
        return delivererStatusTimeWindowDto;
    }

    @Override
    public DelivererStatusTimeWindowProxyDto createProxy() {
        Long id = this.getId();
        DelivererStatusTimeWindowProxyDto delivererStatusTimeWindowDto = id == null ? new DelivererStatusTimeWindowProxyDto(this.getTempUUID()) : new DelivererStatusTimeWindowProxyDto(id, this.getVersion());
        return delivererStatusTimeWindowDto;
    }

    public static enum DelivererStatusTimeWindowModelEnum {
        START_TIME("startTime"),
        END_TIME("endTime"),
        STATUS("status"),
        DELIVERER("deliverer");

        private String propertyName;

        private DelivererStatusTimeWindowModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

