/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererFactorModel;
import de.datomino.peppergis.dto.tour.DelivererEmploymentDto;
import de.datomino.peppergis.dto.tour.DelivererFactorFullDto;
import de.datomino.peppergis.dto.tour.DelivererFactorProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DelivererFactorModelImpl
extends AbstractModel<DelivererFactorFullDto, DelivererFactorProxyDto>
implements DelivererFactorModel {
    private Double factor;
    private DelivererEmploymentModel delivererEmployment;

    public DelivererFactorModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DelivererFactorModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Double getFactor() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.factor;
    }

    @Override
    public void setFactor(Double factor) {
        this.setFactor(factor, true);
    }

    private void setFactor(Double factor, boolean setDirty) {
        Double oldFactor = this.getFactor();
        if (new EqualsBuilder().append(oldFactor, factor).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererFactorModelEnum.FACTOR.getPropertyName());
        }
        this.factor = factor;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererFactorModelEnum.FACTOR, factor, oldFactor);
    }

    @Override
    public DelivererEmploymentModel getDelivererEmployment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.delivererEmployment;
    }

    @Override
    public void setDelivererEmployment(DelivererEmploymentModel delivererEmployment) {
        this.setDelivererEmployment(delivererEmployment, true);
    }

    private void setDelivererEmployment(DelivererEmploymentModel delivererEmployment, boolean setDirty) {
        DelivererEmploymentModel oldDelivererEmployment = this.getDelivererEmployment();
        if (oldDelivererEmployment == delivererEmployment) {
            return;
        }
        if (oldDelivererEmployment != null) {
            oldDelivererEmployment.removeFactor(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererFactorModelEnum.DELIVERER_EMPLOYMENT.getPropertyName());
        }
        this.delivererEmployment = delivererEmployment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererFactorModelEnum.DELIVERER_EMPLOYMENT, delivererEmployment, oldDelivererEmployment);
        if (this.delivererEmployment != null) {
            this.delivererEmployment.addFactor(this);
        }
    }

    @Override
    protected void updateByDto(DelivererFactorFullDto delivererFactorDto) {
        this.factor = delivererFactorDto.getFactor();
        this.delivererEmployment = (DelivererEmploymentModel)this.getModelCache().getModel(delivererFactorDto.getDelivererEmployment());
    }

    @Override
    protected void updateMasterRelationsByDto(DelivererFactorFullDto delivererFactorDto) {
    }

    @Override
    protected void checkStaleByDto(DelivererFactorFullDto delivererFactorDto) throws StaleStateException {
        DelivererEmploymentModelImpl delivererEmploymentModel;
        DelivererEmploymentDto delivererEmploymentDto = delivererFactorDto.getDelivererEmployment();
        if (delivererEmploymentDto != null && delivererEmploymentDto.getId() != null && (delivererEmploymentModel = (DelivererEmploymentModelImpl)this.getModelCache().getModel(DelivererEmploymentModel.class, delivererEmploymentDto.getId())) != null) {
            delivererEmploymentModel.checkStaleState(delivererEmploymentDto);
        }
    }

    @Override
    public DelivererFactorFullDto createDto() {
        Long id = this.getId();
        DelivererFactorFullDto delivererFactorDto = id == null ? new DelivererFactorFullDto(this.getTempUUID()) : new DelivererFactorFullDto(id, this.getVersion());
        delivererFactorDto.setFactor(this.getFactor());
        DelivererEmploymentModelImpl delivererEmployment = (DelivererEmploymentModelImpl)this.getDelivererEmployment();
        if (delivererEmployment != null) {
            delivererFactorDto.setDelivererEmployment(delivererEmployment.createProxy());
        }
        return delivererFactorDto;
    }

    @Override
    public DelivererFactorProxyDto createProxy() {
        Long id = this.getId();
        DelivererFactorProxyDto delivererFactorDto = id == null ? new DelivererFactorProxyDto(this.getTempUUID()) : new DelivererFactorProxyDto(id, this.getVersion());
        return delivererFactorDto;
    }

    public static enum DelivererFactorModelEnum {
        FACTOR("factor"),
        DELIVERER_EMPLOYMENT("delivererEmployment");

        private String propertyName;

        private DelivererFactorModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

