/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.logistic.dto.TourPartType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaStopModelImpl;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourModelImpl;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.dto.tour.AreaStopDto;
import de.datomino.peppergis.dto.tour.AreaTourDto;
import de.datomino.peppergis.dto.tour.AreaTourPartFullDto;
import de.datomino.peppergis.dto.tour.AreaTourPartProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaTourPartModelImpl
extends AbstractModel<AreaTourPartFullDto, AreaTourPartProxyDto>
implements AreaTourPartModel {
    private String name;
    private List<AreaStopModel> areaStops = null;
    private AreaTourModel areaTour;
    private Integer sortOrder;
    private RouteType routeType;
    private RouteVehicleType routeVehicleType;
    private ImmutableLineString lineString;
    private TourPartType tourPartType;

    public AreaTourPartModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaTourPartModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.NAME, name, oldName);
    }

    @Override
    public int countAreaStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return this.areaStops.size();
    }

    @Override
    public Iterator<AreaStopModel> iterateAreaStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return new ImmutableIterator<AreaStopModel>(this.areaStops);
    }

    @Override
    public Iterable<AreaStopModel> iterableAreaStops() {
        return new IteratorIterable<AreaStopModel>(this.iterateAreaStops());
    }

    @Override
    public void addAreaStop(AreaStopModel areaStop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        if (this.areaStops.contains(areaStop)) {
            return;
        }
        this.areaStops.add(areaStop);
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, areaStop, null);
        if (areaStop != null) {
            areaStop.setAreaTourPart(this);
            areaStop.setSortOrder(this.areaStops.size() - 1);
        }
    }

    @Override
    public void removeAreaStop(AreaStopModel areaStop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        if (!this.areaStops.contains(areaStop)) {
            return;
        }
        this.areaStops.remove(areaStop);
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, areaStop, null);
        if (areaStop != null) {
            areaStop.setAreaTourPart(null);
            areaStop.setSortOrder(null);
        }
        this.reorderAreaStops(0);
    }

    @Override
    public AreaStopModel getAreaStopAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return this.areaStops.get(index);
    }

    @Override
    public void insertAreaStop(AreaStopModel areaStop, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        if (this.areaStops.contains(areaStop)) {
            this.removeAreaStop(areaStop);
        }
        this.areaStops.add(index, areaStop);
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, areaStop, null);
        if (areaStop != null) {
            areaStop.setAreaTourPart(this);
        }
        this.reorderAreaStops(index);
    }

    @Override
    public void removeAreaStopAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        AreaStopModel oldAreaStop = this.areaStops.get(index);
        this.areaStops.remove(index);
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, oldAreaStop, null);
        if (oldAreaStop != null) {
            oldAreaStop.setAreaTourPart(null);
            oldAreaStop.setSortOrder(null);
        }
        this.reorderAreaStops(index);
    }

    @Override
    public void setAreaStopAt(AreaStopModel areaStop, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        AreaStopModel oldAreaStop = this.areaStops.get(index);
        this.areaStops.set(index, areaStop);
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, areaStop, oldAreaStop);
        if (oldAreaStop != null) {
            oldAreaStop.setAreaTourPart(null);
            oldAreaStop.setSortOrder(null);
        }
        if (areaStop != null) {
            areaStop.setAreaTourPart(this);
            areaStop.setSortOrder(index);
        }
    }

    @Override
    public void clearAreaStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        ArrayList<AreaStopModel> oldAreaStops = new ArrayList<AreaStopModel>(this.areaStops);
        this.areaStops.clear();
        this.fireValueChanged(AreaTourPartModelEnum.AREA_STOPS, null, null);
        for (AreaStopModel oldAreaStop : oldAreaStops) {
            if (oldAreaStop == null) continue;
            oldAreaStop.setAreaTourPart(null);
            oldAreaStop.setSortOrder(null);
        }
    }

    @Override
    public boolean isAreaStopsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return this.areaStops.isEmpty();
    }

    @Override
    public boolean containsAreaStop(AreaStopModel areaStop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return this.areaStops.contains(areaStop);
    }

    @Override
    public int indexOfAreaStop(AreaStopModel areaStop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        return this.areaStops.indexOf(areaStop);
    }

    @Override
    public boolean isAreaStopsInitialized() {
        return this.areaStops != null;
    }

    private void reorderAreaStops(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaStops == null) {
            this.areaStops = new ArrayList<AreaStopModel>();
            if (this.getId() != null) {
                Collection areaStopsCollection = this.commonCaller.fetchChildren(this, AreaTourPartModelEnum.AREA_STOPS.getPropertyName());
                this.areaStops.addAll(areaStopsCollection);
            }
        }
        ListIterator<AreaStopModel> listIterator = this.areaStops.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            AreaStopModel areaStop = listIterator.next();
            areaStop.setSortOrder(index++);
        }
    }

    @Override
    public AreaTourModel getAreaTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaTour;
    }

    @Override
    public void setAreaTour(AreaTourModel areaTour) {
        this.setAreaTour(areaTour, true);
    }

    private void setAreaTour(AreaTourModel areaTour, boolean setDirty) {
        AreaTourModel oldAreaTour = this.getAreaTour();
        if (oldAreaTour == areaTour) {
            return;
        }
        if (oldAreaTour != null) {
            oldAreaTour.removeAreaTourPart(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.AREA_TOUR.getPropertyName());
        }
        this.areaTour = areaTour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.AREA_TOUR, areaTour, oldAreaTour);
        if (this.areaTour != null) {
            this.areaTour.addAreaTourPart(this);
        }
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getRouteVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeVehicleType;
    }

    @Override
    public void setRouteVehicleType(RouteVehicleType routeVehicleType) {
        this.setRouteVehicleType(routeVehicleType, true);
    }

    private void setRouteVehicleType(RouteVehicleType routeVehicleType, boolean setDirty) {
        RouteVehicleType oldRouteVehicleType = this.getRouteVehicleType();
        if (new EqualsBuilder().append((Object)oldRouteVehicleType, (Object)routeVehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.ROUTE_VEHICLE_TYPE.getPropertyName());
        }
        this.routeVehicleType = routeVehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.ROUTE_VEHICLE_TYPE, (Object)routeVehicleType, (Object)oldRouteVehicleType);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public TourPartType getTourPartType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tourPartType;
    }

    @Override
    public void setTourPartType(TourPartType tourPartType) {
        this.setTourPartType(tourPartType, true);
    }

    private void setTourPartType(TourPartType tourPartType, boolean setDirty) {
        TourPartType oldTourPartType = this.getTourPartType();
        if (new EqualsBuilder().append((Object)oldTourPartType, (Object)tourPartType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourPartModelEnum.TOUR_PART_TYPE.getPropertyName());
        }
        this.tourPartType = tourPartType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourPartModelEnum.TOUR_PART_TYPE, (Object)tourPartType, (Object)oldTourPartType);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.areaStops = null;
        }
    }

    @Override
    protected void updateByDto(AreaTourPartFullDto areaTourPartDto) {
        this.name = areaTourPartDto.getName();
        AreaStopDto[] areaStops = areaTourPartDto.getAreaStops();
        if (areaStops != null) {
            if (this.areaStops == null) {
                this.areaStops = new ArrayList<AreaStopModel>();
            } else {
                this.areaStops.clear();
            }
        }
        this.areaTour = (AreaTourModel)this.getModelCache().getModel(areaTourPartDto.getAreaTour());
        this.sortOrder = areaTourPartDto.getSortOrder();
        this.routeType = areaTourPartDto.getRouteType();
        this.routeVehicleType = areaTourPartDto.getRouteVehicleType();
        ImmutableLineStringDto lineString = areaTourPartDto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.tourPartType = areaTourPartDto.getTourPartType();
    }

    @Override
    protected void updateMasterRelationsByDto(AreaTourPartFullDto areaTourPartDto) {
        AreaStopDto[] areaStops = areaTourPartDto.getAreaStops();
        if (areaStops != null) {
            if (this.areaStops == null) {
                this.areaStops = new ArrayList<AreaStopModel>();
            } else {
                this.areaStops.clear();
            }
            for (AreaStopDto areaStopDto : areaStops) {
                AreaStopModel areaStopModel = (AreaStopModel)this.getModelCache().getModel(areaStopDto);
                this.areaStops.add(areaStopModel);
            }
        } else {
            this.areaStops = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaTourPartFullDto areaTourPartDto) throws StaleStateException {
        AreaTourModelImpl areaTourModel;
        AreaTourDto areaTourDto;
        AreaStopDto[] areaStopDtos = areaTourPartDto.getAreaStops();
        if (areaStopDtos != null) {
            for (AreaStopDto areaStopDto : areaStopDtos) {
                AreaStopModelImpl areaStopModel = (AreaStopModelImpl)this.getModelCache().getModel(AreaStopModel.class, areaStopDto.getId());
                if (areaStopModel == null) continue;
                areaStopModel.checkStaleState(areaStopDto);
            }
        }
        if ((areaTourDto = areaTourPartDto.getAreaTour()) != null && areaTourDto.getId() != null && (areaTourModel = (AreaTourModelImpl)this.getModelCache().getModel(AreaTourModel.class, areaTourDto.getId())) != null) {
            areaTourModel.checkStaleState(areaTourDto);
        }
    }

    @Override
    public AreaTourPartFullDto createDto() {
        Long id = this.getId();
        AreaTourPartFullDto areaTourPartDto = id == null ? new AreaTourPartFullDto(this.getTempUUID()) : new AreaTourPartFullDto(id, this.getVersion());
        areaTourPartDto.setName(this.getName());
        AreaTourModelImpl areaTour = (AreaTourModelImpl)this.getAreaTour();
        if (areaTour != null) {
            areaTourPartDto.setAreaTour(areaTour.createProxy());
        }
        areaTourPartDto.setSortOrder(this.getSortOrder());
        areaTourPartDto.setRouteType(this.getRouteType());
        areaTourPartDto.setRouteVehicleType(this.getRouteVehicleType());
        ImmutableLineString lineString = this.getLineString();
        areaTourPartDto.setLineString(ImmutableLineStringDto.create(lineString));
        areaTourPartDto.setTourPartType(this.getTourPartType());
        return areaTourPartDto;
    }

    @Override
    public AreaTourPartProxyDto createProxy() {
        Long id = this.getId();
        AreaTourPartProxyDto areaTourPartDto = id == null ? new AreaTourPartProxyDto(this.getTempUUID()) : new AreaTourPartProxyDto(id, this.getVersion());
        return areaTourPartDto;
    }

    public static enum AreaTourPartModelEnum {
        NAME("name"),
        AREA_STOPS("areaStops"),
        AREA_TOUR("areaTour"),
        SORT_ORDER("sortOrder"),
        ROUTE_TYPE("routeType"),
        ROUTE_VEHICLE_TYPE("routeVehicleType"),
        LINE_STRING("lineString"),
        TOUR_PART_TYPE("tourPartType");

        private String propertyName;

        private AreaTourPartModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

