/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModelImpl;
import de.datomino.peppergis.dto.base.LetterDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.tour.AreaStopFullDto;
import de.datomino.peppergis.dto.tour.AreaStopProxyDto;
import de.datomino.peppergis.dto.tour.AreaTourPartDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaStopModelImpl
extends AbstractModel<AreaStopFullDto, AreaStopProxyDto>
implements AreaStopModel {
    private String name;
    private String information;
    private AreaTourPartModel areaTourPart;
    private PoiModel poi;
    private ParcelModel parcel;
    private SubscriptionModel subscription;
    private ImmutablePoint accessLocation;
    private Integer sortOrder;
    private Integer estimatedDurationSeconds;
    private Integer metersFromStart;
    private Integer secondsFromStart;
    private ImmutablePoint location;
    private LetterModel letter;

    public AreaStopModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaStopModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public AreaTourPartModel getAreaTourPart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaTourPart;
    }

    @Override
    public void setAreaTourPart(AreaTourPartModel areaTourPart) {
        this.setAreaTourPart(areaTourPart, true);
    }

    private void setAreaTourPart(AreaTourPartModel areaTourPart, boolean setDirty) {
        AreaTourPartModel oldAreaTourPart = this.getAreaTourPart();
        if (oldAreaTourPart == areaTourPart) {
            return;
        }
        if (oldAreaTourPart != null) {
            oldAreaTourPart.removeAreaStop(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.AREA_TOUR_PART.getPropertyName());
        }
        this.areaTourPart = areaTourPart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.AREA_TOUR_PART, areaTourPart, oldAreaTourPart);
        if (this.areaTourPart != null) {
            this.areaTourPart.addAreaStop(this);
        }
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.POI, poi, oldPoi);
    }

    @Override
    public ParcelModel getParcel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parcel;
    }

    @Override
    public void setParcel(ParcelModel parcel) {
        this.setParcel(parcel, true);
    }

    private void setParcel(ParcelModel parcel, boolean setDirty) {
        ParcelModel oldParcel = this.getParcel();
        if (oldParcel == parcel) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.PARCEL.getPropertyName());
        }
        this.parcel = parcel;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.PARCEL, parcel, oldParcel);
    }

    @Override
    public SubscriptionModel getSubscription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.subscription;
    }

    @Override
    public void setSubscription(SubscriptionModel subscription) {
        this.setSubscription(subscription, true);
    }

    private void setSubscription(SubscriptionModel subscription, boolean setDirty) {
        SubscriptionModel oldSubscription = this.getSubscription();
        if (oldSubscription == subscription) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.SUBSCRIPTION.getPropertyName());
        }
        this.subscription = subscription;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.SUBSCRIPTION, subscription, oldSubscription);
    }

    @Override
    public ImmutablePoint getAccessLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.accessLocation;
    }

    @Override
    public void setAccessLocation(ImmutablePoint accessLocation) {
        this.setAccessLocation(accessLocation, true);
    }

    private void setAccessLocation(ImmutablePoint accessLocation, boolean setDirty) {
        ImmutablePoint oldAccessLocation = this.getAccessLocation();
        if (new EqualsBuilder().append(oldAccessLocation, accessLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.ACCESS_LOCATION.getPropertyName());
        }
        this.accessLocation = accessLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.ACCESS_LOCATION, accessLocation, oldAccessLocation);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public Integer getEstimatedDurationSeconds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.estimatedDurationSeconds;
    }

    @Override
    public void setEstimatedDurationSeconds(Integer estimatedDurationSeconds) {
        this.setEstimatedDurationSeconds(estimatedDurationSeconds, true);
    }

    private void setEstimatedDurationSeconds(Integer estimatedDurationSeconds, boolean setDirty) {
        Integer oldEstimatedDurationSeconds = this.getEstimatedDurationSeconds();
        if (new EqualsBuilder().append(oldEstimatedDurationSeconds, estimatedDurationSeconds).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.ESTIMATED_DURATION_SECONDS.getPropertyName());
        }
        this.estimatedDurationSeconds = estimatedDurationSeconds;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.ESTIMATED_DURATION_SECONDS, estimatedDurationSeconds, oldEstimatedDurationSeconds);
    }

    @Override
    public Integer getMetersFromStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.metersFromStart;
    }

    @Override
    public void setMetersFromStart(Integer metersFromStart) {
        this.setMetersFromStart(metersFromStart, true);
    }

    private void setMetersFromStart(Integer metersFromStart, boolean setDirty) {
        Integer oldMetersFromStart = this.getMetersFromStart();
        if (new EqualsBuilder().append(oldMetersFromStart, metersFromStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.METERS_FROM_START.getPropertyName());
        }
        this.metersFromStart = metersFromStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.METERS_FROM_START, metersFromStart, oldMetersFromStart);
    }

    @Override
    public Integer getSecondsFromStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.secondsFromStart;
    }

    @Override
    public void setSecondsFromStart(Integer secondsFromStart) {
        this.setSecondsFromStart(secondsFromStart, true);
    }

    private void setSecondsFromStart(Integer secondsFromStart, boolean setDirty) {
        Integer oldSecondsFromStart = this.getSecondsFromStart();
        if (new EqualsBuilder().append(oldSecondsFromStart, secondsFromStart).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.SECONDS_FROM_START.getPropertyName());
        }
        this.secondsFromStart = secondsFromStart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.SECONDS_FROM_START, secondsFromStart, oldSecondsFromStart);
    }

    @Override
    public ImmutablePoint getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(ImmutablePoint location) {
        this.setLocation(location, true);
    }

    private void setLocation(ImmutablePoint location, boolean setDirty) {
        ImmutablePoint oldLocation = this.getLocation();
        if (new EqualsBuilder().append(oldLocation, location).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public LetterModel getLetter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.letter;
    }

    @Override
    public void setLetter(LetterModel letter) {
        this.setLetter(letter, true);
    }

    private void setLetter(LetterModel letter, boolean setDirty) {
        LetterModel oldLetter = this.getLetter();
        if (oldLetter == letter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaStopModelEnum.LETTER.getPropertyName());
        }
        this.letter = letter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaStopModelEnum.LETTER, letter, oldLetter);
    }

    @Override
    protected void updateByDto(AreaStopFullDto areaStopDto) {
        this.name = areaStopDto.getName();
        this.information = areaStopDto.getInformation();
        this.areaTourPart = (AreaTourPartModel)this.getModelCache().getModel(areaStopDto.getAreaTourPart());
        this.poi = (PoiModel)this.getModelCache().getModel(areaStopDto.getPoi());
        this.parcel = (ParcelModel)this.getModelCache().getModel(areaStopDto.getParcel());
        this.subscription = (SubscriptionModel)this.getModelCache().getModel(areaStopDto.getSubscription());
        ImmutablePointDto accessLocation = areaStopDto.getAccessLocation();
        this.accessLocation = accessLocation == null ? null : (ImmutablePoint)accessLocation.getGeoObject();
        this.sortOrder = areaStopDto.getSortOrder();
        this.estimatedDurationSeconds = areaStopDto.getEstimatedDurationSeconds();
        this.metersFromStart = areaStopDto.getMetersFromStart();
        this.secondsFromStart = areaStopDto.getSecondsFromStart();
        ImmutablePointDto location = areaStopDto.getLocation();
        this.location = location == null ? null : (ImmutablePoint)location.getGeoObject();
        this.letter = (LetterModel)this.getModelCache().getModel(areaStopDto.getLetter());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaStopFullDto areaStopDto) {
    }

    @Override
    protected void checkStaleByDto(AreaStopFullDto areaStopDto) throws StaleStateException {
        LetterModelImpl letterModel;
        LetterDto letterDto;
        SubscriptionModelImpl subscriptionModel;
        SubscriptionDto subscriptionDto;
        ParcelModelImpl parcelModel;
        ParcelDto parcelDto;
        PoiModelImpl poiModel;
        PoiDto poiDto;
        AreaTourPartModelImpl areaTourPartModel;
        AreaTourPartDto areaTourPartDto = areaStopDto.getAreaTourPart();
        if (areaTourPartDto != null && areaTourPartDto.getId() != null && (areaTourPartModel = (AreaTourPartModelImpl)this.getModelCache().getModel(AreaTourPartModel.class, areaTourPartDto.getId())) != null) {
            areaTourPartModel.checkStaleState(areaTourPartDto);
        }
        if ((poiDto = areaStopDto.getPoi()) != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
        if ((parcelDto = areaStopDto.getParcel()) != null && parcelDto.getId() != null && (parcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, parcelDto.getId())) != null) {
            parcelModel.checkStaleState(parcelDto);
        }
        if ((subscriptionDto = areaStopDto.getSubscription()) != null && subscriptionDto.getId() != null && (subscriptionModel = (SubscriptionModelImpl)this.getModelCache().getModel(SubscriptionModel.class, subscriptionDto.getId())) != null) {
            subscriptionModel.checkStaleState(subscriptionDto);
        }
        if ((letterDto = areaStopDto.getLetter()) != null && letterDto.getId() != null && (letterModel = (LetterModelImpl)this.getModelCache().getModel(LetterModel.class, letterDto.getId())) != null) {
            letterModel.checkStaleState(letterDto);
        }
    }

    @Override
    public AreaStopFullDto createDto() {
        SubscriptionModelImpl subscription;
        ParcelModelImpl parcel;
        PoiModelImpl poi;
        Long id = this.getId();
        AreaStopFullDto areaStopDto = id == null ? new AreaStopFullDto(this.getTempUUID()) : new AreaStopFullDto(id, this.getVersion());
        areaStopDto.setName(this.getName());
        areaStopDto.setInformation(this.getInformation());
        AreaTourPartModelImpl areaTourPart = (AreaTourPartModelImpl)this.getAreaTourPart();
        if (areaTourPart != null) {
            areaStopDto.setAreaTourPart(areaTourPart.createProxy());
        }
        if ((poi = (PoiModelImpl)this.getPoi()) != null) {
            areaStopDto.setPoi(poi.createProxy());
        }
        if ((parcel = (ParcelModelImpl)this.getParcel()) != null) {
            areaStopDto.setParcel(parcel.createProxy());
        }
        if ((subscription = (SubscriptionModelImpl)this.getSubscription()) != null) {
            areaStopDto.setSubscription(subscription.createProxy());
        }
        ImmutablePoint accessLocation = this.getAccessLocation();
        areaStopDto.setAccessLocation(ImmutablePointDto.create(accessLocation));
        areaStopDto.setSortOrder(this.getSortOrder());
        areaStopDto.setEstimatedDurationSeconds(this.getEstimatedDurationSeconds());
        areaStopDto.setMetersFromStart(this.getMetersFromStart());
        areaStopDto.setSecondsFromStart(this.getSecondsFromStart());
        ImmutablePoint location = this.getLocation();
        areaStopDto.setLocation(ImmutablePointDto.create(location));
        LetterModelImpl letter = (LetterModelImpl)this.getLetter();
        if (letter != null) {
            areaStopDto.setLetter(letter.createProxy());
        }
        return areaStopDto;
    }

    @Override
    public AreaStopProxyDto createProxy() {
        Long id = this.getId();
        AreaStopProxyDto areaStopDto = id == null ? new AreaStopProxyDto(this.getTempUUID()) : new AreaStopProxyDto(id, this.getVersion());
        return areaStopDto;
    }

    public static enum AreaStopModelEnum {
        NAME("name"),
        INFORMATION("information"),
        AREA_TOUR_PART("areaTourPart"),
        POI("poi"),
        PARCEL("parcel"),
        SUBSCRIPTION("subscription"),
        ACCESS_LOCATION("accessLocation"),
        SORT_ORDER("sortOrder"),
        ESTIMATED_DURATION_SECONDS("estimatedDurationSeconds"),
        METERS_FROM_START("metersFromStart"),
        SECONDS_FROM_START("secondsFromStart"),
        LOCATION("location"),
        LETTER("letter");

        private String propertyName;

        private AreaStopModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

