/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererStatusTimeWindowModel;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaDelivererStatusTimeWindowFullDto;
import de.datomino.peppergis.dto.tour.AreaDelivererStatusTimeWindowProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.DelivererStatus;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaDelivererStatusTimeWindowModelImpl
extends AbstractModel<AreaDelivererStatusTimeWindowFullDto, AreaDelivererStatusTimeWindowProxyDto>
implements AreaDelivererStatusTimeWindowModel {
    private Date startTime;
    private Date endTime;
    private DelivererStatus status;
    private AreaDelivererModel deliverer;

    public AreaDelivererStatusTimeWindowModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDelivererStatusTimeWindowModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Date getStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.setStartTime(startTime, true);
    }

    private void setStartTime(Date startTime, boolean setDirty) {
        Date oldStartTime = this.getStartTime();
        if (new EqualsBuilder().append(oldStartTime, startTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererStatusTimeWindowModelEnum.START_TIME.getPropertyName());
        }
        this.startTime = startTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererStatusTimeWindowModelEnum.START_TIME, startTime, oldStartTime);
    }

    @Override
    public Date getEndTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.setEndTime(endTime, true);
    }

    private void setEndTime(Date endTime, boolean setDirty) {
        Date oldEndTime = this.getEndTime();
        if (new EqualsBuilder().append(oldEndTime, endTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererStatusTimeWindowModelEnum.END_TIME.getPropertyName());
        }
        this.endTime = endTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererStatusTimeWindowModelEnum.END_TIME, endTime, oldEndTime);
    }

    @Override
    public DelivererStatus getStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.status;
    }

    @Override
    public void setStatus(DelivererStatus status) {
        this.setStatus(status, true);
    }

    private void setStatus(DelivererStatus status, boolean setDirty) {
        DelivererStatus oldStatus = this.getStatus();
        if (new EqualsBuilder().append((Object)oldStatus, (Object)status).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererStatusTimeWindowModelEnum.STATUS.getPropertyName());
        }
        this.status = status;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererStatusTimeWindowModelEnum.STATUS, (Object)status, (Object)oldStatus);
    }

    @Override
    public AreaDelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(AreaDelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(AreaDelivererModel deliverer, boolean setDirty) {
        AreaDelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.removeStatusTimeWindow(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererStatusTimeWindowModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererStatusTimeWindowModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.addStatusTimeWindow(this);
        }
    }

    @Override
    protected void updateByDto(AreaDelivererStatusTimeWindowFullDto areaDelivererStatusTimeWindowDto) {
        this.startTime = areaDelivererStatusTimeWindowDto.getStartTime();
        this.endTime = areaDelivererStatusTimeWindowDto.getEndTime();
        this.status = areaDelivererStatusTimeWindowDto.getStatus();
        this.deliverer = (AreaDelivererModel)this.getModelCache().getModel(areaDelivererStatusTimeWindowDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDelivererStatusTimeWindowFullDto areaDelivererStatusTimeWindowDto) {
    }

    @Override
    protected void checkStaleByDto(AreaDelivererStatusTimeWindowFullDto areaDelivererStatusTimeWindowDto) throws StaleStateException {
        AreaDelivererModelImpl delivererModel;
        AreaDelivererDto delivererDto = areaDelivererStatusTimeWindowDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (AreaDelivererModelImpl)this.getModelCache().getModel(AreaDelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public AreaDelivererStatusTimeWindowFullDto createDto() {
        Long id = this.getId();
        AreaDelivererStatusTimeWindowFullDto areaDelivererStatusTimeWindowDto = id == null ? new AreaDelivererStatusTimeWindowFullDto(this.getTempUUID()) : new AreaDelivererStatusTimeWindowFullDto(id, this.getVersion());
        areaDelivererStatusTimeWindowDto.setStartTime(this.getStartTime());
        areaDelivererStatusTimeWindowDto.setEndTime(this.getEndTime());
        areaDelivererStatusTimeWindowDto.setStatus(this.getStatus());
        AreaDelivererModelImpl deliverer = (AreaDelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            areaDelivererStatusTimeWindowDto.setDeliverer(deliverer.createProxy());
        }
        return areaDelivererStatusTimeWindowDto;
    }

    @Override
    public AreaDelivererStatusTimeWindowProxyDto createProxy() {
        Long id = this.getId();
        AreaDelivererStatusTimeWindowProxyDto areaDelivererStatusTimeWindowDto = id == null ? new AreaDelivererStatusTimeWindowProxyDto(this.getTempUUID()) : new AreaDelivererStatusTimeWindowProxyDto(id, this.getVersion());
        return areaDelivererStatusTimeWindowDto;
    }

    public static enum AreaDelivererStatusTimeWindowModelEnum {
        START_TIME("startTime"),
        END_TIME("endTime"),
        STATUS("status"),
        DELIVERER("deliverer");

        private String propertyName;

        private AreaDelivererStatusTimeWindowModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

