/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModel;
import de.datomino.peppergis.dto.tour.AreaDelivererEmploymentDto;
import de.datomino.peppergis.dto.tour.AreaDelivererFactorFullDto;
import de.datomino.peppergis.dto.tour.AreaDelivererFactorProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaDelivererFactorModelImpl
extends AbstractModel<AreaDelivererFactorFullDto, AreaDelivererFactorProxyDto>
implements AreaDelivererFactorModel {
    private Double factor;
    private AreaDelivererEmploymentModel delivererEmployment;

    public AreaDelivererFactorModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDelivererFactorModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Double getFactor() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.factor;
    }

    @Override
    public void setFactor(Double factor) {
        this.setFactor(factor, true);
    }

    private void setFactor(Double factor, boolean setDirty) {
        Double oldFactor = this.getFactor();
        if (new EqualsBuilder().append(oldFactor, factor).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererFactorModelEnum.FACTOR.getPropertyName());
        }
        this.factor = factor;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererFactorModelEnum.FACTOR, factor, oldFactor);
    }

    @Override
    public AreaDelivererEmploymentModel getDelivererEmployment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.delivererEmployment;
    }

    @Override
    public void setDelivererEmployment(AreaDelivererEmploymentModel delivererEmployment) {
        this.setDelivererEmployment(delivererEmployment, true);
    }

    private void setDelivererEmployment(AreaDelivererEmploymentModel delivererEmployment, boolean setDirty) {
        AreaDelivererEmploymentModel oldDelivererEmployment = this.getDelivererEmployment();
        if (oldDelivererEmployment == delivererEmployment) {
            return;
        }
        if (oldDelivererEmployment != null) {
            oldDelivererEmployment.removeFactor(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererFactorModelEnum.DELIVERER_EMPLOYMENT.getPropertyName());
        }
        this.delivererEmployment = delivererEmployment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererFactorModelEnum.DELIVERER_EMPLOYMENT, delivererEmployment, oldDelivererEmployment);
        if (this.delivererEmployment != null) {
            this.delivererEmployment.addFactor(this);
        }
    }

    @Override
    protected void updateByDto(AreaDelivererFactorFullDto areaDelivererFactorDto) {
        this.factor = areaDelivererFactorDto.getFactor();
        this.delivererEmployment = (AreaDelivererEmploymentModel)this.getModelCache().getModel(areaDelivererFactorDto.getDelivererEmployment());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDelivererFactorFullDto areaDelivererFactorDto) {
    }

    @Override
    protected void checkStaleByDto(AreaDelivererFactorFullDto areaDelivererFactorDto) throws StaleStateException {
        AreaDelivererEmploymentModelImpl delivererEmploymentModel;
        AreaDelivererEmploymentDto delivererEmploymentDto = areaDelivererFactorDto.getDelivererEmployment();
        if (delivererEmploymentDto != null && delivererEmploymentDto.getId() != null && (delivererEmploymentModel = (AreaDelivererEmploymentModelImpl)this.getModelCache().getModel(AreaDelivererEmploymentModel.class, delivererEmploymentDto.getId())) != null) {
            delivererEmploymentModel.checkStaleState(delivererEmploymentDto);
        }
    }

    @Override
    public AreaDelivererFactorFullDto createDto() {
        Long id = this.getId();
        AreaDelivererFactorFullDto areaDelivererFactorDto = id == null ? new AreaDelivererFactorFullDto(this.getTempUUID()) : new AreaDelivererFactorFullDto(id, this.getVersion());
        areaDelivererFactorDto.setFactor(this.getFactor());
        AreaDelivererEmploymentModelImpl delivererEmployment = (AreaDelivererEmploymentModelImpl)this.getDelivererEmployment();
        if (delivererEmployment != null) {
            areaDelivererFactorDto.setDelivererEmployment(delivererEmployment.createProxy());
        }
        return areaDelivererFactorDto;
    }

    @Override
    public AreaDelivererFactorProxyDto createProxy() {
        Long id = this.getId();
        AreaDelivererFactorProxyDto areaDelivererFactorDto = id == null ? new AreaDelivererFactorProxyDto(this.getTempUUID()) : new AreaDelivererFactorProxyDto(id, this.getVersion());
        return areaDelivererFactorDto;
    }

    public static enum AreaDelivererFactorModelEnum {
        FACTOR("factor"),
        DELIVERER_EMPLOYMENT("delivererEmployment");

        private String propertyName;

        private AreaDelivererFactorModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

