/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.offer.SenderModel;
import de.datomino.peppergis.dto.offer.SenderFullDto;
import de.datomino.peppergis.dto.offer.SenderProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SenderModelImpl
extends AbstractModel<SenderFullDto, SenderProxyDto>
implements SenderModel {
    private String name;
    private String street;
    private String housenumber;
    private String housenumberExtension;
    private String postcode;
    private String city;

    public SenderModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SenderModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.NAME, name, oldName);
    }

    @Override
    public String getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(String street) {
        this.setStreet(street, true);
    }

    private void setStreet(String street, boolean setDirty) {
        String oldStreet = this.getStreet();
        if (new EqualsBuilder().append(oldStreet, street).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.STREET, street, oldStreet);
    }

    @Override
    public String getHousenumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumber;
    }

    @Override
    public void setHousenumber(String housenumber) {
        this.setHousenumber(housenumber, true);
    }

    private void setHousenumber(String housenumber, boolean setDirty) {
        String oldHousenumber = this.getHousenumber();
        if (new EqualsBuilder().append(oldHousenumber, housenumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.HOUSENUMBER.getPropertyName());
        }
        this.housenumber = housenumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.HOUSENUMBER, housenumber, oldHousenumber);
    }

    @Override
    public String getHousenumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumberExtension;
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.setHousenumberExtension(housenumberExtension, true);
    }

    private void setHousenumberExtension(String housenumberExtension, boolean setDirty) {
        String oldHousenumberExtension = this.getHousenumberExtension();
        if (new EqualsBuilder().append(oldHousenumberExtension, housenumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.HOUSENUMBER_EXTENSION.getPropertyName());
        }
        this.housenumberExtension = housenumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.HOUSENUMBER_EXTENSION, housenumberExtension, oldHousenumberExtension);
    }

    @Override
    public String getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(String postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(String postcode, boolean setDirty) {
        String oldPostcode = this.getPostcode();
        if (new EqualsBuilder().append(oldPostcode, postcode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.POSTCODE, postcode, oldPostcode);
    }

    @Override
    public String getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.setCity(city, true);
    }

    private void setCity(String city, boolean setDirty) {
        String oldCity = this.getCity();
        if (new EqualsBuilder().append(oldCity, city).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SenderModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SenderModelEnum.CITY, city, oldCity);
    }

    @Override
    protected void updateByDto(SenderFullDto senderDto) {
        this.name = senderDto.getName();
        this.street = senderDto.getStreet();
        this.housenumber = senderDto.getHousenumber();
        this.housenumberExtension = senderDto.getHousenumberExtension();
        this.postcode = senderDto.getPostcode();
        this.city = senderDto.getCity();
    }

    @Override
    protected void updateMasterRelationsByDto(SenderFullDto senderDto) {
    }

    @Override
    protected void checkStaleByDto(SenderFullDto senderDto) throws StaleStateException {
    }

    @Override
    public SenderFullDto createDto() {
        Long id = this.getId();
        SenderFullDto senderDto = id == null ? new SenderFullDto(this.getTempUUID()) : new SenderFullDto(id, this.getVersion());
        senderDto.setName(this.getName());
        senderDto.setStreet(this.getStreet());
        senderDto.setHousenumber(this.getHousenumber());
        senderDto.setHousenumberExtension(this.getHousenumberExtension());
        senderDto.setPostcode(this.getPostcode());
        senderDto.setCity(this.getCity());
        return senderDto;
    }

    @Override
    public SenderProxyDto createProxy() {
        Long id = this.getId();
        SenderProxyDto senderDto = id == null ? new SenderProxyDto(this.getTempUUID()) : new SenderProxyDto(id, this.getVersion());
        return senderDto;
    }

    public static enum SenderModelEnum {
        NAME("name"),
        STREET("street"),
        HOUSENUMBER("housenumber"),
        HOUSENUMBER_EXTENSION("housenumberExtension"),
        POSTCODE("postcode"),
        CITY("city");

        private String propertyName;

        private SenderModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

