/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.offer.AgentModel;
import de.datomino.peppergis.client.model.offer.AgentModelImpl;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferTourRelationModel;
import de.datomino.peppergis.client.model.offer.OfferTourRelationModelImpl;
import de.datomino.peppergis.client.model.offer.SenderModel;
import de.datomino.peppergis.client.model.offer.SenderModelImpl;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.offer.AgentDto;
import de.datomino.peppergis.dto.offer.OfferAreaRelationDto;
import de.datomino.peppergis.dto.offer.OfferDeliveryRelationDto;
import de.datomino.peppergis.dto.offer.OfferFullDto;
import de.datomino.peppergis.dto.offer.OfferProxyDto;
import de.datomino.peppergis.dto.offer.OfferTourRelationDto;
import de.datomino.peppergis.dto.offer.SenderDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.OfferExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class OfferModelImpl
extends AbstractModel<OfferFullDto, OfferProxyDto>
implements OfferModel {
    private String offerNumber;
    private Date creationTime;
    private OfferExtension type;
    private CustomerModel customer;
    private AgentModel agent;
    private String salutationBrick;
    private String deliveryInformation;
    private Set<OfferAreaRelationModel> offerAreaRelations = null;
    private SenderModel sender;
    private Set<OfferTourRelationModel> offerTourRelations = null;
    private Set<OfferDeliveryRelationModel> offerDeliveryRelations = null;

    public OfferModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public OfferModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getOfferNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.offerNumber;
    }

    @Override
    public void setOfferNumber(String offerNumber) {
        this.setOfferNumber(offerNumber, true);
    }

    private void setOfferNumber(String offerNumber, boolean setDirty) {
        String oldOfferNumber = this.getOfferNumber();
        if (new EqualsBuilder().append(oldOfferNumber, offerNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.OFFER_NUMBER.getPropertyName());
        }
        this.offerNumber = offerNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.OFFER_NUMBER, offerNumber, oldOfferNumber);
    }

    @Override
    public Date getCreationTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.creationTime;
    }

    @Override
    public void setCreationTime(Date creationTime) {
        this.setCreationTime(creationTime, true);
    }

    private void setCreationTime(Date creationTime, boolean setDirty) {
        Date oldCreationTime = this.getCreationTime();
        if (new EqualsBuilder().append(oldCreationTime, creationTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.CREATION_TIME.getPropertyName());
        }
        this.creationTime = creationTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.CREATION_TIME, creationTime, oldCreationTime);
    }

    @Override
    public OfferExtension getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(OfferExtension type) {
        this.setType(type, true);
    }

    private void setType(OfferExtension type, boolean setDirty) {
        OfferExtension oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removeOffer(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addOffer(this);
        }
    }

    @Override
    public AgentModel getAgent() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.agent;
    }

    @Override
    public void setAgent(AgentModel agent) {
        this.setAgent(agent, true);
    }

    private void setAgent(AgentModel agent, boolean setDirty) {
        AgentModel oldAgent = this.getAgent();
        if (oldAgent == agent) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.AGENT.getPropertyName());
        }
        this.agent = agent;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.AGENT, agent, oldAgent);
    }

    @Override
    public String getSalutationBrick() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.salutationBrick;
    }

    @Override
    public void setSalutationBrick(String salutationBrick) {
        this.setSalutationBrick(salutationBrick, true);
    }

    private void setSalutationBrick(String salutationBrick, boolean setDirty) {
        String oldSalutationBrick = this.getSalutationBrick();
        if (new EqualsBuilder().append(oldSalutationBrick, salutationBrick).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.SALUTATION_BRICK.getPropertyName());
        }
        this.salutationBrick = salutationBrick;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.SALUTATION_BRICK, salutationBrick, oldSalutationBrick);
    }

    @Override
    public String getDeliveryInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryInformation;
    }

    @Override
    public void setDeliveryInformation(String deliveryInformation) {
        this.setDeliveryInformation(deliveryInformation, true);
    }

    private void setDeliveryInformation(String deliveryInformation, boolean setDirty) {
        String oldDeliveryInformation = this.getDeliveryInformation();
        if (new EqualsBuilder().append(oldDeliveryInformation, deliveryInformation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.DELIVERY_INFORMATION.getPropertyName());
        }
        this.deliveryInformation = deliveryInformation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.DELIVERY_INFORMATION, deliveryInformation, oldDeliveryInformation);
    }

    @Override
    public int countOfferAreaRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        return this.offerAreaRelations.size();
    }

    @Override
    public Iterator<OfferAreaRelationModel> iterateOfferAreaRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        return new ImmutableIterator<OfferAreaRelationModel>(this.offerAreaRelations);
    }

    @Override
    public Iterable<OfferAreaRelationModel> iterableOfferAreaRelations() {
        return new IteratorIterable<OfferAreaRelationModel>(this.iterateOfferAreaRelations());
    }

    @Override
    public void addOfferAreaRelation(OfferAreaRelationModel offerAreaRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        if (this.offerAreaRelations.contains(offerAreaRelation)) {
            return;
        }
        this.offerAreaRelations.add(offerAreaRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_AREA_RELATIONS, offerAreaRelation, null);
        if (offerAreaRelation != null) {
            offerAreaRelation.setOffer(this);
        }
    }

    @Override
    public void removeOfferAreaRelation(OfferAreaRelationModel offerAreaRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        if (!this.offerAreaRelations.contains(offerAreaRelation)) {
            return;
        }
        this.offerAreaRelations.remove(offerAreaRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_AREA_RELATIONS, offerAreaRelation, null);
        if (offerAreaRelation != null) {
            offerAreaRelation.setOffer(null);
        }
    }

    @Override
    public void clearOfferAreaRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        ArrayList<OfferAreaRelationModel> oldOfferAreaRelations = new ArrayList<OfferAreaRelationModel>(this.offerAreaRelations);
        this.offerAreaRelations.clear();
        this.fireValueChanged(OfferModelEnum.OFFER_AREA_RELATIONS, null, null);
        for (OfferAreaRelationModel oldOfferAreaRelation : oldOfferAreaRelations) {
            if (oldOfferAreaRelation == null) continue;
            oldOfferAreaRelation.setOffer(null);
        }
    }

    @Override
    public boolean isOfferAreaRelationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        return this.offerAreaRelations.isEmpty();
    }

    @Override
    public boolean containsOfferAreaRelation(OfferAreaRelationModel offerAreaRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerAreaRelations == null) {
            this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            if (this.getId() != null) {
                Collection offerAreaRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_AREA_RELATIONS.getPropertyName());
                this.offerAreaRelations.addAll(offerAreaRelationsCollection);
            }
        }
        return this.offerAreaRelations.contains(offerAreaRelation);
    }

    @Override
    public boolean isOfferAreaRelationsInitialized() {
        return this.offerAreaRelations != null;
    }

    @Override
    public SenderModel getSender() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sender;
    }

    @Override
    public void setSender(SenderModel sender) {
        this.setSender(sender, true);
    }

    private void setSender(SenderModel sender, boolean setDirty) {
        SenderModel oldSender = this.getSender();
        if (oldSender == sender) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferModelEnum.SENDER.getPropertyName());
        }
        this.sender = sender;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferModelEnum.SENDER, sender, oldSender);
    }

    @Override
    public int countOfferTourRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        return this.offerTourRelations.size();
    }

    @Override
    public Iterator<OfferTourRelationModel> iterateOfferTourRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        return new ImmutableIterator<OfferTourRelationModel>(this.offerTourRelations);
    }

    @Override
    public Iterable<OfferTourRelationModel> iterableOfferTourRelations() {
        return new IteratorIterable<OfferTourRelationModel>(this.iterateOfferTourRelations());
    }

    @Override
    public void addOfferTourRelation(OfferTourRelationModel offerTourRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        if (this.offerTourRelations.contains(offerTourRelation)) {
            return;
        }
        this.offerTourRelations.add(offerTourRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_TOUR_RELATIONS, offerTourRelation, null);
        if (offerTourRelation != null) {
            offerTourRelation.setOffer(this);
        }
    }

    @Override
    public void removeOfferTourRelation(OfferTourRelationModel offerTourRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        if (!this.offerTourRelations.contains(offerTourRelation)) {
            return;
        }
        this.offerTourRelations.remove(offerTourRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_TOUR_RELATIONS, offerTourRelation, null);
        if (offerTourRelation != null) {
            offerTourRelation.setOffer(null);
        }
    }

    @Override
    public void clearOfferTourRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        ArrayList<OfferTourRelationModel> oldOfferTourRelations = new ArrayList<OfferTourRelationModel>(this.offerTourRelations);
        this.offerTourRelations.clear();
        this.fireValueChanged(OfferModelEnum.OFFER_TOUR_RELATIONS, null, null);
        for (OfferTourRelationModel oldOfferTourRelation : oldOfferTourRelations) {
            if (oldOfferTourRelation == null) continue;
            oldOfferTourRelation.setOffer(null);
        }
    }

    @Override
    public boolean isOfferTourRelationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        return this.offerTourRelations.isEmpty();
    }

    @Override
    public boolean containsOfferTourRelation(OfferTourRelationModel offerTourRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerTourRelations == null) {
            this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            if (this.getId() != null) {
                Collection offerTourRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_TOUR_RELATIONS.getPropertyName());
                this.offerTourRelations.addAll(offerTourRelationsCollection);
            }
        }
        return this.offerTourRelations.contains(offerTourRelation);
    }

    @Override
    public boolean isOfferTourRelationsInitialized() {
        return this.offerTourRelations != null;
    }

    @Override
    public int countOfferDeliveryRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        return this.offerDeliveryRelations.size();
    }

    @Override
    public Iterator<OfferDeliveryRelationModel> iterateOfferDeliveryRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        return new ImmutableIterator<OfferDeliveryRelationModel>(this.offerDeliveryRelations);
    }

    @Override
    public Iterable<OfferDeliveryRelationModel> iterableOfferDeliveryRelations() {
        return new IteratorIterable<OfferDeliveryRelationModel>(this.iterateOfferDeliveryRelations());
    }

    @Override
    public void addOfferDeliveryRelation(OfferDeliveryRelationModel offerDeliveryRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        if (this.offerDeliveryRelations.contains(offerDeliveryRelation)) {
            return;
        }
        this.offerDeliveryRelations.add(offerDeliveryRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_DELIVERY_RELATIONS, offerDeliveryRelation, null);
        if (offerDeliveryRelation != null) {
            offerDeliveryRelation.setOffer(this);
        }
    }

    @Override
    public void removeOfferDeliveryRelation(OfferDeliveryRelationModel offerDeliveryRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        if (!this.offerDeliveryRelations.contains(offerDeliveryRelation)) {
            return;
        }
        this.offerDeliveryRelations.remove(offerDeliveryRelation);
        this.fireValueChanged(OfferModelEnum.OFFER_DELIVERY_RELATIONS, offerDeliveryRelation, null);
        if (offerDeliveryRelation != null) {
            offerDeliveryRelation.setOffer(null);
        }
    }

    @Override
    public void clearOfferDeliveryRelations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        ArrayList<OfferDeliveryRelationModel> oldOfferDeliveryRelations = new ArrayList<OfferDeliveryRelationModel>(this.offerDeliveryRelations);
        this.offerDeliveryRelations.clear();
        this.fireValueChanged(OfferModelEnum.OFFER_DELIVERY_RELATIONS, null, null);
        for (OfferDeliveryRelationModel oldOfferDeliveryRelation : oldOfferDeliveryRelations) {
            if (oldOfferDeliveryRelation == null) continue;
            oldOfferDeliveryRelation.setOffer(null);
        }
    }

    @Override
    public boolean isOfferDeliveryRelationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        return this.offerDeliveryRelations.isEmpty();
    }

    @Override
    public boolean containsOfferDeliveryRelation(OfferDeliveryRelationModel offerDeliveryRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offerDeliveryRelations == null) {
            this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            if (this.getId() != null) {
                Collection offerDeliveryRelationsCollection = this.commonCaller.fetchChildren(this, OfferModelEnum.OFFER_DELIVERY_RELATIONS.getPropertyName());
                this.offerDeliveryRelations.addAll(offerDeliveryRelationsCollection);
            }
        }
        return this.offerDeliveryRelations.contains(offerDeliveryRelation);
    }

    @Override
    public boolean isOfferDeliveryRelationsInitialized() {
        return this.offerDeliveryRelations != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.offerAreaRelations = null;
            this.offerTourRelations = null;
            this.offerDeliveryRelations = null;
        }
    }

    @Override
    protected void updateByDto(OfferFullDto offerDto) {
        OfferDeliveryRelationDto[] offerDeliveryRelations;
        this.offerNumber = offerDto.getOfferNumber();
        this.creationTime = offerDto.getCreationTime();
        this.type = offerDto.getType();
        this.customer = (CustomerModel)this.getModelCache().getModel(offerDto.getCustomer());
        this.agent = (AgentModel)this.getModelCache().getModel(offerDto.getAgent());
        this.salutationBrick = offerDto.getSalutationBrick();
        this.deliveryInformation = offerDto.getDeliveryInformation();
        OfferAreaRelationDto[] offerAreaRelations = offerDto.getOfferAreaRelations();
        if (offerAreaRelations != null) {
            if (this.offerAreaRelations == null) {
                this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            } else {
                this.offerAreaRelations.clear();
            }
        }
        this.sender = (SenderModel)this.getModelCache().getModel(offerDto.getSender());
        OfferTourRelationDto[] offerTourRelations = offerDto.getOfferTourRelations();
        if (offerTourRelations != null) {
            if (this.offerTourRelations == null) {
                this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            } else {
                this.offerTourRelations.clear();
            }
        }
        if ((offerDeliveryRelations = offerDto.getOfferDeliveryRelations()) != null) {
            if (this.offerDeliveryRelations == null) {
                this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            } else {
                this.offerDeliveryRelations.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(OfferFullDto offerDto) {
        OfferDeliveryRelationDto[] offerDeliveryRelations;
        OfferTourRelationDto[] offerTourRelations;
        OfferAreaRelationDto[] offerAreaRelations = offerDto.getOfferAreaRelations();
        if (offerAreaRelations != null) {
            if (this.offerAreaRelations == null) {
                this.offerAreaRelations = new LinkedHashSet<OfferAreaRelationModel>();
            } else {
                this.offerAreaRelations.clear();
            }
            for (OfferAreaRelationDto offerAreaRelationDto : offerAreaRelations) {
                OfferAreaRelationModel offerAreaRelationModel = (OfferAreaRelationModel)this.getModelCache().getModel(offerAreaRelationDto);
                this.offerAreaRelations.add(offerAreaRelationModel);
            }
        } else {
            this.offerAreaRelations = null;
        }
        if ((offerTourRelations = offerDto.getOfferTourRelations()) != null) {
            if (this.offerTourRelations == null) {
                this.offerTourRelations = new LinkedHashSet<OfferTourRelationModel>();
            } else {
                this.offerTourRelations.clear();
            }
            for (OfferTourRelationDto offerTourRelationDto : offerTourRelations) {
                OfferTourRelationModel offerTourRelationModel = (OfferTourRelationModel)this.getModelCache().getModel(offerTourRelationDto);
                this.offerTourRelations.add(offerTourRelationModel);
            }
        } else {
            this.offerTourRelations = null;
        }
        if ((offerDeliveryRelations = offerDto.getOfferDeliveryRelations()) != null) {
            if (this.offerDeliveryRelations == null) {
                this.offerDeliveryRelations = new LinkedHashSet<OfferDeliveryRelationModel>();
            } else {
                this.offerDeliveryRelations.clear();
            }
            for (OfferDeliveryRelationDto offerDeliveryRelationDto : offerDeliveryRelations) {
                OfferDeliveryRelationModel offerDeliveryRelationModel = (OfferDeliveryRelationModel)this.getModelCache().getModel(offerDeliveryRelationDto);
                this.offerDeliveryRelations.add(offerDeliveryRelationModel);
            }
        } else {
            this.offerDeliveryRelations = null;
        }
    }

    @Override
    protected void checkStaleByDto(OfferFullDto offerDto) throws StaleStateException {
        OfferDeliveryRelationDto[] offerDeliveryRelationDtos;
        OfferTourRelationDto[] offerTourRelationDtos;
        SenderModelImpl senderModel;
        SenderDto senderDto;
        OfferAreaRelationDto[] offerAreaRelationDtos;
        AgentModelImpl agentModel;
        AgentDto agentDto;
        CustomerModelImpl customerModel;
        CustomerDto customerDto = offerDto.getCustomer();
        if (customerDto != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
        if ((agentDto = offerDto.getAgent()) != null && agentDto.getId() != null && (agentModel = (AgentModelImpl)this.getModelCache().getModel(AgentModel.class, agentDto.getId())) != null) {
            agentModel.checkStaleState(agentDto);
        }
        if ((offerAreaRelationDtos = offerDto.getOfferAreaRelations()) != null) {
            for (OfferAreaRelationDto offerAreaRelationDto : offerAreaRelationDtos) {
                OfferAreaRelationModelImpl offerAreaRelationModel = (OfferAreaRelationModelImpl)this.getModelCache().getModel(OfferAreaRelationModel.class, offerAreaRelationDto.getId());
                if (offerAreaRelationModel == null) continue;
                offerAreaRelationModel.checkStaleState(offerAreaRelationDto);
            }
        }
        if ((senderDto = offerDto.getSender()) != null && senderDto.getId() != null && (senderModel = (SenderModelImpl)this.getModelCache().getModel(SenderModel.class, senderDto.getId())) != null) {
            senderModel.checkStaleState(senderDto);
        }
        if ((offerTourRelationDtos = offerDto.getOfferTourRelations()) != null) {
            for (OfferTourRelationDto offerTourRelationDto : offerTourRelationDtos) {
                OfferTourRelationModelImpl offerTourRelationModel = (OfferTourRelationModelImpl)this.getModelCache().getModel(OfferTourRelationModel.class, offerTourRelationDto.getId());
                if (offerTourRelationModel == null) continue;
                offerTourRelationModel.checkStaleState(offerTourRelationDto);
            }
        }
        if ((offerDeliveryRelationDtos = offerDto.getOfferDeliveryRelations()) != null) {
            for (OfferDeliveryRelationDto offerDeliveryRelationDto : offerDeliveryRelationDtos) {
                OfferDeliveryRelationModelImpl offerDeliveryRelationModel = (OfferDeliveryRelationModelImpl)this.getModelCache().getModel(OfferDeliveryRelationModel.class, offerDeliveryRelationDto.getId());
                if (offerDeliveryRelationModel == null) continue;
                offerDeliveryRelationModel.checkStaleState(offerDeliveryRelationDto);
            }
        }
    }

    @Override
    public OfferFullDto createDto() {
        AgentModelImpl agent;
        Long id = this.getId();
        OfferFullDto offerDto = id == null ? new OfferFullDto(this.getTempUUID()) : new OfferFullDto(id, this.getVersion());
        offerDto.setOfferNumber(this.getOfferNumber());
        offerDto.setCreationTime(this.getCreationTime());
        offerDto.setType(this.getType());
        CustomerModelImpl customer = (CustomerModelImpl)this.getCustomer();
        if (customer != null) {
            offerDto.setCustomer(customer.createProxy());
        }
        if ((agent = (AgentModelImpl)this.getAgent()) != null) {
            offerDto.setAgent(agent.createProxy());
        }
        offerDto.setSalutationBrick(this.getSalutationBrick());
        offerDto.setDeliveryInformation(this.getDeliveryInformation());
        SenderModelImpl sender = (SenderModelImpl)this.getSender();
        if (sender != null) {
            offerDto.setSender(sender.createProxy());
        }
        return offerDto;
    }

    @Override
    public OfferProxyDto createProxy() {
        Long id = this.getId();
        OfferProxyDto offerDto = id == null ? new OfferProxyDto(this.getTempUUID()) : new OfferProxyDto(id, this.getVersion());
        return offerDto;
    }

    public static enum OfferModelEnum {
        OFFER_NUMBER("offerNumber"),
        CREATION_TIME("creationTime"),
        TYPE("type"),
        CUSTOMER("customer"),
        AGENT("agent"),
        SALUTATION_BRICK("salutationBrick"),
        DELIVERY_INFORMATION("deliveryInformation"),
        OFFER_AREA_RELATIONS("offerAreaRelations"),
        SENDER("sender"),
        OFFER_TOUR_RELATIONS("offerTourRelations"),
        OFFER_DELIVERY_RELATIONS("offerDeliveryRelations");

        private String propertyName;

        private OfferModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

