/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModel;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferModelImpl;
import de.datomino.peppergis.dto.offer.OfferDeliveryInformationDto;
import de.datomino.peppergis.dto.offer.OfferDeliveryRelationFullDto;
import de.datomino.peppergis.dto.offer.OfferDeliveryRelationProxyDto;
import de.datomino.peppergis.dto.offer.OfferDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class OfferDeliveryRelationModelImpl
extends AbstractModel<OfferDeliveryRelationFullDto, OfferDeliveryRelationProxyDto>
implements OfferDeliveryRelationModel {
    private Integer quantity;
    private OfferModel offer;
    private OfferDeliveryInformationModel offerDeliveryInformation;

    public OfferDeliveryRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public OfferDeliveryRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getQuantity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer quantity) {
        this.setQuantity(quantity, true);
    }

    private void setQuantity(Integer quantity, boolean setDirty) {
        Integer oldQuantity = this.getQuantity();
        if (new EqualsBuilder().append(oldQuantity, quantity).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferDeliveryRelationModelEnum.QUANTITY.getPropertyName());
        }
        this.quantity = quantity;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferDeliveryRelationModelEnum.QUANTITY, quantity, oldQuantity);
    }

    @Override
    public OfferModel getOffer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.offer;
    }

    @Override
    public void setOffer(OfferModel offer) {
        this.setOffer(offer, true);
    }

    private void setOffer(OfferModel offer, boolean setDirty) {
        OfferModel oldOffer = this.getOffer();
        if (oldOffer == offer) {
            return;
        }
        if (oldOffer != null) {
            oldOffer.removeOfferDeliveryRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferDeliveryRelationModelEnum.OFFER.getPropertyName());
        }
        this.offer = offer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferDeliveryRelationModelEnum.OFFER, offer, oldOffer);
        if (this.offer != null) {
            this.offer.addOfferDeliveryRelation(this);
        }
    }

    @Override
    public OfferDeliveryInformationModel getOfferDeliveryInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.offerDeliveryInformation;
    }

    @Override
    public void setOfferDeliveryInformation(OfferDeliveryInformationModel offerDeliveryInformation) {
        this.setOfferDeliveryInformation(offerDeliveryInformation, true);
    }

    private void setOfferDeliveryInformation(OfferDeliveryInformationModel offerDeliveryInformation, boolean setDirty) {
        OfferDeliveryInformationModel oldOfferDeliveryInformation = this.getOfferDeliveryInformation();
        if (oldOfferDeliveryInformation == offerDeliveryInformation) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferDeliveryRelationModelEnum.OFFER_DELIVERY_INFORMATION.getPropertyName());
        }
        this.offerDeliveryInformation = offerDeliveryInformation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferDeliveryRelationModelEnum.OFFER_DELIVERY_INFORMATION, offerDeliveryInformation, oldOfferDeliveryInformation);
    }

    @Override
    protected void updateByDto(OfferDeliveryRelationFullDto offerDeliveryRelationDto) {
        this.quantity = offerDeliveryRelationDto.getQuantity();
        this.offer = (OfferModel)this.getModelCache().getModel(offerDeliveryRelationDto.getOffer());
        this.offerDeliveryInformation = (OfferDeliveryInformationModel)this.getModelCache().getModel(offerDeliveryRelationDto.getOfferDeliveryInformation());
    }

    @Override
    protected void updateMasterRelationsByDto(OfferDeliveryRelationFullDto offerDeliveryRelationDto) {
    }

    @Override
    protected void checkStaleByDto(OfferDeliveryRelationFullDto offerDeliveryRelationDto) throws StaleStateException {
        OfferDeliveryInformationModelImpl offerDeliveryInformationModel;
        OfferDeliveryInformationDto offerDeliveryInformationDto;
        OfferModelImpl offerModel;
        OfferDto offerDto = offerDeliveryRelationDto.getOffer();
        if (offerDto != null && offerDto.getId() != null && (offerModel = (OfferModelImpl)this.getModelCache().getModel(OfferModel.class, offerDto.getId())) != null) {
            offerModel.checkStaleState(offerDto);
        }
        if ((offerDeliveryInformationDto = offerDeliveryRelationDto.getOfferDeliveryInformation()) != null && offerDeliveryInformationDto.getId() != null && (offerDeliveryInformationModel = (OfferDeliveryInformationModelImpl)this.getModelCache().getModel(OfferDeliveryInformationModel.class, offerDeliveryInformationDto.getId())) != null) {
            offerDeliveryInformationModel.checkStaleState(offerDeliveryInformationDto);
        }
    }

    @Override
    public OfferDeliveryRelationFullDto createDto() {
        OfferDeliveryInformationModelImpl offerDeliveryInformation;
        Long id = this.getId();
        OfferDeliveryRelationFullDto offerDeliveryRelationDto = id == null ? new OfferDeliveryRelationFullDto(this.getTempUUID()) : new OfferDeliveryRelationFullDto(id, this.getVersion());
        offerDeliveryRelationDto.setQuantity(this.getQuantity());
        OfferModelImpl offer = (OfferModelImpl)this.getOffer();
        if (offer != null) {
            offerDeliveryRelationDto.setOffer(offer.createProxy());
        }
        if ((offerDeliveryInformation = (OfferDeliveryInformationModelImpl)this.getOfferDeliveryInformation()) != null) {
            offerDeliveryRelationDto.setOfferDeliveryInformation(offerDeliveryInformation.createProxy());
        }
        return offerDeliveryRelationDto;
    }

    @Override
    public OfferDeliveryRelationProxyDto createProxy() {
        Long id = this.getId();
        OfferDeliveryRelationProxyDto offerDeliveryRelationDto = id == null ? new OfferDeliveryRelationProxyDto(this.getTempUUID()) : new OfferDeliveryRelationProxyDto(id, this.getVersion());
        return offerDeliveryRelationDto;
    }

    public static enum OfferDeliveryRelationModelEnum {
        QUANTITY("quantity"),
        OFFER("offer"),
        OFFER_DELIVERY_INFORMATION("offerDeliveryInformation");

        private String propertyName;

        private OfferDeliveryRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

