/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.offer.MediaModel;
import de.datomino.peppergis.dto.offer.MediaFullDto;
import de.datomino.peppergis.dto.offer.MediaProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class MediaModelImpl
extends AbstractModel<MediaFullDto, MediaProxyDto>
implements MediaModel {
    private String name;

    public MediaModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public MediaModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, MediaModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(MediaModelEnum.NAME, name, oldName);
    }

    @Override
    protected void updateByDto(MediaFullDto mediaDto) {
        this.name = mediaDto.getName();
    }

    @Override
    protected void updateMasterRelationsByDto(MediaFullDto mediaDto) {
    }

    @Override
    protected void checkStaleByDto(MediaFullDto mediaDto) throws StaleStateException {
    }

    @Override
    public MediaFullDto createDto() {
        Long id = this.getId();
        MediaFullDto mediaDto = id == null ? new MediaFullDto(this.getTempUUID()) : new MediaFullDto(id, this.getVersion());
        mediaDto.setName(this.getName());
        return mediaDto;
    }

    @Override
    public MediaProxyDto createProxy() {
        Long id = this.getId();
        MediaProxyDto mediaDto = id == null ? new MediaProxyDto(this.getTempUUID()) : new MediaProxyDto(id, this.getVersion());
        return mediaDto;
    }

    public static enum MediaModelEnum {
        NAME("name");

        private String propertyName;

        private MediaModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

