/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.offer.AgencyFullDto;
import de.datomino.peppergis.dto.offer.AgencyProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AgencyModelImpl
extends AbstractModel<AgencyFullDto, AgencyProxyDto>
implements AgencyModel {
    private String agencyNumber;
    private String name;
    private LocationModel location;
    private Set<CustomerModel> customers = null;

    public AgencyModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AgencyModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getAgencyNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.agencyNumber;
    }

    @Override
    public void setAgencyNumber(String agencyNumber) {
        this.setAgencyNumber(agencyNumber, true);
    }

    private void setAgencyNumber(String agencyNumber, boolean setDirty) {
        String oldAgencyNumber = this.getAgencyNumber();
        if (new EqualsBuilder().append(oldAgencyNumber, agencyNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgencyModelEnum.AGENCY_NUMBER.getPropertyName());
        }
        this.agencyNumber = agencyNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgencyModelEnum.AGENCY_NUMBER, agencyNumber, oldAgencyNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgencyModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgencyModelEnum.NAME, name, oldName);
    }

    @Override
    public LocationModel getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(LocationModel location) {
        this.setLocation(location, true);
    }

    private void setLocation(LocationModel location, boolean setDirty) {
        LocationModel oldLocation = this.getLocation();
        if (oldLocation == location) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgencyModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgencyModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public int countCustomers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        return this.customers.size();
    }

    @Override
    public Iterator<CustomerModel> iterateCustomers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        return new ImmutableIterator<CustomerModel>(this.customers);
    }

    @Override
    public Iterable<CustomerModel> iterableCustomers() {
        return new IteratorIterable<CustomerModel>(this.iterateCustomers());
    }

    @Override
    public void addCustomer(CustomerModel customer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        if (this.customers.contains(customer)) {
            return;
        }
        this.customers.add(customer);
        this.fireValueChanged(AgencyModelEnum.CUSTOMERS, customer, null);
        if (customer != null) {
            customer.setAgency(this);
        }
    }

    @Override
    public void removeCustomer(CustomerModel customer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        if (!this.customers.contains(customer)) {
            return;
        }
        this.customers.remove(customer);
        this.fireValueChanged(AgencyModelEnum.CUSTOMERS, customer, null);
        if (customer != null) {
            customer.setAgency(null);
        }
    }

    @Override
    public void clearCustomers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        ArrayList<CustomerModel> oldCustomers = new ArrayList<CustomerModel>(this.customers);
        this.customers.clear();
        this.fireValueChanged(AgencyModelEnum.CUSTOMERS, null, null);
        for (CustomerModel oldCustomer : oldCustomers) {
            if (oldCustomer == null) continue;
            oldCustomer.setAgency(null);
        }
    }

    @Override
    public boolean isCustomersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        return this.customers.isEmpty();
    }

    @Override
    public boolean containsCustomer(CustomerModel customer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.customers == null) {
            this.customers = new LinkedHashSet<CustomerModel>();
            if (this.getId() != null) {
                Collection customersCollection = this.commonCaller.fetchChildren(this, AgencyModelEnum.CUSTOMERS.getPropertyName());
                this.customers.addAll(customersCollection);
            }
        }
        return this.customers.contains(customer);
    }

    @Override
    public boolean isCustomersInitialized() {
        return this.customers != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.customers = null;
        }
    }

    @Override
    protected void updateByDto(AgencyFullDto agencyDto) {
        this.agencyNumber = agencyDto.getAgencyNumber();
        this.name = agencyDto.getName();
        this.location = (LocationModel)this.getModelCache().getModel(agencyDto.getLocation());
        CustomerDto[] customers = agencyDto.getCustomers();
        if (customers != null) {
            if (this.customers == null) {
                this.customers = new LinkedHashSet<CustomerModel>();
            } else {
                this.customers.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(AgencyFullDto agencyDto) {
        CustomerDto[] customers = agencyDto.getCustomers();
        if (customers != null) {
            if (this.customers == null) {
                this.customers = new LinkedHashSet<CustomerModel>();
            } else {
                this.customers.clear();
            }
            for (CustomerDto customerDto : customers) {
                CustomerModel customerModel = (CustomerModel)this.getModelCache().getModel(customerDto);
                this.customers.add(customerModel);
            }
        } else {
            this.customers = null;
        }
    }

    @Override
    protected void checkStaleByDto(AgencyFullDto agencyDto) throws StaleStateException {
        CustomerDto[] customerDtos;
        LocationModelImpl locationModel;
        LocationDto locationDto = agencyDto.getLocation();
        if (locationDto != null && locationDto.getId() != null && (locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId())) != null) {
            locationModel.checkStaleState(locationDto);
        }
        if ((customerDtos = agencyDto.getCustomers()) != null) {
            for (CustomerDto customerDto : customerDtos) {
                CustomerModelImpl customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId());
                if (customerModel == null) continue;
                customerModel.checkStaleState(customerDto);
            }
        }
    }

    @Override
    public AgencyFullDto createDto() {
        Long id = this.getId();
        AgencyFullDto agencyDto = id == null ? new AgencyFullDto(this.getTempUUID()) : new AgencyFullDto(id, this.getVersion());
        agencyDto.setAgencyNumber(this.getAgencyNumber());
        agencyDto.setName(this.getName());
        LocationModelImpl location = (LocationModelImpl)this.getLocation();
        if (location != null) {
            agencyDto.setLocation(location.createProxy());
        }
        return agencyDto;
    }

    @Override
    public AgencyProxyDto createProxy() {
        Long id = this.getId();
        AgencyProxyDto agencyDto = id == null ? new AgencyProxyDto(this.getTempUUID()) : new AgencyProxyDto(id, this.getVersion());
        return agencyDto;
    }

    public static enum AgencyModelEnum {
        AGENCY_NUMBER("agencyNumber"),
        NAME("name"),
        LOCATION("location"),
        CUSTOMERS("customers");

        private String propertyName;

        private AgencyModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

