/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.mobile.TourSyncStatusModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.TourSyncStatusFullDto;
import de.datomino.peppergis.dto.mobile.TourSyncStatusProxyDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class TourSyncStatusModelImpl
extends AbstractModel<TourSyncStatusFullDto, TourSyncStatusProxyDto>
implements TourSyncStatusModel {
    private TourModel tour;
    private Long syncedVersion;
    private AccountModel account;

    public TourSyncStatusModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TourSyncStatusModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public TourModel getTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tour;
    }

    @Override
    public void setTour(TourModel tour) {
        this.setTour(tour, true);
    }

    private void setTour(TourModel tour, boolean setDirty) {
        TourModel oldTour = this.getTour();
        if (oldTour == tour) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourSyncStatusModelEnum.TOUR.getPropertyName());
        }
        this.tour = tour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourSyncStatusModelEnum.TOUR, tour, oldTour);
    }

    @Override
    public Long getSyncedVersion() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.syncedVersion;
    }

    @Override
    public void setSyncedVersion(Long syncedVersion) {
        this.setSyncedVersion(syncedVersion, true);
    }

    private void setSyncedVersion(Long syncedVersion, boolean setDirty) {
        Long oldSyncedVersion = this.getSyncedVersion();
        if (new EqualsBuilder().append(oldSyncedVersion, syncedVersion).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourSyncStatusModelEnum.SYNCED_VERSION.getPropertyName());
        }
        this.syncedVersion = syncedVersion;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourSyncStatusModelEnum.SYNCED_VERSION, syncedVersion, oldSyncedVersion);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourSyncStatusModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourSyncStatusModelEnum.ACCOUNT, account, oldAccount);
    }

    @Override
    protected void updateByDto(TourSyncStatusFullDto tourSyncStatusDto) {
        this.tour = (TourModel)this.getModelCache().getModel(tourSyncStatusDto.getTour());
        this.syncedVersion = tourSyncStatusDto.getSyncedVersion();
        this.account = (AccountModel)this.getModelCache().getModel(tourSyncStatusDto.getAccount());
    }

    @Override
    protected void updateMasterRelationsByDto(TourSyncStatusFullDto tourSyncStatusDto) {
    }

    @Override
    protected void checkStaleByDto(TourSyncStatusFullDto tourSyncStatusDto) throws StaleStateException {
        AccountModelImpl accountModel;
        AccountDto accountDto;
        TourModelImpl tourModel;
        TourDto tourDto = tourSyncStatusDto.getTour();
        if (tourDto != null && tourDto.getId() != null && (tourModel = (TourModelImpl)this.getModelCache().getModel(TourModel.class, tourDto.getId())) != null) {
            tourModel.checkStaleState(tourDto);
        }
        if ((accountDto = tourSyncStatusDto.getAccount()) != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
    }

    @Override
    public TourSyncStatusFullDto createDto() {
        Long id = this.getId();
        TourSyncStatusFullDto tourSyncStatusDto = id == null ? new TourSyncStatusFullDto(this.getTempUUID()) : new TourSyncStatusFullDto(id, this.getVersion());
        TourModelImpl tour = (TourModelImpl)this.getTour();
        if (tour != null) {
            tourSyncStatusDto.setTour(tour.createProxy());
        }
        tourSyncStatusDto.setSyncedVersion(this.getSyncedVersion());
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            tourSyncStatusDto.setAccount(account.createProxy());
        }
        return tourSyncStatusDto;
    }

    @Override
    public TourSyncStatusProxyDto createProxy() {
        Long id = this.getId();
        TourSyncStatusProxyDto tourSyncStatusDto = id == null ? new TourSyncStatusProxyDto(this.getTempUUID()) : new TourSyncStatusProxyDto(id, this.getVersion());
        return tourSyncStatusDto;
    }

    public static enum TourSyncStatusModelEnum {
        TOUR("tour"),
        SYNCED_VERSION("syncedVersion"),
        ACCOUNT("account");

        private String propertyName;

        private TourSyncStatusModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

