/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.mobile.TourPartSyncStatusModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.TourPartSyncStatusFullDto;
import de.datomino.peppergis.dto.mobile.TourPartSyncStatusProxyDto;
import de.datomino.peppergis.dto.tour.TourPartDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class TourPartSyncStatusModelImpl
extends AbstractModel<TourPartSyncStatusFullDto, TourPartSyncStatusProxyDto>
implements TourPartSyncStatusModel {
    private TourPartModel tourPart;
    private Long syncedVersion;
    private AccountModel account;

    public TourPartSyncStatusModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TourPartSyncStatusModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public TourPartModel getTourPart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tourPart;
    }

    @Override
    public void setTourPart(TourPartModel tourPart) {
        this.setTourPart(tourPart, true);
    }

    private void setTourPart(TourPartModel tourPart, boolean setDirty) {
        TourPartModel oldTourPart = this.getTourPart();
        if (oldTourPart == tourPart) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartSyncStatusModelEnum.TOUR_PART.getPropertyName());
        }
        this.tourPart = tourPart;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartSyncStatusModelEnum.TOUR_PART, tourPart, oldTourPart);
    }

    @Override
    public Long getSyncedVersion() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.syncedVersion;
    }

    @Override
    public void setSyncedVersion(Long syncedVersion) {
        this.setSyncedVersion(syncedVersion, true);
    }

    private void setSyncedVersion(Long syncedVersion, boolean setDirty) {
        Long oldSyncedVersion = this.getSyncedVersion();
        if (new EqualsBuilder().append(oldSyncedVersion, syncedVersion).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartSyncStatusModelEnum.SYNCED_VERSION.getPropertyName());
        }
        this.syncedVersion = syncedVersion;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartSyncStatusModelEnum.SYNCED_VERSION, syncedVersion, oldSyncedVersion);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartSyncStatusModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartSyncStatusModelEnum.ACCOUNT, account, oldAccount);
    }

    @Override
    protected void updateByDto(TourPartSyncStatusFullDto tourPartSyncStatusDto) {
        this.tourPart = (TourPartModel)this.getModelCache().getModel(tourPartSyncStatusDto.getTourPart());
        this.syncedVersion = tourPartSyncStatusDto.getSyncedVersion();
        this.account = (AccountModel)this.getModelCache().getModel(tourPartSyncStatusDto.getAccount());
    }

    @Override
    protected void updateMasterRelationsByDto(TourPartSyncStatusFullDto tourPartSyncStatusDto) {
    }

    @Override
    protected void checkStaleByDto(TourPartSyncStatusFullDto tourPartSyncStatusDto) throws StaleStateException {
        AccountModelImpl accountModel;
        AccountDto accountDto;
        TourPartModelImpl tourPartModel;
        TourPartDto tourPartDto = tourPartSyncStatusDto.getTourPart();
        if (tourPartDto != null && tourPartDto.getId() != null && (tourPartModel = (TourPartModelImpl)this.getModelCache().getModel(TourPartModel.class, tourPartDto.getId())) != null) {
            tourPartModel.checkStaleState(tourPartDto);
        }
        if ((accountDto = tourPartSyncStatusDto.getAccount()) != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
    }

    @Override
    public TourPartSyncStatusFullDto createDto() {
        Long id = this.getId();
        TourPartSyncStatusFullDto tourPartSyncStatusDto = id == null ? new TourPartSyncStatusFullDto(this.getTempUUID()) : new TourPartSyncStatusFullDto(id, this.getVersion());
        TourPartModelImpl tourPart = (TourPartModelImpl)this.getTourPart();
        if (tourPart != null) {
            tourPartSyncStatusDto.setTourPart(tourPart.createProxy());
        }
        tourPartSyncStatusDto.setSyncedVersion(this.getSyncedVersion());
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            tourPartSyncStatusDto.setAccount(account.createProxy());
        }
        return tourPartSyncStatusDto;
    }

    @Override
    public TourPartSyncStatusProxyDto createProxy() {
        Long id = this.getId();
        TourPartSyncStatusProxyDto tourPartSyncStatusDto = id == null ? new TourPartSyncStatusProxyDto(this.getTempUUID()) : new TourPartSyncStatusProxyDto(id, this.getVersion());
        return tourPartSyncStatusDto;
    }

    public static enum TourPartSyncStatusModelEnum {
        TOUR_PART("tourPart"),
        SYNCED_VERSION("syncedVersion"),
        ACCOUNT("account");

        private String propertyName;

        private TourPartSyncStatusModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

