/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.PlaceOfBusinessModel;
import de.datomino.peppergis.dto.mobile.PlaceOfBusinessFullDto;
import de.datomino.peppergis.dto.mobile.PlaceOfBusinessProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PlaceOfBusinessModelImpl
extends AbstractModel<PlaceOfBusinessFullDto, PlaceOfBusinessProxyDto>
implements PlaceOfBusinessModel {
    private String number;
    private String name;

    public PlaceOfBusinessModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PlaceOfBusinessModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.number;
    }

    @Override
    public void setNumber(String number) {
        this.setNumber(number, true);
    }

    private void setNumber(String number, boolean setDirty) {
        String oldNumber = this.getNumber();
        if (new EqualsBuilder().append(oldNumber, number).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceOfBusinessModelEnum.NUMBER.getPropertyName());
        }
        this.number = number;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceOfBusinessModelEnum.NUMBER, number, oldNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceOfBusinessModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceOfBusinessModelEnum.NAME, name, oldName);
    }

    @Override
    protected void updateByDto(PlaceOfBusinessFullDto placeOfBusinessDto) {
        this.number = placeOfBusinessDto.getNumber();
        this.name = placeOfBusinessDto.getName();
    }

    @Override
    protected void updateMasterRelationsByDto(PlaceOfBusinessFullDto placeOfBusinessDto) {
    }

    @Override
    protected void checkStaleByDto(PlaceOfBusinessFullDto placeOfBusinessDto) throws StaleStateException {
    }

    @Override
    public PlaceOfBusinessFullDto createDto() {
        Long id = this.getId();
        PlaceOfBusinessFullDto placeOfBusinessDto = id == null ? new PlaceOfBusinessFullDto(this.getTempUUID()) : new PlaceOfBusinessFullDto(id, this.getVersion());
        placeOfBusinessDto.setNumber(this.getNumber());
        placeOfBusinessDto.setName(this.getName());
        return placeOfBusinessDto;
    }

    @Override
    public PlaceOfBusinessProxyDto createProxy() {
        Long id = this.getId();
        PlaceOfBusinessProxyDto placeOfBusinessDto = id == null ? new PlaceOfBusinessProxyDto(this.getTempUUID()) : new PlaceOfBusinessProxyDto(id, this.getVersion());
        return placeOfBusinessDto;
    }

    public static enum PlaceOfBusinessModelEnum {
        NUMBER("number"),
        NAME("name");

        private String propertyName;

        private PlaceOfBusinessModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

