/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.LocationCapturingFullDto;
import de.datomino.peppergis.dto.mobile.LocationCapturingProxyDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class LocationCapturingModelImpl
extends AbstractModel<LocationCapturingFullDto, LocationCapturingProxyDto>
implements LocationCapturingModel {
    private AccountModel account;
    private String country;
    private String postcode;
    private String city;
    private String district;
    private String street;
    private String housenumber;
    private String housenumberExtension;
    private ImmutablePoint geoLocation;
    private Date mobileTime;
    private Date syncTime;
    private StopModel stop;

    public LocationCapturingModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public LocationCapturingModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.ACCOUNT, account, oldAccount);
    }

    @Override
    public String getCountry() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.country;
    }

    @Override
    public void setCountry(String country) {
        this.setCountry(country, true);
    }

    private void setCountry(String country, boolean setDirty) {
        String oldCountry = this.getCountry();
        if (new EqualsBuilder().append(oldCountry, country).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.COUNTRY.getPropertyName());
        }
        this.country = country;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.COUNTRY, country, oldCountry);
    }

    @Override
    public String getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(String postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(String postcode, boolean setDirty) {
        String oldPostcode = this.getPostcode();
        if (new EqualsBuilder().append(oldPostcode, postcode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.POSTCODE, postcode, oldPostcode);
    }

    @Override
    public String getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.setCity(city, true);
    }

    private void setCity(String city, boolean setDirty) {
        String oldCity = this.getCity();
        if (new EqualsBuilder().append(oldCity, city).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.CITY, city, oldCity);
    }

    @Override
    public String getDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.district;
    }

    @Override
    public void setDistrict(String district) {
        this.setDistrict(district, true);
    }

    private void setDistrict(String district, boolean setDirty) {
        String oldDistrict = this.getDistrict();
        if (new EqualsBuilder().append(oldDistrict, district).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.DISTRICT.getPropertyName());
        }
        this.district = district;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.DISTRICT, district, oldDistrict);
    }

    @Override
    public String getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(String street) {
        this.setStreet(street, true);
    }

    private void setStreet(String street, boolean setDirty) {
        String oldStreet = this.getStreet();
        if (new EqualsBuilder().append(oldStreet, street).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.STREET, street, oldStreet);
    }

    @Override
    public String getHousenumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumber;
    }

    @Override
    public void setHousenumber(String housenumber) {
        this.setHousenumber(housenumber, true);
    }

    private void setHousenumber(String housenumber, boolean setDirty) {
        String oldHousenumber = this.getHousenumber();
        if (new EqualsBuilder().append(oldHousenumber, housenumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.HOUSENUMBER.getPropertyName());
        }
        this.housenumber = housenumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.HOUSENUMBER, housenumber, oldHousenumber);
    }

    @Override
    public String getHousenumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumberExtension;
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.setHousenumberExtension(housenumberExtension, true);
    }

    private void setHousenumberExtension(String housenumberExtension, boolean setDirty) {
        String oldHousenumberExtension = this.getHousenumberExtension();
        if (new EqualsBuilder().append(oldHousenumberExtension, housenumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.HOUSENUMBER_EXTENSION.getPropertyName());
        }
        this.housenumberExtension = housenumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.HOUSENUMBER_EXTENSION, housenumberExtension, oldHousenumberExtension);
    }

    @Override
    public ImmutablePoint getGeoLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geoLocation;
    }

    @Override
    public void setGeoLocation(ImmutablePoint geoLocation) {
        this.setGeoLocation(geoLocation, true);
    }

    private void setGeoLocation(ImmutablePoint geoLocation, boolean setDirty) {
        ImmutablePoint oldGeoLocation = this.getGeoLocation();
        if (new EqualsBuilder().append(oldGeoLocation, geoLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.GEO_LOCATION.getPropertyName());
        }
        this.geoLocation = geoLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.GEO_LOCATION, geoLocation, oldGeoLocation);
    }

    @Override
    public Date getMobileTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileTime;
    }

    @Override
    public void setMobileTime(Date mobileTime) {
        this.setMobileTime(mobileTime, true);
    }

    private void setMobileTime(Date mobileTime, boolean setDirty) {
        Date oldMobileTime = this.getMobileTime();
        if (new EqualsBuilder().append(oldMobileTime, mobileTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.MOBILE_TIME.getPropertyName());
        }
        this.mobileTime = mobileTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.MOBILE_TIME, mobileTime, oldMobileTime);
    }

    @Override
    public Date getSyncTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.syncTime;
    }

    @Override
    public void setSyncTime(Date syncTime) {
        this.setSyncTime(syncTime, true);
    }

    private void setSyncTime(Date syncTime, boolean setDirty) {
        Date oldSyncTime = this.getSyncTime();
        if (new EqualsBuilder().append(oldSyncTime, syncTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.SYNC_TIME.getPropertyName());
        }
        this.syncTime = syncTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.SYNC_TIME, syncTime, oldSyncTime);
    }

    @Override
    public StopModel getStop() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stop;
    }

    @Override
    public void setStop(StopModel stop) {
        this.setStop(stop, true);
    }

    private void setStop(StopModel stop, boolean setDirty) {
        StopModel oldStop = this.getStop();
        if (oldStop == stop) {
            return;
        }
        if (oldStop != null) {
            oldStop.removeLocationCapturing(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationCapturingModelEnum.STOP.getPropertyName());
        }
        this.stop = stop;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationCapturingModelEnum.STOP, stop, oldStop);
        if (this.stop != null) {
            this.stop.addLocationCapturing(this);
        }
    }

    @Override
    protected void updateByDto(LocationCapturingFullDto locationCapturingDto) {
        this.account = (AccountModel)this.getModelCache().getModel(locationCapturingDto.getAccount());
        this.country = locationCapturingDto.getCountry();
        this.postcode = locationCapturingDto.getPostcode();
        this.city = locationCapturingDto.getCity();
        this.district = locationCapturingDto.getDistrict();
        this.street = locationCapturingDto.getStreet();
        this.housenumber = locationCapturingDto.getHousenumber();
        this.housenumberExtension = locationCapturingDto.getHousenumberExtension();
        ImmutablePointDto geoLocation = locationCapturingDto.getGeoLocation();
        this.geoLocation = geoLocation == null ? null : (ImmutablePoint)geoLocation.getGeoObject();
        this.mobileTime = locationCapturingDto.getMobileTime();
        this.syncTime = locationCapturingDto.getSyncTime();
        this.stop = (StopModel)this.getModelCache().getModel(locationCapturingDto.getStop());
    }

    @Override
    protected void updateMasterRelationsByDto(LocationCapturingFullDto locationCapturingDto) {
    }

    @Override
    protected void checkStaleByDto(LocationCapturingFullDto locationCapturingDto) throws StaleStateException {
        StopModelImpl stopModel;
        StopDto stopDto;
        AccountModelImpl accountModel;
        AccountDto accountDto = locationCapturingDto.getAccount();
        if (accountDto != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
        if ((stopDto = locationCapturingDto.getStop()) != null && stopDto.getId() != null && (stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId())) != null) {
            stopModel.checkStaleState(stopDto);
        }
    }

    @Override
    public LocationCapturingFullDto createDto() {
        Long id = this.getId();
        LocationCapturingFullDto locationCapturingDto = id == null ? new LocationCapturingFullDto(this.getTempUUID()) : new LocationCapturingFullDto(id, this.getVersion());
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            locationCapturingDto.setAccount(account.createProxy());
        }
        locationCapturingDto.setCountry(this.getCountry());
        locationCapturingDto.setPostcode(this.getPostcode());
        locationCapturingDto.setCity(this.getCity());
        locationCapturingDto.setDistrict(this.getDistrict());
        locationCapturingDto.setStreet(this.getStreet());
        locationCapturingDto.setHousenumber(this.getHousenumber());
        locationCapturingDto.setHousenumberExtension(this.getHousenumberExtension());
        ImmutablePoint geoLocation = this.getGeoLocation();
        locationCapturingDto.setGeoLocation(ImmutablePointDto.create(geoLocation));
        locationCapturingDto.setMobileTime(this.getMobileTime());
        locationCapturingDto.setSyncTime(this.getSyncTime());
        StopModelImpl stop = (StopModelImpl)this.getStop();
        if (stop != null) {
            locationCapturingDto.setStop(stop.createProxy());
        }
        return locationCapturingDto;
    }

    @Override
    public LocationCapturingProxyDto createProxy() {
        Long id = this.getId();
        LocationCapturingProxyDto locationCapturingDto = id == null ? new LocationCapturingProxyDto(this.getTempUUID()) : new LocationCapturingProxyDto(id, this.getVersion());
        return locationCapturingDto;
    }

    public static enum LocationCapturingModelEnum {
        ACCOUNT("account"),
        COUNTRY("country"),
        POSTCODE("postcode"),
        CITY("city"),
        DISTRICT("district"),
        STREET("street"),
        HOUSENUMBER("housenumber"),
        HOUSENUMBER_EXTENSION("housenumberExtension"),
        GEO_LOCATION("geoLocation"),
        MOBILE_TIME("mobileTime"),
        SYNC_TIME("syncTime"),
        STOP("stop");

        private String propertyName;

        private LocationCapturingModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

