/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModelImpl;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.SegmentModelImpl;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetAliasModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationDto;
import de.datomino.peppergis.dto.map.SegmentDto;
import de.datomino.peppergis.dto.map.StreetAliasDto;
import de.datomino.peppergis.dto.map.StreetFullDto;
import de.datomino.peppergis.dto.map.StreetProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class StreetModelImpl
extends AbstractModel<StreetFullDto, StreetProxyDto>
implements StreetModel {
    private String name;
    private PostcodeDistrictRelationModel postcodeDistrictRelation;
    private Set<StreetAliasModel> alias = null;
    private Integer color_code;
    private Set<ParcelModel> parcels = null;
    private Set<SegmentModel> segments = null;

    public StreetModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public StreetModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetModelEnum.NAME, name, oldName);
    }

    @Override
    public PostcodeDistrictRelationModel getPostcodeDistrictRelation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcodeDistrictRelation;
    }

    @Override
    public void setPostcodeDistrictRelation(PostcodeDistrictRelationModel postcodeDistrictRelation) {
        this.setPostcodeDistrictRelation(postcodeDistrictRelation, true);
    }

    private void setPostcodeDistrictRelation(PostcodeDistrictRelationModel postcodeDistrictRelation, boolean setDirty) {
        PostcodeDistrictRelationModel oldPostcodeDistrictRelation = this.getPostcodeDistrictRelation();
        if (oldPostcodeDistrictRelation == postcodeDistrictRelation) {
            return;
        }
        if (oldPostcodeDistrictRelation != null) {
            oldPostcodeDistrictRelation.removeStreet(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetModelEnum.POSTCODE_DISTRICT_RELATION.getPropertyName());
        }
        this.postcodeDistrictRelation = postcodeDistrictRelation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetModelEnum.POSTCODE_DISTRICT_RELATION, postcodeDistrictRelation, oldPostcodeDistrictRelation);
        if (this.postcodeDistrictRelation != null) {
            this.postcodeDistrictRelation.addStreet(this);
        }
    }

    @Override
    public int countAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.size();
    }

    @Override
    public Iterator<StreetAliasModel> iterateAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return new ImmutableIterator<StreetAliasModel>(this.alias);
    }

    @Override
    public Iterable<StreetAliasModel> iterableAlias() {
        return new IteratorIterable<StreetAliasModel>(this.iterateAlias());
    }

    @Override
    public void addAlia(StreetAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (this.alias.contains(alia)) {
            return;
        }
        this.alias.add(alia);
        this.fireValueChanged(StreetModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setStreet(this);
        }
    }

    @Override
    public void removeAlia(StreetAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (!this.alias.contains(alia)) {
            return;
        }
        this.alias.remove(alia);
        this.fireValueChanged(StreetModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setStreet(null);
        }
    }

    @Override
    public void clearAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        ArrayList<StreetAliasModel> oldAlias = new ArrayList<StreetAliasModel>(this.alias);
        this.alias.clear();
        this.fireValueChanged(StreetModelEnum.ALIAS, null, null);
        for (StreetAliasModel oldAlia : oldAlias) {
            if (oldAlia == null) continue;
            oldAlia.setStreet(null);
        }
    }

    @Override
    public boolean isAliasEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.isEmpty();
    }

    @Override
    public boolean containsAlia(StreetAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<StreetAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.contains(alia);
    }

    @Override
    public boolean isAliasInitialized() {
        return this.alias != null;
    }

    @Override
    public Integer getColor_code() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.color_code;
    }

    @Override
    public void setColor_code(Integer color_code) {
        this.setColor_code(color_code, true);
    }

    private void setColor_code(Integer color_code, boolean setDirty) {
        Integer oldColor_code = this.getColor_code();
        if (new EqualsBuilder().append(oldColor_code, color_code).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetModelEnum.COLOR_CODE.getPropertyName());
        }
        this.color_code = color_code;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetModelEnum.COLOR_CODE, color_code, oldColor_code);
    }

    @Override
    public int countParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        return this.parcels.size();
    }

    @Override
    public Iterator<ParcelModel> iterateParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        return new ImmutableIterator<ParcelModel>(this.parcels);
    }

    @Override
    public Iterable<ParcelModel> iterableParcels() {
        return new IteratorIterable<ParcelModel>(this.iterateParcels());
    }

    @Override
    public void addParcel(ParcelModel parcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        if (this.parcels.contains(parcel)) {
            return;
        }
        this.parcels.add(parcel);
        this.fireValueChanged(StreetModelEnum.PARCELS, parcel, null);
        if (parcel != null) {
            parcel.setStreet(this);
        }
    }

    @Override
    public void removeParcel(ParcelModel parcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        if (!this.parcels.contains(parcel)) {
            return;
        }
        this.parcels.remove(parcel);
        this.fireValueChanged(StreetModelEnum.PARCELS, parcel, null);
        if (parcel != null) {
            parcel.setStreet(null);
        }
    }

    @Override
    public void clearParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        ArrayList<ParcelModel> oldParcels = new ArrayList<ParcelModel>(this.parcels);
        this.parcels.clear();
        this.fireValueChanged(StreetModelEnum.PARCELS, null, null);
        for (ParcelModel oldParcel : oldParcels) {
            if (oldParcel == null) continue;
            oldParcel.setStreet(null);
        }
    }

    @Override
    public boolean isParcelsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        return this.parcels.isEmpty();
    }

    @Override
    public boolean containsParcel(ParcelModel parcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcels == null) {
            this.parcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection parcelsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.PARCELS.getPropertyName());
                this.parcels.addAll(parcelsCollection);
            }
        }
        return this.parcels.contains(parcel);
    }

    @Override
    public boolean isParcelsInitialized() {
        return this.parcels != null;
    }

    @Override
    public int countSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.size();
    }

    @Override
    public Iterator<SegmentModel> iterateSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return new ImmutableIterator<SegmentModel>(this.segments);
    }

    @Override
    public Iterable<SegmentModel> iterableSegments() {
        return new IteratorIterable<SegmentModel>(this.iterateSegments());
    }

    @Override
    public void addSegment(SegmentModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        if (this.segments.contains(segment)) {
            return;
        }
        this.segments.add(segment);
        this.fireValueChanged(StreetModelEnum.SEGMENTS, segment, null);
        if (segment != null) {
            segment.setStreet(this);
        }
    }

    @Override
    public void removeSegment(SegmentModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        if (!this.segments.contains(segment)) {
            return;
        }
        this.segments.remove(segment);
        this.fireValueChanged(StreetModelEnum.SEGMENTS, segment, null);
        if (segment != null) {
            segment.setStreet(null);
        }
    }

    @Override
    public void clearSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        ArrayList<SegmentModel> oldSegments = new ArrayList<SegmentModel>(this.segments);
        this.segments.clear();
        this.fireValueChanged(StreetModelEnum.SEGMENTS, null, null);
        for (SegmentModel oldSegment : oldSegments) {
            if (oldSegment == null) continue;
            oldSegment.setStreet(null);
        }
    }

    @Override
    public boolean isSegmentsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.isEmpty();
    }

    @Override
    public boolean containsSegment(SegmentModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<SegmentModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, StreetModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.contains(segment);
    }

    @Override
    public boolean isSegmentsInitialized() {
        return this.segments != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.alias = null;
            this.parcels = null;
            this.segments = null;
        }
    }

    @Override
    protected void updateByDto(StreetFullDto streetDto) {
        SegmentDto[] segments;
        this.name = streetDto.getName();
        this.postcodeDistrictRelation = (PostcodeDistrictRelationModel)this.getModelCache().getModel(streetDto.getPostcodeDistrictRelation());
        StreetAliasDto[] alias = streetDto.getAlias();
        if (alias != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<StreetAliasModel>();
            } else {
                this.alias.clear();
            }
        }
        this.color_code = streetDto.getColor_code();
        ParcelDto[] parcels = streetDto.getParcels();
        if (parcels != null) {
            if (this.parcels == null) {
                this.parcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.parcels.clear();
            }
        }
        if ((segments = streetDto.getSegments()) != null) {
            if (this.segments == null) {
                this.segments = new LinkedHashSet<SegmentModel>();
            } else {
                this.segments.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(StreetFullDto streetDto) {
        SegmentDto[] segments;
        ParcelDto[] parcels;
        StreetAliasDto[] alias = streetDto.getAlias();
        if (alias != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<StreetAliasModel>();
            } else {
                this.alias.clear();
            }
            for (StreetAliasDto aliaDto : alias) {
                StreetAliasModel aliaModel = (StreetAliasModel)this.getModelCache().getModel(aliaDto);
                this.alias.add(aliaModel);
            }
        } else {
            this.alias = null;
        }
        if ((parcels = streetDto.getParcels()) != null) {
            if (this.parcels == null) {
                this.parcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.parcels.clear();
            }
            for (ParcelDto parcelDto : parcels) {
                ParcelModel parcelModel = (ParcelModel)this.getModelCache().getModel(parcelDto);
                this.parcels.add(parcelModel);
            }
        } else {
            this.parcels = null;
        }
        if ((segments = streetDto.getSegments()) != null) {
            if (this.segments == null) {
                this.segments = new LinkedHashSet<SegmentModel>();
            } else {
                this.segments.clear();
            }
            for (SegmentDto segmentDto : segments) {
                SegmentModel segmentModel = (SegmentModel)this.getModelCache().getModel(segmentDto);
                this.segments.add(segmentModel);
            }
        } else {
            this.segments = null;
        }
    }

    @Override
    protected void checkStaleByDto(StreetFullDto streetDto) throws StaleStateException {
        SegmentDto[] segmentDtos;
        ParcelDto[] parcelDtos;
        StreetAliasDto[] aliaDtos;
        PostcodeDistrictRelationModelImpl postcodeDistrictRelationModel;
        PostcodeDistrictRelationDto postcodeDistrictRelationDto = streetDto.getPostcodeDistrictRelation();
        if (postcodeDistrictRelationDto != null && postcodeDistrictRelationDto.getId() != null && (postcodeDistrictRelationModel = (PostcodeDistrictRelationModelImpl)this.getModelCache().getModel(PostcodeDistrictRelationModel.class, postcodeDistrictRelationDto.getId())) != null) {
            postcodeDistrictRelationModel.checkStaleState(postcodeDistrictRelationDto);
        }
        if ((aliaDtos = streetDto.getAlias()) != null) {
            for (StreetAliasDto aliaDto : aliaDtos) {
                StreetAliasModelImpl aliaModel = (StreetAliasModelImpl)this.getModelCache().getModel(StreetAliasModel.class, aliaDto.getId());
                if (aliaModel == null) continue;
                aliaModel.checkStaleState(aliaDto);
            }
        }
        if ((parcelDtos = streetDto.getParcels()) != null) {
            for (ParcelDto parcelDto : parcelDtos) {
                ParcelModelImpl parcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, parcelDto.getId());
                if (parcelModel == null) continue;
                parcelModel.checkStaleState(parcelDto);
            }
        }
        if ((segmentDtos = streetDto.getSegments()) != null) {
            for (SegmentDto segmentDto : segmentDtos) {
                SegmentModelImpl segmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, segmentDto.getId());
                if (segmentModel == null) continue;
                segmentModel.checkStaleState(segmentDto);
            }
        }
    }

    @Override
    public StreetFullDto createDto() {
        Long id = this.getId();
        StreetFullDto streetDto = id == null ? new StreetFullDto(this.getTempUUID()) : new StreetFullDto(id, this.getVersion());
        streetDto.setName(this.getName());
        PostcodeDistrictRelationModelImpl postcodeDistrictRelation = (PostcodeDistrictRelationModelImpl)this.getPostcodeDistrictRelation();
        if (postcodeDistrictRelation != null) {
            streetDto.setPostcodeDistrictRelation(postcodeDistrictRelation.createProxy());
        }
        streetDto.setColor_code(this.getColor_code());
        return streetDto;
    }

    @Override
    public StreetProxyDto createProxy() {
        Long id = this.getId();
        StreetProxyDto streetDto = id == null ? new StreetProxyDto(this.getTempUUID()) : new StreetProxyDto(id, this.getVersion());
        return streetDto;
    }

    public static enum StreetModelEnum {
        NAME("name"),
        POSTCODE_DISTRICT_RELATION("postcodeDistrictRelation"),
        ALIAS("alias"),
        COLOR_CODE("color_code"),
        PARCELS("parcels"),
        SEGMENTS("segments");

        private String propertyName;

        private StreetModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

