/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.map.StreetModelImpl;
import de.datomino.peppergis.dto.map.StreetAliasFullDto;
import de.datomino.peppergis.dto.map.StreetAliasProxyDto;
import de.datomino.peppergis.dto.map.StreetDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class StreetAliasModelImpl
extends AbstractModel<StreetAliasFullDto, StreetAliasProxyDto>
implements StreetAliasModel {
    private String name;
    private String search;
    private StreetModel street;

    public StreetAliasModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public StreetAliasModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetAliasModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetAliasModelEnum.NAME, name, oldName);
    }

    @Override
    public String getSearch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.search;
    }

    @Override
    public void setSearch(String search) {
        this.setSearch(search, true);
    }

    private void setSearch(String search, boolean setDirty) {
        String oldSearch = this.getSearch();
        if (new EqualsBuilder().append(oldSearch, search).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetAliasModelEnum.SEARCH.getPropertyName());
        }
        this.search = search;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetAliasModelEnum.SEARCH, search, oldSearch);
    }

    @Override
    public StreetModel getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(StreetModel street) {
        this.setStreet(street, true);
    }

    private void setStreet(StreetModel street, boolean setDirty) {
        StreetModel oldStreet = this.getStreet();
        if (oldStreet == street) {
            return;
        }
        if (oldStreet != null) {
            oldStreet.removeAlia(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StreetAliasModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StreetAliasModelEnum.STREET, street, oldStreet);
        if (this.street != null) {
            this.street.addAlia(this);
        }
    }

    @Override
    protected void updateByDto(StreetAliasFullDto streetAliasDto) {
        this.name = streetAliasDto.getName();
        this.search = streetAliasDto.getSearch();
        this.street = (StreetModel)this.getModelCache().getModel(streetAliasDto.getStreet());
    }

    @Override
    protected void updateMasterRelationsByDto(StreetAliasFullDto streetAliasDto) {
    }

    @Override
    protected void checkStaleByDto(StreetAliasFullDto streetAliasDto) throws StaleStateException {
        StreetModelImpl streetModel;
        StreetDto streetDto = streetAliasDto.getStreet();
        if (streetDto != null && streetDto.getId() != null && (streetModel = (StreetModelImpl)this.getModelCache().getModel(StreetModel.class, streetDto.getId())) != null) {
            streetModel.checkStaleState(streetDto);
        }
    }

    @Override
    public StreetAliasFullDto createDto() {
        Long id = this.getId();
        StreetAliasFullDto streetAliasDto = id == null ? new StreetAliasFullDto(this.getTempUUID()) : new StreetAliasFullDto(id, this.getVersion());
        streetAliasDto.setName(this.getName());
        streetAliasDto.setSearch(this.getSearch());
        StreetModelImpl street = (StreetModelImpl)this.getStreet();
        if (street != null) {
            streetAliasDto.setStreet(street.createProxy());
        }
        return streetAliasDto;
    }

    @Override
    public StreetAliasProxyDto createProxy() {
        Long id = this.getId();
        StreetAliasProxyDto streetAliasDto = id == null ? new StreetAliasProxyDto(this.getTempUUID()) : new StreetAliasProxyDto(id, this.getVersion());
        return streetAliasDto;
    }

    public static enum StreetAliasModelEnum {
        NAME("name"),
        SEARCH("search"),
        STREET("street");

        private String propertyName;

        private StreetAliasModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

