/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.map.SegmentAttributeModel;
import de.datomino.peppergis.client.model.map.SegmentAttributeModelImpl;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.map.StreetModelImpl;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.SegmentAttributeDto;
import de.datomino.peppergis.dto.map.SegmentFullDto;
import de.datomino.peppergis.dto.map.SegmentProxyDto;
import de.datomino.peppergis.dto.map.StreetDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class SegmentModelImpl
extends AbstractModel<SegmentFullDto, SegmentProxyDto>
implements SegmentModel {
    private ImmutableLineString geom;
    private SegmentType segmentType;
    private Set<SegmentAttributeModel> attributes = null;
    private StreetModel street;
    private Long idImportRef;
    private SegmentStatus segmentStatus;
    private Set<ParcelModel> footParcels = null;
    private Set<ParcelModel> motorParcels = null;
    private Set<ParcelModel> bikeParcels = null;
    private Set<LocationModel> footLocations = null;
    private Set<LocationModel> motorLocations = null;
    private Set<LocationModel> bikeLocations = null;

    public SegmentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SegmentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutableLineString getGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geom;
    }

    @Override
    public void setGeom(ImmutableLineString geom) {
        this.setGeom(geom, true);
    }

    private void setGeom(ImmutableLineString geom, boolean setDirty) {
        ImmutableLineString oldGeom = this.getGeom();
        if (new EqualsBuilder().append(oldGeom, geom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentModelEnum.GEOM.getPropertyName());
        }
        this.geom = geom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentModelEnum.GEOM, geom, oldGeom);
    }

    @Override
    public SegmentType getSegmentType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.segmentType;
    }

    @Override
    public void setSegmentType(SegmentType segmentType) {
        this.setSegmentType(segmentType, true);
    }

    private void setSegmentType(SegmentType segmentType, boolean setDirty) {
        SegmentType oldSegmentType = this.getSegmentType();
        if (new EqualsBuilder().append((Object)oldSegmentType, (Object)segmentType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentModelEnum.SEGMENT_TYPE.getPropertyName());
        }
        this.segmentType = segmentType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentModelEnum.SEGMENT_TYPE, (Object)segmentType, (Object)oldSegmentType);
    }

    @Override
    public int countAttributes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        return this.attributes.size();
    }

    @Override
    public Iterator<SegmentAttributeModel> iterateAttributes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        return new ImmutableIterator<SegmentAttributeModel>(this.attributes);
    }

    @Override
    public Iterable<SegmentAttributeModel> iterableAttributes() {
        return new IteratorIterable<SegmentAttributeModel>(this.iterateAttributes());
    }

    @Override
    public void addAttribute(SegmentAttributeModel attribute) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        if (this.attributes.contains(attribute)) {
            return;
        }
        this.attributes.add(attribute);
        this.fireValueChanged(SegmentModelEnum.ATTRIBUTES, attribute, null);
        if (attribute != null) {
            attribute.setSegment(this);
        }
    }

    @Override
    public void removeAttribute(SegmentAttributeModel attribute) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        if (!this.attributes.contains(attribute)) {
            return;
        }
        this.attributes.remove(attribute);
        this.fireValueChanged(SegmentModelEnum.ATTRIBUTES, attribute, null);
        if (attribute != null) {
            attribute.setSegment(null);
        }
    }

    @Override
    public void clearAttributes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        ArrayList<SegmentAttributeModel> oldAttributes = new ArrayList<SegmentAttributeModel>(this.attributes);
        this.attributes.clear();
        this.fireValueChanged(SegmentModelEnum.ATTRIBUTES, null, null);
        for (SegmentAttributeModel oldAttribute : oldAttributes) {
            if (oldAttribute == null) continue;
            oldAttribute.setSegment(null);
        }
    }

    @Override
    public boolean isAttributesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsAttribute(SegmentAttributeModel attribute) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            if (this.getId() != null) {
                Collection attributesCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.ATTRIBUTES.getPropertyName());
                this.attributes.addAll(attributesCollection);
            }
        }
        return this.attributes.contains(attribute);
    }

    @Override
    public boolean isAttributesInitialized() {
        return this.attributes != null;
    }

    @Override
    public StreetModel getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(StreetModel street) {
        this.setStreet(street, true);
    }

    private void setStreet(StreetModel street, boolean setDirty) {
        StreetModel oldStreet = this.getStreet();
        if (oldStreet == street) {
            return;
        }
        if (oldStreet != null) {
            oldStreet.removeSegment(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentModelEnum.STREET, street, oldStreet);
        if (this.street != null) {
            this.street.addSegment(this);
        }
    }

    @Override
    public Long getIdImportRef() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.idImportRef;
    }

    @Override
    public void setIdImportRef(Long idImportRef) {
        this.setIdImportRef(idImportRef, true);
    }

    private void setIdImportRef(Long idImportRef, boolean setDirty) {
        Long oldIdImportRef = this.getIdImportRef();
        if (new EqualsBuilder().append(oldIdImportRef, idImportRef).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentModelEnum.ID_IMPORT_REF.getPropertyName());
        }
        this.idImportRef = idImportRef;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentModelEnum.ID_IMPORT_REF, idImportRef, oldIdImportRef);
    }

    @Override
    public SegmentStatus getSegmentStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.segmentStatus;
    }

    @Override
    public void setSegmentStatus(SegmentStatus segmentStatus) {
        this.setSegmentStatus(segmentStatus, true);
    }

    private void setSegmentStatus(SegmentStatus segmentStatus, boolean setDirty) {
        SegmentStatus oldSegmentStatus = this.getSegmentStatus();
        if (new EqualsBuilder().append((Object)oldSegmentStatus, (Object)segmentStatus).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentModelEnum.SEGMENT_STATUS.getPropertyName());
        }
        this.segmentStatus = segmentStatus;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentModelEnum.SEGMENT_STATUS, (Object)segmentStatus, (Object)oldSegmentStatus);
    }

    @Override
    public int countFootParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        return this.footParcels.size();
    }

    @Override
    public Iterator<ParcelModel> iterateFootParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        return new ImmutableIterator<ParcelModel>(this.footParcels);
    }

    @Override
    public Iterable<ParcelModel> iterableFootParcels() {
        return new IteratorIterable<ParcelModel>(this.iterateFootParcels());
    }

    @Override
    public void addFootParcel(ParcelModel footParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        if (this.footParcels.contains(footParcel)) {
            return;
        }
        this.footParcels.add(footParcel);
        this.fireValueChanged(SegmentModelEnum.FOOT_PARCELS, footParcel, null);
        if (footParcel != null) {
            footParcel.setFootSegment(this);
        }
    }

    @Override
    public void removeFootParcel(ParcelModel footParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        if (!this.footParcels.contains(footParcel)) {
            return;
        }
        this.footParcels.remove(footParcel);
        this.fireValueChanged(SegmentModelEnum.FOOT_PARCELS, footParcel, null);
        if (footParcel != null) {
            footParcel.setFootSegment(null);
        }
    }

    @Override
    public void clearFootParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        ArrayList<ParcelModel> oldFootParcels = new ArrayList<ParcelModel>(this.footParcels);
        this.footParcels.clear();
        this.fireValueChanged(SegmentModelEnum.FOOT_PARCELS, null, null);
        for (ParcelModel oldFootParcel : oldFootParcels) {
            if (oldFootParcel == null) continue;
            oldFootParcel.setFootSegment(null);
        }
    }

    @Override
    public boolean isFootParcelsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        return this.footParcels.isEmpty();
    }

    @Override
    public boolean containsFootParcel(ParcelModel footParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footParcels == null) {
            this.footParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection footParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_PARCELS.getPropertyName());
                this.footParcels.addAll(footParcelsCollection);
            }
        }
        return this.footParcels.contains(footParcel);
    }

    @Override
    public boolean isFootParcelsInitialized() {
        return this.footParcels != null;
    }

    @Override
    public int countMotorParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        return this.motorParcels.size();
    }

    @Override
    public Iterator<ParcelModel> iterateMotorParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        return new ImmutableIterator<ParcelModel>(this.motorParcels);
    }

    @Override
    public Iterable<ParcelModel> iterableMotorParcels() {
        return new IteratorIterable<ParcelModel>(this.iterateMotorParcels());
    }

    @Override
    public void addMotorParcel(ParcelModel motorParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        if (this.motorParcels.contains(motorParcel)) {
            return;
        }
        this.motorParcels.add(motorParcel);
        this.fireValueChanged(SegmentModelEnum.MOTOR_PARCELS, motorParcel, null);
        if (motorParcel != null) {
            motorParcel.setMotorSegment(this);
        }
    }

    @Override
    public void removeMotorParcel(ParcelModel motorParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        if (!this.motorParcels.contains(motorParcel)) {
            return;
        }
        this.motorParcels.remove(motorParcel);
        this.fireValueChanged(SegmentModelEnum.MOTOR_PARCELS, motorParcel, null);
        if (motorParcel != null) {
            motorParcel.setMotorSegment(null);
        }
    }

    @Override
    public void clearMotorParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        ArrayList<ParcelModel> oldMotorParcels = new ArrayList<ParcelModel>(this.motorParcels);
        this.motorParcels.clear();
        this.fireValueChanged(SegmentModelEnum.MOTOR_PARCELS, null, null);
        for (ParcelModel oldMotorParcel : oldMotorParcels) {
            if (oldMotorParcel == null) continue;
            oldMotorParcel.setMotorSegment(null);
        }
    }

    @Override
    public boolean isMotorParcelsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        return this.motorParcels.isEmpty();
    }

    @Override
    public boolean containsMotorParcel(ParcelModel motorParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorParcels == null) {
            this.motorParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection motorParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_PARCELS.getPropertyName());
                this.motorParcels.addAll(motorParcelsCollection);
            }
        }
        return this.motorParcels.contains(motorParcel);
    }

    @Override
    public boolean isMotorParcelsInitialized() {
        return this.motorParcels != null;
    }

    @Override
    public int countBikeParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        return this.bikeParcels.size();
    }

    @Override
    public Iterator<ParcelModel> iterateBikeParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        return new ImmutableIterator<ParcelModel>(this.bikeParcels);
    }

    @Override
    public Iterable<ParcelModel> iterableBikeParcels() {
        return new IteratorIterable<ParcelModel>(this.iterateBikeParcels());
    }

    @Override
    public void addBikeParcel(ParcelModel bikeParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        if (this.bikeParcels.contains(bikeParcel)) {
            return;
        }
        this.bikeParcels.add(bikeParcel);
        this.fireValueChanged(SegmentModelEnum.BIKE_PARCELS, bikeParcel, null);
        if (bikeParcel != null) {
            bikeParcel.setBikeSegment(this);
        }
    }

    @Override
    public void removeBikeParcel(ParcelModel bikeParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        if (!this.bikeParcels.contains(bikeParcel)) {
            return;
        }
        this.bikeParcels.remove(bikeParcel);
        this.fireValueChanged(SegmentModelEnum.BIKE_PARCELS, bikeParcel, null);
        if (bikeParcel != null) {
            bikeParcel.setBikeSegment(null);
        }
    }

    @Override
    public void clearBikeParcels() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        ArrayList<ParcelModel> oldBikeParcels = new ArrayList<ParcelModel>(this.bikeParcels);
        this.bikeParcels.clear();
        this.fireValueChanged(SegmentModelEnum.BIKE_PARCELS, null, null);
        for (ParcelModel oldBikeParcel : oldBikeParcels) {
            if (oldBikeParcel == null) continue;
            oldBikeParcel.setBikeSegment(null);
        }
    }

    @Override
    public boolean isBikeParcelsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        return this.bikeParcels.isEmpty();
    }

    @Override
    public boolean containsBikeParcel(ParcelModel bikeParcel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeParcels == null) {
            this.bikeParcels = new LinkedHashSet<ParcelModel>();
            if (this.getId() != null) {
                Collection bikeParcelsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_PARCELS.getPropertyName());
                this.bikeParcels.addAll(bikeParcelsCollection);
            }
        }
        return this.bikeParcels.contains(bikeParcel);
    }

    @Override
    public boolean isBikeParcelsInitialized() {
        return this.bikeParcels != null;
    }

    @Override
    public int countFootLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        return this.footLocations.size();
    }

    @Override
    public Iterator<LocationModel> iterateFootLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.footLocations);
    }

    @Override
    public Iterable<LocationModel> iterableFootLocations() {
        return new IteratorIterable<LocationModel>(this.iterateFootLocations());
    }

    @Override
    public void addFootLocation(LocationModel footLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        if (this.footLocations.contains(footLocation)) {
            return;
        }
        this.footLocations.add(footLocation);
        this.fireValueChanged(SegmentModelEnum.FOOT_LOCATIONS, footLocation, null);
        if (footLocation != null) {
            footLocation.setFootSegment(this);
        }
    }

    @Override
    public void removeFootLocation(LocationModel footLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        if (!this.footLocations.contains(footLocation)) {
            return;
        }
        this.footLocations.remove(footLocation);
        this.fireValueChanged(SegmentModelEnum.FOOT_LOCATIONS, footLocation, null);
        if (footLocation != null) {
            footLocation.setFootSegment(null);
        }
    }

    @Override
    public void clearFootLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        ArrayList<LocationModel> oldFootLocations = new ArrayList<LocationModel>(this.footLocations);
        this.footLocations.clear();
        this.fireValueChanged(SegmentModelEnum.FOOT_LOCATIONS, null, null);
        for (LocationModel oldFootLocation : oldFootLocations) {
            if (oldFootLocation == null) continue;
            oldFootLocation.setFootSegment(null);
        }
    }

    @Override
    public boolean isFootLocationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        return this.footLocations.isEmpty();
    }

    @Override
    public boolean containsFootLocation(LocationModel footLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.footLocations == null) {
            this.footLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection footLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.FOOT_LOCATIONS.getPropertyName());
                this.footLocations.addAll(footLocationsCollection);
            }
        }
        return this.footLocations.contains(footLocation);
    }

    @Override
    public boolean isFootLocationsInitialized() {
        return this.footLocations != null;
    }

    @Override
    public int countMotorLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        return this.motorLocations.size();
    }

    @Override
    public Iterator<LocationModel> iterateMotorLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.motorLocations);
    }

    @Override
    public Iterable<LocationModel> iterableMotorLocations() {
        return new IteratorIterable<LocationModel>(this.iterateMotorLocations());
    }

    @Override
    public void addMotorLocation(LocationModel motorLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        if (this.motorLocations.contains(motorLocation)) {
            return;
        }
        this.motorLocations.add(motorLocation);
        this.fireValueChanged(SegmentModelEnum.MOTOR_LOCATIONS, motorLocation, null);
        if (motorLocation != null) {
            motorLocation.setMotorSegment(this);
        }
    }

    @Override
    public void removeMotorLocation(LocationModel motorLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        if (!this.motorLocations.contains(motorLocation)) {
            return;
        }
        this.motorLocations.remove(motorLocation);
        this.fireValueChanged(SegmentModelEnum.MOTOR_LOCATIONS, motorLocation, null);
        if (motorLocation != null) {
            motorLocation.setMotorSegment(null);
        }
    }

    @Override
    public void clearMotorLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        ArrayList<LocationModel> oldMotorLocations = new ArrayList<LocationModel>(this.motorLocations);
        this.motorLocations.clear();
        this.fireValueChanged(SegmentModelEnum.MOTOR_LOCATIONS, null, null);
        for (LocationModel oldMotorLocation : oldMotorLocations) {
            if (oldMotorLocation == null) continue;
            oldMotorLocation.setMotorSegment(null);
        }
    }

    @Override
    public boolean isMotorLocationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        return this.motorLocations.isEmpty();
    }

    @Override
    public boolean containsMotorLocation(LocationModel motorLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.motorLocations == null) {
            this.motorLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection motorLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.MOTOR_LOCATIONS.getPropertyName());
                this.motorLocations.addAll(motorLocationsCollection);
            }
        }
        return this.motorLocations.contains(motorLocation);
    }

    @Override
    public boolean isMotorLocationsInitialized() {
        return this.motorLocations != null;
    }

    @Override
    public int countBikeLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        return this.bikeLocations.size();
    }

    @Override
    public Iterator<LocationModel> iterateBikeLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.bikeLocations);
    }

    @Override
    public Iterable<LocationModel> iterableBikeLocations() {
        return new IteratorIterable<LocationModel>(this.iterateBikeLocations());
    }

    @Override
    public void addBikeLocation(LocationModel bikeLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        if (this.bikeLocations.contains(bikeLocation)) {
            return;
        }
        this.bikeLocations.add(bikeLocation);
        this.fireValueChanged(SegmentModelEnum.BIKE_LOCATIONS, bikeLocation, null);
        if (bikeLocation != null) {
            bikeLocation.setBikeSegment(this);
        }
    }

    @Override
    public void removeBikeLocation(LocationModel bikeLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        if (!this.bikeLocations.contains(bikeLocation)) {
            return;
        }
        this.bikeLocations.remove(bikeLocation);
        this.fireValueChanged(SegmentModelEnum.BIKE_LOCATIONS, bikeLocation, null);
        if (bikeLocation != null) {
            bikeLocation.setBikeSegment(null);
        }
    }

    @Override
    public void clearBikeLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        ArrayList<LocationModel> oldBikeLocations = new ArrayList<LocationModel>(this.bikeLocations);
        this.bikeLocations.clear();
        this.fireValueChanged(SegmentModelEnum.BIKE_LOCATIONS, null, null);
        for (LocationModel oldBikeLocation : oldBikeLocations) {
            if (oldBikeLocation == null) continue;
            oldBikeLocation.setBikeSegment(null);
        }
    }

    @Override
    public boolean isBikeLocationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        return this.bikeLocations.isEmpty();
    }

    @Override
    public boolean containsBikeLocation(LocationModel bikeLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.bikeLocations == null) {
            this.bikeLocations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection bikeLocationsCollection = this.commonCaller.fetchChildren(this, SegmentModelEnum.BIKE_LOCATIONS.getPropertyName());
                this.bikeLocations.addAll(bikeLocationsCollection);
            }
        }
        return this.bikeLocations.contains(bikeLocation);
    }

    @Override
    public boolean isBikeLocationsInitialized() {
        return this.bikeLocations != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.attributes = null;
            this.footParcels = null;
            this.motorParcels = null;
            this.bikeParcels = null;
            this.footLocations = null;
            this.motorLocations = null;
            this.bikeLocations = null;
        }
    }

    @Override
    protected void updateByDto(SegmentFullDto segmentDto) {
        LocationDto[] bikeLocations;
        LocationDto[] motorLocations;
        LocationDto[] footLocations;
        ParcelDto[] bikeParcels;
        ParcelDto[] motorParcels;
        ImmutableLineStringDto geom = segmentDto.getGeom();
        this.geom = geom == null ? null : (ImmutableLineString)geom.getGeoObject();
        this.segmentType = segmentDto.getSegmentType();
        SegmentAttributeDto[] attributes = segmentDto.getAttributes();
        if (attributes != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            } else {
                this.attributes.clear();
            }
        }
        this.street = (StreetModel)this.getModelCache().getModel(segmentDto.getStreet());
        this.idImportRef = segmentDto.getIdImportRef();
        this.segmentStatus = segmentDto.getSegmentStatus();
        ParcelDto[] footParcels = segmentDto.getFootParcels();
        if (footParcels != null) {
            if (this.footParcels == null) {
                this.footParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.footParcels.clear();
            }
        }
        if ((motorParcels = segmentDto.getMotorParcels()) != null) {
            if (this.motorParcels == null) {
                this.motorParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.motorParcels.clear();
            }
        }
        if ((bikeParcels = segmentDto.getBikeParcels()) != null) {
            if (this.bikeParcels == null) {
                this.bikeParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.bikeParcels.clear();
            }
        }
        if ((footLocations = segmentDto.getFootLocations()) != null) {
            if (this.footLocations == null) {
                this.footLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.footLocations.clear();
            }
        }
        if ((motorLocations = segmentDto.getMotorLocations()) != null) {
            if (this.motorLocations == null) {
                this.motorLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.motorLocations.clear();
            }
        }
        if ((bikeLocations = segmentDto.getBikeLocations()) != null) {
            if (this.bikeLocations == null) {
                this.bikeLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.bikeLocations.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(SegmentFullDto segmentDto) {
        LocationDto[] bikeLocations;
        LocationDto[] motorLocations;
        LocationDto[] footLocations;
        ParcelDto[] bikeParcels;
        ParcelDto[] motorParcels;
        ParcelDto[] footParcels;
        SegmentAttributeDto[] attributes = segmentDto.getAttributes();
        if (attributes != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashSet<SegmentAttributeModel>();
            } else {
                this.attributes.clear();
            }
            for (SegmentAttributeDto attributeDto : attributes) {
                SegmentAttributeModel attributeModel = (SegmentAttributeModel)this.getModelCache().getModel(attributeDto);
                this.attributes.add(attributeModel);
            }
        } else {
            this.attributes = null;
        }
        if ((footParcels = segmentDto.getFootParcels()) != null) {
            if (this.footParcels == null) {
                this.footParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.footParcels.clear();
            }
            for (ParcelDto footParcelDto : footParcels) {
                ParcelModel footParcelModel = (ParcelModel)this.getModelCache().getModel(footParcelDto);
                this.footParcels.add(footParcelModel);
            }
        } else {
            this.footParcels = null;
        }
        if ((motorParcels = segmentDto.getMotorParcels()) != null) {
            if (this.motorParcels == null) {
                this.motorParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.motorParcels.clear();
            }
            for (ParcelDto motorParcelDto : motorParcels) {
                ParcelModel motorParcelModel = (ParcelModel)this.getModelCache().getModel(motorParcelDto);
                this.motorParcels.add(motorParcelModel);
            }
        } else {
            this.motorParcels = null;
        }
        if ((bikeParcels = segmentDto.getBikeParcels()) != null) {
            if (this.bikeParcels == null) {
                this.bikeParcels = new LinkedHashSet<ParcelModel>();
            } else {
                this.bikeParcels.clear();
            }
            for (ParcelDto bikeParcelDto : bikeParcels) {
                ParcelModel bikeParcelModel = (ParcelModel)this.getModelCache().getModel(bikeParcelDto);
                this.bikeParcels.add(bikeParcelModel);
            }
        } else {
            this.bikeParcels = null;
        }
        if ((footLocations = segmentDto.getFootLocations()) != null) {
            if (this.footLocations == null) {
                this.footLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.footLocations.clear();
            }
            for (LocationDto footLocationDto : footLocations) {
                LocationModel footLocationModel = (LocationModel)this.getModelCache().getModel(footLocationDto);
                this.footLocations.add(footLocationModel);
            }
        } else {
            this.footLocations = null;
        }
        if ((motorLocations = segmentDto.getMotorLocations()) != null) {
            if (this.motorLocations == null) {
                this.motorLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.motorLocations.clear();
            }
            for (LocationDto motorLocationDto : motorLocations) {
                LocationModel motorLocationModel = (LocationModel)this.getModelCache().getModel(motorLocationDto);
                this.motorLocations.add(motorLocationModel);
            }
        } else {
            this.motorLocations = null;
        }
        if ((bikeLocations = segmentDto.getBikeLocations()) != null) {
            if (this.bikeLocations == null) {
                this.bikeLocations = new LinkedHashSet<LocationModel>();
            } else {
                this.bikeLocations.clear();
            }
            for (LocationDto bikeLocationDto : bikeLocations) {
                LocationModel bikeLocationModel = (LocationModel)this.getModelCache().getModel(bikeLocationDto);
                this.bikeLocations.add(bikeLocationModel);
            }
        } else {
            this.bikeLocations = null;
        }
    }

    @Override
    protected void checkStaleByDto(SegmentFullDto segmentDto) throws StaleStateException {
        LocationDto[] bikeLocationDtos;
        LocationDto[] motorLocationDtos;
        LocationDto[] footLocationDtos;
        ParcelDto[] bikeParcelDtos;
        ParcelDto[] motorParcelDtos;
        ParcelDto[] footParcelDtos;
        StreetModelImpl streetModel;
        StreetDto streetDto;
        SegmentAttributeDto[] attributeDtos = segmentDto.getAttributes();
        if (attributeDtos != null) {
            for (SegmentAttributeDto attributeDto : attributeDtos) {
                SegmentAttributeModelImpl attributeModel = (SegmentAttributeModelImpl)this.getModelCache().getModel(SegmentAttributeModel.class, attributeDto.getId());
                if (attributeModel == null) continue;
                attributeModel.checkStaleState(attributeDto);
            }
        }
        if ((streetDto = segmentDto.getStreet()) != null && streetDto.getId() != null && (streetModel = (StreetModelImpl)this.getModelCache().getModel(StreetModel.class, streetDto.getId())) != null) {
            streetModel.checkStaleState(streetDto);
        }
        if ((footParcelDtos = segmentDto.getFootParcels()) != null) {
            for (ParcelDto footParcelDto : footParcelDtos) {
                ParcelModelImpl footParcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, footParcelDto.getId());
                if (footParcelModel == null) continue;
                footParcelModel.checkStaleState(footParcelDto);
            }
        }
        if ((motorParcelDtos = segmentDto.getMotorParcels()) != null) {
            for (ParcelDto motorParcelDto : motorParcelDtos) {
                ParcelModelImpl motorParcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, motorParcelDto.getId());
                if (motorParcelModel == null) continue;
                motorParcelModel.checkStaleState(motorParcelDto);
            }
        }
        if ((bikeParcelDtos = segmentDto.getBikeParcels()) != null) {
            for (ParcelDto bikeParcelDto : bikeParcelDtos) {
                ParcelModelImpl bikeParcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, bikeParcelDto.getId());
                if (bikeParcelModel == null) continue;
                bikeParcelModel.checkStaleState(bikeParcelDto);
            }
        }
        if ((footLocationDtos = segmentDto.getFootLocations()) != null) {
            for (LocationDto footLocationDto : footLocationDtos) {
                LocationModelImpl footLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, footLocationDto.getId());
                if (footLocationModel == null) continue;
                footLocationModel.checkStaleState(footLocationDto);
            }
        }
        if ((motorLocationDtos = segmentDto.getMotorLocations()) != null) {
            for (LocationDto motorLocationDto : motorLocationDtos) {
                LocationModelImpl motorLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, motorLocationDto.getId());
                if (motorLocationModel == null) continue;
                motorLocationModel.checkStaleState(motorLocationDto);
            }
        }
        if ((bikeLocationDtos = segmentDto.getBikeLocations()) != null) {
            for (LocationDto bikeLocationDto : bikeLocationDtos) {
                LocationModelImpl bikeLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, bikeLocationDto.getId());
                if (bikeLocationModel == null) continue;
                bikeLocationModel.checkStaleState(bikeLocationDto);
            }
        }
    }

    @Override
    public SegmentFullDto createDto() {
        Long id = this.getId();
        SegmentFullDto segmentDto = id == null ? new SegmentFullDto(this.getTempUUID()) : new SegmentFullDto(id, this.getVersion());
        ImmutableLineString geom = this.getGeom();
        segmentDto.setGeom(ImmutableLineStringDto.create(geom));
        segmentDto.setSegmentType(this.getSegmentType());
        StreetModelImpl street = (StreetModelImpl)this.getStreet();
        if (street != null) {
            segmentDto.setStreet(street.createProxy());
        }
        segmentDto.setIdImportRef(this.getIdImportRef());
        segmentDto.setSegmentStatus(this.getSegmentStatus());
        return segmentDto;
    }

    @Override
    public SegmentProxyDto createProxy() {
        Long id = this.getId();
        SegmentProxyDto segmentDto = id == null ? new SegmentProxyDto(this.getTempUUID()) : new SegmentProxyDto(id, this.getVersion());
        return segmentDto;
    }

    public static enum SegmentModelEnum {
        GEOM("geom"),
        SEGMENT_TYPE("segmentType"),
        ATTRIBUTES("attributes"),
        STREET("street"),
        ID_IMPORT_REF("idImportRef"),
        SEGMENT_STATUS("segmentStatus"),
        FOOT_PARCELS("footParcels"),
        MOTOR_PARCELS("motorParcels"),
        BIKE_PARCELS("bikeParcels"),
        FOOT_LOCATIONS("footLocations"),
        MOTOR_LOCATIONS("motorLocations"),
        BIKE_LOCATIONS("bikeLocations");

        private String propertyName;

        private SegmentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

