/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.SegmentAttributeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.SegmentModelImpl;
import de.datomino.peppergis.dto.map.SegmentAttributeFullDto;
import de.datomino.peppergis.dto.map.SegmentAttributeProxyDto;
import de.datomino.peppergis.dto.map.SegmentDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SegmentAttributeModelImpl
extends AbstractModel<SegmentAttributeFullDto, SegmentAttributeProxyDto>
implements SegmentAttributeModel {
    private String key;
    private String value;
    private SegmentModel segment;

    public SegmentAttributeModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SegmentAttributeModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.setKey(key, true);
    }

    private void setKey(String key, boolean setDirty) {
        String oldKey = this.getKey();
        if (new EqualsBuilder().append(oldKey, key).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentAttributeModelEnum.KEY.getPropertyName());
        }
        this.key = key;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentAttributeModelEnum.KEY, key, oldKey);
    }

    @Override
    public String getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, true);
    }

    private void setValue(String value, boolean setDirty) {
        String oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentAttributeModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentAttributeModelEnum.VALUE, value, oldValue);
    }

    @Override
    public SegmentModel getSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.segment;
    }

    @Override
    public void setSegment(SegmentModel segment) {
        this.setSegment(segment, true);
    }

    private void setSegment(SegmentModel segment, boolean setDirty) {
        SegmentModel oldSegment = this.getSegment();
        if (oldSegment == segment) {
            return;
        }
        if (oldSegment != null) {
            oldSegment.removeAttribute(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SegmentAttributeModelEnum.SEGMENT.getPropertyName());
        }
        this.segment = segment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SegmentAttributeModelEnum.SEGMENT, segment, oldSegment);
        if (this.segment != null) {
            this.segment.addAttribute(this);
        }
    }

    @Override
    protected void updateByDto(SegmentAttributeFullDto segmentAttributeDto) {
        this.key = segmentAttributeDto.getKey();
        this.value = segmentAttributeDto.getValue();
        this.segment = (SegmentModel)this.getModelCache().getModel(segmentAttributeDto.getSegment());
    }

    @Override
    protected void updateMasterRelationsByDto(SegmentAttributeFullDto segmentAttributeDto) {
    }

    @Override
    protected void checkStaleByDto(SegmentAttributeFullDto segmentAttributeDto) throws StaleStateException {
        SegmentModelImpl segmentModel;
        SegmentDto segmentDto = segmentAttributeDto.getSegment();
        if (segmentDto != null && segmentDto.getId() != null && (segmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, segmentDto.getId())) != null) {
            segmentModel.checkStaleState(segmentDto);
        }
    }

    @Override
    public SegmentAttributeFullDto createDto() {
        Long id = this.getId();
        SegmentAttributeFullDto segmentAttributeDto = id == null ? new SegmentAttributeFullDto(this.getTempUUID()) : new SegmentAttributeFullDto(id, this.getVersion());
        segmentAttributeDto.setKey(this.getKey());
        segmentAttributeDto.setValue(this.getValue());
        SegmentModelImpl segment = (SegmentModelImpl)this.getSegment();
        if (segment != null) {
            segmentAttributeDto.setSegment(segment.createProxy());
        }
        return segmentAttributeDto;
    }

    @Override
    public SegmentAttributeProxyDto createProxy() {
        Long id = this.getId();
        SegmentAttributeProxyDto segmentAttributeDto = id == null ? new SegmentAttributeProxyDto(this.getTempUUID()) : new SegmentAttributeProxyDto(id, this.getVersion());
        return segmentAttributeDto;
    }

    public static enum SegmentAttributeModelEnum {
        KEY("key"),
        VALUE("value"),
        SEGMENT("segment");

        private String propertyName;

        private SegmentAttributeModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

