/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModelImpl;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationDto;
import de.datomino.peppergis.dto.map.PostcodeFullDto;
import de.datomino.peppergis.dto.map.PostcodeProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import de.datomino.util.international.country.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class PostcodeModelImpl
extends AbstractModel<PostcodeFullDto, PostcodeProxyDto>
implements PostcodeModel {
    private String name;
    private Set<PostcodeDistrictRelationModel> districts = null;
    private ImmutablePolygonKind geom;
    private Country country;

    public PostcodeModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PostcodeModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PostcodeModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PostcodeModelEnum.NAME, name, oldName);
    }

    @Override
    public int countDistricts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        return this.districts.size();
    }

    @Override
    public Iterator<PostcodeDistrictRelationModel> iterateDistricts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        return new ImmutableIterator<PostcodeDistrictRelationModel>(this.districts);
    }

    @Override
    public Iterable<PostcodeDistrictRelationModel> iterableDistricts() {
        return new IteratorIterable<PostcodeDistrictRelationModel>(this.iterateDistricts());
    }

    @Override
    public void addDistrict(PostcodeDistrictRelationModel district) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        if (this.districts.contains(district)) {
            return;
        }
        this.districts.add(district);
        this.fireValueChanged(PostcodeModelEnum.DISTRICTS, district, null);
        if (district != null) {
            district.setPostcode(this);
        }
    }

    @Override
    public void removeDistrict(PostcodeDistrictRelationModel district) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        if (!this.districts.contains(district)) {
            return;
        }
        this.districts.remove(district);
        this.fireValueChanged(PostcodeModelEnum.DISTRICTS, district, null);
        if (district != null) {
            district.setPostcode(null);
        }
    }

    @Override
    public void clearDistricts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        ArrayList<PostcodeDistrictRelationModel> oldDistricts = new ArrayList<PostcodeDistrictRelationModel>(this.districts);
        this.districts.clear();
        this.fireValueChanged(PostcodeModelEnum.DISTRICTS, null, null);
        for (PostcodeDistrictRelationModel oldDistrict : oldDistricts) {
            if (oldDistrict == null) continue;
            oldDistrict.setPostcode(null);
        }
    }

    @Override
    public boolean isDistrictsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        return this.districts.isEmpty();
    }

    @Override
    public boolean containsDistrict(PostcodeDistrictRelationModel district) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.districts == null) {
            this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection districtsCollection = this.commonCaller.fetchChildren(this, PostcodeModelEnum.DISTRICTS.getPropertyName());
                this.districts.addAll(districtsCollection);
            }
        }
        return this.districts.contains(district);
    }

    @Override
    public boolean isDistrictsInitialized() {
        return this.districts != null;
    }

    @Override
    public ImmutablePolygonKind getGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geom;
    }

    @Override
    public void setGeom(ImmutablePolygonKind geom) {
        this.setGeom(geom, true);
    }

    private void setGeom(ImmutablePolygonKind geom, boolean setDirty) {
        ImmutablePolygonKind oldGeom = this.getGeom();
        if (new EqualsBuilder().append(oldGeom, geom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PostcodeModelEnum.GEOM.getPropertyName());
        }
        this.geom = geom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PostcodeModelEnum.GEOM, geom, oldGeom);
    }

    @Override
    public Country getCountry() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.setCountry(country, true);
    }

    private void setCountry(Country country, boolean setDirty) {
        Country oldCountry = this.getCountry();
        if (new EqualsBuilder().append(oldCountry, country).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PostcodeModelEnum.COUNTRY.getPropertyName());
        }
        this.country = country;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PostcodeModelEnum.COUNTRY, country, oldCountry);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.districts = null;
        }
    }

    @Override
    protected void updateByDto(PostcodeFullDto postcodeDto) {
        ImmutablePolygonKindDto geom;
        this.name = postcodeDto.getName();
        PostcodeDistrictRelationDto[] districts = postcodeDto.getDistricts();
        if (districts != null) {
            if (this.districts == null) {
                this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            } else {
                this.districts.clear();
            }
        }
        this.geom = (geom = postcodeDto.getGeom()) == null ? null : (ImmutablePolygonKind)geom.getGeoObject();
        this.country = postcodeDto.getCountry();
    }

    @Override
    protected void updateMasterRelationsByDto(PostcodeFullDto postcodeDto) {
        PostcodeDistrictRelationDto[] districts = postcodeDto.getDistricts();
        if (districts != null) {
            if (this.districts == null) {
                this.districts = new LinkedHashSet<PostcodeDistrictRelationModel>();
            } else {
                this.districts.clear();
            }
            for (PostcodeDistrictRelationDto districtDto : districts) {
                PostcodeDistrictRelationModel districtModel = (PostcodeDistrictRelationModel)this.getModelCache().getModel(districtDto);
                this.districts.add(districtModel);
            }
        } else {
            this.districts = null;
        }
    }

    @Override
    protected void checkStaleByDto(PostcodeFullDto postcodeDto) throws StaleStateException {
        PostcodeDistrictRelationDto[] districtDtos = postcodeDto.getDistricts();
        if (districtDtos != null) {
            for (PostcodeDistrictRelationDto districtDto : districtDtos) {
                PostcodeDistrictRelationModelImpl districtModel = (PostcodeDistrictRelationModelImpl)this.getModelCache().getModel(PostcodeDistrictRelationModel.class, districtDto.getId());
                if (districtModel == null) continue;
                districtModel.checkStaleState(districtDto);
            }
        }
    }

    @Override
    public PostcodeFullDto createDto() {
        Long id = this.getId();
        PostcodeFullDto postcodeDto = id == null ? new PostcodeFullDto(this.getTempUUID()) : new PostcodeFullDto(id, this.getVersion());
        postcodeDto.setName(this.getName());
        ImmutablePolygonKind geom = this.getGeom();
        postcodeDto.setGeom(ImmutablePolygonKindDto.create(geom));
        postcodeDto.setCountry(this.getCountry());
        return postcodeDto;
    }

    @Override
    public PostcodeProxyDto createProxy() {
        Long id = this.getId();
        PostcodeProxyDto postcodeDto = id == null ? new PostcodeProxyDto(this.getTempUUID()) : new PostcodeProxyDto(id, this.getVersion());
        return postcodeDto;
    }

    public static enum PostcodeModelEnum {
        NAME("name"),
        DISTRICTS("districts"),
        GEOM("geom"),
        COUNTRY("country");

        private String propertyName;

        private PostcodeModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

