/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.DistrictModelImpl;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.PostcodeModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.map.StreetModelImpl;
import de.datomino.peppergis.dto.map.DistrictDto;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationFullDto;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationProxyDto;
import de.datomino.peppergis.dto.map.PostcodeDto;
import de.datomino.peppergis.dto.map.StreetDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class PostcodeDistrictRelationModelImpl
extends AbstractModel<PostcodeDistrictRelationFullDto, PostcodeDistrictRelationProxyDto>
implements PostcodeDistrictRelationModel {
    private PostcodeModel postcode;
    private DistrictModel district;
    private Set<StreetModel> streets = null;

    public PostcodeDistrictRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PostcodeDistrictRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public PostcodeModel getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(PostcodeModel postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(PostcodeModel postcode, boolean setDirty) {
        PostcodeModel oldPostcode = this.getPostcode();
        if (oldPostcode == postcode) {
            return;
        }
        if (oldPostcode != null) {
            oldPostcode.removeDistrict(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PostcodeDistrictRelationModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PostcodeDistrictRelationModelEnum.POSTCODE, postcode, oldPostcode);
        if (this.postcode != null) {
            this.postcode.addDistrict(this);
        }
    }

    @Override
    public DistrictModel getDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.district;
    }

    @Override
    public void setDistrict(DistrictModel district) {
        this.setDistrict(district, true);
    }

    private void setDistrict(DistrictModel district, boolean setDirty) {
        DistrictModel oldDistrict = this.getDistrict();
        if (oldDistrict == district) {
            return;
        }
        if (oldDistrict != null) {
            oldDistrict.removePostcode(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PostcodeDistrictRelationModelEnum.DISTRICT.getPropertyName());
        }
        this.district = district;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PostcodeDistrictRelationModelEnum.DISTRICT, district, oldDistrict);
        if (this.district != null) {
            this.district.addPostcode(this);
        }
    }

    @Override
    public int countStreets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        return this.streets.size();
    }

    @Override
    public Iterator<StreetModel> iterateStreets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        return new ImmutableIterator<StreetModel>(this.streets);
    }

    @Override
    public Iterable<StreetModel> iterableStreets() {
        return new IteratorIterable<StreetModel>(this.iterateStreets());
    }

    @Override
    public void addStreet(StreetModel street) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        if (this.streets.contains(street)) {
            return;
        }
        this.streets.add(street);
        this.fireValueChanged(PostcodeDistrictRelationModelEnum.STREETS, street, null);
        if (street != null) {
            street.setPostcodeDistrictRelation(this);
        }
    }

    @Override
    public void removeStreet(StreetModel street) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        if (!this.streets.contains(street)) {
            return;
        }
        this.streets.remove(street);
        this.fireValueChanged(PostcodeDistrictRelationModelEnum.STREETS, street, null);
        if (street != null) {
            street.setPostcodeDistrictRelation(null);
        }
    }

    @Override
    public void clearStreets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        ArrayList<StreetModel> oldStreets = new ArrayList<StreetModel>(this.streets);
        this.streets.clear();
        this.fireValueChanged(PostcodeDistrictRelationModelEnum.STREETS, null, null);
        for (StreetModel oldStreet : oldStreets) {
            if (oldStreet == null) continue;
            oldStreet.setPostcodeDistrictRelation(null);
        }
    }

    @Override
    public boolean isStreetsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        return this.streets.isEmpty();
    }

    @Override
    public boolean containsStreet(StreetModel street) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.streets == null) {
            this.streets = new LinkedHashSet<StreetModel>();
            if (this.getId() != null) {
                Collection streetsCollection = this.commonCaller.fetchChildren(this, PostcodeDistrictRelationModelEnum.STREETS.getPropertyName());
                this.streets.addAll(streetsCollection);
            }
        }
        return this.streets.contains(street);
    }

    @Override
    public boolean isStreetsInitialized() {
        return this.streets != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.streets = null;
        }
    }

    @Override
    protected void updateByDto(PostcodeDistrictRelationFullDto postcodeDistrictRelationDto) {
        this.postcode = (PostcodeModel)this.getModelCache().getModel(postcodeDistrictRelationDto.getPostcode());
        this.district = (DistrictModel)this.getModelCache().getModel(postcodeDistrictRelationDto.getDistrict());
        StreetDto[] streets = postcodeDistrictRelationDto.getStreets();
        if (streets != null) {
            if (this.streets == null) {
                this.streets = new LinkedHashSet<StreetModel>();
            } else {
                this.streets.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(PostcodeDistrictRelationFullDto postcodeDistrictRelationDto) {
        StreetDto[] streets = postcodeDistrictRelationDto.getStreets();
        if (streets != null) {
            if (this.streets == null) {
                this.streets = new LinkedHashSet<StreetModel>();
            } else {
                this.streets.clear();
            }
            for (StreetDto streetDto : streets) {
                StreetModel streetModel = (StreetModel)this.getModelCache().getModel(streetDto);
                this.streets.add(streetModel);
            }
        } else {
            this.streets = null;
        }
    }

    @Override
    protected void checkStaleByDto(PostcodeDistrictRelationFullDto postcodeDistrictRelationDto) throws StaleStateException {
        StreetDto[] streetDtos;
        DistrictModelImpl districtModel;
        DistrictDto districtDto;
        PostcodeModelImpl postcodeModel;
        PostcodeDto postcodeDto = postcodeDistrictRelationDto.getPostcode();
        if (postcodeDto != null && postcodeDto.getId() != null && (postcodeModel = (PostcodeModelImpl)this.getModelCache().getModel(PostcodeModel.class, postcodeDto.getId())) != null) {
            postcodeModel.checkStaleState(postcodeDto);
        }
        if ((districtDto = postcodeDistrictRelationDto.getDistrict()) != null && districtDto.getId() != null && (districtModel = (DistrictModelImpl)this.getModelCache().getModel(DistrictModel.class, districtDto.getId())) != null) {
            districtModel.checkStaleState(districtDto);
        }
        if ((streetDtos = postcodeDistrictRelationDto.getStreets()) != null) {
            for (StreetDto streetDto : streetDtos) {
                StreetModelImpl streetModel = (StreetModelImpl)this.getModelCache().getModel(StreetModel.class, streetDto.getId());
                if (streetModel == null) continue;
                streetModel.checkStaleState(streetDto);
            }
        }
    }

    @Override
    public PostcodeDistrictRelationFullDto createDto() {
        DistrictModelImpl district;
        Long id = this.getId();
        PostcodeDistrictRelationFullDto postcodeDistrictRelationDto = id == null ? new PostcodeDistrictRelationFullDto(this.getTempUUID()) : new PostcodeDistrictRelationFullDto(id, this.getVersion());
        PostcodeModelImpl postcode = (PostcodeModelImpl)this.getPostcode();
        if (postcode != null) {
            postcodeDistrictRelationDto.setPostcode(postcode.createProxy());
        }
        if ((district = (DistrictModelImpl)this.getDistrict()) != null) {
            postcodeDistrictRelationDto.setDistrict(district.createProxy());
        }
        return postcodeDistrictRelationDto;
    }

    @Override
    public PostcodeDistrictRelationProxyDto createProxy() {
        Long id = this.getId();
        PostcodeDistrictRelationProxyDto postcodeDistrictRelationDto = id == null ? new PostcodeDistrictRelationProxyDto(this.getTempUUID()) : new PostcodeDistrictRelationProxyDto(id, this.getVersion());
        return postcodeDistrictRelationDto;
    }

    public static enum PostcodeDistrictRelationModelEnum {
        POSTCODE("postcode"),
        DISTRICT("district"),
        STREETS("streets");

        private String propertyName;

        private PostcodeDistrictRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

