/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.SegmentModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.map.StreetModelImpl;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.area.AreaObjectParcelRelDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.map.ParcelAttributeValueDto;
import de.datomino.peppergis.dto.map.ParcelFullDto;
import de.datomino.peppergis.dto.map.ParcelProxyDto;
import de.datomino.peppergis.dto.map.SegmentDto;
import de.datomino.peppergis.dto.map.StreetDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ImportAddress;
import de.datomino.peppergis.type.ImportParcelProcess;
import de.datomino.peppergis.type.ImportParcelStatus;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ParcelModelImpl
extends AbstractModel<ParcelFullDto, ParcelProxyDto>
implements ParcelModel {
    private String houseNumber;
    private String houseNumberExtension;
    private StreetModel street;
    private SegmentModel footSegment;
    private SegmentModel motorSegment;
    private SegmentModel bikeSegment;
    private ImmutablePoint geom;
    private Set<AreaObjectParcelRelModel> areaObjectParcelRel = null;
    private Set<ParcelAttributeValueModel> parcelAttributeValues = null;
    private Boolean manualFootSegmentUpdate;
    private Boolean manualMotorSegmentUpdate;
    private Boolean manualBikeSegmentUpdate;
    private String importKey;
    private ImportAddress importAddress;
    private ImportParcelStatus importStatus;
    private ImportParcelProcess importProcess;
    private ImmutablePoint oldGeom;
    private UserModel editorUser;
    private UserModel loginUser;
    private Set<LocationModel> locations = null;

    public ParcelModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ParcelModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getHouseNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.houseNumber;
    }

    @Override
    public void setHouseNumber(String houseNumber) {
        this.setHouseNumber(houseNumber, true);
    }

    private void setHouseNumber(String houseNumber, boolean setDirty) {
        String oldHouseNumber = this.getHouseNumber();
        if (new EqualsBuilder().append(oldHouseNumber, houseNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.HOUSE_NUMBER.getPropertyName());
        }
        this.houseNumber = houseNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.HOUSE_NUMBER, houseNumber, oldHouseNumber);
    }

    @Override
    public String getHouseNumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.houseNumberExtension;
    }

    @Override
    public void setHouseNumberExtension(String houseNumberExtension) {
        this.setHouseNumberExtension(houseNumberExtension, true);
    }

    private void setHouseNumberExtension(String houseNumberExtension, boolean setDirty) {
        String oldHouseNumberExtension = this.getHouseNumberExtension();
        if (new EqualsBuilder().append(oldHouseNumberExtension, houseNumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.HOUSE_NUMBER_EXTENSION.getPropertyName());
        }
        this.houseNumberExtension = houseNumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.HOUSE_NUMBER_EXTENSION, houseNumberExtension, oldHouseNumberExtension);
    }

    @Override
    public StreetModel getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(StreetModel street) {
        this.setStreet(street, true);
    }

    private void setStreet(StreetModel street, boolean setDirty) {
        StreetModel oldStreet = this.getStreet();
        if (oldStreet == street) {
            return;
        }
        if (oldStreet != null) {
            oldStreet.removeParcel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.STREET, street, oldStreet);
        if (this.street != null) {
            this.street.addParcel(this);
        }
    }

    @Override
    public SegmentModel getFootSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.footSegment;
    }

    @Override
    public void setFootSegment(SegmentModel footSegment) {
        this.setFootSegment(footSegment, true);
    }

    private void setFootSegment(SegmentModel footSegment, boolean setDirty) {
        SegmentModel oldFootSegment = this.getFootSegment();
        if (oldFootSegment == footSegment) {
            return;
        }
        if (oldFootSegment != null) {
            oldFootSegment.removeFootParcel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.FOOT_SEGMENT.getPropertyName());
        }
        this.footSegment = footSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.FOOT_SEGMENT, footSegment, oldFootSegment);
        if (this.footSegment != null) {
            this.footSegment.addFootParcel(this);
        }
    }

    @Override
    public SegmentModel getMotorSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.motorSegment;
    }

    @Override
    public void setMotorSegment(SegmentModel motorSegment) {
        this.setMotorSegment(motorSegment, true);
    }

    private void setMotorSegment(SegmentModel motorSegment, boolean setDirty) {
        SegmentModel oldMotorSegment = this.getMotorSegment();
        if (oldMotorSegment == motorSegment) {
            return;
        }
        if (oldMotorSegment != null) {
            oldMotorSegment.removeMotorParcel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.MOTOR_SEGMENT.getPropertyName());
        }
        this.motorSegment = motorSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.MOTOR_SEGMENT, motorSegment, oldMotorSegment);
        if (this.motorSegment != null) {
            this.motorSegment.addMotorParcel(this);
        }
    }

    @Override
    public SegmentModel getBikeSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.bikeSegment;
    }

    @Override
    public void setBikeSegment(SegmentModel bikeSegment) {
        this.setBikeSegment(bikeSegment, true);
    }

    private void setBikeSegment(SegmentModel bikeSegment, boolean setDirty) {
        SegmentModel oldBikeSegment = this.getBikeSegment();
        if (oldBikeSegment == bikeSegment) {
            return;
        }
        if (oldBikeSegment != null) {
            oldBikeSegment.removeBikeParcel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.BIKE_SEGMENT.getPropertyName());
        }
        this.bikeSegment = bikeSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.BIKE_SEGMENT, bikeSegment, oldBikeSegment);
        if (this.bikeSegment != null) {
            this.bikeSegment.addBikeParcel(this);
        }
    }

    @Override
    public ImmutablePoint getGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geom;
    }

    @Override
    public void setGeom(ImmutablePoint geom) {
        this.setGeom(geom, true);
    }

    private void setGeom(ImmutablePoint geom, boolean setDirty) {
        ImmutablePoint oldGeom = this.getGeom();
        if (new EqualsBuilder().append(oldGeom, geom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.GEOM.getPropertyName());
        }
        this.geom = geom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.GEOM, geom, oldGeom);
    }

    @Override
    public int countAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.size();
    }

    @Override
    public Iterator<AreaObjectParcelRelModel> iterateAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return new ImmutableIterator<AreaObjectParcelRelModel>(this.areaObjectParcelRel);
    }

    @Override
    public Iterable<AreaObjectParcelRelModel> iterableAreaObjectParcelRel() {
        return new IteratorIterable<AreaObjectParcelRelModel>(this.iterateAreaObjectParcelRel());
    }

    @Override
    public void addAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        if (this.areaObjectParcelRel.contains(aAreaObjectParcelRel)) {
            return;
        }
        this.areaObjectParcelRel.add(aAreaObjectParcelRel);
        this.fireValueChanged(ParcelModelEnum.AREA_OBJECT_PARCEL_REL, aAreaObjectParcelRel, null);
        if (aAreaObjectParcelRel != null) {
            aAreaObjectParcelRel.setParcel(this);
        }
    }

    @Override
    public void removeAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        if (!this.areaObjectParcelRel.contains(aAreaObjectParcelRel)) {
            return;
        }
        this.areaObjectParcelRel.remove(aAreaObjectParcelRel);
        this.fireValueChanged(ParcelModelEnum.AREA_OBJECT_PARCEL_REL, aAreaObjectParcelRel, null);
        if (aAreaObjectParcelRel != null) {
            aAreaObjectParcelRel.setParcel(null);
        }
    }

    @Override
    public void clearAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        ArrayList<AreaObjectParcelRelModel> oldAreaObjectParcelRel = new ArrayList<AreaObjectParcelRelModel>(this.areaObjectParcelRel);
        this.areaObjectParcelRel.clear();
        this.fireValueChanged(ParcelModelEnum.AREA_OBJECT_PARCEL_REL, null, null);
        for (AreaObjectParcelRelModel oldAAreaObjectParcelRel : oldAreaObjectParcelRel) {
            if (oldAAreaObjectParcelRel == null) continue;
            oldAAreaObjectParcelRel.setParcel(null);
        }
    }

    @Override
    public boolean isAreaObjectParcelRelEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.isEmpty();
    }

    @Override
    public boolean containsAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.contains(aAreaObjectParcelRel);
    }

    @Override
    public boolean isAreaObjectParcelRelInitialized() {
        return this.areaObjectParcelRel != null;
    }

    @Override
    public int countParcelAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        return this.parcelAttributeValues.size();
    }

    @Override
    public Iterator<ParcelAttributeValueModel> iterateParcelAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        return new ImmutableIterator<ParcelAttributeValueModel>(this.parcelAttributeValues);
    }

    @Override
    public Iterable<ParcelAttributeValueModel> iterableParcelAttributeValues() {
        return new IteratorIterable<ParcelAttributeValueModel>(this.iterateParcelAttributeValues());
    }

    @Override
    public void addParcelAttributeValue(ParcelAttributeValueModel parcelAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        if (this.parcelAttributeValues.contains(parcelAttributeValue)) {
            return;
        }
        this.parcelAttributeValues.add(parcelAttributeValue);
        this.fireValueChanged(ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES, parcelAttributeValue, null);
        if (parcelAttributeValue != null) {
            parcelAttributeValue.setParcel(this);
        }
    }

    @Override
    public void removeParcelAttributeValue(ParcelAttributeValueModel parcelAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        if (!this.parcelAttributeValues.contains(parcelAttributeValue)) {
            return;
        }
        this.parcelAttributeValues.remove(parcelAttributeValue);
        this.fireValueChanged(ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES, parcelAttributeValue, null);
        if (parcelAttributeValue != null) {
            parcelAttributeValue.setParcel(null);
        }
    }

    @Override
    public void clearParcelAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        ArrayList<ParcelAttributeValueModel> oldParcelAttributeValues = new ArrayList<ParcelAttributeValueModel>(this.parcelAttributeValues);
        this.parcelAttributeValues.clear();
        this.fireValueChanged(ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES, null, null);
        for (ParcelAttributeValueModel oldParcelAttributeValue : oldParcelAttributeValues) {
            if (oldParcelAttributeValue == null) continue;
            oldParcelAttributeValue.setParcel(null);
        }
    }

    @Override
    public boolean isParcelAttributeValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        return this.parcelAttributeValues.isEmpty();
    }

    @Override
    public boolean containsParcelAttributeValue(ParcelAttributeValueModel parcelAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parcelAttributeValues == null) {
            this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            if (this.getId() != null) {
                Collection parcelAttributeValuesCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.PARCEL_ATTRIBUTE_VALUES.getPropertyName());
                this.parcelAttributeValues.addAll(parcelAttributeValuesCollection);
            }
        }
        return this.parcelAttributeValues.contains(parcelAttributeValue);
    }

    @Override
    public boolean isParcelAttributeValuesInitialized() {
        return this.parcelAttributeValues != null;
    }

    @Override
    public Boolean getManualFootSegmentUpdate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.manualFootSegmentUpdate;
    }

    @Override
    public void setManualFootSegmentUpdate(Boolean manualFootSegmentUpdate) {
        this.setManualFootSegmentUpdate(manualFootSegmentUpdate, true);
    }

    private void setManualFootSegmentUpdate(Boolean manualFootSegmentUpdate, boolean setDirty) {
        Boolean oldManualFootSegmentUpdate = this.getManualFootSegmentUpdate();
        if (new EqualsBuilder().append(oldManualFootSegmentUpdate, manualFootSegmentUpdate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.MANUAL_FOOT_SEGMENT_UPDATE.getPropertyName());
        }
        this.manualFootSegmentUpdate = manualFootSegmentUpdate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.MANUAL_FOOT_SEGMENT_UPDATE, manualFootSegmentUpdate, oldManualFootSegmentUpdate);
    }

    @Override
    public Boolean getManualMotorSegmentUpdate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.manualMotorSegmentUpdate;
    }

    @Override
    public void setManualMotorSegmentUpdate(Boolean manualMotorSegmentUpdate) {
        this.setManualMotorSegmentUpdate(manualMotorSegmentUpdate, true);
    }

    private void setManualMotorSegmentUpdate(Boolean manualMotorSegmentUpdate, boolean setDirty) {
        Boolean oldManualMotorSegmentUpdate = this.getManualMotorSegmentUpdate();
        if (new EqualsBuilder().append(oldManualMotorSegmentUpdate, manualMotorSegmentUpdate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.MANUAL_MOTOR_SEGMENT_UPDATE.getPropertyName());
        }
        this.manualMotorSegmentUpdate = manualMotorSegmentUpdate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.MANUAL_MOTOR_SEGMENT_UPDATE, manualMotorSegmentUpdate, oldManualMotorSegmentUpdate);
    }

    @Override
    public Boolean getManualBikeSegmentUpdate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.manualBikeSegmentUpdate;
    }

    @Override
    public void setManualBikeSegmentUpdate(Boolean manualBikeSegmentUpdate) {
        this.setManualBikeSegmentUpdate(manualBikeSegmentUpdate, true);
    }

    private void setManualBikeSegmentUpdate(Boolean manualBikeSegmentUpdate, boolean setDirty) {
        Boolean oldManualBikeSegmentUpdate = this.getManualBikeSegmentUpdate();
        if (new EqualsBuilder().append(oldManualBikeSegmentUpdate, manualBikeSegmentUpdate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.MANUAL_BIKE_SEGMENT_UPDATE.getPropertyName());
        }
        this.manualBikeSegmentUpdate = manualBikeSegmentUpdate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.MANUAL_BIKE_SEGMENT_UPDATE, manualBikeSegmentUpdate, oldManualBikeSegmentUpdate);
    }

    @Override
    public String getImportKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importKey;
    }

    @Override
    public void setImportKey(String importKey) {
        this.setImportKey(importKey, true);
    }

    private void setImportKey(String importKey, boolean setDirty) {
        String oldImportKey = this.getImportKey();
        if (new EqualsBuilder().append(oldImportKey, importKey).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.IMPORT_KEY.getPropertyName());
        }
        this.importKey = importKey;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.IMPORT_KEY, importKey, oldImportKey);
    }

    @Override
    public ImportAddress getImportAddress() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importAddress;
    }

    @Override
    public void setImportAddress(ImportAddress importAddress) {
        this.setImportAddress(importAddress, true);
    }

    private void setImportAddress(ImportAddress importAddress, boolean setDirty) {
        ImportAddress oldImportAddress = this.getImportAddress();
        if (new EqualsBuilder().append(oldImportAddress, importAddress).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.IMPORT_ADDRESS.getPropertyName());
        }
        this.importAddress = importAddress;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.IMPORT_ADDRESS, importAddress, oldImportAddress);
    }

    @Override
    public ImportParcelStatus getImportStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importStatus;
    }

    @Override
    public void setImportStatus(ImportParcelStatus importStatus) {
        this.setImportStatus(importStatus, true);
    }

    private void setImportStatus(ImportParcelStatus importStatus, boolean setDirty) {
        ImportParcelStatus oldImportStatus = this.getImportStatus();
        if (new EqualsBuilder().append((Object)oldImportStatus, (Object)importStatus).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.IMPORT_STATUS.getPropertyName());
        }
        this.importStatus = importStatus;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.IMPORT_STATUS, (Object)importStatus, (Object)oldImportStatus);
    }

    @Override
    public ImportParcelProcess getImportProcess() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importProcess;
    }

    @Override
    public void setImportProcess(ImportParcelProcess importProcess) {
        this.setImportProcess(importProcess, true);
    }

    private void setImportProcess(ImportParcelProcess importProcess, boolean setDirty) {
        ImportParcelProcess oldImportProcess = this.getImportProcess();
        if (new EqualsBuilder().append((Object)oldImportProcess, (Object)importProcess).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.IMPORT_PROCESS.getPropertyName());
        }
        this.importProcess = importProcess;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.IMPORT_PROCESS, (Object)importProcess, (Object)oldImportProcess);
    }

    @Override
    public ImmutablePoint getOldGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.oldGeom;
    }

    @Override
    public void setOldGeom(ImmutablePoint oldGeom) {
        this.setOldGeom(oldGeom, true);
    }

    private void setOldGeom(ImmutablePoint oldGeom, boolean setDirty) {
        ImmutablePoint oldOldGeom = this.getOldGeom();
        if (new EqualsBuilder().append(oldOldGeom, oldGeom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.OLD_GEOM.getPropertyName());
        }
        this.oldGeom = oldGeom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.OLD_GEOM, oldGeom, oldOldGeom);
    }

    @Override
    public UserModel getEditorUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.editorUser;
    }

    @Override
    public void setEditorUser(UserModel editorUser) {
        this.setEditorUser(editorUser, true);
    }

    private void setEditorUser(UserModel editorUser, boolean setDirty) {
        UserModel oldEditorUser = this.getEditorUser();
        if (oldEditorUser == editorUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.EDITOR_USER.getPropertyName());
        }
        this.editorUser = editorUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.EDITOR_USER, editorUser, oldEditorUser);
    }

    @Override
    public UserModel getLoginUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.loginUser;
    }

    @Override
    public void setLoginUser(UserModel loginUser) {
        this.setLoginUser(loginUser, true);
    }

    private void setLoginUser(UserModel loginUser, boolean setDirty) {
        UserModel oldLoginUser = this.getLoginUser();
        if (oldLoginUser == loginUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelModelEnum.LOGIN_USER.getPropertyName());
        }
        this.loginUser = loginUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelModelEnum.LOGIN_USER, loginUser, oldLoginUser);
    }

    @Override
    public int countLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        return this.locations.size();
    }

    @Override
    public Iterator<LocationModel> iterateLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.locations);
    }

    @Override
    public Iterable<LocationModel> iterableLocations() {
        return new IteratorIterable<LocationModel>(this.iterateLocations());
    }

    @Override
    public void addLocation(LocationModel location) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        if (this.locations.contains(location)) {
            return;
        }
        this.locations.add(location);
        this.fireValueChanged(ParcelModelEnum.LOCATIONS, location, null);
        if (location != null) {
            location.setParcel(this);
        }
    }

    @Override
    public void removeLocation(LocationModel location) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        if (!this.locations.contains(location)) {
            return;
        }
        this.locations.remove(location);
        this.fireValueChanged(ParcelModelEnum.LOCATIONS, location, null);
        if (location != null) {
            location.setParcel(null);
        }
    }

    @Override
    public void clearLocations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        ArrayList<LocationModel> oldLocations = new ArrayList<LocationModel>(this.locations);
        this.locations.clear();
        this.fireValueChanged(ParcelModelEnum.LOCATIONS, null, null);
        for (LocationModel oldLocation : oldLocations) {
            if (oldLocation == null) continue;
            oldLocation.setParcel(null);
        }
    }

    @Override
    public boolean isLocationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        return this.locations.isEmpty();
    }

    @Override
    public boolean containsLocation(LocationModel location) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.locations == null) {
            this.locations = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationsCollection = this.commonCaller.fetchChildren(this, ParcelModelEnum.LOCATIONS.getPropertyName());
                this.locations.addAll(locationsCollection);
            }
        }
        return this.locations.contains(location);
    }

    @Override
    public boolean isLocationsInitialized() {
        return this.locations != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.areaObjectParcelRel = null;
            this.parcelAttributeValues = null;
            this.locations = null;
        }
    }

    @Override
    protected void updateByDto(ParcelFullDto parcelDto) {
        ParcelAttributeValueDto[] parcelAttributeValues;
        this.houseNumber = parcelDto.getHouseNumber();
        this.houseNumberExtension = parcelDto.getHouseNumberExtension();
        this.street = (StreetModel)this.getModelCache().getModel(parcelDto.getStreet());
        this.footSegment = (SegmentModel)this.getModelCache().getModel(parcelDto.getFootSegment());
        this.motorSegment = (SegmentModel)this.getModelCache().getModel(parcelDto.getMotorSegment());
        this.bikeSegment = (SegmentModel)this.getModelCache().getModel(parcelDto.getBikeSegment());
        ImmutablePointDto geom = parcelDto.getGeom();
        this.geom = geom == null ? null : (ImmutablePoint)geom.getGeoObject();
        AreaObjectParcelRelDto[] areaObjectParcelRel = parcelDto.getAreaObjectParcelRel();
        if (areaObjectParcelRel != null) {
            if (this.areaObjectParcelRel == null) {
                this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            } else {
                this.areaObjectParcelRel.clear();
            }
        }
        if ((parcelAttributeValues = parcelDto.getParcelAttributeValues()) != null) {
            if (this.parcelAttributeValues == null) {
                this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            } else {
                this.parcelAttributeValues.clear();
            }
        }
        this.manualFootSegmentUpdate = parcelDto.getManualFootSegmentUpdate();
        this.manualMotorSegmentUpdate = parcelDto.getManualMotorSegmentUpdate();
        this.manualBikeSegmentUpdate = parcelDto.getManualBikeSegmentUpdate();
        this.importKey = parcelDto.getImportKey();
        this.importAddress = parcelDto.getImportAddress();
        this.importStatus = parcelDto.getImportStatus();
        this.importProcess = parcelDto.getImportProcess();
        ImmutablePointDto oldGeom = parcelDto.getOldGeom();
        this.oldGeom = oldGeom == null ? null : (ImmutablePoint)oldGeom.getGeoObject();
        this.editorUser = (UserModel)this.getModelCache().getModel(parcelDto.getEditorUser());
        this.loginUser = (UserModel)this.getModelCache().getModel(parcelDto.getLoginUser());
        LocationDto[] locations = parcelDto.getLocations();
        if (locations != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashSet<LocationModel>();
            } else {
                this.locations.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(ParcelFullDto parcelDto) {
        LocationDto[] locations;
        ParcelAttributeValueDto[] parcelAttributeValues;
        AreaObjectParcelRelDto[] areaObjectParcelRel = parcelDto.getAreaObjectParcelRel();
        if (areaObjectParcelRel != null) {
            if (this.areaObjectParcelRel == null) {
                this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            } else {
                this.areaObjectParcelRel.clear();
            }
            for (AreaObjectParcelRelDto aAreaObjectParcelRelDto : areaObjectParcelRel) {
                AreaObjectParcelRelModel aAreaObjectParcelRelModel = (AreaObjectParcelRelModel)this.getModelCache().getModel(aAreaObjectParcelRelDto);
                this.areaObjectParcelRel.add(aAreaObjectParcelRelModel);
            }
        } else {
            this.areaObjectParcelRel = null;
        }
        if ((parcelAttributeValues = parcelDto.getParcelAttributeValues()) != null) {
            if (this.parcelAttributeValues == null) {
                this.parcelAttributeValues = new LinkedHashSet<ParcelAttributeValueModel>();
            } else {
                this.parcelAttributeValues.clear();
            }
            for (ParcelAttributeValueDto parcelAttributeValueDto : parcelAttributeValues) {
                ParcelAttributeValueModel parcelAttributeValueModel = (ParcelAttributeValueModel)this.getModelCache().getModel(parcelAttributeValueDto);
                this.parcelAttributeValues.add(parcelAttributeValueModel);
            }
        } else {
            this.parcelAttributeValues = null;
        }
        if ((locations = parcelDto.getLocations()) != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashSet<LocationModel>();
            } else {
                this.locations.clear();
            }
            for (LocationDto locationDto : locations) {
                LocationModel locationModel = (LocationModel)this.getModelCache().getModel(locationDto);
                this.locations.add(locationModel);
            }
        } else {
            this.locations = null;
        }
    }

    @Override
    protected void checkStaleByDto(ParcelFullDto parcelDto) throws StaleStateException {
        LocationDto[] locationDtos;
        UserModelImpl loginUserModel;
        UserDto loginUserDto;
        UserModelImpl editorUserModel;
        UserDto editorUserDto;
        ParcelAttributeValueDto[] parcelAttributeValueDtos;
        AreaObjectParcelRelDto[] aAreaObjectParcelRelDtos;
        SegmentModelImpl bikeSegmentModel;
        SegmentDto bikeSegmentDto;
        SegmentModelImpl motorSegmentModel;
        SegmentDto motorSegmentDto;
        SegmentModelImpl footSegmentModel;
        SegmentDto footSegmentDto;
        StreetModelImpl streetModel;
        StreetDto streetDto = parcelDto.getStreet();
        if (streetDto != null && streetDto.getId() != null && (streetModel = (StreetModelImpl)this.getModelCache().getModel(StreetModel.class, streetDto.getId())) != null) {
            streetModel.checkStaleState(streetDto);
        }
        if ((footSegmentDto = parcelDto.getFootSegment()) != null && footSegmentDto.getId() != null && (footSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, footSegmentDto.getId())) != null) {
            footSegmentModel.checkStaleState(footSegmentDto);
        }
        if ((motorSegmentDto = parcelDto.getMotorSegment()) != null && motorSegmentDto.getId() != null && (motorSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, motorSegmentDto.getId())) != null) {
            motorSegmentModel.checkStaleState(motorSegmentDto);
        }
        if ((bikeSegmentDto = parcelDto.getBikeSegment()) != null && bikeSegmentDto.getId() != null && (bikeSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, bikeSegmentDto.getId())) != null) {
            bikeSegmentModel.checkStaleState(bikeSegmentDto);
        }
        if ((aAreaObjectParcelRelDtos = parcelDto.getAreaObjectParcelRel()) != null) {
            for (AreaObjectParcelRelDto aAreaObjectParcelRelDto : aAreaObjectParcelRelDtos) {
                AreaObjectParcelRelModelImpl aAreaObjectParcelRelModel = (AreaObjectParcelRelModelImpl)this.getModelCache().getModel(AreaObjectParcelRelModel.class, aAreaObjectParcelRelDto.getId());
                if (aAreaObjectParcelRelModel == null) continue;
                aAreaObjectParcelRelModel.checkStaleState(aAreaObjectParcelRelDto);
            }
        }
        if ((parcelAttributeValueDtos = parcelDto.getParcelAttributeValues()) != null) {
            for (ParcelAttributeValueDto parcelAttributeValueDto : parcelAttributeValueDtos) {
                ParcelAttributeValueModelImpl parcelAttributeValueModel = (ParcelAttributeValueModelImpl)this.getModelCache().getModel(ParcelAttributeValueModel.class, parcelAttributeValueDto.getId());
                if (parcelAttributeValueModel == null) continue;
                parcelAttributeValueModel.checkStaleState(parcelAttributeValueDto);
            }
        }
        if ((editorUserDto = parcelDto.getEditorUser()) != null && editorUserDto.getId() != null && (editorUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, editorUserDto.getId())) != null) {
            editorUserModel.checkStaleState(editorUserDto);
        }
        if ((loginUserDto = parcelDto.getLoginUser()) != null && loginUserDto.getId() != null && (loginUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, loginUserDto.getId())) != null) {
            loginUserModel.checkStaleState(loginUserDto);
        }
        if ((locationDtos = parcelDto.getLocations()) != null) {
            for (LocationDto locationDto : locationDtos) {
                LocationModelImpl locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId());
                if (locationModel == null) continue;
                locationModel.checkStaleState(locationDto);
            }
        }
    }

    @Override
    public ParcelFullDto createDto() {
        UserModelImpl loginUser;
        SegmentModelImpl bikeSegment;
        SegmentModelImpl motorSegment;
        SegmentModelImpl footSegment;
        Long id = this.getId();
        ParcelFullDto parcelDto = id == null ? new ParcelFullDto(this.getTempUUID()) : new ParcelFullDto(id, this.getVersion());
        parcelDto.setHouseNumber(this.getHouseNumber());
        parcelDto.setHouseNumberExtension(this.getHouseNumberExtension());
        StreetModelImpl street = (StreetModelImpl)this.getStreet();
        if (street != null) {
            parcelDto.setStreet(street.createProxy());
        }
        if ((footSegment = (SegmentModelImpl)this.getFootSegment()) != null) {
            parcelDto.setFootSegment(footSegment.createProxy());
        }
        if ((motorSegment = (SegmentModelImpl)this.getMotorSegment()) != null) {
            parcelDto.setMotorSegment(motorSegment.createProxy());
        }
        if ((bikeSegment = (SegmentModelImpl)this.getBikeSegment()) != null) {
            parcelDto.setBikeSegment(bikeSegment.createProxy());
        }
        ImmutablePoint geom = this.getGeom();
        parcelDto.setGeom(ImmutablePointDto.create(geom));
        parcelDto.setManualFootSegmentUpdate(this.getManualFootSegmentUpdate());
        parcelDto.setManualMotorSegmentUpdate(this.getManualMotorSegmentUpdate());
        parcelDto.setManualBikeSegmentUpdate(this.getManualBikeSegmentUpdate());
        parcelDto.setImportKey(this.getImportKey());
        parcelDto.setImportAddress(this.getImportAddress());
        parcelDto.setImportStatus(this.getImportStatus());
        parcelDto.setImportProcess(this.getImportProcess());
        ImmutablePoint oldGeom = this.getOldGeom();
        parcelDto.setOldGeom(ImmutablePointDto.create(oldGeom));
        UserModelImpl editorUser = (UserModelImpl)this.getEditorUser();
        if (editorUser != null) {
            parcelDto.setEditorUser(editorUser.createProxy());
        }
        if ((loginUser = (UserModelImpl)this.getLoginUser()) != null) {
            parcelDto.setLoginUser(loginUser.createProxy());
        }
        return parcelDto;
    }

    @Override
    public ParcelProxyDto createProxy() {
        Long id = this.getId();
        ParcelProxyDto parcelDto = id == null ? new ParcelProxyDto(this.getTempUUID()) : new ParcelProxyDto(id, this.getVersion());
        return parcelDto;
    }

    public static enum ParcelModelEnum {
        HOUSE_NUMBER("houseNumber"),
        HOUSE_NUMBER_EXTENSION("houseNumberExtension"),
        STREET("street"),
        FOOT_SEGMENT("footSegment"),
        MOTOR_SEGMENT("motorSegment"),
        BIKE_SEGMENT("bikeSegment"),
        GEOM("geom"),
        AREA_OBJECT_PARCEL_REL("areaObjectParcelRel"),
        PARCEL_ATTRIBUTE_VALUES("parcelAttributeValues"),
        MANUAL_FOOT_SEGMENT_UPDATE("manualFootSegmentUpdate"),
        MANUAL_MOTOR_SEGMENT_UPDATE("manualMotorSegmentUpdate"),
        MANUAL_BIKE_SEGMENT_UPDATE("manualBikeSegmentUpdate"),
        IMPORT_KEY("importKey"),
        IMPORT_ADDRESS("importAddress"),
        IMPORT_STATUS("importStatus"),
        IMPORT_PROCESS("importProcess"),
        OLD_GEOM("oldGeom"),
        EDITOR_USER("editorUser"),
        LOGIN_USER("loginUser"),
        LOCATIONS("locations");

        private String propertyName;

        private ParcelModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

