/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.DistrictModelImpl;
import de.datomino.peppergis.dto.map.DistrictAliasFullDto;
import de.datomino.peppergis.dto.map.DistrictAliasProxyDto;
import de.datomino.peppergis.dto.map.DistrictDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DistrictAliasModelImpl
extends AbstractModel<DistrictAliasFullDto, DistrictAliasProxyDto>
implements DistrictAliasModel {
    private String name;
    private String search;
    private DistrictModel district;

    public DistrictAliasModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DistrictAliasModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DistrictAliasModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DistrictAliasModelEnum.NAME, name, oldName);
    }

    @Override
    public String getSearch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.search;
    }

    @Override
    public void setSearch(String search) {
        this.setSearch(search, true);
    }

    private void setSearch(String search, boolean setDirty) {
        String oldSearch = this.getSearch();
        if (new EqualsBuilder().append(oldSearch, search).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DistrictAliasModelEnum.SEARCH.getPropertyName());
        }
        this.search = search;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DistrictAliasModelEnum.SEARCH, search, oldSearch);
    }

    @Override
    public DistrictModel getDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.district;
    }

    @Override
    public void setDistrict(DistrictModel district) {
        this.setDistrict(district, true);
    }

    private void setDistrict(DistrictModel district, boolean setDirty) {
        DistrictModel oldDistrict = this.getDistrict();
        if (oldDistrict == district) {
            return;
        }
        if (oldDistrict != null) {
            oldDistrict.removeAlia(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DistrictAliasModelEnum.DISTRICT.getPropertyName());
        }
        this.district = district;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DistrictAliasModelEnum.DISTRICT, district, oldDistrict);
        if (this.district != null) {
            this.district.addAlia(this);
        }
    }

    @Override
    protected void updateByDto(DistrictAliasFullDto districtAliasDto) {
        this.name = districtAliasDto.getName();
        this.search = districtAliasDto.getSearch();
        this.district = (DistrictModel)this.getModelCache().getModel(districtAliasDto.getDistrict());
    }

    @Override
    protected void updateMasterRelationsByDto(DistrictAliasFullDto districtAliasDto) {
    }

    @Override
    protected void checkStaleByDto(DistrictAliasFullDto districtAliasDto) throws StaleStateException {
        DistrictModelImpl districtModel;
        DistrictDto districtDto = districtAliasDto.getDistrict();
        if (districtDto != null && districtDto.getId() != null && (districtModel = (DistrictModelImpl)this.getModelCache().getModel(DistrictModel.class, districtDto.getId())) != null) {
            districtModel.checkStaleState(districtDto);
        }
    }

    @Override
    public DistrictAliasFullDto createDto() {
        Long id = this.getId();
        DistrictAliasFullDto districtAliasDto = id == null ? new DistrictAliasFullDto(this.getTempUUID()) : new DistrictAliasFullDto(id, this.getVersion());
        districtAliasDto.setName(this.getName());
        districtAliasDto.setSearch(this.getSearch());
        DistrictModelImpl district = (DistrictModelImpl)this.getDistrict();
        if (district != null) {
            districtAliasDto.setDistrict(district.createProxy());
        }
        return districtAliasDto;
    }

    @Override
    public DistrictAliasProxyDto createProxy() {
        Long id = this.getId();
        DistrictAliasProxyDto districtAliasDto = id == null ? new DistrictAliasProxyDto(this.getTempUUID()) : new DistrictAliasProxyDto(id, this.getVersion());
        return districtAliasDto;
    }

    public static enum DistrictAliasModelEnum {
        NAME("name"),
        SEARCH("search"),
        DISTRICT("district");

        private String propertyName;

        private DistrictAliasModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

