/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityAliasModelImpl;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.DistrictModelImpl;
import de.datomino.peppergis.dto.map.CityAliasDto;
import de.datomino.peppergis.dto.map.CityFullDto;
import de.datomino.peppergis.dto.map.CityProxyDto;
import de.datomino.peppergis.dto.map.DistrictDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class CityModelImpl
extends AbstractModel<CityFullDto, CityProxyDto>
implements CityModel {
    private String name;
    private Set<DistrictModel> district = null;
    private Set<CityAliasModel> alias = null;

    public CityModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CityModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CityModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CityModelEnum.NAME, name, oldName);
    }

    @Override
    public int countDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        return this.district.size();
    }

    @Override
    public Iterator<DistrictModel> iterateDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        return new ImmutableIterator<DistrictModel>(this.district);
    }

    @Override
    public Iterable<DistrictModel> iterableDistrict() {
        return new IteratorIterable<DistrictModel>(this.iterateDistrict());
    }

    @Override
    public void addADistrict(DistrictModel aDistrict) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        if (this.district.contains(aDistrict)) {
            return;
        }
        this.district.add(aDistrict);
        this.fireValueChanged(CityModelEnum.DISTRICT, aDistrict, null);
        if (aDistrict != null) {
            aDistrict.setCity(this);
        }
    }

    @Override
    public void removeADistrict(DistrictModel aDistrict) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        if (!this.district.contains(aDistrict)) {
            return;
        }
        this.district.remove(aDistrict);
        this.fireValueChanged(CityModelEnum.DISTRICT, aDistrict, null);
        if (aDistrict != null) {
            aDistrict.setCity(null);
        }
    }

    @Override
    public void clearDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        ArrayList<DistrictModel> oldDistrict = new ArrayList<DistrictModel>(this.district);
        this.district.clear();
        this.fireValueChanged(CityModelEnum.DISTRICT, null, null);
        for (DistrictModel oldADistrict : oldDistrict) {
            if (oldADistrict == null) continue;
            oldADistrict.setCity(null);
        }
    }

    @Override
    public boolean isDistrictEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        return this.district.isEmpty();
    }

    @Override
    public boolean containsADistrict(DistrictModel aDistrict) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.district == null) {
            this.district = new LinkedHashSet<DistrictModel>();
            if (this.getId() != null) {
                Collection districtCollection = this.commonCaller.fetchChildren(this, CityModelEnum.DISTRICT.getPropertyName());
                this.district.addAll(districtCollection);
            }
        }
        return this.district.contains(aDistrict);
    }

    @Override
    public boolean isDistrictInitialized() {
        return this.district != null;
    }

    @Override
    public int countAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.size();
    }

    @Override
    public Iterator<CityAliasModel> iterateAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return new ImmutableIterator<CityAliasModel>(this.alias);
    }

    @Override
    public Iterable<CityAliasModel> iterableAlias() {
        return new IteratorIterable<CityAliasModel>(this.iterateAlias());
    }

    @Override
    public void addAlia(CityAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (this.alias.contains(alia)) {
            return;
        }
        this.alias.add(alia);
        this.fireValueChanged(CityModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setCity(this);
        }
    }

    @Override
    public void removeAlia(CityAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (!this.alias.contains(alia)) {
            return;
        }
        this.alias.remove(alia);
        this.fireValueChanged(CityModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setCity(null);
        }
    }

    @Override
    public void clearAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        ArrayList<CityAliasModel> oldAlias = new ArrayList<CityAliasModel>(this.alias);
        this.alias.clear();
        this.fireValueChanged(CityModelEnum.ALIAS, null, null);
        for (CityAliasModel oldAlia : oldAlias) {
            if (oldAlia == null) continue;
            oldAlia.setCity(null);
        }
    }

    @Override
    public boolean isAliasEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.isEmpty();
    }

    @Override
    public boolean containsAlia(CityAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<CityAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, CityModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.contains(alia);
    }

    @Override
    public boolean isAliasInitialized() {
        return this.alias != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.district = null;
            this.alias = null;
        }
    }

    @Override
    protected void updateByDto(CityFullDto cityDto) {
        CityAliasDto[] alias;
        this.name = cityDto.getName();
        DistrictDto[] district = cityDto.getDistrict();
        if (district != null) {
            if (this.district == null) {
                this.district = new LinkedHashSet<DistrictModel>();
            } else {
                this.district.clear();
            }
        }
        if ((alias = cityDto.getAlias()) != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<CityAliasModel>();
            } else {
                this.alias.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(CityFullDto cityDto) {
        CityAliasDto[] alias;
        DistrictDto[] district = cityDto.getDistrict();
        if (district != null) {
            if (this.district == null) {
                this.district = new LinkedHashSet<DistrictModel>();
            } else {
                this.district.clear();
            }
            for (DistrictDto aDistrictDto : district) {
                DistrictModel aDistrictModel = (DistrictModel)this.getModelCache().getModel(aDistrictDto);
                this.district.add(aDistrictModel);
            }
        } else {
            this.district = null;
        }
        if ((alias = cityDto.getAlias()) != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<CityAliasModel>();
            } else {
                this.alias.clear();
            }
            for (CityAliasDto aliaDto : alias) {
                CityAliasModel aliaModel = (CityAliasModel)this.getModelCache().getModel(aliaDto);
                this.alias.add(aliaModel);
            }
        } else {
            this.alias = null;
        }
    }

    @Override
    protected void checkStaleByDto(CityFullDto cityDto) throws StaleStateException {
        CityAliasDto[] aliaDtos;
        DistrictDto[] aDistrictDtos = cityDto.getDistrict();
        if (aDistrictDtos != null) {
            for (DistrictDto aDistrictDto : aDistrictDtos) {
                DistrictModelImpl aDistrictModel = (DistrictModelImpl)this.getModelCache().getModel(DistrictModel.class, aDistrictDto.getId());
                if (aDistrictModel == null) continue;
                aDistrictModel.checkStaleState(aDistrictDto);
            }
        }
        if ((aliaDtos = cityDto.getAlias()) != null) {
            for (CityAliasDto aliaDto : aliaDtos) {
                CityAliasModelImpl aliaModel = (CityAliasModelImpl)this.getModelCache().getModel(CityAliasModel.class, aliaDto.getId());
                if (aliaModel == null) continue;
                aliaModel.checkStaleState(aliaDto);
            }
        }
    }

    @Override
    public CityFullDto createDto() {
        Long id = this.getId();
        CityFullDto cityDto = id == null ? new CityFullDto(this.getTempUUID()) : new CityFullDto(id, this.getVersion());
        cityDto.setName(this.getName());
        return cityDto;
    }

    @Override
    public CityProxyDto createProxy() {
        Long id = this.getId();
        CityProxyDto cityDto = id == null ? new CityProxyDto(this.getTempUUID()) : new CityProxyDto(id, this.getVersion());
        return cityDto;
    }

    public static enum CityModelEnum {
        NAME("name"),
        DISTRICT("district"),
        ALIAS("alias");

        private String propertyName;

        private CityModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

