/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.CityModelImpl;
import de.datomino.peppergis.dto.map.CityAliasFullDto;
import de.datomino.peppergis.dto.map.CityAliasProxyDto;
import de.datomino.peppergis.dto.map.CityDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class CityAliasModelImpl
extends AbstractModel<CityAliasFullDto, CityAliasProxyDto>
implements CityAliasModel {
    private String name;
    private String search;
    private CityModel city;

    public CityAliasModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CityAliasModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CityAliasModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CityAliasModelEnum.NAME, name, oldName);
    }

    @Override
    public String getSearch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.search;
    }

    @Override
    public void setSearch(String search) {
        this.setSearch(search, true);
    }

    private void setSearch(String search, boolean setDirty) {
        String oldSearch = this.getSearch();
        if (new EqualsBuilder().append(oldSearch, search).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CityAliasModelEnum.SEARCH.getPropertyName());
        }
        this.search = search;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CityAliasModelEnum.SEARCH, search, oldSearch);
    }

    @Override
    public CityModel getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(CityModel city) {
        this.setCity(city, true);
    }

    private void setCity(CityModel city, boolean setDirty) {
        CityModel oldCity = this.getCity();
        if (oldCity == city) {
            return;
        }
        if (oldCity != null) {
            oldCity.removeAlia(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CityAliasModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CityAliasModelEnum.CITY, city, oldCity);
        if (this.city != null) {
            this.city.addAlia(this);
        }
    }

    @Override
    protected void updateByDto(CityAliasFullDto cityAliasDto) {
        this.name = cityAliasDto.getName();
        this.search = cityAliasDto.getSearch();
        this.city = (CityModel)this.getModelCache().getModel(cityAliasDto.getCity());
    }

    @Override
    protected void updateMasterRelationsByDto(CityAliasFullDto cityAliasDto) {
    }

    @Override
    protected void checkStaleByDto(CityAliasFullDto cityAliasDto) throws StaleStateException {
        CityModelImpl cityModel;
        CityDto cityDto = cityAliasDto.getCity();
        if (cityDto != null && cityDto.getId() != null && (cityModel = (CityModelImpl)this.getModelCache().getModel(CityModel.class, cityDto.getId())) != null) {
            cityModel.checkStaleState(cityDto);
        }
    }

    @Override
    public CityAliasFullDto createDto() {
        Long id = this.getId();
        CityAliasFullDto cityAliasDto = id == null ? new CityAliasFullDto(this.getTempUUID()) : new CityAliasFullDto(id, this.getVersion());
        cityAliasDto.setName(this.getName());
        cityAliasDto.setSearch(this.getSearch());
        CityModelImpl city = (CityModelImpl)this.getCity();
        if (city != null) {
            cityAliasDto.setCity(city.createProxy());
        }
        return cityAliasDto;
    }

    @Override
    public CityAliasProxyDto createProxy() {
        Long id = this.getId();
        CityAliasProxyDto cityAliasDto = id == null ? new CityAliasProxyDto(this.getTempUUID()) : new CityAliasProxyDto(id, this.getVersion());
        return cityAliasDto;
    }

    public static enum CityAliasModelEnum {
        NAME("name"),
        SEARCH("search"),
        CITY("city");

        private String propertyName;

        private CityAliasModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

