/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.filter;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModelImpl;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.dto.filter.AttributeValueFilterDto;
import de.datomino.peppergis.dto.filter.PoiFilterFullDto;
import de.datomino.peppergis.dto.filter.PoiFilterProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.PoiType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PoiFilterModelImpl
extends AbstractModel<PoiFilterFullDto, PoiFilterProxyDto>
implements PoiFilterModel {
    private String name;
    private String poiNumber;
    private PoiType poiType;
    private AttributeValueFilterModel attributeValueFilter;
    private Boolean modifiable;

    public PoiFilterModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PoiFilterModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterModelEnum.NAME, name, oldName);
    }

    @Override
    public String getPoiNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poiNumber;
    }

    @Override
    public void setPoiNumber(String poiNumber) {
        this.setPoiNumber(poiNumber, true);
    }

    private void setPoiNumber(String poiNumber, boolean setDirty) {
        String oldPoiNumber = this.getPoiNumber();
        if (new EqualsBuilder().append(oldPoiNumber, poiNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterModelEnum.POI_NUMBER.getPropertyName());
        }
        this.poiNumber = poiNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterModelEnum.POI_NUMBER, poiNumber, oldPoiNumber);
    }

    @Override
    public PoiType getPoiType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poiType;
    }

    @Override
    public void setPoiType(PoiType poiType) {
        this.setPoiType(poiType, true);
    }

    private void setPoiType(PoiType poiType, boolean setDirty) {
        PoiType oldPoiType = this.getPoiType();
        if (new EqualsBuilder().append((Object)oldPoiType, (Object)poiType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterModelEnum.POI_TYPE.getPropertyName());
        }
        this.poiType = poiType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterModelEnum.POI_TYPE, (Object)poiType, (Object)oldPoiType);
    }

    @Override
    public AttributeValueFilterModel getAttributeValueFilter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.attributeValueFilter;
    }

    @Override
    public void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter) {
        this.setAttributeValueFilter(attributeValueFilter, true);
    }

    private void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter, boolean setDirty) {
        AttributeValueFilterModel oldAttributeValueFilter = this.getAttributeValueFilter();
        if (oldAttributeValueFilter == attributeValueFilter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterModelEnum.ATTRIBUTE_VALUE_FILTER.getPropertyName());
        }
        this.attributeValueFilter = attributeValueFilter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterModelEnum.ATTRIBUTE_VALUE_FILTER, attributeValueFilter, oldAttributeValueFilter);
    }

    @Override
    public Boolean getModifiable() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.modifiable;
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.setModifiable(modifiable, true);
    }

    private void setModifiable(Boolean modifiable, boolean setDirty) {
        Boolean oldModifiable = this.getModifiable();
        if (new EqualsBuilder().append(oldModifiable, modifiable).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterModelEnum.MODIFIABLE.getPropertyName());
        }
        this.modifiable = modifiable;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterModelEnum.MODIFIABLE, modifiable, oldModifiable);
    }

    @Override
    protected void updateByDto(PoiFilterFullDto poiFilterDto) {
        this.name = poiFilterDto.getName();
        this.poiNumber = poiFilterDto.getPoiNumber();
        this.poiType = poiFilterDto.getPoiType();
        this.attributeValueFilter = (AttributeValueFilterModel)this.getModelCache().getModel(poiFilterDto.getAttributeValueFilter());
        this.modifiable = poiFilterDto.getModifiable();
    }

    @Override
    protected void updateMasterRelationsByDto(PoiFilterFullDto poiFilterDto) {
    }

    @Override
    protected void checkStaleByDto(PoiFilterFullDto poiFilterDto) throws StaleStateException {
        AttributeValueFilterModelImpl attributeValueFilterModel;
        AttributeValueFilterDto attributeValueFilterDto = poiFilterDto.getAttributeValueFilter();
        if (attributeValueFilterDto != null && attributeValueFilterDto.getId() != null && (attributeValueFilterModel = (AttributeValueFilterModelImpl)this.getModelCache().getModel(AttributeValueFilterModel.class, attributeValueFilterDto.getId())) != null) {
            attributeValueFilterModel.checkStaleState(attributeValueFilterDto);
        }
    }

    @Override
    public PoiFilterFullDto createDto() {
        Long id = this.getId();
        PoiFilterFullDto poiFilterDto = id == null ? new PoiFilterFullDto(this.getTempUUID()) : new PoiFilterFullDto(id, this.getVersion());
        poiFilterDto.setName(this.getName());
        poiFilterDto.setPoiNumber(this.getPoiNumber());
        poiFilterDto.setPoiType(this.getPoiType());
        AttributeValueFilterModelImpl attributeValueFilter = (AttributeValueFilterModelImpl)this.getAttributeValueFilter();
        if (attributeValueFilter != null) {
            poiFilterDto.setAttributeValueFilter(attributeValueFilter.createProxy());
        }
        poiFilterDto.setModifiable(this.getModifiable());
        return poiFilterDto;
    }

    @Override
    public PoiFilterProxyDto createProxy() {
        Long id = this.getId();
        PoiFilterProxyDto poiFilterDto = id == null ? new PoiFilterProxyDto(this.getTempUUID()) : new PoiFilterProxyDto(id, this.getVersion());
        return poiFilterDto;
    }

    public static enum PoiFilterModelEnum {
        NAME("name"),
        POI_NUMBER("poiNumber"),
        POI_TYPE("poiType"),
        ATTRIBUTE_VALUE_FILTER("attributeValueFilter"),
        MODIFIABLE("modifiable");

        private String propertyName;

        private PoiFilterModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

