/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.distance;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.distance.GeoDistanceMatrix92Model;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix92FullDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix92ProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoDistanceMatrix92ModelImpl
extends AbstractModel<GeoDistanceMatrix92FullDto, GeoDistanceMatrix92ProxyDto>
implements GeoDistanceMatrix92Model {
    private ImmutablePoint start;
    private ImmutablePoint target;
    private Integer distance;
    private Integer duration;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType vehicleType;

    public GeoDistanceMatrix92ModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoDistanceMatrix92ModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.start;
    }

    @Override
    public void setStart(ImmutablePoint start) {
        this.setStart(start, true);
    }

    private void setStart(ImmutablePoint start, boolean setDirty) {
        ImmutablePoint oldStart = this.getStart();
        if (new EqualsBuilder().append(oldStart, start).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.START.getPropertyName());
        }
        this.start = start;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.START, start, oldStart);
    }

    @Override
    public ImmutablePoint getTarget() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.target;
    }

    @Override
    public void setTarget(ImmutablePoint target) {
        this.setTarget(target, true);
    }

    private void setTarget(ImmutablePoint target, boolean setDirty) {
        ImmutablePoint oldTarget = this.getTarget();
        if (new EqualsBuilder().append(oldTarget, target).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.TARGET.getPropertyName());
        }
        this.target = target;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.TARGET, target, oldTarget);
    }

    @Override
    public Integer getDistance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distance;
    }

    @Override
    public void setDistance(Integer distance) {
        this.setDistance(distance, true);
    }

    private void setDistance(Integer distance, boolean setDirty) {
        Integer oldDistance = this.getDistance();
        if (new EqualsBuilder().append(oldDistance, distance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.DISTANCE.getPropertyName());
        }
        this.distance = distance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.DISTANCE, distance, oldDistance);
    }

    @Override
    public Integer getDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.duration;
    }

    @Override
    public void setDuration(Integer duration) {
        this.setDuration(duration, true);
    }

    private void setDuration(Integer duration, boolean setDirty) {
        Integer oldDuration = this.getDuration();
        if (new EqualsBuilder().append(oldDuration, duration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.DURATION.getPropertyName());
        }
        this.duration = duration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.DURATION, duration, oldDuration);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicleType;
    }

    @Override
    public void setVehicleType(RouteVehicleType vehicleType) {
        this.setVehicleType(vehicleType, true);
    }

    private void setVehicleType(RouteVehicleType vehicleType, boolean setDirty) {
        RouteVehicleType oldVehicleType = this.getVehicleType();
        if (new EqualsBuilder().append((Object)oldVehicleType, (Object)vehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix92ModelEnum.VEHICLE_TYPE.getPropertyName());
        }
        this.vehicleType = vehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix92ModelEnum.VEHICLE_TYPE, (Object)vehicleType, (Object)oldVehicleType);
    }

    @Override
    protected void updateByDto(GeoDistanceMatrix92FullDto geoDistanceMatrix92Dto) {
        ImmutablePointDto start = geoDistanceMatrix92Dto.getStart();
        this.start = start == null ? null : (ImmutablePoint)start.getGeoObject();
        ImmutablePointDto target = geoDistanceMatrix92Dto.getTarget();
        this.target = target == null ? null : (ImmutablePoint)target.getGeoObject();
        this.distance = geoDistanceMatrix92Dto.getDistance();
        this.duration = geoDistanceMatrix92Dto.getDuration();
        ImmutableLineStringDto lineString = geoDistanceMatrix92Dto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = geoDistanceMatrix92Dto.getRouteType();
        this.vehicleType = geoDistanceMatrix92Dto.getVehicleType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoDistanceMatrix92FullDto geoDistanceMatrix92Dto) {
    }

    @Override
    protected void checkStaleByDto(GeoDistanceMatrix92FullDto geoDistanceMatrix92Dto) throws StaleStateException {
    }

    @Override
    public GeoDistanceMatrix92FullDto createDto() {
        Long id = this.getId();
        GeoDistanceMatrix92FullDto geoDistanceMatrix92Dto = id == null ? new GeoDistanceMatrix92FullDto(this.getTempUUID()) : new GeoDistanceMatrix92FullDto(id, this.getVersion());
        ImmutablePoint start = this.getStart();
        geoDistanceMatrix92Dto.setStart(ImmutablePointDto.create(start));
        ImmutablePoint target = this.getTarget();
        geoDistanceMatrix92Dto.setTarget(ImmutablePointDto.create(target));
        geoDistanceMatrix92Dto.setDistance(this.getDistance());
        geoDistanceMatrix92Dto.setDuration(this.getDuration());
        ImmutableLineString lineString = this.getLineString();
        geoDistanceMatrix92Dto.setLineString(ImmutableLineStringDto.create(lineString));
        geoDistanceMatrix92Dto.setRouteType(this.getRouteType());
        geoDistanceMatrix92Dto.setVehicleType(this.getVehicleType());
        return geoDistanceMatrix92Dto;
    }

    @Override
    public GeoDistanceMatrix92ProxyDto createProxy() {
        Long id = this.getId();
        GeoDistanceMatrix92ProxyDto geoDistanceMatrix92Dto = id == null ? new GeoDistanceMatrix92ProxyDto(this.getTempUUID()) : new GeoDistanceMatrix92ProxyDto(id, this.getVersion());
        return geoDistanceMatrix92Dto;
    }

    public static enum GeoDistanceMatrix92ModelEnum {
        START("start"),
        TARGET("target"),
        DISTANCE("distance"),
        DURATION("duration"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        VEHICLE_TYPE("vehicleType");

        private String propertyName;

        private GeoDistanceMatrix92ModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

