/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.distance;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.distance.GeoDistanceMatrix07Model;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix07FullDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix07ProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoDistanceMatrix07ModelImpl
extends AbstractModel<GeoDistanceMatrix07FullDto, GeoDistanceMatrix07ProxyDto>
implements GeoDistanceMatrix07Model {
    private ImmutablePoint start;
    private ImmutablePoint target;
    private Integer distance;
    private Integer duration;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType vehicleType;

    public GeoDistanceMatrix07ModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoDistanceMatrix07ModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.start;
    }

    @Override
    public void setStart(ImmutablePoint start) {
        this.setStart(start, true);
    }

    private void setStart(ImmutablePoint start, boolean setDirty) {
        ImmutablePoint oldStart = this.getStart();
        if (new EqualsBuilder().append(oldStart, start).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.START.getPropertyName());
        }
        this.start = start;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.START, start, oldStart);
    }

    @Override
    public ImmutablePoint getTarget() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.target;
    }

    @Override
    public void setTarget(ImmutablePoint target) {
        this.setTarget(target, true);
    }

    private void setTarget(ImmutablePoint target, boolean setDirty) {
        ImmutablePoint oldTarget = this.getTarget();
        if (new EqualsBuilder().append(oldTarget, target).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.TARGET.getPropertyName());
        }
        this.target = target;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.TARGET, target, oldTarget);
    }

    @Override
    public Integer getDistance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distance;
    }

    @Override
    public void setDistance(Integer distance) {
        this.setDistance(distance, true);
    }

    private void setDistance(Integer distance, boolean setDirty) {
        Integer oldDistance = this.getDistance();
        if (new EqualsBuilder().append(oldDistance, distance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.DISTANCE.getPropertyName());
        }
        this.distance = distance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.DISTANCE, distance, oldDistance);
    }

    @Override
    public Integer getDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.duration;
    }

    @Override
    public void setDuration(Integer duration) {
        this.setDuration(duration, true);
    }

    private void setDuration(Integer duration, boolean setDirty) {
        Integer oldDuration = this.getDuration();
        if (new EqualsBuilder().append(oldDuration, duration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.DURATION.getPropertyName());
        }
        this.duration = duration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.DURATION, duration, oldDuration);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicleType;
    }

    @Override
    public void setVehicleType(RouteVehicleType vehicleType) {
        this.setVehicleType(vehicleType, true);
    }

    private void setVehicleType(RouteVehicleType vehicleType, boolean setDirty) {
        RouteVehicleType oldVehicleType = this.getVehicleType();
        if (new EqualsBuilder().append((Object)oldVehicleType, (Object)vehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix07ModelEnum.VEHICLE_TYPE.getPropertyName());
        }
        this.vehicleType = vehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix07ModelEnum.VEHICLE_TYPE, (Object)vehicleType, (Object)oldVehicleType);
    }

    @Override
    protected void updateByDto(GeoDistanceMatrix07FullDto geoDistanceMatrix07Dto) {
        ImmutablePointDto start = geoDistanceMatrix07Dto.getStart();
        this.start = start == null ? null : (ImmutablePoint)start.getGeoObject();
        ImmutablePointDto target = geoDistanceMatrix07Dto.getTarget();
        this.target = target == null ? null : (ImmutablePoint)target.getGeoObject();
        this.distance = geoDistanceMatrix07Dto.getDistance();
        this.duration = geoDistanceMatrix07Dto.getDuration();
        ImmutableLineStringDto lineString = geoDistanceMatrix07Dto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = geoDistanceMatrix07Dto.getRouteType();
        this.vehicleType = geoDistanceMatrix07Dto.getVehicleType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoDistanceMatrix07FullDto geoDistanceMatrix07Dto) {
    }

    @Override
    protected void checkStaleByDto(GeoDistanceMatrix07FullDto geoDistanceMatrix07Dto) throws StaleStateException {
    }

    @Override
    public GeoDistanceMatrix07FullDto createDto() {
        Long id = this.getId();
        GeoDistanceMatrix07FullDto geoDistanceMatrix07Dto = id == null ? new GeoDistanceMatrix07FullDto(this.getTempUUID()) : new GeoDistanceMatrix07FullDto(id, this.getVersion());
        ImmutablePoint start = this.getStart();
        geoDistanceMatrix07Dto.setStart(ImmutablePointDto.create(start));
        ImmutablePoint target = this.getTarget();
        geoDistanceMatrix07Dto.setTarget(ImmutablePointDto.create(target));
        geoDistanceMatrix07Dto.setDistance(this.getDistance());
        geoDistanceMatrix07Dto.setDuration(this.getDuration());
        ImmutableLineString lineString = this.getLineString();
        geoDistanceMatrix07Dto.setLineString(ImmutableLineStringDto.create(lineString));
        geoDistanceMatrix07Dto.setRouteType(this.getRouteType());
        geoDistanceMatrix07Dto.setVehicleType(this.getVehicleType());
        return geoDistanceMatrix07Dto;
    }

    @Override
    public GeoDistanceMatrix07ProxyDto createProxy() {
        Long id = this.getId();
        GeoDistanceMatrix07ProxyDto geoDistanceMatrix07Dto = id == null ? new GeoDistanceMatrix07ProxyDto(this.getTempUUID()) : new GeoDistanceMatrix07ProxyDto(id, this.getVersion());
        return geoDistanceMatrix07Dto;
    }

    public static enum GeoDistanceMatrix07ModelEnum {
        START("start"),
        TARGET("target"),
        DISTANCE("distance"),
        DURATION("duration"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        VEHICLE_TYPE("vehicleType");

        private String propertyName;

        private GeoDistanceMatrix07ModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

