/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionSortOrderModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.base.SubscriptionSortOrderFullDto;
import de.datomino.peppergis.dto.base.SubscriptionSortOrderProxyDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SubscriptionSortOrderModelImpl
extends AbstractModel<SubscriptionSortOrderFullDto, SubscriptionSortOrderProxyDto>
implements SubscriptionSortOrderModel {
    private Integer value;
    private RouteVehicleType vehicle;
    private DeliveryRoundModel deliveryRound;
    private SubscriptionModel subscription;

    public SubscriptionSortOrderModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SubscriptionSortOrderModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, true);
    }

    private void setValue(Integer value, boolean setDirty) {
        Integer oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionSortOrderModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionSortOrderModelEnum.VALUE, value, oldValue);
    }

    @Override
    public RouteVehicleType getVehicle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicle;
    }

    @Override
    public void setVehicle(RouteVehicleType vehicle) {
        this.setVehicle(vehicle, true);
    }

    private void setVehicle(RouteVehicleType vehicle, boolean setDirty) {
        RouteVehicleType oldVehicle = this.getVehicle();
        if (new EqualsBuilder().append((Object)oldVehicle, (Object)vehicle).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionSortOrderModelEnum.VEHICLE.getPropertyName());
        }
        this.vehicle = vehicle;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionSortOrderModelEnum.VEHICLE, (Object)vehicle, (Object)oldVehicle);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionSortOrderModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionSortOrderModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public SubscriptionModel getSubscription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.subscription;
    }

    @Override
    public void setSubscription(SubscriptionModel subscription) {
        this.setSubscription(subscription, true);
    }

    private void setSubscription(SubscriptionModel subscription, boolean setDirty) {
        SubscriptionModel oldSubscription = this.getSubscription();
        if (oldSubscription == subscription) {
            return;
        }
        if (oldSubscription != null) {
            oldSubscription.removeSortOrder(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionSortOrderModelEnum.SUBSCRIPTION.getPropertyName());
        }
        this.subscription = subscription;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionSortOrderModelEnum.SUBSCRIPTION, subscription, oldSubscription);
        if (this.subscription != null) {
            this.subscription.addSortOrder(this);
        }
    }

    @Override
    protected void updateByDto(SubscriptionSortOrderFullDto subscriptionSortOrderDto) {
        this.value = subscriptionSortOrderDto.getValue();
        this.vehicle = subscriptionSortOrderDto.getVehicle();
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(subscriptionSortOrderDto.getDeliveryRound());
        this.subscription = (SubscriptionModel)this.getModelCache().getModel(subscriptionSortOrderDto.getSubscription());
    }

    @Override
    protected void updateMasterRelationsByDto(SubscriptionSortOrderFullDto subscriptionSortOrderDto) {
    }

    @Override
    protected void checkStaleByDto(SubscriptionSortOrderFullDto subscriptionSortOrderDto) throws StaleStateException {
        SubscriptionModelImpl subscriptionModel;
        SubscriptionDto subscriptionDto;
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = subscriptionSortOrderDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((subscriptionDto = subscriptionSortOrderDto.getSubscription()) != null && subscriptionDto.getId() != null && (subscriptionModel = (SubscriptionModelImpl)this.getModelCache().getModel(SubscriptionModel.class, subscriptionDto.getId())) != null) {
            subscriptionModel.checkStaleState(subscriptionDto);
        }
    }

    @Override
    public SubscriptionSortOrderFullDto createDto() {
        SubscriptionModelImpl subscription;
        Long id = this.getId();
        SubscriptionSortOrderFullDto subscriptionSortOrderDto = id == null ? new SubscriptionSortOrderFullDto(this.getTempUUID()) : new SubscriptionSortOrderFullDto(id, this.getVersion());
        subscriptionSortOrderDto.setValue(this.getValue());
        subscriptionSortOrderDto.setVehicle(this.getVehicle());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            subscriptionSortOrderDto.setDeliveryRound(deliveryRound.createProxy());
        }
        if ((subscription = (SubscriptionModelImpl)this.getSubscription()) != null) {
            subscriptionSortOrderDto.setSubscription(subscription.createProxy());
        }
        return subscriptionSortOrderDto;
    }

    @Override
    public SubscriptionSortOrderProxyDto createProxy() {
        Long id = this.getId();
        SubscriptionSortOrderProxyDto subscriptionSortOrderDto = id == null ? new SubscriptionSortOrderProxyDto(this.getTempUUID()) : new SubscriptionSortOrderProxyDto(id, this.getVersion());
        return subscriptionSortOrderDto;
    }

    public static enum SubscriptionSortOrderModelEnum {
        VALUE("value"),
        VEHICLE("vehicle"),
        DELIVERY_ROUND("deliveryRound"),
        SUBSCRIPTION("subscription");

        private String propertyName;

        private SubscriptionSortOrderModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

