/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionModelImpl;
import de.datomino.peppergis.dto.base.SubscriptionBreakTimeFullDto;
import de.datomino.peppergis.dto.base.SubscriptionBreakTimeProxyDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SubscriptionBreakTimeModelImpl
extends AbstractModel<SubscriptionBreakTimeFullDto, SubscriptionBreakTimeProxyDto>
implements SubscriptionBreakTimeModel {
    private Date startDate;
    private Date endDate;
    private SubscriptionModel subscription;
    private SubscriptionModel lendSubscription;

    public SubscriptionBreakTimeModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SubscriptionBreakTimeModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Date getStartDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.setStartDate(startDate, true);
    }

    private void setStartDate(Date startDate, boolean setDirty) {
        Date oldStartDate = this.getStartDate();
        if (new EqualsBuilder().append(oldStartDate, startDate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionBreakTimeModelEnum.START_DATE.getPropertyName());
        }
        this.startDate = startDate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionBreakTimeModelEnum.START_DATE, startDate, oldStartDate);
    }

    @Override
    public Date getEndDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.setEndDate(endDate, true);
    }

    private void setEndDate(Date endDate, boolean setDirty) {
        Date oldEndDate = this.getEndDate();
        if (new EqualsBuilder().append(oldEndDate, endDate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionBreakTimeModelEnum.END_DATE.getPropertyName());
        }
        this.endDate = endDate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionBreakTimeModelEnum.END_DATE, endDate, oldEndDate);
    }

    @Override
    public SubscriptionModel getSubscription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.subscription;
    }

    @Override
    public void setSubscription(SubscriptionModel subscription) {
        this.setSubscription(subscription, true);
    }

    private void setSubscription(SubscriptionModel subscription, boolean setDirty) {
        SubscriptionModel oldSubscription = this.getSubscription();
        if (oldSubscription == subscription) {
            return;
        }
        if (oldSubscription != null) {
            oldSubscription.removeBreakTime(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionBreakTimeModelEnum.SUBSCRIPTION.getPropertyName());
        }
        this.subscription = subscription;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionBreakTimeModelEnum.SUBSCRIPTION, subscription, oldSubscription);
        if (this.subscription != null) {
            this.subscription.addBreakTime(this);
        }
    }

    @Override
    public SubscriptionModel getLendSubscription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lendSubscription;
    }

    @Override
    public void setLendSubscription(SubscriptionModel lendSubscription) {
        this.setLendSubscription(lendSubscription, true);
    }

    private void setLendSubscription(SubscriptionModel lendSubscription, boolean setDirty) {
        SubscriptionModel oldLendSubscription = this.getLendSubscription();
        if (oldLendSubscription == lendSubscription) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionBreakTimeModelEnum.LEND_SUBSCRIPTION.getPropertyName());
        }
        this.lendSubscription = lendSubscription;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionBreakTimeModelEnum.LEND_SUBSCRIPTION, lendSubscription, oldLendSubscription);
    }

    @Override
    protected void updateByDto(SubscriptionBreakTimeFullDto subscriptionBreakTimeDto) {
        this.startDate = subscriptionBreakTimeDto.getStartDate();
        this.endDate = subscriptionBreakTimeDto.getEndDate();
        this.subscription = (SubscriptionModel)this.getModelCache().getModel(subscriptionBreakTimeDto.getSubscription());
        this.lendSubscription = (SubscriptionModel)this.getModelCache().getModel(subscriptionBreakTimeDto.getLendSubscription());
    }

    @Override
    protected void updateMasterRelationsByDto(SubscriptionBreakTimeFullDto subscriptionBreakTimeDto) {
    }

    @Override
    protected void checkStaleByDto(SubscriptionBreakTimeFullDto subscriptionBreakTimeDto) throws StaleStateException {
        SubscriptionModelImpl lendSubscriptionModel;
        SubscriptionDto lendSubscriptionDto;
        SubscriptionModelImpl subscriptionModel;
        SubscriptionDto subscriptionDto = subscriptionBreakTimeDto.getSubscription();
        if (subscriptionDto != null && subscriptionDto.getId() != null && (subscriptionModel = (SubscriptionModelImpl)this.getModelCache().getModel(SubscriptionModel.class, subscriptionDto.getId())) != null) {
            subscriptionModel.checkStaleState(subscriptionDto);
        }
        if ((lendSubscriptionDto = subscriptionBreakTimeDto.getLendSubscription()) != null && lendSubscriptionDto.getId() != null && (lendSubscriptionModel = (SubscriptionModelImpl)this.getModelCache().getModel(SubscriptionModel.class, lendSubscriptionDto.getId())) != null) {
            lendSubscriptionModel.checkStaleState(lendSubscriptionDto);
        }
    }

    @Override
    public SubscriptionBreakTimeFullDto createDto() {
        SubscriptionModelImpl lendSubscription;
        Long id = this.getId();
        SubscriptionBreakTimeFullDto subscriptionBreakTimeDto = id == null ? new SubscriptionBreakTimeFullDto(this.getTempUUID()) : new SubscriptionBreakTimeFullDto(id, this.getVersion());
        subscriptionBreakTimeDto.setStartDate(this.getStartDate());
        subscriptionBreakTimeDto.setEndDate(this.getEndDate());
        SubscriptionModelImpl subscription = (SubscriptionModelImpl)this.getSubscription();
        if (subscription != null) {
            subscriptionBreakTimeDto.setSubscription(subscription.createProxy());
        }
        if ((lendSubscription = (SubscriptionModelImpl)this.getLendSubscription()) != null) {
            subscriptionBreakTimeDto.setLendSubscription(lendSubscription.createProxy());
        }
        return subscriptionBreakTimeDto;
    }

    @Override
    public SubscriptionBreakTimeProxyDto createProxy() {
        Long id = this.getId();
        SubscriptionBreakTimeProxyDto subscriptionBreakTimeDto = id == null ? new SubscriptionBreakTimeProxyDto(this.getTempUUID()) : new SubscriptionBreakTimeProxyDto(id, this.getVersion());
        return subscriptionBreakTimeDto;
    }

    public static enum SubscriptionBreakTimeModelEnum {
        START_DATE("startDate"),
        END_DATE("endDate"),
        SUBSCRIPTION("subscription"),
        LEND_SUBSCRIPTION("lendSubscription");

        private String propertyName;

        private SubscriptionBreakTimeModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

