/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceModelImpl;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModelImpl;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.ServiceDto;
import de.datomino.peppergis.dto.base.ServiceTicketFullDto;
import de.datomino.peppergis.dto.base.ServiceTicketProxyDto;
import de.datomino.peppergis.dto.tour.ServiceTicketStopRelationDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ServiceTicketModelImpl
extends AbstractModel<ServiceTicketFullDto, ServiceTicketProxyDto>
implements ServiceTicketModel {
    private String name;
    private Date incomingTime;
    private ServiceModel service;
    private Set<ServiceTicketStopRelationModel> serviceTicketStopRelation = null;
    private CustomerModel customer;
    private Integer autoServicePerimeter;

    public ServiceTicketModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ServiceTicketModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketModelEnum.NAME, name, oldName);
    }

    @Override
    public Date getIncomingTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.incomingTime;
    }

    @Override
    public void setIncomingTime(Date incomingTime) {
        this.setIncomingTime(incomingTime, true);
    }

    private void setIncomingTime(Date incomingTime, boolean setDirty) {
        Date oldIncomingTime = this.getIncomingTime();
        if (new EqualsBuilder().append(oldIncomingTime, incomingTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketModelEnum.INCOMING_TIME.getPropertyName());
        }
        this.incomingTime = incomingTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketModelEnum.INCOMING_TIME, incomingTime, oldIncomingTime);
    }

    @Override
    public ServiceModel getService() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.service;
    }

    @Override
    public void setService(ServiceModel service) {
        this.setService(service, true);
    }

    private void setService(ServiceModel service, boolean setDirty) {
        ServiceModel oldService = this.getService();
        if (oldService == service) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketModelEnum.SERVICE.getPropertyName());
        }
        this.service = service;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketModelEnum.SERVICE, service, oldService);
    }

    @Override
    public int countServiceTicketStopRelation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        return this.serviceTicketStopRelation.size();
    }

    @Override
    public Iterator<ServiceTicketStopRelationModel> iterateServiceTicketStopRelation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        return new ImmutableIterator<ServiceTicketStopRelationModel>(this.serviceTicketStopRelation);
    }

    @Override
    public Iterable<ServiceTicketStopRelationModel> iterableServiceTicketStopRelation() {
        return new IteratorIterable<ServiceTicketStopRelationModel>(this.iterateServiceTicketStopRelation());
    }

    @Override
    public void addAServiceTicketStopRelation(ServiceTicketStopRelationModel aServiceTicketStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        if (this.serviceTicketStopRelation.contains(aServiceTicketStopRelation)) {
            return;
        }
        this.serviceTicketStopRelation.add(aServiceTicketStopRelation);
        this.fireValueChanged(ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION, aServiceTicketStopRelation, null);
        if (aServiceTicketStopRelation != null) {
            aServiceTicketStopRelation.setServiceTicket(this);
        }
    }

    @Override
    public void removeAServiceTicketStopRelation(ServiceTicketStopRelationModel aServiceTicketStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        if (!this.serviceTicketStopRelation.contains(aServiceTicketStopRelation)) {
            return;
        }
        this.serviceTicketStopRelation.remove(aServiceTicketStopRelation);
        this.fireValueChanged(ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION, aServiceTicketStopRelation, null);
        if (aServiceTicketStopRelation != null) {
            aServiceTicketStopRelation.setServiceTicket(null);
        }
    }

    @Override
    public void clearServiceTicketStopRelation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        ArrayList<ServiceTicketStopRelationModel> oldServiceTicketStopRelation = new ArrayList<ServiceTicketStopRelationModel>(this.serviceTicketStopRelation);
        this.serviceTicketStopRelation.clear();
        this.fireValueChanged(ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION, null, null);
        for (ServiceTicketStopRelationModel oldAServiceTicketStopRelation : oldServiceTicketStopRelation) {
            if (oldAServiceTicketStopRelation == null) continue;
            oldAServiceTicketStopRelation.setServiceTicket(null);
        }
    }

    @Override
    public boolean isServiceTicketStopRelationEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        return this.serviceTicketStopRelation.isEmpty();
    }

    @Override
    public boolean containsAServiceTicketStopRelation(ServiceTicketStopRelationModel aServiceTicketStopRelation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTicketStopRelation == null) {
            this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            if (this.getId() != null) {
                Collection serviceTicketStopRelationCollection = this.commonCaller.fetchChildren(this, ServiceTicketModelEnum.SERVICE_TICKET_STOP_RELATION.getPropertyName());
                this.serviceTicketStopRelation.addAll(serviceTicketStopRelationCollection);
            }
        }
        return this.serviceTicketStopRelation.contains(aServiceTicketStopRelation);
    }

    @Override
    public boolean isServiceTicketStopRelationInitialized() {
        return this.serviceTicketStopRelation != null;
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removeServiceTicket(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addServiceTicket(this);
        }
    }

    @Override
    public Integer getAutoServicePerimeter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.autoServicePerimeter;
    }

    @Override
    public void setAutoServicePerimeter(Integer autoServicePerimeter) {
        this.setAutoServicePerimeter(autoServicePerimeter, true);
    }

    private void setAutoServicePerimeter(Integer autoServicePerimeter, boolean setDirty) {
        Integer oldAutoServicePerimeter = this.getAutoServicePerimeter();
        if (new EqualsBuilder().append(oldAutoServicePerimeter, autoServicePerimeter).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceTicketModelEnum.AUTO_SERVICE_PERIMETER.getPropertyName());
        }
        this.autoServicePerimeter = autoServicePerimeter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceTicketModelEnum.AUTO_SERVICE_PERIMETER, autoServicePerimeter, oldAutoServicePerimeter);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.serviceTicketStopRelation = null;
        }
    }

    @Override
    protected void updateByDto(ServiceTicketFullDto serviceTicketDto) {
        this.name = serviceTicketDto.getName();
        this.incomingTime = serviceTicketDto.getIncomingTime();
        this.service = (ServiceModel)this.getModelCache().getModel(serviceTicketDto.getService());
        ServiceTicketStopRelationDto[] serviceTicketStopRelation = serviceTicketDto.getServiceTicketStopRelation();
        if (serviceTicketStopRelation != null) {
            if (this.serviceTicketStopRelation == null) {
                this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            } else {
                this.serviceTicketStopRelation.clear();
            }
        }
        this.customer = (CustomerModel)this.getModelCache().getModel(serviceTicketDto.getCustomer());
        this.autoServicePerimeter = serviceTicketDto.getAutoServicePerimeter();
    }

    @Override
    protected void updateMasterRelationsByDto(ServiceTicketFullDto serviceTicketDto) {
        ServiceTicketStopRelationDto[] serviceTicketStopRelation = serviceTicketDto.getServiceTicketStopRelation();
        if (serviceTicketStopRelation != null) {
            if (this.serviceTicketStopRelation == null) {
                this.serviceTicketStopRelation = new LinkedHashSet<ServiceTicketStopRelationModel>();
            } else {
                this.serviceTicketStopRelation.clear();
            }
            for (ServiceTicketStopRelationDto aServiceTicketStopRelationDto : serviceTicketStopRelation) {
                ServiceTicketStopRelationModel aServiceTicketStopRelationModel = (ServiceTicketStopRelationModel)this.getModelCache().getModel(aServiceTicketStopRelationDto);
                this.serviceTicketStopRelation.add(aServiceTicketStopRelationModel);
            }
        } else {
            this.serviceTicketStopRelation = null;
        }
    }

    @Override
    protected void checkStaleByDto(ServiceTicketFullDto serviceTicketDto) throws StaleStateException {
        CustomerModelImpl customerModel;
        CustomerDto customerDto;
        ServiceTicketStopRelationDto[] aServiceTicketStopRelationDtos;
        ServiceModelImpl serviceModel;
        ServiceDto serviceDto = serviceTicketDto.getService();
        if (serviceDto != null && serviceDto.getId() != null && (serviceModel = (ServiceModelImpl)this.getModelCache().getModel(ServiceModel.class, serviceDto.getId())) != null) {
            serviceModel.checkStaleState(serviceDto);
        }
        if ((aServiceTicketStopRelationDtos = serviceTicketDto.getServiceTicketStopRelation()) != null) {
            for (ServiceTicketStopRelationDto aServiceTicketStopRelationDto : aServiceTicketStopRelationDtos) {
                ServiceTicketStopRelationModelImpl aServiceTicketStopRelationModel = (ServiceTicketStopRelationModelImpl)this.getModelCache().getModel(ServiceTicketStopRelationModel.class, aServiceTicketStopRelationDto.getId());
                if (aServiceTicketStopRelationModel == null) continue;
                aServiceTicketStopRelationModel.checkStaleState(aServiceTicketStopRelationDto);
            }
        }
        if ((customerDto = serviceTicketDto.getCustomer()) != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
    }

    @Override
    public ServiceTicketFullDto createDto() {
        CustomerModelImpl customer;
        Long id = this.getId();
        ServiceTicketFullDto serviceTicketDto = id == null ? new ServiceTicketFullDto(this.getTempUUID()) : new ServiceTicketFullDto(id, this.getVersion());
        serviceTicketDto.setName(this.getName());
        serviceTicketDto.setIncomingTime(this.getIncomingTime());
        ServiceModelImpl service = (ServiceModelImpl)this.getService();
        if (service != null) {
            serviceTicketDto.setService(service.createProxy());
        }
        if ((customer = (CustomerModelImpl)this.getCustomer()) != null) {
            serviceTicketDto.setCustomer(customer.createProxy());
        }
        serviceTicketDto.setAutoServicePerimeter(this.getAutoServicePerimeter());
        return serviceTicketDto;
    }

    @Override
    public ServiceTicketProxyDto createProxy() {
        Long id = this.getId();
        ServiceTicketProxyDto serviceTicketDto = id == null ? new ServiceTicketProxyDto(this.getTempUUID()) : new ServiceTicketProxyDto(id, this.getVersion());
        return serviceTicketDto;
    }

    public static enum ServiceTicketModelEnum {
        NAME("name"),
        INCOMING_TIME("incomingTime"),
        SERVICE("service"),
        SERVICE_TICKET_STOP_RELATION("serviceTicketStopRelation"),
        CUSTOMER("customer"),
        AUTO_SERVICE_PERIMETER("autoServicePerimeter");

        private String propertyName;

        private ServiceTicketModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

