/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceStatusConfigurationModel;
import de.datomino.peppergis.client.model.base.ServiceStatusConfigurationModelImpl;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModelImpl;
import de.datomino.peppergis.dto.base.ServiceFullDto;
import de.datomino.peppergis.dto.base.ServiceProxyDto;
import de.datomino.peppergis.dto.base.ServiceStatusConfigurationDto;
import de.datomino.peppergis.dto.base.ServiceValueDescriptorDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ServiceModelImpl
extends AbstractModel<ServiceFullDto, ServiceProxyDto>
implements ServiceModel {
    private String serviceNumber;
    private String name;
    private String description;
    private String mobileInputMaskXml;
    private List<ServiceValueDescriptorModel> serviceValueDescriptors = null;
    private Set<ServiceStatusConfigurationModel> serviceStatusConfigurations = null;
    private Integer autoServicePerimeter;
    private Integer autoMinGpsDuration;

    public ServiceModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ServiceModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getServiceNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.serviceNumber;
    }

    @Override
    public void setServiceNumber(String serviceNumber) {
        this.setServiceNumber(serviceNumber, true);
    }

    private void setServiceNumber(String serviceNumber, boolean setDirty) {
        String oldServiceNumber = this.getServiceNumber();
        if (new EqualsBuilder().append(oldServiceNumber, serviceNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.SERVICE_NUMBER.getPropertyName());
        }
        this.serviceNumber = serviceNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.SERVICE_NUMBER, serviceNumber, oldServiceNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.NAME, name, oldName);
    }

    @Override
    public String getDescription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(description, true);
    }

    private void setDescription(String description, boolean setDirty) {
        String oldDescription = this.getDescription();
        if (new EqualsBuilder().append(oldDescription, description).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.DESCRIPTION.getPropertyName());
        }
        this.description = description;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.DESCRIPTION, description, oldDescription);
    }

    @Override
    public String getMobileInputMaskXml() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileInputMaskXml;
    }

    @Override
    public void setMobileInputMaskXml(String mobileInputMaskXml) {
        this.setMobileInputMaskXml(mobileInputMaskXml, true);
    }

    private void setMobileInputMaskXml(String mobileInputMaskXml, boolean setDirty) {
        String oldMobileInputMaskXml = this.getMobileInputMaskXml();
        if (new EqualsBuilder().append(oldMobileInputMaskXml, mobileInputMaskXml).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.MOBILE_INPUT_MASK_XML.getPropertyName());
        }
        this.mobileInputMaskXml = mobileInputMaskXml;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.MOBILE_INPUT_MASK_XML, mobileInputMaskXml, oldMobileInputMaskXml);
    }

    @Override
    public int countServiceValueDescriptors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return this.serviceValueDescriptors.size();
    }

    @Override
    public Iterator<ServiceValueDescriptorModel> iterateServiceValueDescriptors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return new ImmutableIterator<ServiceValueDescriptorModel>(this.serviceValueDescriptors);
    }

    @Override
    public Iterable<ServiceValueDescriptorModel> iterableServiceValueDescriptors() {
        return new IteratorIterable<ServiceValueDescriptorModel>(this.iterateServiceValueDescriptors());
    }

    @Override
    public void addServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        if (this.serviceValueDescriptors.contains(serviceValueDescriptor)) {
            return;
        }
        this.serviceValueDescriptors.add(serviceValueDescriptor);
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, serviceValueDescriptor, null);
        if (serviceValueDescriptor != null) {
            serviceValueDescriptor.setService(this);
            serviceValueDescriptor.setSortOrder(this.serviceValueDescriptors.size() - 1);
        }
    }

    @Override
    public void removeServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        if (!this.serviceValueDescriptors.contains(serviceValueDescriptor)) {
            return;
        }
        this.serviceValueDescriptors.remove(serviceValueDescriptor);
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, serviceValueDescriptor, null);
        if (serviceValueDescriptor != null) {
            serviceValueDescriptor.setService(null);
            serviceValueDescriptor.setSortOrder(null);
        }
        this.reorderServiceValueDescriptors(0);
    }

    @Override
    public ServiceValueDescriptorModel getServiceValueDescriptorAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return this.serviceValueDescriptors.get(index);
    }

    @Override
    public void insertServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        if (this.serviceValueDescriptors.contains(serviceValueDescriptor)) {
            this.removeServiceValueDescriptor(serviceValueDescriptor);
        }
        this.serviceValueDescriptors.add(index, serviceValueDescriptor);
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, serviceValueDescriptor, null);
        if (serviceValueDescriptor != null) {
            serviceValueDescriptor.setService(this);
        }
        this.reorderServiceValueDescriptors(index);
    }

    @Override
    public void removeServiceValueDescriptorAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        ServiceValueDescriptorModel oldServiceValueDescriptor = this.serviceValueDescriptors.get(index);
        this.serviceValueDescriptors.remove(index);
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, oldServiceValueDescriptor, null);
        if (oldServiceValueDescriptor != null) {
            oldServiceValueDescriptor.setService(null);
            oldServiceValueDescriptor.setSortOrder(null);
        }
        this.reorderServiceValueDescriptors(index);
    }

    @Override
    public void setServiceValueDescriptorAt(ServiceValueDescriptorModel serviceValueDescriptor, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        ServiceValueDescriptorModel oldServiceValueDescriptor = this.serviceValueDescriptors.get(index);
        this.serviceValueDescriptors.set(index, serviceValueDescriptor);
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, serviceValueDescriptor, oldServiceValueDescriptor);
        if (oldServiceValueDescriptor != null) {
            oldServiceValueDescriptor.setService(null);
            oldServiceValueDescriptor.setSortOrder(null);
        }
        if (serviceValueDescriptor != null) {
            serviceValueDescriptor.setService(this);
            serviceValueDescriptor.setSortOrder(index);
        }
    }

    @Override
    public void clearServiceValueDescriptors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        ArrayList<ServiceValueDescriptorModel> oldServiceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>(this.serviceValueDescriptors);
        this.serviceValueDescriptors.clear();
        this.fireValueChanged(ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS, null, null);
        for (ServiceValueDescriptorModel oldServiceValueDescriptor : oldServiceValueDescriptors) {
            if (oldServiceValueDescriptor == null) continue;
            oldServiceValueDescriptor.setService(null);
            oldServiceValueDescriptor.setSortOrder(null);
        }
    }

    @Override
    public boolean isServiceValueDescriptorsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return this.serviceValueDescriptors.isEmpty();
    }

    @Override
    public boolean containsServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return this.serviceValueDescriptors.contains(serviceValueDescriptor);
    }

    @Override
    public int indexOfServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        return this.serviceValueDescriptors.indexOf(serviceValueDescriptor);
    }

    @Override
    public boolean isServiceValueDescriptorsInitialized() {
        return this.serviceValueDescriptors != null;
    }

    private void reorderServiceValueDescriptors(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceValueDescriptors == null) {
            this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            if (this.getId() != null) {
                Collection serviceValueDescriptorsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_VALUE_DESCRIPTORS.getPropertyName());
                this.serviceValueDescriptors.addAll(serviceValueDescriptorsCollection);
            }
        }
        ListIterator<ServiceValueDescriptorModel> listIterator = this.serviceValueDescriptors.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            ServiceValueDescriptorModel serviceValueDescriptor = listIterator.next();
            serviceValueDescriptor.setSortOrder(index++);
        }
    }

    @Override
    public int countServiceStatusConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        return this.serviceStatusConfigurations.size();
    }

    @Override
    public Iterator<ServiceStatusConfigurationModel> iterateServiceStatusConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        return new ImmutableIterator<ServiceStatusConfigurationModel>(this.serviceStatusConfigurations);
    }

    @Override
    public Iterable<ServiceStatusConfigurationModel> iterableServiceStatusConfigurations() {
        return new IteratorIterable<ServiceStatusConfigurationModel>(this.iterateServiceStatusConfigurations());
    }

    @Override
    public void addServiceStatusConfiguration(ServiceStatusConfigurationModel serviceStatusConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        if (this.serviceStatusConfigurations.contains(serviceStatusConfiguration)) {
            return;
        }
        this.serviceStatusConfigurations.add(serviceStatusConfiguration);
        this.fireValueChanged(ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS, serviceStatusConfiguration, null);
        if (serviceStatusConfiguration != null) {
            serviceStatusConfiguration.setService(this);
        }
    }

    @Override
    public void removeServiceStatusConfiguration(ServiceStatusConfigurationModel serviceStatusConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        if (!this.serviceStatusConfigurations.contains(serviceStatusConfiguration)) {
            return;
        }
        this.serviceStatusConfigurations.remove(serviceStatusConfiguration);
        this.fireValueChanged(ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS, serviceStatusConfiguration, null);
        if (serviceStatusConfiguration != null) {
            serviceStatusConfiguration.setService(null);
        }
    }

    @Override
    public void clearServiceStatusConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        ArrayList<ServiceStatusConfigurationModel> oldServiceStatusConfigurations = new ArrayList<ServiceStatusConfigurationModel>(this.serviceStatusConfigurations);
        this.serviceStatusConfigurations.clear();
        this.fireValueChanged(ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS, null, null);
        for (ServiceStatusConfigurationModel oldServiceStatusConfiguration : oldServiceStatusConfigurations) {
            if (oldServiceStatusConfiguration == null) continue;
            oldServiceStatusConfiguration.setService(null);
        }
    }

    @Override
    public boolean isServiceStatusConfigurationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        return this.serviceStatusConfigurations.isEmpty();
    }

    @Override
    public boolean containsServiceStatusConfiguration(ServiceStatusConfigurationModel serviceStatusConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusConfigurations == null) {
            this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceModelEnum.SERVICE_STATUS_CONFIGURATIONS.getPropertyName());
                this.serviceStatusConfigurations.addAll(serviceStatusConfigurationsCollection);
            }
        }
        return this.serviceStatusConfigurations.contains(serviceStatusConfiguration);
    }

    @Override
    public boolean isServiceStatusConfigurationsInitialized() {
        return this.serviceStatusConfigurations != null;
    }

    @Override
    public Integer getAutoServicePerimeter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.autoServicePerimeter;
    }

    @Override
    public void setAutoServicePerimeter(Integer autoServicePerimeter) {
        this.setAutoServicePerimeter(autoServicePerimeter, true);
    }

    private void setAutoServicePerimeter(Integer autoServicePerimeter, boolean setDirty) {
        Integer oldAutoServicePerimeter = this.getAutoServicePerimeter();
        if (new EqualsBuilder().append(oldAutoServicePerimeter, autoServicePerimeter).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.AUTO_SERVICE_PERIMETER.getPropertyName());
        }
        this.autoServicePerimeter = autoServicePerimeter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.AUTO_SERVICE_PERIMETER, autoServicePerimeter, oldAutoServicePerimeter);
    }

    @Override
    public Integer getAutoMinGpsDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.autoMinGpsDuration;
    }

    @Override
    public void setAutoMinGpsDuration(Integer autoMinGpsDuration) {
        this.setAutoMinGpsDuration(autoMinGpsDuration, true);
    }

    private void setAutoMinGpsDuration(Integer autoMinGpsDuration, boolean setDirty) {
        Integer oldAutoMinGpsDuration = this.getAutoMinGpsDuration();
        if (new EqualsBuilder().append(oldAutoMinGpsDuration, autoMinGpsDuration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceModelEnum.AUTO_MIN_GPS_DURATION.getPropertyName());
        }
        this.autoMinGpsDuration = autoMinGpsDuration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceModelEnum.AUTO_MIN_GPS_DURATION, autoMinGpsDuration, oldAutoMinGpsDuration);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.serviceValueDescriptors = null;
            this.serviceStatusConfigurations = null;
        }
    }

    @Override
    protected void updateByDto(ServiceFullDto serviceDto) {
        ServiceStatusConfigurationDto[] serviceStatusConfigurations;
        this.serviceNumber = serviceDto.getServiceNumber();
        this.name = serviceDto.getName();
        this.description = serviceDto.getDescription();
        this.mobileInputMaskXml = serviceDto.getMobileInputMaskXml();
        ServiceValueDescriptorDto[] serviceValueDescriptors = serviceDto.getServiceValueDescriptors();
        if (serviceValueDescriptors != null) {
            if (this.serviceValueDescriptors == null) {
                this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            } else {
                this.serviceValueDescriptors.clear();
            }
        }
        if ((serviceStatusConfigurations = serviceDto.getServiceStatusConfigurations()) != null) {
            if (this.serviceStatusConfigurations == null) {
                this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            } else {
                this.serviceStatusConfigurations.clear();
            }
        }
        this.autoServicePerimeter = serviceDto.getAutoServicePerimeter();
        this.autoMinGpsDuration = serviceDto.getAutoMinGpsDuration();
    }

    @Override
    protected void updateMasterRelationsByDto(ServiceFullDto serviceDto) {
        ServiceStatusConfigurationDto[] serviceStatusConfigurations;
        ServiceValueDescriptorDto[] serviceValueDescriptors = serviceDto.getServiceValueDescriptors();
        if (serviceValueDescriptors != null) {
            if (this.serviceValueDescriptors == null) {
                this.serviceValueDescriptors = new ArrayList<ServiceValueDescriptorModel>();
            } else {
                this.serviceValueDescriptors.clear();
            }
            for (ServiceValueDescriptorDto serviceValueDescriptorDto : serviceValueDescriptors) {
                ServiceValueDescriptorModel serviceValueDescriptorModel = (ServiceValueDescriptorModel)this.getModelCache().getModel(serviceValueDescriptorDto);
                this.serviceValueDescriptors.add(serviceValueDescriptorModel);
            }
        } else {
            this.serviceValueDescriptors = null;
        }
        if ((serviceStatusConfigurations = serviceDto.getServiceStatusConfigurations()) != null) {
            if (this.serviceStatusConfigurations == null) {
                this.serviceStatusConfigurations = new LinkedHashSet<ServiceStatusConfigurationModel>();
            } else {
                this.serviceStatusConfigurations.clear();
            }
            for (ServiceStatusConfigurationDto serviceStatusConfigurationDto : serviceStatusConfigurations) {
                ServiceStatusConfigurationModel serviceStatusConfigurationModel = (ServiceStatusConfigurationModel)this.getModelCache().getModel(serviceStatusConfigurationDto);
                this.serviceStatusConfigurations.add(serviceStatusConfigurationModel);
            }
        } else {
            this.serviceStatusConfigurations = null;
        }
    }

    @Override
    protected void checkStaleByDto(ServiceFullDto serviceDto) throws StaleStateException {
        ServiceStatusConfigurationDto[] serviceStatusConfigurationDtos;
        ServiceValueDescriptorDto[] serviceValueDescriptorDtos = serviceDto.getServiceValueDescriptors();
        if (serviceValueDescriptorDtos != null) {
            for (ServiceValueDescriptorDto serviceValueDescriptorDto : serviceValueDescriptorDtos) {
                ServiceValueDescriptorModelImpl serviceValueDescriptorModel = (ServiceValueDescriptorModelImpl)this.getModelCache().getModel(ServiceValueDescriptorModel.class, serviceValueDescriptorDto.getId());
                if (serviceValueDescriptorModel == null) continue;
                serviceValueDescriptorModel.checkStaleState(serviceValueDescriptorDto);
            }
        }
        if ((serviceStatusConfigurationDtos = serviceDto.getServiceStatusConfigurations()) != null) {
            for (ServiceStatusConfigurationDto serviceStatusConfigurationDto : serviceStatusConfigurationDtos) {
                ServiceStatusConfigurationModelImpl serviceStatusConfigurationModel = (ServiceStatusConfigurationModelImpl)this.getModelCache().getModel(ServiceStatusConfigurationModel.class, serviceStatusConfigurationDto.getId());
                if (serviceStatusConfigurationModel == null) continue;
                serviceStatusConfigurationModel.checkStaleState(serviceStatusConfigurationDto);
            }
        }
    }

    @Override
    public ServiceFullDto createDto() {
        Long id = this.getId();
        ServiceFullDto serviceDto = id == null ? new ServiceFullDto(this.getTempUUID()) : new ServiceFullDto(id, this.getVersion());
        serviceDto.setServiceNumber(this.getServiceNumber());
        serviceDto.setName(this.getName());
        serviceDto.setDescription(this.getDescription());
        serviceDto.setMobileInputMaskXml(this.getMobileInputMaskXml());
        serviceDto.setAutoServicePerimeter(this.getAutoServicePerimeter());
        serviceDto.setAutoMinGpsDuration(this.getAutoMinGpsDuration());
        return serviceDto;
    }

    @Override
    public ServiceProxyDto createProxy() {
        Long id = this.getId();
        ServiceProxyDto serviceDto = id == null ? new ServiceProxyDto(this.getTempUUID()) : new ServiceProxyDto(id, this.getVersion());
        return serviceDto;
    }

    public static enum ServiceModelEnum {
        SERVICE_NUMBER("serviceNumber"),
        NAME("name"),
        DESCRIPTION("description"),
        MOBILE_INPUT_MASK_XML("mobileInputMaskXml"),
        SERVICE_VALUE_DESCRIPTORS("serviceValueDescriptors"),
        SERVICE_STATUS_CONFIGURATIONS("serviceStatusConfigurations"),
        AUTO_SERVICE_PERIMETER("autoServicePerimeter"),
        AUTO_MIN_GPS_DURATION("autoMinGpsDuration");

        private String propertyName;

        private ServiceModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

