/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.PrintParameterModel;
import de.datomino.peppergis.dto.base.PrintParameterFullDto;
import de.datomino.peppergis.dto.base.PrintParameterProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.PrintObject;
import de.datomino.peppergis.type.PrintParameterKey;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PrintParameterModelImpl
extends AbstractModel<PrintParameterFullDto, PrintParameterProxyDto>
implements PrintParameterModel {
    private PrintObject printObject;
    private PrintParameterKey key;
    private String stringValue;
    private Integer integerValue;
    private Double floatValue;
    private Boolean booleanValue;

    public PrintParameterModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PrintParameterModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public PrintObject getPrintObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printObject;
    }

    @Override
    public void setPrintObject(PrintObject printObject) {
        this.setPrintObject(printObject, true);
    }

    private void setPrintObject(PrintObject printObject, boolean setDirty) {
        PrintObject oldPrintObject = this.getPrintObject();
        if (new EqualsBuilder().append((Object)oldPrintObject, (Object)printObject).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.PRINT_OBJECT.getPropertyName());
        }
        this.printObject = printObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.PRINT_OBJECT, (Object)printObject, (Object)oldPrintObject);
    }

    @Override
    public PrintParameterKey getKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.key;
    }

    @Override
    public void setKey(PrintParameterKey key) {
        this.setKey(key, true);
    }

    private void setKey(PrintParameterKey key, boolean setDirty) {
        PrintParameterKey oldKey = this.getKey();
        if (new EqualsBuilder().append(oldKey, key).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.KEY.getPropertyName());
        }
        this.key = key;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.KEY, key, oldKey);
    }

    @Override
    public String getStringValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stringValue;
    }

    @Override
    public void setStringValue(String stringValue) {
        this.setStringValue(stringValue, true);
    }

    private void setStringValue(String stringValue, boolean setDirty) {
        String oldStringValue = this.getStringValue();
        if (new EqualsBuilder().append(oldStringValue, stringValue).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.STRING_VALUE.getPropertyName());
        }
        this.stringValue = stringValue;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.STRING_VALUE, stringValue, oldStringValue);
    }

    @Override
    public Integer getIntegerValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.integerValue;
    }

    @Override
    public void setIntegerValue(Integer integerValue) {
        this.setIntegerValue(integerValue, true);
    }

    private void setIntegerValue(Integer integerValue, boolean setDirty) {
        Integer oldIntegerValue = this.getIntegerValue();
        if (new EqualsBuilder().append(oldIntegerValue, integerValue).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.INTEGER_VALUE.getPropertyName());
        }
        this.integerValue = integerValue;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.INTEGER_VALUE, integerValue, oldIntegerValue);
    }

    @Override
    public Double getFloatValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.floatValue;
    }

    @Override
    public void setFloatValue(Double floatValue) {
        this.setFloatValue(floatValue, true);
    }

    private void setFloatValue(Double floatValue, boolean setDirty) {
        Double oldFloatValue = this.getFloatValue();
        if (new EqualsBuilder().append(oldFloatValue, floatValue).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.FLOAT_VALUE.getPropertyName());
        }
        this.floatValue = floatValue;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.FLOAT_VALUE, floatValue, oldFloatValue);
    }

    @Override
    public Boolean getBooleanValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.booleanValue;
    }

    @Override
    public void setBooleanValue(Boolean booleanValue) {
        this.setBooleanValue(booleanValue, true);
    }

    private void setBooleanValue(Boolean booleanValue, boolean setDirty) {
        Boolean oldBooleanValue = this.getBooleanValue();
        if (new EqualsBuilder().append(oldBooleanValue, booleanValue).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintParameterModelEnum.BOOLEAN_VALUE.getPropertyName());
        }
        this.booleanValue = booleanValue;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintParameterModelEnum.BOOLEAN_VALUE, booleanValue, oldBooleanValue);
    }

    @Override
    protected void updateByDto(PrintParameterFullDto printParameterDto) {
        this.printObject = printParameterDto.getPrintObject();
        this.key = printParameterDto.getKey();
        this.stringValue = printParameterDto.getStringValue();
        this.integerValue = printParameterDto.getIntegerValue();
        this.floatValue = printParameterDto.getFloatValue();
        this.booleanValue = printParameterDto.getBooleanValue();
    }

    @Override
    protected void updateMasterRelationsByDto(PrintParameterFullDto printParameterDto) {
    }

    @Override
    protected void checkStaleByDto(PrintParameterFullDto printParameterDto) throws StaleStateException {
    }

    @Override
    public PrintParameterFullDto createDto() {
        Long id = this.getId();
        PrintParameterFullDto printParameterDto = id == null ? new PrintParameterFullDto(this.getTempUUID()) : new PrintParameterFullDto(id, this.getVersion());
        printParameterDto.setPrintObject(this.getPrintObject());
        printParameterDto.setKey(this.getKey());
        printParameterDto.setStringValue(this.getStringValue());
        printParameterDto.setIntegerValue(this.getIntegerValue());
        printParameterDto.setFloatValue(this.getFloatValue());
        printParameterDto.setBooleanValue(this.getBooleanValue());
        return printParameterDto;
    }

    @Override
    public PrintParameterProxyDto createProxy() {
        Long id = this.getId();
        PrintParameterProxyDto printParameterDto = id == null ? new PrintParameterProxyDto(this.getTempUUID()) : new PrintParameterProxyDto(id, this.getVersion());
        return printParameterDto;
    }

    public static enum PrintParameterModelEnum {
        PRINT_OBJECT("printObject"),
        KEY("key"),
        STRING_VALUE("stringValue"),
        INTEGER_VALUE("integerValue"),
        FLOAT_VALUE("floatValue"),
        BOOLEAN_VALUE("booleanValue");

        private String propertyName;

        private PrintParameterModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

