/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ExternalLocationModel;
import de.datomino.peppergis.client.model.base.ExternalLocationModelImpl;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.SegmentModelImpl;
import de.datomino.peppergis.dto.base.ExternalLocationDto;
import de.datomino.peppergis.dto.base.ImportedLocationDto;
import de.datomino.peppergis.dto.base.LocationFullDto;
import de.datomino.peppergis.dto.base.LocationProxyDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.SegmentDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.ktde.util.cache.ChangeSet;

public class LocationModelImpl
extends AbstractModel<LocationFullDto, LocationProxyDto>
implements LocationModel {
    private ImportedLocationModel importedLocation;
    private ExternalLocationModel externalLocation;
    private ParcelModel parcel;
    private SegmentModel footSegment;
    private SegmentModel motorSegment;
    private SegmentModel bikeSegment;

    public LocationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public LocationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImportedLocationModel getImportedLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importedLocation;
    }

    @Override
    public void setImportedLocation(ImportedLocationModel importedLocation) {
        this.setImportedLocation(importedLocation, true);
    }

    private void setImportedLocation(ImportedLocationModel importedLocation, boolean setDirty) {
        ImportedLocationModel oldImportedLocation = this.getImportedLocation();
        if (oldImportedLocation == importedLocation) {
            return;
        }
        if (oldImportedLocation != null) {
            oldImportedLocation.removeALocation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.IMPORTED_LOCATION.getPropertyName());
        }
        this.importedLocation = importedLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.IMPORTED_LOCATION, importedLocation, oldImportedLocation);
        if (this.importedLocation != null) {
            this.importedLocation.addALocation(this);
        }
    }

    @Override
    public ExternalLocationModel getExternalLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.externalLocation;
    }

    @Override
    public void setExternalLocation(ExternalLocationModel externalLocation) {
        this.setExternalLocation(externalLocation, true);
    }

    private void setExternalLocation(ExternalLocationModel externalLocation, boolean setDirty) {
        ExternalLocationModel oldExternalLocation = this.getExternalLocation();
        if (oldExternalLocation == externalLocation) {
            return;
        }
        if (oldExternalLocation != null) {
            oldExternalLocation.removeALocation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.EXTERNAL_LOCATION.getPropertyName());
        }
        this.externalLocation = externalLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.EXTERNAL_LOCATION, externalLocation, oldExternalLocation);
        if (this.externalLocation != null) {
            this.externalLocation.addALocation(this);
        }
    }

    @Override
    public ParcelModel getParcel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parcel;
    }

    @Override
    public void setParcel(ParcelModel parcel) {
        this.setParcel(parcel, true);
    }

    private void setParcel(ParcelModel parcel, boolean setDirty) {
        ParcelModel oldParcel = this.getParcel();
        if (oldParcel == parcel) {
            return;
        }
        if (oldParcel != null) {
            oldParcel.removeLocation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.PARCEL.getPropertyName());
        }
        this.parcel = parcel;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.PARCEL, parcel, oldParcel);
        if (this.parcel != null) {
            this.parcel.addLocation(this);
        }
    }

    @Override
    public SegmentModel getFootSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.footSegment;
    }

    @Override
    public void setFootSegment(SegmentModel footSegment) {
        this.setFootSegment(footSegment, true);
    }

    private void setFootSegment(SegmentModel footSegment, boolean setDirty) {
        SegmentModel oldFootSegment = this.getFootSegment();
        if (oldFootSegment == footSegment) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.FOOT_SEGMENT.getPropertyName());
        }
        this.footSegment = footSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.FOOT_SEGMENT, footSegment, oldFootSegment);
    }

    @Override
    public SegmentModel getMotorSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.motorSegment;
    }

    @Override
    public void setMotorSegment(SegmentModel motorSegment) {
        this.setMotorSegment(motorSegment, true);
    }

    private void setMotorSegment(SegmentModel motorSegment, boolean setDirty) {
        SegmentModel oldMotorSegment = this.getMotorSegment();
        if (oldMotorSegment == motorSegment) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.MOTOR_SEGMENT.getPropertyName());
        }
        this.motorSegment = motorSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.MOTOR_SEGMENT, motorSegment, oldMotorSegment);
    }

    @Override
    public SegmentModel getBikeSegment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.bikeSegment;
    }

    @Override
    public void setBikeSegment(SegmentModel bikeSegment) {
        this.setBikeSegment(bikeSegment, true);
    }

    private void setBikeSegment(SegmentModel bikeSegment, boolean setDirty) {
        SegmentModel oldBikeSegment = this.getBikeSegment();
        if (oldBikeSegment == bikeSegment) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LocationModelEnum.BIKE_SEGMENT.getPropertyName());
        }
        this.bikeSegment = bikeSegment;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LocationModelEnum.BIKE_SEGMENT, bikeSegment, oldBikeSegment);
    }

    @Override
    protected void updateByDto(LocationFullDto locationDto) {
        this.importedLocation = (ImportedLocationModel)this.getModelCache().getModel(locationDto.getImportedLocation());
        this.externalLocation = (ExternalLocationModel)this.getModelCache().getModel(locationDto.getExternalLocation());
        this.parcel = (ParcelModel)this.getModelCache().getModel(locationDto.getParcel());
        this.footSegment = (SegmentModel)this.getModelCache().getModel(locationDto.getFootSegment());
        this.motorSegment = (SegmentModel)this.getModelCache().getModel(locationDto.getMotorSegment());
        this.bikeSegment = (SegmentModel)this.getModelCache().getModel(locationDto.getBikeSegment());
    }

    @Override
    protected void updateMasterRelationsByDto(LocationFullDto locationDto) {
    }

    @Override
    protected void checkStaleByDto(LocationFullDto locationDto) throws StaleStateException {
        SegmentModelImpl bikeSegmentModel;
        SegmentDto bikeSegmentDto;
        SegmentModelImpl motorSegmentModel;
        SegmentDto motorSegmentDto;
        SegmentModelImpl footSegmentModel;
        SegmentDto footSegmentDto;
        ParcelModelImpl parcelModel;
        ParcelDto parcelDto;
        ExternalLocationModelImpl externalLocationModel;
        ExternalLocationDto externalLocationDto;
        ImportedLocationModelImpl importedLocationModel;
        ImportedLocationDto importedLocationDto = locationDto.getImportedLocation();
        if (importedLocationDto != null && importedLocationDto.getId() != null && (importedLocationModel = (ImportedLocationModelImpl)this.getModelCache().getModel(ImportedLocationModel.class, importedLocationDto.getId())) != null) {
            importedLocationModel.checkStaleState(importedLocationDto);
        }
        if ((externalLocationDto = locationDto.getExternalLocation()) != null && externalLocationDto.getId() != null && (externalLocationModel = (ExternalLocationModelImpl)this.getModelCache().getModel(ExternalLocationModel.class, externalLocationDto.getId())) != null) {
            externalLocationModel.checkStaleState(externalLocationDto);
        }
        if ((parcelDto = locationDto.getParcel()) != null && parcelDto.getId() != null && (parcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, parcelDto.getId())) != null) {
            parcelModel.checkStaleState(parcelDto);
        }
        if ((footSegmentDto = locationDto.getFootSegment()) != null && footSegmentDto.getId() != null && (footSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, footSegmentDto.getId())) != null) {
            footSegmentModel.checkStaleState(footSegmentDto);
        }
        if ((motorSegmentDto = locationDto.getMotorSegment()) != null && motorSegmentDto.getId() != null && (motorSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, motorSegmentDto.getId())) != null) {
            motorSegmentModel.checkStaleState(motorSegmentDto);
        }
        if ((bikeSegmentDto = locationDto.getBikeSegment()) != null && bikeSegmentDto.getId() != null && (bikeSegmentModel = (SegmentModelImpl)this.getModelCache().getModel(SegmentModel.class, bikeSegmentDto.getId())) != null) {
            bikeSegmentModel.checkStaleState(bikeSegmentDto);
        }
    }

    @Override
    public LocationFullDto createDto() {
        SegmentModelImpl bikeSegment;
        SegmentModelImpl motorSegment;
        SegmentModelImpl footSegment;
        ParcelModelImpl parcel;
        ExternalLocationModelImpl externalLocation;
        Long id = this.getId();
        LocationFullDto locationDto = id == null ? new LocationFullDto(this.getTempUUID()) : new LocationFullDto(id, this.getVersion());
        ImportedLocationModelImpl importedLocation = (ImportedLocationModelImpl)this.getImportedLocation();
        if (importedLocation != null) {
            locationDto.setImportedLocation(importedLocation.createProxy());
        }
        if ((externalLocation = (ExternalLocationModelImpl)this.getExternalLocation()) != null) {
            locationDto.setExternalLocation(externalLocation.createProxy());
        }
        if ((parcel = (ParcelModelImpl)this.getParcel()) != null) {
            locationDto.setParcel(parcel.createProxy());
        }
        if ((footSegment = (SegmentModelImpl)this.getFootSegment()) != null) {
            locationDto.setFootSegment(footSegment.createProxy());
        }
        if ((motorSegment = (SegmentModelImpl)this.getMotorSegment()) != null) {
            locationDto.setMotorSegment(motorSegment.createProxy());
        }
        if ((bikeSegment = (SegmentModelImpl)this.getBikeSegment()) != null) {
            locationDto.setBikeSegment(bikeSegment.createProxy());
        }
        return locationDto;
    }

    @Override
    public LocationProxyDto createProxy() {
        Long id = this.getId();
        LocationProxyDto locationDto = id == null ? new LocationProxyDto(this.getTempUUID()) : new LocationProxyDto(id, this.getVersion());
        return locationDto;
    }

    public static enum LocationModelEnum {
        IMPORTED_LOCATION("importedLocation"),
        EXTERNAL_LOCATION("externalLocation"),
        PARCEL("parcel"),
        FOOT_SEGMENT("footSegment"),
        MOTOR_SEGMENT("motorSegment"),
        BIKE_SEGMENT("bikeSegment");

        private String propertyName;

        private LocationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

