/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterModelImpl;
import de.datomino.peppergis.client.model.base.LetterSortOrderModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.dto.base.LetterDto;
import de.datomino.peppergis.dto.base.LetterSortOrderFullDto;
import de.datomino.peppergis.dto.base.LetterSortOrderProxyDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class LetterSortOrderModelImpl
extends AbstractModel<LetterSortOrderFullDto, LetterSortOrderProxyDto>
implements LetterSortOrderModel {
    private Integer value;
    private RouteVehicleType vehicle;
    private DeliveryRoundModel deliveryRound;
    private LetterModel letter;

    public LetterSortOrderModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public LetterSortOrderModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, true);
    }

    private void setValue(Integer value, boolean setDirty) {
        Integer oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterSortOrderModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterSortOrderModelEnum.VALUE, value, oldValue);
    }

    @Override
    public RouteVehicleType getVehicle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicle;
    }

    @Override
    public void setVehicle(RouteVehicleType vehicle) {
        this.setVehicle(vehicle, true);
    }

    private void setVehicle(RouteVehicleType vehicle, boolean setDirty) {
        RouteVehicleType oldVehicle = this.getVehicle();
        if (new EqualsBuilder().append((Object)oldVehicle, (Object)vehicle).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterSortOrderModelEnum.VEHICLE.getPropertyName());
        }
        this.vehicle = vehicle;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterSortOrderModelEnum.VEHICLE, (Object)vehicle, (Object)oldVehicle);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterSortOrderModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterSortOrderModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public LetterModel getLetter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.letter;
    }

    @Override
    public void setLetter(LetterModel letter) {
        this.setLetter(letter, true);
    }

    private void setLetter(LetterModel letter, boolean setDirty) {
        LetterModel oldLetter = this.getLetter();
        if (oldLetter == letter) {
            return;
        }
        if (oldLetter != null) {
            oldLetter.removeSortOrder(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterSortOrderModelEnum.LETTER.getPropertyName());
        }
        this.letter = letter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterSortOrderModelEnum.LETTER, letter, oldLetter);
        if (this.letter != null) {
            this.letter.addSortOrder(this);
        }
    }

    @Override
    protected void updateByDto(LetterSortOrderFullDto letterSortOrderDto) {
        this.value = letterSortOrderDto.getValue();
        this.vehicle = letterSortOrderDto.getVehicle();
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(letterSortOrderDto.getDeliveryRound());
        this.letter = (LetterModel)this.getModelCache().getModel(letterSortOrderDto.getLetter());
    }

    @Override
    protected void updateMasterRelationsByDto(LetterSortOrderFullDto letterSortOrderDto) {
    }

    @Override
    protected void checkStaleByDto(LetterSortOrderFullDto letterSortOrderDto) throws StaleStateException {
        LetterModelImpl letterModel;
        LetterDto letterDto;
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = letterSortOrderDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((letterDto = letterSortOrderDto.getLetter()) != null && letterDto.getId() != null && (letterModel = (LetterModelImpl)this.getModelCache().getModel(LetterModel.class, letterDto.getId())) != null) {
            letterModel.checkStaleState(letterDto);
        }
    }

    @Override
    public LetterSortOrderFullDto createDto() {
        LetterModelImpl letter;
        Long id = this.getId();
        LetterSortOrderFullDto letterSortOrderDto = id == null ? new LetterSortOrderFullDto(this.getTempUUID()) : new LetterSortOrderFullDto(id, this.getVersion());
        letterSortOrderDto.setValue(this.getValue());
        letterSortOrderDto.setVehicle(this.getVehicle());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            letterSortOrderDto.setDeliveryRound(deliveryRound.createProxy());
        }
        if ((letter = (LetterModelImpl)this.getLetter()) != null) {
            letterSortOrderDto.setLetter(letter.createProxy());
        }
        return letterSortOrderDto;
    }

    @Override
    public LetterSortOrderProxyDto createProxy() {
        Long id = this.getId();
        LetterSortOrderProxyDto letterSortOrderDto = id == null ? new LetterSortOrderProxyDto(this.getTempUUID()) : new LetterSortOrderProxyDto(id, this.getVersion());
        return letterSortOrderDto;
    }

    public static enum LetterSortOrderModelEnum {
        VALUE("value"),
        VEHICLE("vehicle"),
        DELIVERY_ROUND("deliveryRound"),
        LETTER("letter");

        private String propertyName;

        private LetterSortOrderModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

