/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.LetterAttributeValueModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueModelImpl;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterSortOrderModel;
import de.datomino.peppergis.client.model.base.LetterSortOrderModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.base.LetterAttributeValueDto;
import de.datomino.peppergis.dto.base.LetterFullDto;
import de.datomino.peppergis.dto.base.LetterProxyDto;
import de.datomino.peppergis.dto.base.LetterSortOrderDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.LetterDeliveryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class LetterModelImpl
extends AbstractModel<LetterFullDto, LetterProxyDto>
implements LetterModel {
    private String letterNumber;
    private String information;
    private String firstName;
    private String lastName;
    private AreaObjectModel areaObject;
    private Set<LetterAttributeValueModel> letterAttributeValues = null;
    private AreaLayerModel areaLayer;
    private LetterDeliveryType deliveryType;
    private Date date;
    private Set<LetterSortOrderModel> sortOrders = null;
    private LocationModel location;
    private String companyName;

    public LetterModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public LetterModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getLetterNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.letterNumber;
    }

    @Override
    public void setLetterNumber(String letterNumber) {
        this.setLetterNumber(letterNumber, true);
    }

    private void setLetterNumber(String letterNumber, boolean setDirty) {
        String oldLetterNumber = this.getLetterNumber();
        if (new EqualsBuilder().append(oldLetterNumber, letterNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.LETTER_NUMBER.getPropertyName());
        }
        this.letterNumber = letterNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.LETTER_NUMBER, letterNumber, oldLetterNumber);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (oldAreaObject != null) {
            oldAreaObject.removeLetter(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
        if (this.areaObject != null) {
            this.areaObject.addLetter(this);
        }
    }

    @Override
    public int countLetterAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        return this.letterAttributeValues.size();
    }

    @Override
    public Iterator<LetterAttributeValueModel> iterateLetterAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        return new ImmutableIterator<LetterAttributeValueModel>(this.letterAttributeValues);
    }

    @Override
    public Iterable<LetterAttributeValueModel> iterableLetterAttributeValues() {
        return new IteratorIterable<LetterAttributeValueModel>(this.iterateLetterAttributeValues());
    }

    @Override
    public void addLetterAttributeValue(LetterAttributeValueModel letterAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        if (this.letterAttributeValues.contains(letterAttributeValue)) {
            return;
        }
        this.letterAttributeValues.add(letterAttributeValue);
        this.fireValueChanged(LetterModelEnum.LETTER_ATTRIBUTE_VALUES, letterAttributeValue, null);
        if (letterAttributeValue != null) {
            letterAttributeValue.setLetter(this);
        }
    }

    @Override
    public void removeLetterAttributeValue(LetterAttributeValueModel letterAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        if (!this.letterAttributeValues.contains(letterAttributeValue)) {
            return;
        }
        this.letterAttributeValues.remove(letterAttributeValue);
        this.fireValueChanged(LetterModelEnum.LETTER_ATTRIBUTE_VALUES, letterAttributeValue, null);
        if (letterAttributeValue != null) {
            letterAttributeValue.setLetter(null);
        }
    }

    @Override
    public void clearLetterAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        ArrayList<LetterAttributeValueModel> oldLetterAttributeValues = new ArrayList<LetterAttributeValueModel>(this.letterAttributeValues);
        this.letterAttributeValues.clear();
        this.fireValueChanged(LetterModelEnum.LETTER_ATTRIBUTE_VALUES, null, null);
        for (LetterAttributeValueModel oldLetterAttributeValue : oldLetterAttributeValues) {
            if (oldLetterAttributeValue == null) continue;
            oldLetterAttributeValue.setLetter(null);
        }
    }

    @Override
    public boolean isLetterAttributeValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        return this.letterAttributeValues.isEmpty();
    }

    @Override
    public boolean containsLetterAttributeValue(LetterAttributeValueModel letterAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letterAttributeValues == null) {
            this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            if (this.getId() != null) {
                Collection letterAttributeValuesCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.LETTER_ATTRIBUTE_VALUES.getPropertyName());
                this.letterAttributeValues.addAll(letterAttributeValuesCollection);
            }
        }
        return this.letterAttributeValues.contains(letterAttributeValue);
    }

    @Override
    public boolean isLetterAttributeValuesInitialized() {
        return this.letterAttributeValues != null;
    }

    @Override
    public AreaLayerModel getAreaLayer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaLayer;
    }

    @Override
    public void setAreaLayer(AreaLayerModel areaLayer) {
        this.setAreaLayer(areaLayer, true);
    }

    private void setAreaLayer(AreaLayerModel areaLayer, boolean setDirty) {
        AreaLayerModel oldAreaLayer = this.getAreaLayer();
        if (oldAreaLayer == areaLayer) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.AREA_LAYER.getPropertyName());
        }
        this.areaLayer = areaLayer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.AREA_LAYER, areaLayer, oldAreaLayer);
    }

    @Override
    public LetterDeliveryType getDeliveryType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryType;
    }

    @Override
    public void setDeliveryType(LetterDeliveryType deliveryType) {
        this.setDeliveryType(deliveryType, true);
    }

    private void setDeliveryType(LetterDeliveryType deliveryType, boolean setDirty) {
        LetterDeliveryType oldDeliveryType = this.getDeliveryType();
        if (new EqualsBuilder().append((Object)oldDeliveryType, (Object)deliveryType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.DELIVERY_TYPE.getPropertyName());
        }
        this.deliveryType = deliveryType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.DELIVERY_TYPE, (Object)deliveryType, (Object)oldDeliveryType);
    }

    @Override
    public Date getDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.setDate(date, true);
    }

    private void setDate(Date date, boolean setDirty) {
        Date oldDate = this.getDate();
        if (new EqualsBuilder().append(oldDate, date).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.DATE.getPropertyName());
        }
        this.date = date;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.DATE, date, oldDate);
    }

    @Override
    public int countSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.size();
    }

    @Override
    public Iterator<LetterSortOrderModel> iterateSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return new ImmutableIterator<LetterSortOrderModel>(this.sortOrders);
    }

    @Override
    public Iterable<LetterSortOrderModel> iterableSortOrders() {
        return new IteratorIterable<LetterSortOrderModel>(this.iterateSortOrders());
    }

    @Override
    public void addSortOrder(LetterSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.add(sortOrder);
        this.fireValueChanged(LetterModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setLetter(this);
        }
    }

    @Override
    public void removeSortOrder(LetterSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (!this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.remove(sortOrder);
        this.fireValueChanged(LetterModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setLetter(null);
        }
    }

    @Override
    public void clearSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        ArrayList<LetterSortOrderModel> oldSortOrders = new ArrayList<LetterSortOrderModel>(this.sortOrders);
        this.sortOrders.clear();
        this.fireValueChanged(LetterModelEnum.SORT_ORDERS, null, null);
        for (LetterSortOrderModel oldSortOrder : oldSortOrders) {
            if (oldSortOrder == null) continue;
            oldSortOrder.setLetter(null);
        }
    }

    @Override
    public boolean isSortOrdersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.isEmpty();
    }

    @Override
    public boolean containsSortOrder(LetterSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, LetterModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.contains(sortOrder);
    }

    @Override
    public boolean isSortOrdersInitialized() {
        return this.sortOrders != null;
    }

    @Override
    public LocationModel getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(LocationModel location) {
        this.setLocation(location, true);
    }

    private void setLocation(LocationModel location, boolean setDirty) {
        LocationModel oldLocation = this.getLocation();
        if (oldLocation == location) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public String getCompanyName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.companyName;
    }

    @Override
    public void setCompanyName(String companyName) {
        this.setCompanyName(companyName, true);
    }

    private void setCompanyName(String companyName, boolean setDirty) {
        String oldCompanyName = this.getCompanyName();
        if (new EqualsBuilder().append(oldCompanyName, companyName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, LetterModelEnum.COMPANY_NAME.getPropertyName());
        }
        this.companyName = companyName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(LetterModelEnum.COMPANY_NAME, companyName, oldCompanyName);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.letterAttributeValues = null;
            this.sortOrders = null;
        }
    }

    @Override
    protected void updateByDto(LetterFullDto letterDto) {
        this.letterNumber = letterDto.getLetterNumber();
        this.information = letterDto.getInformation();
        this.firstName = letterDto.getFirstName();
        this.lastName = letterDto.getLastName();
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(letterDto.getAreaObject());
        LetterAttributeValueDto[] letterAttributeValues = letterDto.getLetterAttributeValues();
        if (letterAttributeValues != null) {
            if (this.letterAttributeValues == null) {
                this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            } else {
                this.letterAttributeValues.clear();
            }
        }
        this.areaLayer = (AreaLayerModel)this.getModelCache().getModel(letterDto.getAreaLayer());
        this.deliveryType = letterDto.getDeliveryType();
        this.date = letterDto.getDate();
        LetterSortOrderDto[] sortOrders = letterDto.getSortOrders();
        if (sortOrders != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
        }
        this.location = (LocationModel)this.getModelCache().getModel(letterDto.getLocation());
        this.companyName = letterDto.getCompanyName();
    }

    @Override
    protected void updateMasterRelationsByDto(LetterFullDto letterDto) {
        LetterSortOrderDto[] sortOrders;
        LetterAttributeValueDto[] letterAttributeValues = letterDto.getLetterAttributeValues();
        if (letterAttributeValues != null) {
            if (this.letterAttributeValues == null) {
                this.letterAttributeValues = new LinkedHashSet<LetterAttributeValueModel>();
            } else {
                this.letterAttributeValues.clear();
            }
            for (LetterAttributeValueDto letterAttributeValueDto : letterAttributeValues) {
                LetterAttributeValueModel letterAttributeValueModel = (LetterAttributeValueModel)this.getModelCache().getModel(letterAttributeValueDto);
                this.letterAttributeValues.add(letterAttributeValueModel);
            }
        } else {
            this.letterAttributeValues = null;
        }
        if ((sortOrders = letterDto.getSortOrders()) != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<LetterSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
            for (LetterSortOrderDto sortOrderDto : sortOrders) {
                LetterSortOrderModel sortOrderModel = (LetterSortOrderModel)this.getModelCache().getModel(sortOrderDto);
                this.sortOrders.add(sortOrderModel);
            }
        } else {
            this.sortOrders = null;
        }
    }

    @Override
    protected void checkStaleByDto(LetterFullDto letterDto) throws StaleStateException {
        LocationModelImpl locationModel;
        LocationDto locationDto;
        LetterSortOrderDto[] sortOrderDtos;
        AreaLayerModelImpl areaLayerModel;
        AreaLayerDto areaLayerDto;
        LetterAttributeValueDto[] letterAttributeValueDtos;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = letterDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((letterAttributeValueDtos = letterDto.getLetterAttributeValues()) != null) {
            for (LetterAttributeValueDto letterAttributeValueDto : letterAttributeValueDtos) {
                LetterAttributeValueModelImpl letterAttributeValueModel = (LetterAttributeValueModelImpl)this.getModelCache().getModel(LetterAttributeValueModel.class, letterAttributeValueDto.getId());
                if (letterAttributeValueModel == null) continue;
                letterAttributeValueModel.checkStaleState(letterAttributeValueDto);
            }
        }
        if ((areaLayerDto = letterDto.getAreaLayer()) != null && areaLayerDto.getId() != null && (areaLayerModel = (AreaLayerModelImpl)this.getModelCache().getModel(AreaLayerModel.class, areaLayerDto.getId())) != null) {
            areaLayerModel.checkStaleState(areaLayerDto);
        }
        if ((sortOrderDtos = letterDto.getSortOrders()) != null) {
            for (LetterSortOrderDto sortOrderDto : sortOrderDtos) {
                LetterSortOrderModelImpl sortOrderModel = (LetterSortOrderModelImpl)this.getModelCache().getModel(LetterSortOrderModel.class, sortOrderDto.getId());
                if (sortOrderModel == null) continue;
                sortOrderModel.checkStaleState(sortOrderDto);
            }
        }
        if ((locationDto = letterDto.getLocation()) != null && locationDto.getId() != null && (locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId())) != null) {
            locationModel.checkStaleState(locationDto);
        }
    }

    @Override
    public LetterFullDto createDto() {
        AreaLayerModelImpl areaLayer;
        Long id = this.getId();
        LetterFullDto letterDto = id == null ? new LetterFullDto(this.getTempUUID()) : new LetterFullDto(id, this.getVersion());
        letterDto.setLetterNumber(this.getLetterNumber());
        letterDto.setInformation(this.getInformation());
        letterDto.setFirstName(this.getFirstName());
        letterDto.setLastName(this.getLastName());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            letterDto.setAreaObject(areaObject.createProxy());
        }
        if ((areaLayer = (AreaLayerModelImpl)this.getAreaLayer()) != null) {
            letterDto.setAreaLayer(areaLayer.createProxy());
        }
        letterDto.setDeliveryType(this.getDeliveryType());
        letterDto.setDate(this.getDate());
        LocationModelImpl location = (LocationModelImpl)this.getLocation();
        if (location != null) {
            letterDto.setLocation(location.createProxy());
        }
        letterDto.setCompanyName(this.getCompanyName());
        return letterDto;
    }

    @Override
    public LetterProxyDto createProxy() {
        Long id = this.getId();
        LetterProxyDto letterDto = id == null ? new LetterProxyDto(this.getTempUUID()) : new LetterProxyDto(id, this.getVersion());
        return letterDto;
    }

    public static enum LetterModelEnum {
        LETTER_NUMBER("letterNumber"),
        INFORMATION("information"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        AREA_OBJECT("areaObject"),
        LETTER_ATTRIBUTE_VALUES("letterAttributeValues"),
        AREA_LAYER("areaLayer"),
        DELIVERY_TYPE("deliveryType"),
        DATE("date"),
        SORT_ORDERS("sortOrders"),
        LOCATION("location"),
        COMPANY_NAME("companyName");

        private String propertyName;

        private LetterModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

