/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.dto.base.ImageFullDto;
import de.datomino.peppergis.dto.base.ImageProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class ImageModelImpl
extends AbstractModel<ImageFullDto, ImageProxyDto>
implements ImageModel {
    private String name;
    private byte[] data;

    public ImageModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ImageModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImageModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImageModelEnum.NAME, name, oldName);
    }

    @Override
    public byte[] getData() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.setData(data, true);
    }

    private void setData(byte[] data, boolean setDirty) {
        byte[] oldData = this.getData();
        if (new EqualsBuilder().append(oldData, data).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImageModelEnum.DATA.getPropertyName());
        }
        this.data = data;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImageModelEnum.DATA, data, oldData);
    }

    @Override
    protected void updateByDto(ImageFullDto imageDto) {
        this.name = imageDto.getName();
        this.data = imageDto.getData();
    }

    @Override
    protected void updateMasterRelationsByDto(ImageFullDto imageDto) {
    }

    @Override
    protected void checkStaleByDto(ImageFullDto imageDto) throws StaleStateException {
    }

    @Override
    public ImageFullDto createDto() {
        Long id = this.getId();
        ImageFullDto imageDto = id == null ? new ImageFullDto(this.getTempUUID()) : new ImageFullDto(id, this.getVersion());
        imageDto.setName(this.getName());
        imageDto.setData(this.getData());
        return imageDto;
    }

    @Override
    public ImageProxyDto createProxy() {
        Long id = this.getId();
        ImageProxyDto imageDto = id == null ? new ImageProxyDto(this.getTempUUID()) : new ImageProxyDto(id, this.getVersion());
        return imageDto;
    }

    public static enum ImageModelEnum {
        NAME("name"),
        DATA("data");

        private String propertyName;

        private ImageModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

