/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.base.ExternalLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.base.ExternalLocationFullDto;
import de.datomino.peppergis.dto.base.ExternalLocationProxyDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ExternalLocationModelImpl
extends AbstractModel<ExternalLocationFullDto, ExternalLocationProxyDto>
implements ExternalLocationModel {
    private String information;
    private Country country;
    private String city;
    private String district;
    private String postcode;
    private String street;
    private Integer housenumber;
    private String housenumberExtension;
    private ImmutablePoint geoLocation;
    private Set<LocationModel> location = null;
    private ImportedLocationStatus status;
    private ImportedLocationProcess process;
    private UserModel editorUser;
    private UserModel loginUser;

    public ExternalLocationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ExternalLocationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public Country getCountry() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.setCountry(country, true);
    }

    private void setCountry(Country country, boolean setDirty) {
        Country oldCountry = this.getCountry();
        if (new EqualsBuilder().append(oldCountry, country).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.COUNTRY.getPropertyName());
        }
        this.country = country;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.COUNTRY, country, oldCountry);
    }

    @Override
    public String getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.setCity(city, true);
    }

    private void setCity(String city, boolean setDirty) {
        String oldCity = this.getCity();
        if (new EqualsBuilder().append(oldCity, city).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.CITY, city, oldCity);
    }

    @Override
    public String getDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.district;
    }

    @Override
    public void setDistrict(String district) {
        this.setDistrict(district, true);
    }

    private void setDistrict(String district, boolean setDirty) {
        String oldDistrict = this.getDistrict();
        if (new EqualsBuilder().append(oldDistrict, district).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.DISTRICT.getPropertyName());
        }
        this.district = district;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.DISTRICT, district, oldDistrict);
    }

    @Override
    public String getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(String postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(String postcode, boolean setDirty) {
        String oldPostcode = this.getPostcode();
        if (new EqualsBuilder().append(oldPostcode, postcode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.POSTCODE, postcode, oldPostcode);
    }

    @Override
    public String getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(String street) {
        this.setStreet(street, true);
    }

    private void setStreet(String street, boolean setDirty) {
        String oldStreet = this.getStreet();
        if (new EqualsBuilder().append(oldStreet, street).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.STREET, street, oldStreet);
    }

    @Override
    public Integer getHousenumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumber;
    }

    @Override
    public void setHousenumber(Integer housenumber) {
        this.setHousenumber(housenumber, true);
    }

    private void setHousenumber(Integer housenumber, boolean setDirty) {
        Integer oldHousenumber = this.getHousenumber();
        if (new EqualsBuilder().append(oldHousenumber, housenumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.HOUSENUMBER.getPropertyName());
        }
        this.housenumber = housenumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.HOUSENUMBER, housenumber, oldHousenumber);
    }

    @Override
    public String getHousenumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumberExtension;
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.setHousenumberExtension(housenumberExtension, true);
    }

    private void setHousenumberExtension(String housenumberExtension, boolean setDirty) {
        String oldHousenumberExtension = this.getHousenumberExtension();
        if (new EqualsBuilder().append(oldHousenumberExtension, housenumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.HOUSENUMBER_EXTENSION.getPropertyName());
        }
        this.housenumberExtension = housenumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.HOUSENUMBER_EXTENSION, housenumberExtension, oldHousenumberExtension);
    }

    @Override
    public ImmutablePoint getGeoLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geoLocation;
    }

    @Override
    public void setGeoLocation(ImmutablePoint geoLocation) {
        this.setGeoLocation(geoLocation, true);
    }

    private void setGeoLocation(ImmutablePoint geoLocation, boolean setDirty) {
        ImmutablePoint oldGeoLocation = this.getGeoLocation();
        if (new EqualsBuilder().append(oldGeoLocation, geoLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.GEO_LOCATION.getPropertyName());
        }
        this.geoLocation = geoLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.GEO_LOCATION, geoLocation, oldGeoLocation);
    }

    @Override
    public int countLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.size();
    }

    @Override
    public Iterator<LocationModel> iterateLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.location);
    }

    @Override
    public Iterable<LocationModel> iterableLocation() {
        return new IteratorIterable<LocationModel>(this.iterateLocation());
    }

    @Override
    public void addALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        if (this.location.contains(aLocation)) {
            return;
        }
        this.location.add(aLocation);
        this.fireValueChanged(ExternalLocationModelEnum.LOCATION, aLocation, null);
        if (aLocation != null) {
            aLocation.setExternalLocation(this);
        }
    }

    @Override
    public void removeALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        if (!this.location.contains(aLocation)) {
            return;
        }
        this.location.remove(aLocation);
        this.fireValueChanged(ExternalLocationModelEnum.LOCATION, aLocation, null);
        if (aLocation != null) {
            aLocation.setExternalLocation(null);
        }
    }

    @Override
    public void clearLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        ArrayList<LocationModel> oldLocation = new ArrayList<LocationModel>(this.location);
        this.location.clear();
        this.fireValueChanged(ExternalLocationModelEnum.LOCATION, null, null);
        for (LocationModel oldALocation : oldLocation) {
            if (oldALocation == null) continue;
            oldALocation.setExternalLocation(null);
        }
    }

    @Override
    public boolean isLocationEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.isEmpty();
    }

    @Override
    public boolean containsALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ExternalLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.contains(aLocation);
    }

    @Override
    public boolean isLocationInitialized() {
        return this.location != null;
    }

    @Override
    public ImportedLocationStatus getStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.status;
    }

    @Override
    public void setStatus(ImportedLocationStatus status) {
        this.setStatus(status, true);
    }

    private void setStatus(ImportedLocationStatus status, boolean setDirty) {
        ImportedLocationStatus oldStatus = this.getStatus();
        if (new EqualsBuilder().append((Object)oldStatus, (Object)status).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.STATUS.getPropertyName());
        }
        this.status = status;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.STATUS, (Object)status, (Object)oldStatus);
    }

    @Override
    public ImportedLocationProcess getProcess() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.process;
    }

    @Override
    public void setProcess(ImportedLocationProcess process) {
        this.setProcess(process, true);
    }

    private void setProcess(ImportedLocationProcess process, boolean setDirty) {
        ImportedLocationProcess oldProcess = this.getProcess();
        if (new EqualsBuilder().append((Object)oldProcess, (Object)process).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.PROCESS.getPropertyName());
        }
        this.process = process;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.PROCESS, (Object)process, (Object)oldProcess);
    }

    @Override
    public UserModel getEditorUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.editorUser;
    }

    @Override
    public void setEditorUser(UserModel editorUser) {
        this.setEditorUser(editorUser, true);
    }

    private void setEditorUser(UserModel editorUser, boolean setDirty) {
        UserModel oldEditorUser = this.getEditorUser();
        if (oldEditorUser == editorUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.EDITOR_USER.getPropertyName());
        }
        this.editorUser = editorUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.EDITOR_USER, editorUser, oldEditorUser);
    }

    @Override
    public UserModel getLoginUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.loginUser;
    }

    @Override
    public void setLoginUser(UserModel loginUser) {
        this.setLoginUser(loginUser, true);
    }

    private void setLoginUser(UserModel loginUser, boolean setDirty) {
        UserModel oldLoginUser = this.getLoginUser();
        if (oldLoginUser == loginUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ExternalLocationModelEnum.LOGIN_USER.getPropertyName());
        }
        this.loginUser = loginUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ExternalLocationModelEnum.LOGIN_USER, loginUser, oldLoginUser);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.location = null;
        }
    }

    @Override
    protected void updateByDto(ExternalLocationFullDto externalLocationDto) {
        this.information = externalLocationDto.getInformation();
        this.country = externalLocationDto.getCountry();
        this.city = externalLocationDto.getCity();
        this.district = externalLocationDto.getDistrict();
        this.postcode = externalLocationDto.getPostcode();
        this.street = externalLocationDto.getStreet();
        this.housenumber = externalLocationDto.getHousenumber();
        this.housenumberExtension = externalLocationDto.getHousenumberExtension();
        ImmutablePointDto geoLocation = externalLocationDto.getGeoLocation();
        this.geoLocation = geoLocation == null ? null : (ImmutablePoint)geoLocation.getGeoObject();
        LocationDto[] location = externalLocationDto.getLocation();
        if (location != null) {
            if (this.location == null) {
                this.location = new LinkedHashSet<LocationModel>();
            } else {
                this.location.clear();
            }
        }
        this.status = externalLocationDto.getStatus();
        this.process = externalLocationDto.getProcess();
        this.editorUser = (UserModel)this.getModelCache().getModel(externalLocationDto.getEditorUser());
        this.loginUser = (UserModel)this.getModelCache().getModel(externalLocationDto.getLoginUser());
    }

    @Override
    protected void updateMasterRelationsByDto(ExternalLocationFullDto externalLocationDto) {
        LocationDto[] location = externalLocationDto.getLocation();
        if (location != null) {
            if (this.location == null) {
                this.location = new LinkedHashSet<LocationModel>();
            } else {
                this.location.clear();
            }
            for (LocationDto aLocationDto : location) {
                LocationModel aLocationModel = (LocationModel)this.getModelCache().getModel(aLocationDto);
                this.location.add(aLocationModel);
            }
        } else {
            this.location = null;
        }
    }

    @Override
    protected void checkStaleByDto(ExternalLocationFullDto externalLocationDto) throws StaleStateException {
        UserModelImpl loginUserModel;
        UserDto loginUserDto;
        UserModelImpl editorUserModel;
        UserDto editorUserDto;
        LocationDto[] aLocationDtos = externalLocationDto.getLocation();
        if (aLocationDtos != null) {
            for (LocationDto aLocationDto : aLocationDtos) {
                LocationModelImpl aLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, aLocationDto.getId());
                if (aLocationModel == null) continue;
                aLocationModel.checkStaleState(aLocationDto);
            }
        }
        if ((editorUserDto = externalLocationDto.getEditorUser()) != null && editorUserDto.getId() != null && (editorUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, editorUserDto.getId())) != null) {
            editorUserModel.checkStaleState(editorUserDto);
        }
        if ((loginUserDto = externalLocationDto.getLoginUser()) != null && loginUserDto.getId() != null && (loginUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, loginUserDto.getId())) != null) {
            loginUserModel.checkStaleState(loginUserDto);
        }
    }

    @Override
    public ExternalLocationFullDto createDto() {
        UserModelImpl loginUser;
        Long id = this.getId();
        ExternalLocationFullDto externalLocationDto = id == null ? new ExternalLocationFullDto(this.getTempUUID()) : new ExternalLocationFullDto(id, this.getVersion());
        externalLocationDto.setInformation(this.getInformation());
        externalLocationDto.setCountry(this.getCountry());
        externalLocationDto.setCity(this.getCity());
        externalLocationDto.setDistrict(this.getDistrict());
        externalLocationDto.setPostcode(this.getPostcode());
        externalLocationDto.setStreet(this.getStreet());
        externalLocationDto.setHousenumber(this.getHousenumber());
        externalLocationDto.setHousenumberExtension(this.getHousenumberExtension());
        ImmutablePoint geoLocation = this.getGeoLocation();
        externalLocationDto.setGeoLocation(ImmutablePointDto.create(geoLocation));
        externalLocationDto.setStatus(this.getStatus());
        externalLocationDto.setProcess(this.getProcess());
        UserModelImpl editorUser = (UserModelImpl)this.getEditorUser();
        if (editorUser != null) {
            externalLocationDto.setEditorUser(editorUser.createProxy());
        }
        if ((loginUser = (UserModelImpl)this.getLoginUser()) != null) {
            externalLocationDto.setLoginUser(loginUser.createProxy());
        }
        return externalLocationDto;
    }

    @Override
    public ExternalLocationProxyDto createProxy() {
        Long id = this.getId();
        ExternalLocationProxyDto externalLocationDto = id == null ? new ExternalLocationProxyDto(this.getTempUUID()) : new ExternalLocationProxyDto(id, this.getVersion());
        return externalLocationDto;
    }

    public static enum ExternalLocationModelEnum {
        INFORMATION("information"),
        COUNTRY("country"),
        CITY("city"),
        DISTRICT("district"),
        POSTCODE("postcode"),
        STREET("street"),
        HOUSENUMBER("housenumber"),
        HOUSENUMBER_EXTENSION("housenumberExtension"),
        GEO_LOCATION("geoLocation"),
        LOCATION("location"),
        STATUS("status"),
        PROCESS("process"),
        EDITOR_USER("editorUser"),
        LOGIN_USER("loginUser");

        private String propertyName;

        private ExternalLocationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

