/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModel;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.CustomerPhoneContactFullDto;
import de.datomino.peppergis.dto.base.CustomerPhoneContactProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class CustomerPhoneContactModelImpl
extends AbstractModel<CustomerPhoneContactFullDto, CustomerPhoneContactProxyDto>
implements CustomerPhoneContactModel {
    private String phoneNumber;
    private String firstName;
    private String lastName;
    private Integer customerOrder;
    private CustomerModel customer;

    public CustomerPhoneContactModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CustomerPhoneContactModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getPhoneNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        this.setPhoneNumber(phoneNumber, true);
    }

    private void setPhoneNumber(String phoneNumber, boolean setDirty) {
        String oldPhoneNumber = this.getPhoneNumber();
        if (new EqualsBuilder().append(oldPhoneNumber, phoneNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerPhoneContactModelEnum.PHONE_NUMBER.getPropertyName());
        }
        this.phoneNumber = phoneNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerPhoneContactModelEnum.PHONE_NUMBER, phoneNumber, oldPhoneNumber);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerPhoneContactModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerPhoneContactModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerPhoneContactModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerPhoneContactModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public Integer getCustomerOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customerOrder;
    }

    @Override
    public void setCustomerOrder(Integer customerOrder) {
        this.setCustomerOrder(customerOrder, true);
    }

    private void setCustomerOrder(Integer customerOrder, boolean setDirty) {
        Integer oldCustomerOrder = this.getCustomerOrder();
        if (new EqualsBuilder().append(oldCustomerOrder, customerOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerPhoneContactModelEnum.CUSTOMER_ORDER.getPropertyName());
        }
        this.customerOrder = customerOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerPhoneContactModelEnum.CUSTOMER_ORDER, customerOrder, oldCustomerOrder);
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removePhoneContact(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerPhoneContactModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerPhoneContactModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addPhoneContact(this);
        }
    }

    @Override
    protected void updateByDto(CustomerPhoneContactFullDto customerPhoneContactDto) {
        this.phoneNumber = customerPhoneContactDto.getPhoneNumber();
        this.firstName = customerPhoneContactDto.getFirstName();
        this.lastName = customerPhoneContactDto.getLastName();
        this.customerOrder = customerPhoneContactDto.getCustomerOrder();
        this.customer = (CustomerModel)this.getModelCache().getModel(customerPhoneContactDto.getCustomer());
    }

    @Override
    protected void updateMasterRelationsByDto(CustomerPhoneContactFullDto customerPhoneContactDto) {
    }

    @Override
    protected void checkStaleByDto(CustomerPhoneContactFullDto customerPhoneContactDto) throws StaleStateException {
        CustomerModelImpl customerModel;
        CustomerDto customerDto = customerPhoneContactDto.getCustomer();
        if (customerDto != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
    }

    @Override
    public CustomerPhoneContactFullDto createDto() {
        Long id = this.getId();
        CustomerPhoneContactFullDto customerPhoneContactDto = id == null ? new CustomerPhoneContactFullDto(this.getTempUUID()) : new CustomerPhoneContactFullDto(id, this.getVersion());
        customerPhoneContactDto.setPhoneNumber(this.getPhoneNumber());
        customerPhoneContactDto.setFirstName(this.getFirstName());
        customerPhoneContactDto.setLastName(this.getLastName());
        customerPhoneContactDto.setCustomerOrder(this.getCustomerOrder());
        CustomerModelImpl customer = (CustomerModelImpl)this.getCustomer();
        if (customer != null) {
            customerPhoneContactDto.setCustomer(customer.createProxy());
        }
        return customerPhoneContactDto;
    }

    @Override
    public CustomerPhoneContactProxyDto createProxy() {
        Long id = this.getId();
        CustomerPhoneContactProxyDto customerPhoneContactDto = id == null ? new CustomerPhoneContactProxyDto(this.getTempUUID()) : new CustomerPhoneContactProxyDto(id, this.getVersion());
        return customerPhoneContactDto;
    }

    public static enum CustomerPhoneContactModelEnum {
        PHONE_NUMBER("phoneNumber"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        CUSTOMER_ORDER("customerOrder"),
        CUSTOMER("customer");

        private String propertyName;

        private CustomerPhoneContactModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

