/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModel;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModelImpl;
import de.datomino.peppergis.client.model.base.CustomerMailContactModel;
import de.datomino.peppergis.client.model.base.CustomerMailContactModelImpl;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModel;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionModelImpl;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.offer.AgencyModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferModelImpl;
import de.datomino.peppergis.dto.base.CustomerFaxContactDto;
import de.datomino.peppergis.dto.base.CustomerFullDto;
import de.datomino.peppergis.dto.base.CustomerMailContactDto;
import de.datomino.peppergis.dto.base.CustomerPhoneContactDto;
import de.datomino.peppergis.dto.base.CustomerProxyDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.ServiceTicketDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.offer.AgencyDto;
import de.datomino.peppergis.dto.offer.OfferDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.Salutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class CustomerModelImpl
extends AbstractModel<CustomerFullDto, CustomerProxyDto>
implements CustomerModel {
    private String customerNumber;
    private String name;
    private Boolean company;
    private String companyName;
    private String firstName;
    private String lastName;
    private LocationModel defaultLocation;
    private List<CustomerPhoneContactModel> phoneContacts = null;
    private List<CustomerFaxContactModel> faxContacts = null;
    private List<CustomerMailContactModel> mailContacts = null;
    private Set<ServiceTicketModel> serviceTickets = null;
    private Set<SubscriptionModel> subscriptions = null;
    private Salutation salutation;
    private String title;
    private String businessPartnerNumber;
    private AgencyModel agency;
    private Set<OfferModel> offers = null;

    public CustomerModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CustomerModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getCustomerNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customerNumber;
    }

    @Override
    public void setCustomerNumber(String customerNumber) {
        this.setCustomerNumber(customerNumber, true);
    }

    private void setCustomerNumber(String customerNumber, boolean setDirty) {
        String oldCustomerNumber = this.getCustomerNumber();
        if (new EqualsBuilder().append(oldCustomerNumber, customerNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.CUSTOMER_NUMBER.getPropertyName());
        }
        this.customerNumber = customerNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.CUSTOMER_NUMBER, customerNumber, oldCustomerNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.NAME, name, oldName);
    }

    @Override
    public Boolean getCompany() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.company;
    }

    @Override
    public void setCompany(Boolean company) {
        this.setCompany(company, true);
    }

    private void setCompany(Boolean company, boolean setDirty) {
        Boolean oldCompany = this.getCompany();
        if (new EqualsBuilder().append(oldCompany, company).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.COMPANY.getPropertyName());
        }
        this.company = company;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.COMPANY, company, oldCompany);
    }

    @Override
    public String getCompanyName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.companyName;
    }

    @Override
    public void setCompanyName(String companyName) {
        this.setCompanyName(companyName, true);
    }

    private void setCompanyName(String companyName, boolean setDirty) {
        String oldCompanyName = this.getCompanyName();
        if (new EqualsBuilder().append(oldCompanyName, companyName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.COMPANY_NAME.getPropertyName());
        }
        this.companyName = companyName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.COMPANY_NAME, companyName, oldCompanyName);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public LocationModel getDefaultLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.defaultLocation;
    }

    @Override
    public void setDefaultLocation(LocationModel defaultLocation) {
        this.setDefaultLocation(defaultLocation, true);
    }

    private void setDefaultLocation(LocationModel defaultLocation, boolean setDirty) {
        LocationModel oldDefaultLocation = this.getDefaultLocation();
        if (oldDefaultLocation == defaultLocation) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.DEFAULT_LOCATION.getPropertyName());
        }
        this.defaultLocation = defaultLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.DEFAULT_LOCATION, defaultLocation, oldDefaultLocation);
    }

    @Override
    public int countPhoneContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return this.phoneContacts.size();
    }

    @Override
    public Iterator<CustomerPhoneContactModel> iteratePhoneContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return new ImmutableIterator<CustomerPhoneContactModel>(this.phoneContacts);
    }

    @Override
    public Iterable<CustomerPhoneContactModel> iterablePhoneContacts() {
        return new IteratorIterable<CustomerPhoneContactModel>(this.iteratePhoneContacts());
    }

    @Override
    public void addPhoneContact(CustomerPhoneContactModel phoneContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        if (this.phoneContacts.contains(phoneContact)) {
            return;
        }
        this.phoneContacts.add(phoneContact);
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, phoneContact, null);
        if (phoneContact != null) {
            phoneContact.setCustomer(this);
            phoneContact.setCustomerOrder(this.phoneContacts.size() - 1);
        }
    }

    @Override
    public void removePhoneContact(CustomerPhoneContactModel phoneContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        if (!this.phoneContacts.contains(phoneContact)) {
            return;
        }
        this.phoneContacts.remove(phoneContact);
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, phoneContact, null);
        if (phoneContact != null) {
            phoneContact.setCustomer(null);
            phoneContact.setCustomerOrder(null);
        }
        this.reorderPhoneContacts(0);
    }

    @Override
    public CustomerPhoneContactModel getPhoneContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return this.phoneContacts.get(index);
    }

    @Override
    public void insertPhoneContact(CustomerPhoneContactModel phoneContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        if (this.phoneContacts.contains(phoneContact)) {
            this.removePhoneContact(phoneContact);
        }
        this.phoneContacts.add(index, phoneContact);
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, phoneContact, null);
        if (phoneContact != null) {
            phoneContact.setCustomer(this);
        }
        this.reorderPhoneContacts(index);
    }

    @Override
    public void removePhoneContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        CustomerPhoneContactModel oldPhoneContact = this.phoneContacts.get(index);
        this.phoneContacts.remove(index);
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, oldPhoneContact, null);
        if (oldPhoneContact != null) {
            oldPhoneContact.setCustomer(null);
            oldPhoneContact.setCustomerOrder(null);
        }
        this.reorderPhoneContacts(index);
    }

    @Override
    public void setPhoneContactAt(CustomerPhoneContactModel phoneContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        CustomerPhoneContactModel oldPhoneContact = this.phoneContacts.get(index);
        this.phoneContacts.set(index, phoneContact);
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, phoneContact, oldPhoneContact);
        if (oldPhoneContact != null) {
            oldPhoneContact.setCustomer(null);
            oldPhoneContact.setCustomerOrder(null);
        }
        if (phoneContact != null) {
            phoneContact.setCustomer(this);
            phoneContact.setCustomerOrder(index);
        }
    }

    @Override
    public void clearPhoneContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        ArrayList<CustomerPhoneContactModel> oldPhoneContacts = new ArrayList<CustomerPhoneContactModel>(this.phoneContacts);
        this.phoneContacts.clear();
        this.fireValueChanged(CustomerModelEnum.PHONE_CONTACTS, null, null);
        for (CustomerPhoneContactModel oldPhoneContact : oldPhoneContacts) {
            if (oldPhoneContact == null) continue;
            oldPhoneContact.setCustomer(null);
            oldPhoneContact.setCustomerOrder(null);
        }
    }

    @Override
    public boolean isPhoneContactsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return this.phoneContacts.isEmpty();
    }

    @Override
    public boolean containsPhoneContact(CustomerPhoneContactModel phoneContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return this.phoneContacts.contains(phoneContact);
    }

    @Override
    public int indexOfPhoneContact(CustomerPhoneContactModel phoneContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        return this.phoneContacts.indexOf(phoneContact);
    }

    @Override
    public boolean isPhoneContactsInitialized() {
        return this.phoneContacts != null;
    }

    private void reorderPhoneContacts(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.phoneContacts == null) {
            this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            if (this.getId() != null) {
                Collection phoneContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.PHONE_CONTACTS.getPropertyName());
                this.phoneContacts.addAll(phoneContactsCollection);
            }
        }
        ListIterator<CustomerPhoneContactModel> listIterator = this.phoneContacts.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            CustomerPhoneContactModel phoneContact = listIterator.next();
            phoneContact.setCustomerOrder(index++);
        }
    }

    @Override
    public int countFaxContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return this.faxContacts.size();
    }

    @Override
    public Iterator<CustomerFaxContactModel> iterateFaxContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return new ImmutableIterator<CustomerFaxContactModel>(this.faxContacts);
    }

    @Override
    public Iterable<CustomerFaxContactModel> iterableFaxContacts() {
        return new IteratorIterable<CustomerFaxContactModel>(this.iterateFaxContacts());
    }

    @Override
    public void addFaxContact(CustomerFaxContactModel faxContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        if (this.faxContacts.contains(faxContact)) {
            return;
        }
        this.faxContacts.add(faxContact);
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, faxContact, null);
        if (faxContact != null) {
            faxContact.setCustomer(this);
            faxContact.setCustomerOrder(this.faxContacts.size() - 1);
        }
    }

    @Override
    public void removeFaxContact(CustomerFaxContactModel faxContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        if (!this.faxContacts.contains(faxContact)) {
            return;
        }
        this.faxContacts.remove(faxContact);
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, faxContact, null);
        if (faxContact != null) {
            faxContact.setCustomer(null);
            faxContact.setCustomerOrder(null);
        }
        this.reorderFaxContacts(0);
    }

    @Override
    public CustomerFaxContactModel getFaxContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return this.faxContacts.get(index);
    }

    @Override
    public void insertFaxContact(CustomerFaxContactModel faxContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        if (this.faxContacts.contains(faxContact)) {
            this.removeFaxContact(faxContact);
        }
        this.faxContacts.add(index, faxContact);
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, faxContact, null);
        if (faxContact != null) {
            faxContact.setCustomer(this);
        }
        this.reorderFaxContacts(index);
    }

    @Override
    public void removeFaxContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        CustomerFaxContactModel oldFaxContact = this.faxContacts.get(index);
        this.faxContacts.remove(index);
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, oldFaxContact, null);
        if (oldFaxContact != null) {
            oldFaxContact.setCustomer(null);
            oldFaxContact.setCustomerOrder(null);
        }
        this.reorderFaxContacts(index);
    }

    @Override
    public void setFaxContactAt(CustomerFaxContactModel faxContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        CustomerFaxContactModel oldFaxContact = this.faxContacts.get(index);
        this.faxContacts.set(index, faxContact);
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, faxContact, oldFaxContact);
        if (oldFaxContact != null) {
            oldFaxContact.setCustomer(null);
            oldFaxContact.setCustomerOrder(null);
        }
        if (faxContact != null) {
            faxContact.setCustomer(this);
            faxContact.setCustomerOrder(index);
        }
    }

    @Override
    public void clearFaxContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        ArrayList<CustomerFaxContactModel> oldFaxContacts = new ArrayList<CustomerFaxContactModel>(this.faxContacts);
        this.faxContacts.clear();
        this.fireValueChanged(CustomerModelEnum.FAX_CONTACTS, null, null);
        for (CustomerFaxContactModel oldFaxContact : oldFaxContacts) {
            if (oldFaxContact == null) continue;
            oldFaxContact.setCustomer(null);
            oldFaxContact.setCustomerOrder(null);
        }
    }

    @Override
    public boolean isFaxContactsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return this.faxContacts.isEmpty();
    }

    @Override
    public boolean containsFaxContact(CustomerFaxContactModel faxContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return this.faxContacts.contains(faxContact);
    }

    @Override
    public int indexOfFaxContact(CustomerFaxContactModel faxContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        return this.faxContacts.indexOf(faxContact);
    }

    @Override
    public boolean isFaxContactsInitialized() {
        return this.faxContacts != null;
    }

    private void reorderFaxContacts(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.faxContacts == null) {
            this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            if (this.getId() != null) {
                Collection faxContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.FAX_CONTACTS.getPropertyName());
                this.faxContacts.addAll(faxContactsCollection);
            }
        }
        ListIterator<CustomerFaxContactModel> listIterator = this.faxContacts.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            CustomerFaxContactModel faxContact = listIterator.next();
            faxContact.setCustomerOrder(index++);
        }
    }

    @Override
    public int countMailContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return this.mailContacts.size();
    }

    @Override
    public Iterator<CustomerMailContactModel> iterateMailContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return new ImmutableIterator<CustomerMailContactModel>(this.mailContacts);
    }

    @Override
    public Iterable<CustomerMailContactModel> iterableMailContacts() {
        return new IteratorIterable<CustomerMailContactModel>(this.iterateMailContacts());
    }

    @Override
    public void addMailContact(CustomerMailContactModel mailContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        if (this.mailContacts.contains(mailContact)) {
            return;
        }
        this.mailContacts.add(mailContact);
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, mailContact, null);
        if (mailContact != null) {
            mailContact.setCustomer(this);
            mailContact.setCustomerOrder(this.mailContacts.size() - 1);
        }
    }

    @Override
    public void removeMailContact(CustomerMailContactModel mailContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        if (!this.mailContacts.contains(mailContact)) {
            return;
        }
        this.mailContacts.remove(mailContact);
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, mailContact, null);
        if (mailContact != null) {
            mailContact.setCustomer(null);
            mailContact.setCustomerOrder(null);
        }
        this.reorderMailContacts(0);
    }

    @Override
    public CustomerMailContactModel getMailContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return this.mailContacts.get(index);
    }

    @Override
    public void insertMailContact(CustomerMailContactModel mailContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        if (this.mailContacts.contains(mailContact)) {
            this.removeMailContact(mailContact);
        }
        this.mailContacts.add(index, mailContact);
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, mailContact, null);
        if (mailContact != null) {
            mailContact.setCustomer(this);
        }
        this.reorderMailContacts(index);
    }

    @Override
    public void removeMailContactAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        CustomerMailContactModel oldMailContact = this.mailContacts.get(index);
        this.mailContacts.remove(index);
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, oldMailContact, null);
        if (oldMailContact != null) {
            oldMailContact.setCustomer(null);
            oldMailContact.setCustomerOrder(null);
        }
        this.reorderMailContacts(index);
    }

    @Override
    public void setMailContactAt(CustomerMailContactModel mailContact, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        CustomerMailContactModel oldMailContact = this.mailContacts.get(index);
        this.mailContacts.set(index, mailContact);
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, mailContact, oldMailContact);
        if (oldMailContact != null) {
            oldMailContact.setCustomer(null);
            oldMailContact.setCustomerOrder(null);
        }
        if (mailContact != null) {
            mailContact.setCustomer(this);
            mailContact.setCustomerOrder(index);
        }
    }

    @Override
    public void clearMailContacts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        ArrayList<CustomerMailContactModel> oldMailContacts = new ArrayList<CustomerMailContactModel>(this.mailContacts);
        this.mailContacts.clear();
        this.fireValueChanged(CustomerModelEnum.MAIL_CONTACTS, null, null);
        for (CustomerMailContactModel oldMailContact : oldMailContacts) {
            if (oldMailContact == null) continue;
            oldMailContact.setCustomer(null);
            oldMailContact.setCustomerOrder(null);
        }
    }

    @Override
    public boolean isMailContactsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return this.mailContacts.isEmpty();
    }

    @Override
    public boolean containsMailContact(CustomerMailContactModel mailContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return this.mailContacts.contains(mailContact);
    }

    @Override
    public int indexOfMailContact(CustomerMailContactModel mailContact) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        return this.mailContacts.indexOf(mailContact);
    }

    @Override
    public boolean isMailContactsInitialized() {
        return this.mailContacts != null;
    }

    private void reorderMailContacts(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mailContacts == null) {
            this.mailContacts = new ArrayList<CustomerMailContactModel>();
            if (this.getId() != null) {
                Collection mailContactsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.MAIL_CONTACTS.getPropertyName());
                this.mailContacts.addAll(mailContactsCollection);
            }
        }
        ListIterator<CustomerMailContactModel> listIterator = this.mailContacts.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            CustomerMailContactModel mailContact = listIterator.next();
            mailContact.setCustomerOrder(index++);
        }
    }

    @Override
    public int countServiceTickets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        return this.serviceTickets.size();
    }

    @Override
    public Iterator<ServiceTicketModel> iterateServiceTickets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        return new ImmutableIterator<ServiceTicketModel>(this.serviceTickets);
    }

    @Override
    public Iterable<ServiceTicketModel> iterableServiceTickets() {
        return new IteratorIterable<ServiceTicketModel>(this.iterateServiceTickets());
    }

    @Override
    public void addServiceTicket(ServiceTicketModel serviceTicket) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        if (this.serviceTickets.contains(serviceTicket)) {
            return;
        }
        this.serviceTickets.add(serviceTicket);
        this.fireValueChanged(CustomerModelEnum.SERVICE_TICKETS, serviceTicket, null);
        if (serviceTicket != null) {
            serviceTicket.setCustomer(this);
        }
    }

    @Override
    public void removeServiceTicket(ServiceTicketModel serviceTicket) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        if (!this.serviceTickets.contains(serviceTicket)) {
            return;
        }
        this.serviceTickets.remove(serviceTicket);
        this.fireValueChanged(CustomerModelEnum.SERVICE_TICKETS, serviceTicket, null);
        if (serviceTicket != null) {
            serviceTicket.setCustomer(null);
        }
    }

    @Override
    public void clearServiceTickets() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        ArrayList<ServiceTicketModel> oldServiceTickets = new ArrayList<ServiceTicketModel>(this.serviceTickets);
        this.serviceTickets.clear();
        this.fireValueChanged(CustomerModelEnum.SERVICE_TICKETS, null, null);
        for (ServiceTicketModel oldServiceTicket : oldServiceTickets) {
            if (oldServiceTicket == null) continue;
            oldServiceTicket.setCustomer(null);
        }
    }

    @Override
    public boolean isServiceTicketsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        return this.serviceTickets.isEmpty();
    }

    @Override
    public boolean containsServiceTicket(ServiceTicketModel serviceTicket) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceTickets == null) {
            this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            if (this.getId() != null) {
                Collection serviceTicketsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SERVICE_TICKETS.getPropertyName());
                this.serviceTickets.addAll(serviceTicketsCollection);
            }
        }
        return this.serviceTickets.contains(serviceTicket);
    }

    @Override
    public boolean isServiceTicketsInitialized() {
        return this.serviceTickets != null;
    }

    @Override
    public int countSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.size();
    }

    @Override
    public Iterator<SubscriptionModel> iterateSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return new ImmutableIterator<SubscriptionModel>(this.subscriptions);
    }

    @Override
    public Iterable<SubscriptionModel> iterableSubscriptions() {
        return new IteratorIterable<SubscriptionModel>(this.iterateSubscriptions());
    }

    @Override
    public void addSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        if (this.subscriptions.contains(subscription)) {
            return;
        }
        this.subscriptions.add(subscription);
        this.fireValueChanged(CustomerModelEnum.SUBSCRIPTIONS, subscription, null);
        if (subscription != null) {
            subscription.setCustomer(this);
        }
    }

    @Override
    public void removeSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        if (!this.subscriptions.contains(subscription)) {
            return;
        }
        this.subscriptions.remove(subscription);
        this.fireValueChanged(CustomerModelEnum.SUBSCRIPTIONS, subscription, null);
        if (subscription != null) {
            subscription.setCustomer(null);
        }
    }

    @Override
    public void clearSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        ArrayList<SubscriptionModel> oldSubscriptions = new ArrayList<SubscriptionModel>(this.subscriptions);
        this.subscriptions.clear();
        this.fireValueChanged(CustomerModelEnum.SUBSCRIPTIONS, null, null);
        for (SubscriptionModel oldSubscription : oldSubscriptions) {
            if (oldSubscription == null) continue;
            oldSubscription.setCustomer(null);
        }
    }

    @Override
    public boolean isSubscriptionsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.isEmpty();
    }

    @Override
    public boolean containsSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.contains(subscription);
    }

    @Override
    public boolean isSubscriptionsInitialized() {
        return this.subscriptions != null;
    }

    @Override
    public Salutation getSalutation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.salutation;
    }

    @Override
    public void setSalutation(Salutation salutation) {
        this.setSalutation(salutation, true);
    }

    private void setSalutation(Salutation salutation, boolean setDirty) {
        Salutation oldSalutation = this.getSalutation();
        if (new EqualsBuilder().append((Object)oldSalutation, (Object)salutation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.SALUTATION.getPropertyName());
        }
        this.salutation = salutation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.SALUTATION, (Object)salutation, (Object)oldSalutation);
    }

    @Override
    public String getTitle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.setTitle(title, true);
    }

    private void setTitle(String title, boolean setDirty) {
        String oldTitle = this.getTitle();
        if (new EqualsBuilder().append(oldTitle, title).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.TITLE.getPropertyName());
        }
        this.title = title;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.TITLE, title, oldTitle);
    }

    @Override
    public String getBusinessPartnerNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.businessPartnerNumber;
    }

    @Override
    public void setBusinessPartnerNumber(String businessPartnerNumber) {
        this.setBusinessPartnerNumber(businessPartnerNumber, true);
    }

    private void setBusinessPartnerNumber(String businessPartnerNumber, boolean setDirty) {
        String oldBusinessPartnerNumber = this.getBusinessPartnerNumber();
        if (new EqualsBuilder().append(oldBusinessPartnerNumber, businessPartnerNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.BUSINESS_PARTNER_NUMBER.getPropertyName());
        }
        this.businessPartnerNumber = businessPartnerNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.BUSINESS_PARTNER_NUMBER, businessPartnerNumber, oldBusinessPartnerNumber);
    }

    @Override
    public AgencyModel getAgency() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.agency;
    }

    @Override
    public void setAgency(AgencyModel agency) {
        this.setAgency(agency, true);
    }

    private void setAgency(AgencyModel agency, boolean setDirty) {
        AgencyModel oldAgency = this.getAgency();
        if (oldAgency == agency) {
            return;
        }
        if (oldAgency != null) {
            oldAgency.removeCustomer(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerModelEnum.AGENCY.getPropertyName());
        }
        this.agency = agency;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerModelEnum.AGENCY, agency, oldAgency);
        if (this.agency != null) {
            this.agency.addCustomer(this);
        }
    }

    @Override
    public int countOffers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        return this.offers.size();
    }

    @Override
    public Iterator<OfferModel> iterateOffers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        return new ImmutableIterator<OfferModel>(this.offers);
    }

    @Override
    public Iterable<OfferModel> iterableOffers() {
        return new IteratorIterable<OfferModel>(this.iterateOffers());
    }

    @Override
    public void addOffer(OfferModel offer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        if (this.offers.contains(offer)) {
            return;
        }
        this.offers.add(offer);
        this.fireValueChanged(CustomerModelEnum.OFFERS, offer, null);
        if (offer != null) {
            offer.setCustomer(this);
        }
    }

    @Override
    public void removeOffer(OfferModel offer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        if (!this.offers.contains(offer)) {
            return;
        }
        this.offers.remove(offer);
        this.fireValueChanged(CustomerModelEnum.OFFERS, offer, null);
        if (offer != null) {
            offer.setCustomer(null);
        }
    }

    @Override
    public void clearOffers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        ArrayList<OfferModel> oldOffers = new ArrayList<OfferModel>(this.offers);
        this.offers.clear();
        this.fireValueChanged(CustomerModelEnum.OFFERS, null, null);
        for (OfferModel oldOffer : oldOffers) {
            if (oldOffer == null) continue;
            oldOffer.setCustomer(null);
        }
    }

    @Override
    public boolean isOffersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        return this.offers.isEmpty();
    }

    @Override
    public boolean containsOffer(OfferModel offer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.offers == null) {
            this.offers = new LinkedHashSet<OfferModel>();
            if (this.getId() != null) {
                Collection offersCollection = this.commonCaller.fetchChildren(this, CustomerModelEnum.OFFERS.getPropertyName());
                this.offers.addAll(offersCollection);
            }
        }
        return this.offers.contains(offer);
    }

    @Override
    public boolean isOffersInitialized() {
        return this.offers != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.phoneContacts = null;
            this.faxContacts = null;
            this.mailContacts = null;
            this.serviceTickets = null;
            this.subscriptions = null;
            this.offers = null;
        }
    }

    @Override
    protected void updateByDto(CustomerFullDto customerDto) {
        SubscriptionDto[] subscriptions;
        ServiceTicketDto[] serviceTickets;
        CustomerMailContactDto[] mailContacts;
        CustomerFaxContactDto[] faxContacts;
        this.customerNumber = customerDto.getCustomerNumber();
        this.name = customerDto.getName();
        this.company = customerDto.getCompany();
        this.companyName = customerDto.getCompanyName();
        this.firstName = customerDto.getFirstName();
        this.lastName = customerDto.getLastName();
        this.defaultLocation = (LocationModel)this.getModelCache().getModel(customerDto.getDefaultLocation());
        CustomerPhoneContactDto[] phoneContacts = customerDto.getPhoneContacts();
        if (phoneContacts != null) {
            if (this.phoneContacts == null) {
                this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            } else {
                this.phoneContacts.clear();
            }
        }
        if ((faxContacts = customerDto.getFaxContacts()) != null) {
            if (this.faxContacts == null) {
                this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            } else {
                this.faxContacts.clear();
            }
        }
        if ((mailContacts = customerDto.getMailContacts()) != null) {
            if (this.mailContacts == null) {
                this.mailContacts = new ArrayList<CustomerMailContactModel>();
            } else {
                this.mailContacts.clear();
            }
        }
        if ((serviceTickets = customerDto.getServiceTickets()) != null) {
            if (this.serviceTickets == null) {
                this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            } else {
                this.serviceTickets.clear();
            }
        }
        if ((subscriptions = customerDto.getSubscriptions()) != null) {
            if (this.subscriptions == null) {
                this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            } else {
                this.subscriptions.clear();
            }
        }
        this.salutation = customerDto.getSalutation();
        this.title = customerDto.getTitle();
        this.businessPartnerNumber = customerDto.getBusinessPartnerNumber();
        this.agency = (AgencyModel)this.getModelCache().getModel(customerDto.getAgency());
        OfferDto[] offers = customerDto.getOffers();
        if (offers != null) {
            if (this.offers == null) {
                this.offers = new LinkedHashSet<OfferModel>();
            } else {
                this.offers.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(CustomerFullDto customerDto) {
        OfferDto[] offers;
        SubscriptionDto[] subscriptions;
        ServiceTicketDto[] serviceTickets;
        CustomerMailContactDto[] mailContacts;
        CustomerFaxContactDto[] faxContacts;
        CustomerPhoneContactDto[] phoneContacts = customerDto.getPhoneContacts();
        if (phoneContacts != null) {
            if (this.phoneContacts == null) {
                this.phoneContacts = new ArrayList<CustomerPhoneContactModel>();
            } else {
                this.phoneContacts.clear();
            }
            for (CustomerPhoneContactDto phoneContactDto : phoneContacts) {
                CustomerPhoneContactModel phoneContactModel = (CustomerPhoneContactModel)this.getModelCache().getModel(phoneContactDto);
                this.phoneContacts.add(phoneContactModel);
            }
        } else {
            this.phoneContacts = null;
        }
        if ((faxContacts = customerDto.getFaxContacts()) != null) {
            if (this.faxContacts == null) {
                this.faxContacts = new ArrayList<CustomerFaxContactModel>();
            } else {
                this.faxContacts.clear();
            }
            for (CustomerFaxContactDto faxContactDto : faxContacts) {
                CustomerFaxContactModel faxContactModel = (CustomerFaxContactModel)this.getModelCache().getModel(faxContactDto);
                this.faxContacts.add(faxContactModel);
            }
        } else {
            this.faxContacts = null;
        }
        if ((mailContacts = customerDto.getMailContacts()) != null) {
            if (this.mailContacts == null) {
                this.mailContacts = new ArrayList<CustomerMailContactModel>();
            } else {
                this.mailContacts.clear();
            }
            for (CustomerMailContactDto mailContactDto : mailContacts) {
                CustomerMailContactModel mailContactModel = (CustomerMailContactModel)this.getModelCache().getModel(mailContactDto);
                this.mailContacts.add(mailContactModel);
            }
        } else {
            this.mailContacts = null;
        }
        if ((serviceTickets = customerDto.getServiceTickets()) != null) {
            if (this.serviceTickets == null) {
                this.serviceTickets = new LinkedHashSet<ServiceTicketModel>();
            } else {
                this.serviceTickets.clear();
            }
            for (ServiceTicketDto serviceTicketDto : serviceTickets) {
                ServiceTicketModel serviceTicketModel = (ServiceTicketModel)this.getModelCache().getModel(serviceTicketDto);
                this.serviceTickets.add(serviceTicketModel);
            }
        } else {
            this.serviceTickets = null;
        }
        if ((subscriptions = customerDto.getSubscriptions()) != null) {
            if (this.subscriptions == null) {
                this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            } else {
                this.subscriptions.clear();
            }
            for (SubscriptionDto subscriptionDto : subscriptions) {
                SubscriptionModel subscriptionModel = (SubscriptionModel)this.getModelCache().getModel(subscriptionDto);
                this.subscriptions.add(subscriptionModel);
            }
        } else {
            this.subscriptions = null;
        }
        if ((offers = customerDto.getOffers()) != null) {
            if (this.offers == null) {
                this.offers = new LinkedHashSet<OfferModel>();
            } else {
                this.offers.clear();
            }
            for (OfferDto offerDto : offers) {
                OfferModel offerModel = (OfferModel)this.getModelCache().getModel(offerDto);
                this.offers.add(offerModel);
            }
        } else {
            this.offers = null;
        }
    }

    @Override
    protected void checkStaleByDto(CustomerFullDto customerDto) throws StaleStateException {
        OfferDto[] offerDtos;
        AgencyModelImpl agencyModel;
        AgencyDto agencyDto;
        SubscriptionDto[] subscriptionDtos;
        ServiceTicketDto[] serviceTicketDtos;
        CustomerMailContactDto[] mailContactDtos;
        CustomerFaxContactDto[] faxContactDtos;
        CustomerPhoneContactDto[] phoneContactDtos;
        LocationModelImpl defaultLocationModel;
        LocationDto defaultLocationDto = customerDto.getDefaultLocation();
        if (defaultLocationDto != null && defaultLocationDto.getId() != null && (defaultLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, defaultLocationDto.getId())) != null) {
            defaultLocationModel.checkStaleState(defaultLocationDto);
        }
        if ((phoneContactDtos = customerDto.getPhoneContacts()) != null) {
            for (CustomerPhoneContactDto phoneContactDto : phoneContactDtos) {
                CustomerPhoneContactModelImpl phoneContactModel = (CustomerPhoneContactModelImpl)this.getModelCache().getModel(CustomerPhoneContactModel.class, phoneContactDto.getId());
                if (phoneContactModel == null) continue;
                phoneContactModel.checkStaleState(phoneContactDto);
            }
        }
        if ((faxContactDtos = customerDto.getFaxContacts()) != null) {
            for (CustomerFaxContactDto faxContactDto : faxContactDtos) {
                CustomerFaxContactModelImpl faxContactModel = (CustomerFaxContactModelImpl)this.getModelCache().getModel(CustomerFaxContactModel.class, faxContactDto.getId());
                if (faxContactModel == null) continue;
                faxContactModel.checkStaleState(faxContactDto);
            }
        }
        if ((mailContactDtos = customerDto.getMailContacts()) != null) {
            for (CustomerMailContactDto mailContactDto : mailContactDtos) {
                CustomerMailContactModelImpl mailContactModel = (CustomerMailContactModelImpl)this.getModelCache().getModel(CustomerMailContactModel.class, mailContactDto.getId());
                if (mailContactModel == null) continue;
                mailContactModel.checkStaleState(mailContactDto);
            }
        }
        if ((serviceTicketDtos = customerDto.getServiceTickets()) != null) {
            for (ServiceTicketDto serviceTicketDto : serviceTicketDtos) {
                ServiceTicketModelImpl serviceTicketModel = (ServiceTicketModelImpl)this.getModelCache().getModel(ServiceTicketModel.class, serviceTicketDto.getId());
                if (serviceTicketModel == null) continue;
                serviceTicketModel.checkStaleState(serviceTicketDto);
            }
        }
        if ((subscriptionDtos = customerDto.getSubscriptions()) != null) {
            for (SubscriptionDto subscriptionDto : subscriptionDtos) {
                SubscriptionModelImpl subscriptionModel = (SubscriptionModelImpl)this.getModelCache().getModel(SubscriptionModel.class, subscriptionDto.getId());
                if (subscriptionModel == null) continue;
                subscriptionModel.checkStaleState(subscriptionDto);
            }
        }
        if ((agencyDto = customerDto.getAgency()) != null && agencyDto.getId() != null && (agencyModel = (AgencyModelImpl)this.getModelCache().getModel(AgencyModel.class, agencyDto.getId())) != null) {
            agencyModel.checkStaleState(agencyDto);
        }
        if ((offerDtos = customerDto.getOffers()) != null) {
            for (OfferDto offerDto : offerDtos) {
                OfferModelImpl offerModel = (OfferModelImpl)this.getModelCache().getModel(OfferModel.class, offerDto.getId());
                if (offerModel == null) continue;
                offerModel.checkStaleState(offerDto);
            }
        }
    }

    @Override
    public CustomerFullDto createDto() {
        Long id = this.getId();
        CustomerFullDto customerDto = id == null ? new CustomerFullDto(this.getTempUUID()) : new CustomerFullDto(id, this.getVersion());
        customerDto.setCustomerNumber(this.getCustomerNumber());
        customerDto.setName(this.getName());
        customerDto.setCompany(this.getCompany());
        customerDto.setCompanyName(this.getCompanyName());
        customerDto.setFirstName(this.getFirstName());
        customerDto.setLastName(this.getLastName());
        LocationModelImpl defaultLocation = (LocationModelImpl)this.getDefaultLocation();
        if (defaultLocation != null) {
            customerDto.setDefaultLocation(defaultLocation.createProxy());
        }
        customerDto.setSalutation(this.getSalutation());
        customerDto.setTitle(this.getTitle());
        customerDto.setBusinessPartnerNumber(this.getBusinessPartnerNumber());
        AgencyModelImpl agency = (AgencyModelImpl)this.getAgency();
        if (agency != null) {
            customerDto.setAgency(agency.createProxy());
        }
        return customerDto;
    }

    @Override
    public CustomerProxyDto createProxy() {
        Long id = this.getId();
        CustomerProxyDto customerDto = id == null ? new CustomerProxyDto(this.getTempUUID()) : new CustomerProxyDto(id, this.getVersion());
        return customerDto;
    }

    public static enum CustomerModelEnum {
        CUSTOMER_NUMBER("customerNumber"),
        NAME("name"),
        COMPANY("company"),
        COMPANY_NAME("companyName"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        DEFAULT_LOCATION("defaultLocation"),
        PHONE_CONTACTS("phoneContacts"),
        FAX_CONTACTS("faxContacts"),
        MAIL_CONTACTS("mailContacts"),
        SERVICE_TICKETS("serviceTickets"),
        SUBSCRIPTIONS("subscriptions"),
        SALUTATION("salutation"),
        TITLE("title"),
        BUSINESS_PARTNER_NUMBER("businessPartnerNumber"),
        AGENCY("agency"),
        OFFERS("offers");

        private String propertyName;

        private CustomerModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

