/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerMailContactModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.CustomerMailContactFullDto;
import de.datomino.peppergis.dto.base.CustomerMailContactProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class CustomerMailContactModelImpl
extends AbstractModel<CustomerMailContactFullDto, CustomerMailContactProxyDto>
implements CustomerMailContactModel {
    private String email;
    private String firstName;
    private String lastName;
    private Integer customerOrder;
    private CustomerModel customer;

    public CustomerMailContactModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CustomerMailContactModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getEmail() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.setEmail(email, true);
    }

    private void setEmail(String email, boolean setDirty) {
        String oldEmail = this.getEmail();
        if (new EqualsBuilder().append(oldEmail, email).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerMailContactModelEnum.EMAIL.getPropertyName());
        }
        this.email = email;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerMailContactModelEnum.EMAIL, email, oldEmail);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerMailContactModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerMailContactModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerMailContactModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerMailContactModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public Integer getCustomerOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customerOrder;
    }

    @Override
    public void setCustomerOrder(Integer customerOrder) {
        this.setCustomerOrder(customerOrder, true);
    }

    private void setCustomerOrder(Integer customerOrder, boolean setDirty) {
        Integer oldCustomerOrder = this.getCustomerOrder();
        if (new EqualsBuilder().append(oldCustomerOrder, customerOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerMailContactModelEnum.CUSTOMER_ORDER.getPropertyName());
        }
        this.customerOrder = customerOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerMailContactModelEnum.CUSTOMER_ORDER, customerOrder, oldCustomerOrder);
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removeMailContact(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerMailContactModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerMailContactModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addMailContact(this);
        }
    }

    @Override
    protected void updateByDto(CustomerMailContactFullDto customerMailContactDto) {
        this.email = customerMailContactDto.getEmail();
        this.firstName = customerMailContactDto.getFirstName();
        this.lastName = customerMailContactDto.getLastName();
        this.customerOrder = customerMailContactDto.getCustomerOrder();
        this.customer = (CustomerModel)this.getModelCache().getModel(customerMailContactDto.getCustomer());
    }

    @Override
    protected void updateMasterRelationsByDto(CustomerMailContactFullDto customerMailContactDto) {
    }

    @Override
    protected void checkStaleByDto(CustomerMailContactFullDto customerMailContactDto) throws StaleStateException {
        CustomerModelImpl customerModel;
        CustomerDto customerDto = customerMailContactDto.getCustomer();
        if (customerDto != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
    }

    @Override
    public CustomerMailContactFullDto createDto() {
        Long id = this.getId();
        CustomerMailContactFullDto customerMailContactDto = id == null ? new CustomerMailContactFullDto(this.getTempUUID()) : new CustomerMailContactFullDto(id, this.getVersion());
        customerMailContactDto.setEmail(this.getEmail());
        customerMailContactDto.setFirstName(this.getFirstName());
        customerMailContactDto.setLastName(this.getLastName());
        customerMailContactDto.setCustomerOrder(this.getCustomerOrder());
        CustomerModelImpl customer = (CustomerModelImpl)this.getCustomer();
        if (customer != null) {
            customerMailContactDto.setCustomer(customer.createProxy());
        }
        return customerMailContactDto;
    }

    @Override
    public CustomerMailContactProxyDto createProxy() {
        Long id = this.getId();
        CustomerMailContactProxyDto customerMailContactDto = id == null ? new CustomerMailContactProxyDto(this.getTempUUID()) : new CustomerMailContactProxyDto(id, this.getVersion());
        return customerMailContactDto;
    }

    public static enum CustomerMailContactModelEnum {
        EMAIL("email"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        CUSTOMER_ORDER("customerOrder"),
        CUSTOMER("customer");

        private String propertyName;

        private CustomerMailContactModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

