/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.dto.base.BranchFullDto;
import de.datomino.peppergis.dto.base.BranchProxyDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.BranchType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class BranchModelImpl
extends AbstractModel<BranchFullDto, BranchProxyDto>
implements BranchModel {
    private String name;
    private String information;
    private PoiModel poi;
    private BranchType branchType;

    public BranchModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public BranchModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, BranchModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(BranchModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, BranchModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(BranchModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (oldPoi != null) {
            oldPoi.removeBranche(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, BranchModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(BranchModelEnum.POI, poi, oldPoi);
        if (this.poi != null) {
            this.poi.addBranche(this);
        }
    }

    @Override
    public BranchType getBranchType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.branchType;
    }

    @Override
    public void setBranchType(BranchType branchType) {
        this.setBranchType(branchType, true);
    }

    private void setBranchType(BranchType branchType, boolean setDirty) {
        BranchType oldBranchType = this.getBranchType();
        if (new EqualsBuilder().append((Object)oldBranchType, (Object)branchType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, BranchModelEnum.BRANCH_TYPE.getPropertyName());
        }
        this.branchType = branchType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(BranchModelEnum.BRANCH_TYPE, (Object)branchType, (Object)oldBranchType);
    }

    @Override
    protected void updateByDto(BranchFullDto branchDto) {
        this.name = branchDto.getName();
        this.information = branchDto.getInformation();
        this.poi = (PoiModel)this.getModelCache().getModel(branchDto.getPoi());
        this.branchType = branchDto.getBranchType();
    }

    @Override
    protected void updateMasterRelationsByDto(BranchFullDto branchDto) {
    }

    @Override
    protected void checkStaleByDto(BranchFullDto branchDto) throws StaleStateException {
        PoiModelImpl poiModel;
        PoiDto poiDto = branchDto.getPoi();
        if (poiDto != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
    }

    @Override
    public BranchFullDto createDto() {
        Long id = this.getId();
        BranchFullDto branchDto = id == null ? new BranchFullDto(this.getTempUUID()) : new BranchFullDto(id, this.getVersion());
        branchDto.setName(this.getName());
        branchDto.setInformation(this.getInformation());
        PoiModelImpl poi = (PoiModelImpl)this.getPoi();
        if (poi != null) {
            branchDto.setPoi(poi.createProxy());
        }
        branchDto.setBranchType(this.getBranchType());
        return branchDto;
    }

    @Override
    public BranchProxyDto createProxy() {
        Long id = this.getId();
        BranchProxyDto branchDto = id == null ? new BranchProxyDto(this.getTempUUID()) : new BranchProxyDto(id, this.getVersion());
        return branchDto;
    }

    public static enum BranchModelEnum {
        NAME("name"),
        INFORMATION("information"),
        POI("poi"),
        BRANCH_TYPE("branchType");

        private String propertyName;

        private BranchModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

